/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.message.send.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.drp.mdr.common.message.send.MessageStoreService;
import kd.drp.mdr.common.message.send.model.SendMessageInfo;
import org.apache.log4j.Logger;

public class MessageQueue {
    private List<SendMessageInfo> messageList = Collections.synchronizedList(new ArrayList());
    private static Logger log = Logger.getLogger(MessageQueue.class);

    public static MessageQueue getInstance() {
        return MessageQueueInstance.instance;
    }

    private MessageQueue() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SendMessageInfo msg) {
        if (msg == null) {
            return;
        }
        List<SendMessageInfo> list = this.messageList;
        synchronized (list) {
            if (this.messageList.indexOf(msg) >= 0) {
                return;
            }
            try (TXHandle h = TX.beginNew();){
                try {
                    MessageStoreService.saveMessage(msg);
                }
                catch (Exception e) {
                    log.info((Object)("\u63d2\u5165\u6d88\u606f\u8bb0\u5f55\u5931\u8d25" + e.getMessage()));
                    h.markRollback();
                }
            }
            this.messageList.add(msg);
            this.messageList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendMessageInfo get() {
        List<SendMessageInfo> list = this.messageList;
        synchronized (list) {
            while (this.messageList.size() == 0) {
                try {
                    this.messageList.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.messageList.remove(0);
        }
    }

    private static class MessageQueueInstance {
        private static MessageQueue instance = new MessageQueue();

        private MessageQueueInstance() {
        }
    }
}

