/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.message.send.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.StringUtils;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.SendMessageInfo;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class MessageSender {
    private static Logger log = Logger.getLogger(MessageSender.class);
    private static HttpClient httpClient;

    private static synchronized void init() {
        if (httpClient != null) {
            return;
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(500);
        connectionManager.setDefaultMaxPerRoute(50);
        httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)300000);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
        httpClient.getParams().setParameter("http.connection.stalecheck", (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageResponse sendMessage(SendMessageInfo messageInfo) {
        if (httpClient == null) {
            MessageSender.init();
        }
        MessageResponse result = new MessageResponse();
        if (StringUtils.isEmpty((Object)messageInfo.getMessageurl())) {
            return result;
        }
        HttpPost method = new HttpPost(messageInfo.getMessageurl());
        method.setHeader("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("message", messageInfo.toJson()));
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                String errorMessage = "send message failed, urlPath:" + messageInfo.getMessageurl() + " status:" + status + " response:" + EntityUtils.toString((HttpEntity)response.getEntity());
                result.setErrorCode("400");
                result.setErrorMessage(errorMessage);
            }
            result = MessageSender.parseResult(result, response);
        }
        catch (ClientProtocolException e) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u6d88\u606f\u5730\u5740\uff1a\u2018%s\u2019 \u8fde\u63a5\u5931\u8d25\uff1a%s", (String)"MessageSender_0", (String)"drp-mdr-common", (Object[])new Object[0]), messageInfo.getMessageurl(), e.getMessage());
            log.error((Object)errorMessage);
            result.setErrorCode("401");
            result.setErrorMessage(errorMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606fIO\u5f02\u5e38\uff1a%s", (String)"MessageSender_1", (String)"drp-mdr-common", (Object[])new Object[0]), e.getMessage());
            log.error((Object)errorMessage);
            result.setErrorCode("402");
            result.setErrorMessage(errorMessage);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private static MessageResponse parseResult(MessageResponse result, HttpResponse response) throws IOException {
        String responseStr = MessageSender.parserResponse(response);
        if (responseStr != null && responseStr.length() > 0) {
            try {
                JSONObject json = JSONObject.fromObject((Object)responseStr);
                result.setData(json.optString("data"));
                result.setErrorCode(json.optString("errorCode"));
                result.setErrorMessage(json.optString("errorMessage"));
            }
            catch (JSONException e) {
                result.setErrorCode("300");
                result.setErrorMessage(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1a%s", (String)"MessageSender_2", (String)"drp-mdr-common", (Object[])new Object[0]), response));
            }
        }
        return result;
    }

    private static String parserResponse(HttpResponse response) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        InputStream in = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        String inputLine = null;
        while ((inputLine = reader.readLine()) != null) {
            contentBuffer.append(inputLine);
            contentBuffer.append("/n");
        }
        if (contentBuffer.length() > 0) {
            contentBuffer.delete(contentBuffer.length() - 2, contentBuffer.length());
        }
        in.close();
        return contentBuffer.toString();
    }
}

