/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.model.dpm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class PromotionOrder
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Object ownerid;
    protected Object customerid;
    protected Date createtime;
    protected String promotioncachekey;
    protected String sourcefromkey;
    protected BigDecimal totalamount = BigDecimal.ZERO;
    protected List<PromotionOrderEntry> entries = new ArrayList<PromotionOrderEntry>();
    protected List<PromotionOrderEntry> policyentries = new ArrayList<PromotionOrderEntry>();

    public PromotionOrder() {
    }

    public PromotionOrder(Object ownerid, Object customerid, Date createtime) {
        this.ownerid = ownerid;
        this.customerid = customerid;
        this.createtime = createtime;
    }

    public void addEntry(PromotionOrderEntry entry) {
        this.entries.add(entry);
        if (SaleOrderEntryType.COMBINATION != entry.getType()) {
            this.totalamount = this.totalamount.add(entry.getAmount());
        }
    }

    public void addEntrys(Collection<PromotionOrderEntry> entrys) {
        this.entries.addAll(entrys);
        for (PromotionOrderEntry entry : entrys) {
            if (SaleOrderEntryType.COMBINATION == entry.getType()) continue;
            this.totalamount = this.totalamount.add(entry.getAmount());
        }
    }

    public void addPolicyEntry(PromotionOrderEntry entry) {
        this.policyentries.add(entry);
    }

    public void addPolicyEntrys(Collection<PromotionOrderEntry> entrys) {
        this.policyentries.addAll(entrys);
    }

    public void setOwnerid(Object ownerid) {
        this.ownerid = ownerid;
    }

    public void setCustomerid(Object customerid) {
        this.customerid = customerid;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public void setSourceFromKey(String sourcefromkey) {
        this.sourcefromkey = sourcefromkey;
    }

    public void setPromotioncachekey(String promotioncachekey) {
        this.promotioncachekey = promotioncachekey;
    }

    public void setEntries(List<PromotionOrderEntry> entries) {
        this.entries = entries;
    }

    public void setPolicyEntries(List<PromotionOrderEntry> policyentries) {
        this.policyentries = policyentries;
    }

    public Object getOwnerid() {
        return this.ownerid;
    }

    public Object getCustomerid() {
        return this.customerid;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public String getsetSourceFromKey() {
        return this.sourcefromkey;
    }

    public String getPromotioncachekey() {
        return this.promotioncachekey;
    }

    public BigDecimal getTotalamount() {
        return this.totalamount;
    }

    public void setTotalamount(BigDecimal amount) {
        this.totalamount = amount;
    }

    public List<PromotionOrderEntry> getEntries() {
        return this.entries;
    }

    public List<PromotionOrderEntry> getPolicyEntries() {
        return this.policyentries;
    }

    public BigDecimal getTotalqty() {
        BigDecimal totalqty = BigDecimal.ZERO;
        for (PromotionOrderEntry entry : this.entries) {
            totalqty = totalqty.add(entry.getQty());
        }
        return totalqty;
    }

    public PromotionOrder clone() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PromotionOrder cloneobj = null;
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(this);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            cloneobj = (PromotionOrder)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return cloneobj;
    }

    public List<PromotionOrderEntry> getChildEntrysByEntryid(Object entryid) {
        ArrayList<PromotionOrderEntry> childentrys = new ArrayList<PromotionOrderEntry>();
        for (PromotionOrderEntry entry : this.getEntries()) {
            if (!entry.getSourceentryid().equals(entryid)) continue;
            childentrys.add(entry);
        }
        return childentrys;
    }

    public PromotionOrderEntry getEntryById(Object entryid) {
        if (entryid == null) {
            return null;
        }
        for (PromotionOrderEntry entry : this.getEntries()) {
            Object currentEntryId = entry.getEntryid();
            if (currentEntryId == null || !currentEntryId.toString().equals(entryid.toString())) continue;
            return entry;
        }
        return null;
    }

    public static void main(String[] args) {
        PromotionOrder order = new PromotionOrder();
        PromotionOrderEntry entry = new PromotionOrderEntry();
        entry.setQty(BigDecimal.ZERO);
        order.addEntry(entry);
        PromotionOrder copyorder = order.clone();
        copyorder.getEntries().get(0).setQty(BigDecimal.ONE);
        System.out.println("\u539f\u5355\u636e:" + order.getEntries().get(0).getQty());
        System.out.println("\u73b0\u5355\u636e:" + copyorder.getEntries().get(0).getQty());
        copyorder.getEntries().remove(0);
    }

    public String toString() {
        return "PromotionOrder [ownerid=" + this.ownerid + ", customerid=" + this.customerid + ", createtime=" + this.createtime + ", totalamount=" + this.totalamount + "]";
    }
}

