/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.pagemodel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CreateJavaFile {
    private String targetDirPath = "";
    private List<String> pageNames;
    private static final String PREFIX = "public static final String ";

    public CreateJavaFile(List<String> pageNames) {
        this.pageNames = pageNames;
        if (StringUtils.isEmpty((CharSequence)this.targetDirPath)) {
            this.targetDirPath = this.getCurrentJavaFilePath();
        }
    }

    public CreateJavaFile(List<String> pageNames, String targetPath) {
        this(pageNames);
        this.targetDirPath = targetPath;
    }

    private boolean isLocalBizDev() {
        return StringUtils.startsWith((CharSequence)System.getProperty("os.name"), (CharSequence)"Windows") && StringUtils.equals((CharSequence)"biz-dev", (CharSequence)System.getProperty("clusterName"));
    }

    private String getCurrentJavaFilePath() {
        URL resource = CreateJavaFile.class.getResource("");
        String url = StringUtils.substring((String)resource.getFile(), (int)1);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"bin/main")) {
            return url.replaceFirst("bin/main", "src/main/java");
        }
        return null;
    }

    public void create() {
        if (!this.isLocalBizDev()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u4e1a\u52a1\u5f00\u53d1\u5206\u652f\u73af\u5883\u751f\u6210", (String)"CreateJavaFile_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)this.targetDirPath)) {
            throw new KDBizException(ResManager.loadKDString((String)"CreateJavaFile.targetPath \u4e0d\u80fd\u4e3a\u7a7a", (String)"CreateJavaFile_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        File file = new File(this.targetDirPath);
        if (!file.exists() || !file.isDirectory()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s: \u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"CreateJavaFile_2", (String)"drp-mdr-common", (Object[])new Object[0]), this.targetDirPath));
        }
        List<String> pages = this.getPageNames();
        if (pages == null) {
            return;
        }
        StringBuffer javaFileStr = null;
        for (String page : pages) {
            javaFileStr = this.createJavaInfo(page);
            this.createFile(javaFileStr, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(StringBuffer javaFileStr, String page) {
        Writer writer = null;
        try {
            String path = this.getTargetDirPath() + this.createClassName(page) + ".java";
            File file = new File(path);
            if (!file.exists() && !file.createNewFile()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6%s\u5931\u8d25\uff01", (String)"CreateJavaFile_7", (String)"drp-mdr-common", (Object[])new Object[0]), file.getName()));
            }
            writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));
            writer.write(javaFileStr.toString());
            writer.flush();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public String getTargetDirPath() {
        return this.targetDirPath;
    }

    public CreateJavaFile setTargetDirPath(String targetDirPath) {
        this.targetDirPath = targetDirPath;
        return this;
    }

    public CreateJavaFile(String ... pageNames) {
        this(Arrays.asList(pageNames));
    }

    public List<String> getPageNames() {
        return this.pageNames;
    }

    public CreateJavaFile setPageNames(List<String> pageNames) {
        this.pageNames = pageNames;
        return this;
    }

    private StringBuffer getMulFieldPropStr(DynamicProperty pro) {
        return this.getPropStr(pro, "MF_");
    }

    private StringBuffer getEntryPropStr(DynamicProperty pro) {
        return this.getPropStr(pro, "E_");
    }

    private StringBuffer getEntryFieldPropStr(DynamicProperty pro) {
        return this.getPropStr(pro, "EF_");
    }

    private StringBuffer getFieldPropStr(DynamicProperty pro) {
        return this.getPropStr(pro, "F_");
    }

    private StringBuffer getPropStr(DynamicProperty pro, String fieldPrefix) {
        LocaleString displayName = pro.getDisplayName();
        if (displayName != null) {
            return this.createFieldStr(displayName.getLocaleValue(), pro.getName(), fieldPrefix);
        }
        return new StringBuffer();
    }

    private StringBuffer createFieldStr(String remark, String fieldName, String fieldPrefix) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        sb.append("\t/** ");
        sb.append(remark);
        sb.append(" **/\n");
        sb.append('\t');
        sb.append(PREFIX);
        sb.append(fieldPrefix);
        sb.append(fieldName);
        sb.append(" = \"");
        sb.append(fieldName);
        sb.append("\";\n");
        return sb;
    }

    private StringBuffer getClassHeaderStr(String modelName) {
        StringBuffer sb = new StringBuffer();
        sb.append("package kd.drp.mdr.common.pagemodel;\n");
        sb.append("/** \n");
        sb.append(ResManager.loadKDString((String)" *  E_ : \u5206\u5f55\u6807\u8bc6\u524d\u7f00 \n", (String)"CreateJavaFile_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        sb.append(ResManager.loadKDString((String)" *  F_ : \u5b57\u6bb5\u6807\u8bc6\u524d\u7f00 \n", (String)"CreateJavaFile_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        sb.append(ResManager.loadKDString((String)" *  MF_ : \u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u6807\u8bc6\u524d\u7f00 \n", (String)"CreateJavaFile_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        sb.append(ResManager.loadKDString((String)" *  EF_ : \u5206\u5f55\u5b57\u6bb5\u6807\u8bc6\u524d\u7f00 \n", (String)"CreateJavaFile_6", (String)"drp-mdr-common", (Object[])new Object[0]));
        sb.append(" */ \n");
        sb.append("public interface ");
        sb.append(this.createClassName(modelName));
        sb.append("{ \n\n");
        return sb;
    }

    private String createClassName(String modelName) {
        String[] split = modelName.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            sb.append(StringUtils.capitalize((String)split[i]));
        }
        return sb.toString();
    }

    private StringBuffer createJavaInfo(String modelName) {
        DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)modelName);
        IDataEntityType type = model.getDataEntityType();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        StringBuffer classStr = this.getClassHeaderStr(modelName);
        if (type instanceof BillEntityType || type instanceof BasedataEntityType || type instanceof MainEntityType) {
            classStr.append(this.createModelPro(modelName));
        }
        ArrayList<EntryProp> entrys = new ArrayList<EntryProp>();
        ArrayList<MulBasedataProp> mulFields = new ArrayList<MulBasedataProp>();
        classStr.append("\n//**************************\u5355\u5934\u5b57\u6bb5****************\n");
        for (IDataEntityProperty pro : properties) {
            if (pro instanceof BasedataProp || pro instanceof FieldProp) {
                classStr.append(this.getFieldPropStr((DynamicProperty)pro));
                continue;
            }
            if (pro instanceof EntryProp) {
                entrys.add((EntryProp)pro);
                continue;
            }
            if (!(pro instanceof MulBasedataProp)) continue;
            mulFields.add((MulBasedataProp)pro);
        }
        for (EntryProp entry : entrys) {
            DataEntityPropertyCollection entryPros = model.getDynamicObjectCollection((IDataEntityProperty)entry).getDynamicObjectType().getProperties();
            classStr.append("\n//**************************");
            classStr.append(entry.getDisplayName());
            classStr.append(ResManager.loadKDString((String)":\u5206\u5f55\u5b57\u6bb5****************n", (String)"CreateJavaFile_8", (String)"drp-mdr-common", (Object[])new Object[0]));
            classStr.append(this.getEntryPropStr((DynamicProperty)entry));
            classStr.append(this.createEntryJavaInfo(entryPros));
        }
        classStr.append("\n//**************************\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5****************\n");
        for (MulBasedataProp field : mulFields) {
            classStr.append(this.getMulFieldPropStr((DynamicProperty)field));
        }
        classStr.append("\n}");
        return classStr;
    }

    private StringBuffer createModelPro(String modelName) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        sb.append("t/** \u9875\u9762\u6807\u8bc6 **/n");
        sb.append('\t');
        sb.append(PREFIX);
        sb.append("P_name");
        sb.append(" = \"");
        sb.append(modelName);
        sb.append("\";\n");
        return sb;
    }

    private StringBuffer createEntryJavaInfo(DataEntityPropertyCollection entryPros) {
        StringBuffer sb = new StringBuffer();
        for (IDataEntityProperty pro : entryPros) {
            if (!(pro instanceof FieldProp) && !(pro instanceof BasedataProp)) continue;
            sb.append(this.getEntryFieldPropStr((DynamicProperty)pro));
        }
        return sb;
    }

    public static void main(String[] args) {
        URL resource = CreateJavaFile.class.getResource("");
        String url = StringUtils.substring((String)resource.getFile(), (int)1);
        String newRul = url.replaceFirst("bin/main", "src/main/java");
        System.out.println(newRul);
    }
}

