/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.strategy;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.strategy.VersionStrategy;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;

public abstract class AbstractVersionStrategy
implements VersionStrategy {
    protected DynamicObject order;
    protected DynamicObject oldOrder;
    protected DynamicObject historyOrder;
    protected String operationKey;

    protected AbstractVersionStrategy(DynamicObject order, String operationKey) {
        this.order = order;
        this.operationKey = operationKey;
    }

    protected abstract DynamicObject createAndSaveOldVersion(DynamicObject var1);

    @Override
    public void saveVersion() {
        if (this.isMustSave() && SysParamsUtil.isSaveOrderVersion()) {
            this.oldOrder = BusinessDataServiceHelper.loadSingle((Object)this.order.get("id"), (DynamicObjectType)this.order.getDynamicObjectType());
            this.historyOrder = this.createAndSaveOldVersion(this.oldOrder);
        }
        this.saveOpLog();
    }

    public void saveOpLog() {
        OrderOperateLogHandler.save(this.order, this.operationKey, "", this.historyOrder == null ? null : this.historyOrder.getPkValue());
    }

    @Override
    public boolean isMustSave() {
        SaleOrderStatus orderStatus = null;
        switch (this.operationKey) {
            case "saveworkflow": {
                return true;
            }
            case "audit": {
                return true;
            }
            case "submit": {
                return !DynamicObjectUtils.isNewCreate(this.order);
            }
            case "save": {
                orderStatus = SaleOrderUtil.getOrderStatus(this.order);
                return orderStatus == SaleOrderStatus.CHANGING || orderStatus == SaleOrderStatus.PENDING_DISPATCH || orderStatus == SaleOrderStatus.PART_DISPATCH;
            }
        }
        return false;
    }
}

