/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.strategy;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.drp.mdr.common.strategy.AbstractVersionStrategy;
import kd.drp.mdr.common.strategy.NewOrderVersionStrategy;
import kd.drp.mdr.common.strategy.OrderDefaultVersionStrategy;
import kd.drp.mdr.common.strategy.VersionStrategy;

public class OrderVersionStrategyFactory {
    public static void saveVersion(DynamicObject order, String operationKey) {
        VersionStrategy versionStrategy = OrderVersionStrategyFactory.getStrategy(order, operationKey);
        if (versionStrategy != null) {
            versionStrategy.saveVersion();
        }
    }

    public static VersionStrategy getStrategy(DynamicObject order, String operationKey) {
        if (order == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrderVersionStrategyFactory_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        AbstractVersionStrategy versionStrategy = null;
        String orderName = order.getDynamicObjectType().getName();
        if ("mdr_saleorder".equals(orderName) || "mdr_purorder".equals(orderName)) {
            versionStrategy = new OrderDefaultVersionStrategy(order, operationKey);
        } else if ("bbc_saleorder".equals(orderName) || "dpa_purorder".equals(orderName)) {
            versionStrategy = new NewOrderVersionStrategy(order, operationKey);
        }
        return versionStrategy;
    }
}

