/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.log4j.Logger;

public class BalanceUtil {
    private static final Logger log = Logger.getLogger(BalanceUtil.class);

    public static DynamicObject getBalanceInfo(Object ownerPK, Object customerPK, boolean isNeedCreate) {
        if (ownerPK == null || customerPK == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u6216\u8981\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BalanceUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (isNeedCreate) {
            return BalanceUtil.getBalanceInfo(ownerPK, customerPK, 3);
        }
        return BalanceUtil.getBalanceInfo(ownerPK, customerPK);
    }

    private static DynamicObject getBalanceInfo(Object ownerPK, Object customerPK, int count) {
        DynamicObject balanceInfo = null;
        QFilter filter = new QFilter("owner", "=", ownerPK).and("customer", "=", customerPK);
        try {
            balanceInfo = !BalanceUtil.isExist(filter) ? BalanceUtil.createBalanceInfo(ownerPK, customerPK) : BalanceUtil.getBalanceInfo(filter);
        }
        catch (Exception e) {
            if (--count == 0) {
                log.error((Object)e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u6536\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01%s", (String)"BalanceUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]), e.getMessage()));
            }
            return BalanceUtil.getBalanceInfo(ownerPK, customerPK, count);
        }
        return balanceInfo;
    }

    private static boolean isExist(QFilter filter) {
        return QueryServiceHelper.exists((String)"mdr_balance", (QFilter[])filter.toArray());
    }

    private static DynamicObject createBalanceInfo(Object ownerPK, Object customerPK) {
        Throwable throwable = null;
        try (TXHandle h = TX.beginNew();){
            DynamicObject balance = BusinessDataServiceHelper.newDynamicObject((String)"mdr_balance");
            balance.set("owner", ownerPK);
            balance.set("customer", customerPK);
            balance.set("currency", (Object)1);
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balance});
            DynamicObject dynamicObject = balance = (DynamicObject)result[0];
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u6536\u6b3e\u521b\u5efa\u5931\u8d25%s", (String)"BalanceUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]), e.getMessage()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static DynamicObject getBalanceInfo(Object ownerPK, Object customerPK) {
        QFilter filter = new QFilter("owner", "=", ownerPK).and("customer", "=", customerPK);
        return BalanceUtil.getBalanceInfo(filter);
    }

    private static DynamicObject getBalanceInfo(QFilter filter) {
        DynamicObject blance = BusinessDataServiceHelper.loadSingle((String)"mdr_balance", (String)"id,balance,occupied,usable,version", (QFilter[])filter.toArray());
        return blance;
    }
}

