/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.WebUtil;

public class BizValidateUtils {
    public static boolean isRegionOwner(Object regionId, Object customerId) {
        QFilter f = WebUtil.getIdQFilter(regionId).and("owner", "=", customerId);
        return QueryServiceHelper.exists((String)"mdr_region", (QFilter[])f.toArray());
    }

    public static void isRegionOwnerValidate(Object regionId, Object customerId) {
        if (!BizValidateUtils.isRegionOwner(regionId, customerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u533a\u57df\u4e0d\u5c5e\u4e8e\u5f52\u5c5e\u6e20\u9053\uff01", (String)"BizValidateUtils_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
    }

    public static void itemAttrValidate(Object itemId, DynamicObject assistAttr) {
        boolean hasAssistAttr = ItemAttrUtil.hasAssistAttr(itemId);
        if (hasAssistAttr) {
            if (assistAttr == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BizValidateUtils_1", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            if (!ItemAttrUtil.hasAssistAttr(itemId, assistAttr.get("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u5f53\u524d\u8f85\u52a9\u5c5e\u6027[%s]\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"BizValidateUtils_2", (String)"drp-mdr-common", (Object[])new Object[0]), assistAttr.getString("name")));
            }
        }
    }

    public static boolean itemAttrNullValidate(Object itemId, DynamicObject assistAttr) {
        boolean hasAssistAttr = ItemAttrUtil.hasAssistAttr(itemId);
        return !hasAssistAttr || assistAttr != null;
    }

    @Deprecated
    public static CheckResult checkItemAttrValidate(Object itemId, DynamicObject assistAttr) {
        boolean hasAssistAttr = ItemAttrUtil.hasAssistAttr(itemId);
        if (hasAssistAttr) {
            if (assistAttr == null) {
                return CheckResult.returnFalse(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BizValidateUtils_1", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            if (!ItemAttrUtil.hasAssistAttr(itemId, assistAttr.get("id"))) {
                return CheckResult.returnFalse(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u5f53\u524d\u8f85\u52a9\u5c5e\u6027[%s]\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"BizValidateUtils_2", (String)"drp-mdr-common", (Object[])new Object[0]), assistAttr.getString("name")));
            }
        }
        return CheckResult.returnTrue();
    }

    public static boolean customerHasWarehouse(Object customerId, Object warehouseId) {
        QFilter f = new QFilter("customer", "=", customerId);
        f.and("warehouse.id", "=", warehouseId);
        return QueryServiceHelper.exists((String)"mdr_warehouse_relation", (QFilter[])f.toArray());
    }

    public static void customerHasWarehouseValidate(Object customerId, Object warehouseId) {
        if (!BizValidateUtils.customerHasWarehouse(customerId, warehouseId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u53d1\u8d27\u5730\u70b9\u672a\u88ab\u5f53\u524d\u6e20\u9053\u6388\u6743\uff01", (String)"BizValidateUtils_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
    }
}

