/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.drp.mdr.common.util.OperationUtil;
import org.apache.log4j.Logger;

public class BotpUtil {
    private static final Logger log = Logger.getLogger(BotpUtil.class);

    public static String pushAndSave(String sourceEntityNumber, String targetEntityNumber, QFilter[] filters) {
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceEntityNumber, (String)"id,billno", (QFilter[])filters);
        return BotpUtil.pushAndSave(sourceEntityNumber, targetEntityNumber, sourceBills);
    }

    public static String pushAndSave(String sourceEntityNumber, String targetEntityNumber, DynamicObjectCollection sourceBills) {
        StringBuilder errorMsg = new StringBuilder();
        ConvertOperationResult result = null;
        for (DynamicObject sourceBill : sourceBills) {
            try {
                result = BotpUtil.pushAndSave(sourceEntityNumber, targetEntityNumber, sourceBill.get("id"));
                log.info((Object)(sourceBill.get("billno") + "\u4e0b\u63a8\u6210\u529f"));
            }
            catch (Exception e) {
                if (result == null) {
                    result = new ConvertOperationResult();
                }
                result.setSuccess(false);
                result.setMessage(e.getMessage());
                log.error((Object)e.getMessage());
            }
            if (result.isSuccess()) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"BotpUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]), sourceBill.get("billno"), result.getMessage()));
            errorMsg.append('\n');
        }
        return errorMsg.toString();
    }

    public static String pushAndSave(String sourceEntityNumber, String targetEntityNumber, HashMap<Object, Object> sourceBills) {
        StringBuilder errorMsg = new StringBuilder();
        ConvertOperationResult result = null;
        for (Map.Entry<Object, Object> entry : sourceBills.entrySet()) {
            try {
                result = BotpUtil.pushAndSave(sourceEntityNumber, targetEntityNumber, entry.getKey());
            }
            catch (Exception e) {
                result = new ConvertOperationResult();
                result.setSuccess(false);
                result.setMessage(e.getMessage());
                log.error((Object)e.getMessage());
            }
            if (!result.isSuccess()) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"BotpUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]), entry.getValue(), result.getMessage()));
                errorMsg.append('\n');
                continue;
            }
            log.info((Object)(entry.getValue() + "\u4e0b\u63a8\u6210\u529f"));
        }
        return errorMsg.toString();
    }

    public static ConvertOperationResult pushAndSave(String sourceEntityNumber, String targetEntityNumber, Object ... longBillIds) {
        PushArgs botp = new PushArgs();
        if (longBillIds == null || longBillIds.length == 0) {
            return new ConvertOperationResult();
        }
        int len = longBillIds.length;
        ArrayList<ListSelectedRow> sourceBill = new ArrayList<ListSelectedRow>(len);
        for (int i = 0; i < len; ++i) {
            sourceBill.add(new ListSelectedRow(longBillIds[i], Boolean.TRUE));
        }
        botp.setSourceEntityNumber(sourceEntityNumber);
        botp.setTargetEntityNumber(targetEntityNumber);
        botp.setSelectedRows(sourceBill);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)botp);
        if (result.isSuccess()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
            List targetOrder = result.loadTargetDataObjects(new IRefrencedataProvider(){

                public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramIDataEntityType) {
                    BusinessDataServiceHelper.loadRefence((Object[])paramArrayOfObject, (IDataEntityType)paramIDataEntityType);
                }
            }, mainType);
            DynamicObject[] targetOrders = new DynamicObject[targetOrder.size()];
            OperationUtil.invokeOperation(targetOrder.toArray(targetOrders), "save");
        }
        return result;
    }
}

