/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;

public class CacheUtil {
    private static final int QUEUE_SIZE = 64;
    private static Comparator<String> tempKeyComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
    };
    private static TreeSet<String> tempKey = new TreeSet<String>(tempKeyComparator);
    private static IAppCache mdrCache = null;

    private static IAppCache getMDRAppCache() {
        if (mdrCache == null) {
            mdrCache = AppCache.get((String)"mdr");
        }
        return mdrCache;
    }

    public static <T> T get(String key, Class<T> clazz) {
        CacheUtil.addTempKey(key);
        return (T)CacheUtil.getMDRAppCache().get(key, clazz);
    }

    private static void addTempKey(String key) {
        int size = tempKey.size();
        if (tempKey.contains(key)) {
            return;
        }
        if (size == 64) {
            tempKey.pollLast();
        }
        tempKey.add(key);
    }

    public static void clearTempKey() {
        IAppCache mc = CacheUtil.getMDRAppCache();
        for (String key : tempKey) {
            mc.remove(key);
        }
        tempKey.clear();
    }

    public static List<String> searchTempKeys() {
        return new ArrayList<String>(tempKey);
    }

    public static void addTestKey() {
        tempKey.add("t01");
        tempKey.add("t02");
        tempKey.add("t03");
        tempKey.add("t04");
        tempKey.add("t05");
    }

    public static String showCacheValue(String key) {
        Object obj = CacheUtil.getMDRAppCache().get(key, Object.class);
        if (obj == null) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u503c\uff01", (String)"CacheUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]);
        }
        return obj.toString();
    }

    public static void put(String key, Object value) {
        CacheUtil.getMDRAppCache().put(key, value);
    }

    public static void remove(String key) {
        CacheUtil.getMDRAppCache().remove(key);
    }
}

