/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerAdminUtil {
    public static boolean isAdmin(Object ownerId) {
        QFilter fs = new QFilter("user", "=", UserUtil.getUserID());
        fs.and("customer", "=", ownerId);
        Set<Object> info = CustomerAdminUtil.loadCustomerAdminInfo(fs);
        return !info.isEmpty();
    }

    public static Set<Object> getCustomersByAdmin(Object userId) {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("user", "=", userId);
        return CustomerAdminUtil.loadCustomerAdminInfo(fs);
    }

    private static Set<Object> loadCustomerAdminInfo(QFilter fs) {
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"dbd_customer_admin", (String)"customer", (QFilter[])fs.toArray());
        HashSet<Object> ids = new HashSet<Object>(customers.size());
        for (DynamicObject info : customers.values()) {
            ids.add(info.getDynamicObject("customer").getPkValue());
        }
        return ids;
    }

    public static Set<Object> getAllCustomersByAdmin(Object userId) {
        Set<Object> ids = CustomerAdminUtil.getCustomersByAdmin(userId);
        if (ids.isEmpty()) {
            return ids;
        }
        QFilter fs = new QFilter("isinnerorg", "=", (Object)"1");
        fs.and("enable", "=", (Object)"1");
        Map infos = BusinessDataServiceHelper.loadFromCache((String)"mdr_customer", (String)"id", (QFilter[])fs.toArray());
        Set allInnerCustomer = infos.keySet();
        if (ids.containsAll(allInnerCustomer)) {
            return null;
        }
        Set<Object> allCustomerIds = CustomerUtil.getAllAuthSubsIdsByIds(ids);
        allCustomerIds.addAll(ids);
        return allCustomerIds;
    }

    public static Set<Object> getCustomersByCurrentUser() {
        return CustomerAdminUtil.getCustomersByAdmin(UserUtil.getUserID());
    }

    public static List<Object> getAuthCustomersByCurrentUser() {
        Set<Object> admins = CustomerAdminUtil.getAllCustomersByAdmin(UserUtil.getUserID());
        return new ArrayList<Object>(admins);
    }
}

