/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.QueryUtil;

public class CustomerSalerUtil {
    public static Set<Object> queryCustomerPKBySaler(Object ownerId, Object salerId) {
        QFilter[] fs = new QFilter[]{new QFilter("owner", "=", ownerId), new QFilter("user", "=", salerId), new QFilter("enable", "=", (Object)"1")};
        HashSet<Object> set = new HashSet<Object>();
        Map custsalerinfo = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_saler_relation", (QFilter[])fs);
        if (!custsalerinfo.isEmpty()) {
            for (DynamicObject custsaler : custsalerinfo.values()) {
                set.add(custsaler.get("customer.id"));
            }
        }
        return set;
    }

    public static Map<Object, Set<Object>> queryCustomerPKBySaler(List<Object> ownerIds, Object salerId) {
        QFilter[] fs = new QFilter[]{new QFilter("owner", "in", ownerIds), new QFilter("user", "=", salerId), new QFilter("enable", "=", (Object)"1")};
        Map custsalerinfo = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_saler_relation", (QFilter[])fs);
        return CustomerSalerUtil.getCustinfoByCustSales(custsalerinfo);
    }

    private static Map<Object, Set<Object>> getCustinfoByCustSales(Map<Object, DynamicObject> custsalerinfo) {
        HashMap<Object, Set<Object>> mapinfo = new HashMap<Object, Set<Object>>();
        HashSet<Object> set = new HashSet<Object>();
        if (!custsalerinfo.isEmpty()) {
            for (DynamicObject custsaler : custsalerinfo.values()) {
                Object ownerId = custsaler.get("owner.id");
                Object customerId = custsaler.get("customer.id");
                if (ownerId == null || customerId == null) continue;
                Set map = (Set)mapinfo.get(ownerId);
                if (map != null) {
                    map.add(customerId);
                    continue;
                }
                set = new HashSet();
                set.add(customerId);
                mapinfo.put(ownerId, set);
            }
        }
        return mapinfo;
    }

    public static Map<Object, Set<Object>> queryCustomerPKBySaler(List<Object> ownerIds, Object salerId, boolean ignoreEnable) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("owner", "in", ownerIds));
        qfilters.add(new QFilter("user", "=", salerId));
        if (!ignoreEnable) {
            qfilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        Map custsalerinfo = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_saler_relation", (QFilter[])qfilters.toArray(new QFilter[0]));
        return CustomerSalerUtil.getCustinfoByCustSales(custsalerinfo);
    }

    public static Set<Object> queryCustomerSalerPK(Object ownerId) {
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("issaler", "=", (Object)"1");
        return QueryUtil.querySingleCol("dbd_drp_user", "sysuser", fs.toArray());
    }

    public static List<Object> queryCustomerSalerPK(Object customerID, Object customerOwnerID) {
        QFilter[] fs = CustomerSalerUtil.getCustomerSalerQFilter(customerID, customerOwnerID);
        Map salerrelations = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_saler_relation", (QFilter[])fs);
        ArrayList<Object> users = new ArrayList<Object>(salerrelations.size());
        if (salerrelations.isEmpty()) {
            return users;
        }
        Object defaultId = null;
        Object id = null;
        DynamicObject user = null;
        for (DynamicObject salerrelation : salerrelations.values()) {
            user = salerrelation.getDynamicObject("user");
            if (user == null) continue;
            id = user.getPkValue();
            if (defaultId == null && salerrelation.getBoolean("isdefault")) {
                defaultId = id;
                continue;
            }
            users.add(id);
        }
        if (defaultId != null) {
            users.add(0, defaultId);
        }
        return users;
    }

    private static QFilter[] getCustomerSalerQFilter(Object customerID, Object customerOwnerID) {
        return new QFilter[]{new QFilter("customer", "=", customerID), new QFilter("owner", "=", customerOwnerID), new QFilter("enable", "=", (Object)"1")};
    }
}

