/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.constants.CustomerConsignType;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.SystemPresetCustomerFuction;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerGroupUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.log4j.Logger;

public class CustomerUtil {
    private static Logger LOG = Logger.getLogger(CustomerUtil.class);
    private static final int MAX_LEVEL = 5;
    private static boolean isUseCache = true;
    private static final String[] cols = new String[]{"onlycash", "region", "leadtime", "parentinvtype", "taxrate", "customergroup", "taxrateid", "authowner", "customer"};

    public static QFilter getAuthSubsIdsQFilter(Object pkValue) {
        QFilter qFilter = CustomerUtil.getCustomerQFilter(CustomerUtil.getAuthSubsIds(pkValue));
        return qFilter;
    }

    private static QFilter getCustomerQFilter(Collection<?> ids) {
        return new QFilter("id", "in", ids);
    }

    public static QFilter getAuthSubsIdsAndSelfQFilter(Object authOwnerId) {
        return CustomerUtil.getCustomerQFilter(CustomerUtil.getAuthSubsIdsAndSelf(authOwnerId));
    }

    public static Set<Object> getAuthSubsIdsAndSelf(Object authOwnerId) {
        Set<Object> ids = CustomerUtil.getAuthSubsIds(authOwnerId);
        ids.add(authOwnerId);
        return ids;
    }

    public static Set<Object> getAuthSubsIdsIgnoreVaild(Object authOwnerId) {
        return CustomerUtil.getAuthSubsIds(authOwnerId, false);
    }

    public static Set<Object> getAuthSubsIds(Object authOwnerId) {
        return CustomerUtil.getAuthSubsIds(authOwnerId, true);
    }

    private static Set<Object> getAuthSubsIds(Object authOwnerId, boolean isFilterVaild) {
        if (authOwnerId == null) {
            return new HashSet<Object>();
        }
        if (isUseCache) {
            try {
                return CustomerUtil.getAuthSubsIdsFromCache(authOwnerId, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getAuthSubsIds(%s,%s)", (String)"CustomerUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]), authOwnerId, isFilterVaild), (Throwable)e);
            }
        }
        return CustomerUtil.getAuthSubsIdsFromDB(authOwnerId, isFilterVaild);
    }

    private static Set<Object> getAuthSubsIdsFromCache(Object id, boolean isFilterVaild) {
        CustomerTreeCache treeCache = CustomerTreeCache.getCache();
        return CustomerUtil.getAuthSubsIdsFromCache(id, treeCache, isFilterVaild);
    }

    private static Set<Object> getAuthSubsIdsFromCache(Object authOwnerId, CustomerTreeCache treeCache, boolean isFilterVaild) {
        Map<Object, List<AuthCust>> authownerMap = treeCache.getAuthownerMap();
        List<AuthCust> relations = authownerMap.get(authOwnerId);
        HashSet<Object> ids = new HashSet<Object>();
        if (relations != null) {
            for (AuthCust authCust : relations) {
                if (isFilterVaild && !authCust.isValid()) continue;
                ids.add(authCust.getCustomerId());
            }
        }
        Integer zero = 0;
        ids.remove(zero);
        return ids;
    }

    private static Set<Object> getAuthSubsIdsFromDB(Object authOwnerId, boolean isFilterVaild) {
        QFilter fs = new QFilter("authowner", "=", authOwnerId);
        return CustomerUtil.getAuthSubsIdsFromDB(fs, isFilterVaild);
    }

    private static Set<Object> getAuthSubsIdsFromDB(QFilter fs, boolean isFilterVaild) {
        if (isFilterVaild) {
            fs.and(F7Utils.getEnableFilter());
        }
        return QueryUtil.querySingleCol("mdr_customer_authorize", "customer", fs.toArray());
    }

    public static Set<Object> getAuthSubsIdsByIdsIgnoreVaild(Set<Object> authOwnerIds) {
        return CustomerUtil.getAuthSubsIdsByIds(authOwnerIds, false);
    }

    public static Set<Object> getAuthSubsIdsByIds(Set<Object> authOwnerIds) {
        return CustomerUtil.getAuthSubsIdsByIds(authOwnerIds, true);
    }

    private static Set<Object> getAuthSubsIdsByIds(Set<Object> authOwnerIds, boolean isFilterVaild) {
        if (authOwnerIds == null || authOwnerIds.size() == 0) {
            return new HashSet<Object>();
        }
        if (isUseCache) {
            try {
                return CustomerUtil.getAuthSubsIdsByIdsFromCache(authOwnerIds, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getAuthSubsIdsByIds(%s,%s)", (String)"CustomerUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]), authOwnerIds, isFilterVaild), (Throwable)e);
            }
        }
        return CustomerUtil.getAuthSubsIdsByIdsFromDB(authOwnerIds, isFilterVaild);
    }

    private static Set<Object> getAuthSubsIdsByIdsFromCache(Set<Object> authOwnerIds, boolean isFilterVaild) {
        HashSet<Object> subIds = new HashSet<Object>();
        if (authOwnerIds != null) {
            CustomerTreeCache treeCache = CustomerTreeCache.getCache();
            for (Object id : authOwnerIds) {
                subIds.addAll(CustomerUtil.getAuthSubsIdsFromCache(id, treeCache, isFilterVaild));
            }
        }
        return subIds;
    }

    private static Set<Object> getAuthSubsIdsByIdsFromDB(Set<Object> authOwnerIds, boolean isFilterVaild) {
        QFilter fs = new QFilter("authowner", "in", authOwnerIds);
        return CustomerUtil.getAuthSubsIdsFromDB(fs, isFilterVaild);
    }

    public static QFilter getAllAuthSubsIdsAndSelfQFilter(Object pkValue) {
        return CustomerUtil.getCustomerQFilter(CustomerUtil.getAllAuthSubsIdsAndSelf(pkValue));
    }

    public static Set<Object> getAllAuthSubsIdsAndSelf(Object authOwnerId) {
        Set<Object> pkValues = CustomerUtil.getAllAuthSubIdsById(authOwnerId);
        pkValues.add(authOwnerId);
        return pkValues;
    }

    public static Set<Object> getAllAuthSubsIdsIgnoreVaild(Object authOwnerId) {
        return CustomerUtil.getAllSubIdsById(authOwnerId, false);
    }

    public static QFilter getAllAuthSubsIdsQFilter(Object authOwnerId) {
        return CustomerUtil.getCustomerQFilter(CustomerUtil.getAllAuthSubIdsById(authOwnerId));
    }

    public static Set<Object> getAllAuthSubIdsById(Object authOwnerId) {
        return CustomerUtil.getAllSubIdsById(authOwnerId, true);
    }

    private static Set<Object> getAllSubIdsById(Object authOwnerId, boolean isFilterVaild) {
        if (authOwnerId == null) {
            return new HashSet<Object>();
        }
        if (isUseCache) {
            try {
                return CustomerUtil.getAllSubsIdsFromCache(authOwnerId, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getAllSubsIds(%s,%s)", (String)"CustomerUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]), authOwnerId, isFilterVaild), (Throwable)e);
            }
        }
        return CustomerUtil.getAllSubsIdsFromDB(authOwnerId, isFilterVaild);
    }

    private static Set<Object> getAllSubsIdsFromDB(Object authOwnerId, boolean isFilterVaild) {
        HashSet<Object> authOwnerIds = new HashSet<Object>();
        authOwnerIds.add(authOwnerId);
        return CustomerUtil.getAllSubsIdsByIdsFromDB(authOwnerIds, isFilterVaild);
    }

    private static Set<Object> getAllSubsIdsFromCache(Object authOwnerId, boolean isFilterVaild) {
        HashSet<Object> ids = new HashSet<Object>();
        CustomerTreeCache treeCache = CustomerTreeCache.getCache();
        Map<Object, List<AuthCust>> ownerMap = treeCache.getAuthownerMap();
        CustomerUtil.getAllSubsIdsById(ids, authOwnerId, ownerMap, isFilterVaild);
        return ids;
    }

    private static void getAllSubsIdsById(Set<Object> ids, Object authOwnerId, Map<Object, List<AuthCust>> ownerMap, boolean isFilterVaild) {
        List<AuthCust> authCusts = ownerMap.get(authOwnerId);
        if (authCusts == null) {
            return;
        }
        for (AuthCust authCust : authCusts) {
            Object childId;
            if (isFilterVaild && !authCust.isValid() || ids.contains(childId = authCust.getCustomerId())) continue;
            ids.add(childId);
            CustomerUtil.getAllSubsIdsById(ids, childId, ownerMap, isFilterVaild);
        }
    }

    public static Set<Object> getAllAuthSubsIdsAndSelfByIds(Set<Object> authOwnerIds) {
        Set<Object> ids = CustomerUtil.getAllAuthSubsIdsByIds(authOwnerIds);
        ids.addAll(authOwnerIds);
        return ids;
    }

    public static Set<Object> getAllAuthSubsIdsByIds(Collection<?> authOwnerIds) {
        return CustomerUtil.getAllAuthSubsIdsByIds(new HashSet<Object>(authOwnerIds));
    }

    public static Set<Object> getAllAuthSubsIdsByIds(Set<Object> authOwnerIds) {
        return CustomerUtil.getAllSubsIdsByIds(authOwnerIds, true);
    }

    public static Set<Object> getAllAuthSubsIdsByIdsIgnoreVaild(Set<Object> authOwnerIds) {
        return CustomerUtil.getAllSubsIdsByIds(authOwnerIds, false);
    }

    private static Set<Object> getAllSubsIdsByIds(Set<Object> authOwnerIds, boolean isFilterVaild) {
        if (authOwnerIds == null || authOwnerIds.size() == 0) {
            return new HashSet<Object>();
        }
        if (isUseCache) {
            try {
                return CustomerUtil.getAllSubsIdsByIdsFromCache(authOwnerIds, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getAllSubsIdsByIds(%s,%s)", (String)"CustomerUtil_3", (String)"drp-mdr-common", (Object[])new Object[0]), authOwnerIds, isFilterVaild), (Throwable)e);
            }
        }
        return CustomerUtil.getAllSubsIdsByIdsFromDB(authOwnerIds, isFilterVaild);
    }

    private static Set<Object> getAllSubsIdsByIdsFromCache(Set<Object> authOwnerIds, boolean isFilterVaild) {
        HashSet<Object> ids = new HashSet<Object>();
        CustomerTreeCache treeCache = CustomerTreeCache.getCache();
        Map<Object, List<AuthCust>> ownerMap = treeCache.getAuthownerMap();
        for (Object authOwnerId : authOwnerIds) {
            CustomerUtil.getAllSubsIdsById(ids, authOwnerId, ownerMap, isFilterVaild);
        }
        return ids;
    }

    private static Set<Object> getAllSubsIdsByIdsFromDB(Set<Object> authOwnerIds, boolean isFilterVaild) {
        HashSet<Object> allIds = new HashSet<Object>();
        Set<Object> tempSubIds = new HashSet<Object>();
        tempSubIds.addAll(authOwnerIds);
        for (int i = 0; i < 5 && (tempSubIds = CustomerUtil.getAuthSubsIdsByIdsFromDB(tempSubIds, isFilterVaild)).size() != 0; ++i) {
            allIds.addAll(tempSubIds);
        }
        return allIds;
    }

    public static QFilter getAuthOwnerIDsFilter(Object pkValue, boolean isFilterVaild) {
        return CustomerUtil.getCustomerQFilter(CustomerUtil.getOwnerIds(pkValue, isFilterVaild));
    }

    public static List<Object> getAuthOwnerIDsIgnoreVaild(Object id) {
        return CustomerUtil.getOwnerIds(id, false);
    }

    public static List<Object> getAuthOwnerIDs(Object id) {
        return CustomerUtil.getOwnerIds(id, true);
    }

    private static List<Object> getOwnerIds(Object customerId, boolean isFilterVaild) {
        if (customerId == null) {
            return new ArrayList<Object>();
        }
        if (isUseCache) {
            try {
                return CustomerUtil.getOwnerIdsFromCache(customerId, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getOwnerIds(%s,%s)", (String)"CustomerUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]), customerId, isFilterVaild), (Throwable)e);
            }
        }
        return CustomerUtil.getOwnerIdsFromDB(customerId, isFilterVaild);
    }

    private static List<Object> getOwnerIdsFromCache(Object customerId, boolean isFilterVaild) {
        Map<Object, List<AuthCust>> customerMap = CustomerTreeCache.getCache().getCustomerMap();
        List<AuthCust> owners = customerMap.get(customerId);
        ArrayList<Object> ownerIds = new ArrayList<Object>();
        if (owners != null) {
            for (AuthCust owner : owners) {
                if (isFilterVaild && !owner.isValid()) continue;
                if (owner.isdefault()) {
                    ownerIds.add(0, owner.getAuthOwnerId());
                    continue;
                }
                ownerIds.add(owner.getAuthOwnerId());
            }
        }
        return ownerIds;
    }

    private static List<Object> getOwnerIdsFromDB(Object customerId, boolean isFilterVaild) {
        QFilter fs = new QFilter("customer", "=", customerId);
        if (isFilterVaild) {
            fs.and(F7Utils.getEnableFilter());
        }
        return QueryUtil.querySingleCol("mdr_customer_authorize", "authowner", fs.toArray(), "isdefault");
    }

    public static Set<Object> getAuthOwnerIDIgnoreVaild(Object id) {
        return CustomerUtil.getOwnerId(id, false);
    }

    public static Set<Object> getAuthOwnerID(Object id) {
        return CustomerUtil.getOwnerId(id, true);
    }

    private static Set<Object> getOwnerId(Object customerId, boolean isFilterVaild) {
        HashSet<Object> ids = new HashSet<Object>();
        if (customerId == null) {
            return ids;
        }
        if (isUseCache) {
            try {
                CustomerUtil.getOwnerIdFromCache(ids, customerId, isFilterVaild);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u8c03\u7528\u5931\u8d25\uff1aCustomerUtil.getOwnerIds(%s,%s)", (String)"CustomerUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]), customerId, isFilterVaild), (Throwable)e);
            }
        } else {
            HashSet<Object> customerIds = new HashSet<Object>();
            customerIds.add(customerId);
            CustomerUtil.getOwnerIdFromDB(ids, customerIds, isFilterVaild);
        }
        return ids;
    }

    private static void getOwnerIdFromCache(Set<Object> ids, Object customerId, boolean isFilterVaild) {
        Map<Object, List<AuthCust>> customerMap = CustomerTreeCache.getCache().getCustomerMap();
        List<AuthCust> owners = customerMap.get(customerId);
        Object id = null;
        if (owners == null || owners.size() == 0) {
            return;
        }
        for (AuthCust customer : owners) {
            if (isFilterVaild && !customer.isValid()) continue;
            id = customer.getAuthOwnerId();
            ids.add(id);
            CustomerUtil.getOwnerIdFromCache(ids, id, isFilterVaild);
        }
    }

    private static void getOwnerIdFromDB(Set<Object> ids, Set<Object> customerIds, boolean isFilterVaild) {
        if (customerIds == null || customerIds.size() == 0) {
            return;
        }
        QFilter fs = new QFilter("customer", "in", customerIds);
        if (isFilterVaild) {
            fs.and(F7Utils.getEnableFilter());
        }
        Set<Object> set = QueryUtil.querySingleCol("mdr_customer_authorize", "authowner", fs.toArray());
        ids.addAll(set);
        CustomerUtil.getOwnerIdFromDB(ids, set, isFilterVaild);
    }

    public static Object getIdByNumber(String number) {
        QFilter f = new QFilter("number", "=", (Object)number);
        DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_customer", (String)"id", (QFilter[])f.toArray());
        if (customer != null) {
            return customer.getPkValue();
        }
        return null;
    }

    public static DynamicObject getAuthBizInfo(Object authOwnerId, Object customerId) {
        QFilter fs = new QFilter("authowner", "=", authOwnerId);
        fs.and("customer", "=", customerId);
        fs.and("enable", "=", (Object)"1");
        DynamicObject info = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_customer_authorize", (String)F7Utils.getSelectCols(cols), (QFilter[])fs.toArray());
        if (info == null) {
            QFilter qf = new QFilter("authowner", "=", authOwnerId);
            qf.and("enable", "=", (Object)"1");
            DynamicObject[] infoList = BusinessDataServiceHelper.load((String)"mdr_customer_authorize", (String)F7Utils.getSelectCols(cols), (QFilter[])qf.toArray());
            if (infoList.length > 0) {
                info = infoList[0];
            }
            if (info == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0e\u8ba2\u8d27\u6e20\u9053\u4e0d\u5b58\u5728\u8ba2\u8d27\u5173\u7cfb\u6216\u5173\u7cfb\u5df2\u7981\u7528", (String)"CustomerUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
        }
        return info;
    }

    public static Object getCustomerGroup(Object customerId, Object ownerId) {
        DynamicObject bizInfo = CustomerUtil.getAuthBizInfo(ownerId, customerId);
        DynamicObject group = bizInfo.getDynamicObject("customergroup");
        if (group == null) {
            return null;
        }
        return group.getPkValue();
    }

    @Deprecated
    public static List<Object> getCustomerGroups(Object customerId) {
        DynamicObject group;
        ArrayList<Object> list = new ArrayList<Object>();
        if (customerId == null) {
            return list;
        }
        DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customerId, (String)"mdr_customer", (String)"group");
        if (customer != null && (group = customer.getDynamicObject("group")) != null) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(group.getPkValue(), list);
        }
        return list;
    }

    public static List<Object> getGroupsByCustomer(Object customerId) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (customerId == null) {
            return list;
        }
        String selectFieldStr = "id,number,name,area,custclassentity.classstandardid,custclassentity.customergroupid ";
        DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customerId, (String)"mdr_customer", (String)selectFieldStr);
        DynamicObjectCollection groupEntrys = customer.getDynamicObjectCollection("custclassentity");
        for (DynamicObject groupEntry : groupEntrys) {
            DynamicObject tempGroup = groupEntry.getDynamicObject("customergroupid");
            if (tempGroup == null || tempGroup.getLong("id") == 0L) continue;
            list.add(tempGroup.getLong("id"));
        }
        return list;
    }

    public static Set<Object> queryCustomerByRegion(Object ownerPK, Object regionIdOrIds) {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("region", "in", regionIdOrIds).and("authowner", "=", ownerPK);
        return QueryUtil.querySingleCol("mdr_customer_authorize", "customer", fs.toArray());
    }

    public static Boolean queryCustomerByCustom(Object customerId, Object ownerId) {
        boolean isdefault = false;
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("isdefault", "=", (Object)Boolean.TRUE).and("customer", "=", customerId).and("authowner", "!=", ownerId);
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"mdr_customer_authorize", (String)"customer", (QFilter[])fs.toArray());
        if (customers != null && customers.size() > 0) {
            isdefault = true;
        }
        return isdefault;
    }

    public static void updateCustomerByCustom(Object customerId) {
        String fields = F7Utils.getSelectCols("authowner", "customer", "marketability", "enable", "isdefault");
        DynamicObject[] evaluates = BusinessDataServiceHelper.load((String)"mdr_customer_authorize", (String)fields, (QFilter[])new QFilter("customer", "=", customerId).and("isdefault", "=", (Object)Character.valueOf('1')).toArray());
        if (evaluates != null && evaluates.length == 1) {
            evaluates[0].set("isdefault", (Object)0);
            SaveServiceHelper.save((DynamicObject[])evaluates);
            ArrayList<AuthCust> newRelation = new ArrayList<AuthCust>(evaluates.length);
            for (DynamicObject data : evaluates) {
                newRelation.add(new AuthCust(data));
            }
            CustomerTreeCache.updateTreeCacheAdd(newRelation);
        }
    }

    public static Object queryCustomerRegion(Object authOwnerId, Object customerId) {
        DynamicObject info = CustomerUtil.getAuthBizInfo(authOwnerId, customerId);
        DynamicObject region = info.getDynamicObject("region");
        if (region == null) {
            return 0L;
        }
        return region.getPkValue();
    }

    public static Set<Object> getRegionAuthSubsIds(Object authOwnerId, Set<Object> regionIds) {
        if (authOwnerId == null) {
            return new HashSet<Object>();
        }
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("authowner", "=", authOwnerId);
        fs.and("region", "in", regionIds);
        return QueryUtil.querySingleCol("mdr_customer_authorize", "customer", fs.toArray());
    }

    public static Set<Object> getInnerCustomerIds() {
        return CustomerUtil.getInnerCustomerIdsFromDB();
    }

    public static Set<Object> getInnerCustomerIdsFromDB() {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("isinnerorg", "=", (Object)"1");
        return QueryUtil.querySingleCol("mdr_customer", "id", fs.toArray());
    }

    public static Set<Object> getPayCustomer(Object ownerId) {
        if (ownerId == null) {
            return null;
        }
        Set<Object> customers = CustomerUtil.queryConsignmentCustomer(ownerId, CustomerConsignType.ACCOUNT);
        customers.add(ownerId);
        return customers;
    }

    public static Set<Object> getStoreCustomer(Object ownerId) {
        if (ownerId == null) {
            return null;
        }
        Set<Object> customers = CustomerUtil.queryConsignmentCustomer(ownerId, CustomerConsignType.DELIVERY);
        customers.add(ownerId);
        return customers;
    }

    private static Set<Object> queryConsignmentCustomer(Object ownerId, CustomerConsignType type) {
        QFilter qFilter = new QFilter("owner", "=", ownerId).and("type", "=", (Object)type.getFlagStr()).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        return QueryUtil.querySingleCol("mdr_customer_consign", "customer", qFilter.toArray());
    }

    public static boolean isAuthRelation(Object ownerId, Object customerId) {
        Map<String, AuthCust> authCustMap = CustomerTreeCache.getCache().getAuthCustMap();
        AuthCust authCust = authCustMap.get(AuthCust.calcuKey(ownerId, customerId));
        return authCust != null;
    }

    public static QFilter getAuthorisedCustomerFilter() {
        return new QFilter("id", "in", UserUtil.getOwnerIDs());
    }

    public static QFilter getOrderCustomerFilter(CustomerProperty customerProperty) {
        QFilter fs = new QFilter("customerproperty", "=", (Object)"0");
        if (customerProperty != null) {
            switch (customerProperty) {
                case INDIRECT_CUSTOMER: {
                    fs = new QFilter("customerproperty", "in", (Object)new HashSet<Object>(){
                        {
                            this.add(CustomerProperty.DIRECT_CUSTOMER);
                            this.add(CustomerProperty.MIX_CUSTOMER);
                        }
                    });
                    break;
                }
                case DIRECT_CUSTOMER: 
                case MIX_CUSTOMER: {
                    fs = new QFilter("customerproperty", "=", (Object)CustomerProperty.INNER_ORG);
                    break;
                }
            }
        }
        return fs;
    }

    public static Object[] getCustomerFunctionIds(SystemPresetCustomerFuction ... customerFunctions) {
        if (customerFunctions != null) {
            int length = customerFunctions.length;
            Object[] results = new Object[length];
            for (int i = 0; i < length; ++i) {
                results[i] = customerFunctions[i].toLong();
            }
            return results;
        }
        return new Object[0];
    }

    public static DynamicObject getDefaultOrderCustomer(long bizGroupId) {
        DynamicObjectCollection queryOrderCustomers = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizgroup", "=", (Object)bizGroupId), new QFilter("customertype.id", "=", (Object)9L), new QFilter("enable", "=", (Object)Enable.ENABLE.toString())});
        if (queryOrderCustomers != null && queryOrderCustomers.size() > 0) {
            return (DynamicObject)queryOrderCustomers.get(0);
        }
        return null;
    }
}

