/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.model.CurrentInfo;
import kd.drp.mdr.common.model.ItemStoreModel;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class DeliveryUtil {
    private static final String BILLTYPE_DISPATCH = "dispatchorder";
    private static final String BILLTYPE_SALEORDER = "saleorder";
    private static final String BILLTYPE_OEMORDER = "oemorder";
    private static final String BILLTYPE_SALOUTBILL = "saloutbill";
    private static final String ENTRY_DELIVERYDETAIL = "deliverydetail";
    private static final String MAINBILLID = "mainbillid";
    private static final String SRCBILLID = "srcbillid";
    private static final String SOURCEBILLTYPE = "sourcebilltype";
    private static final String MAINBILLENTRYID = "mainbillentryid";
    private static final String SRCBILLENTRYID = "srcbillentryid";

    public static void send(DynamicObject deliveryRecord, boolean isUpdateSignInfo) {
        String billType;
        if (deliveryRecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u8d27\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"DeliveryUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        switch (billType = deliveryRecord.getString(SOURCEBILLTYPE)) {
            case "dispatchorder": {
                DeliveryUtil.updateDispatchOrder(deliveryRecord, DeliveryOperation.SEND);
                break;
            }
            case "saleorder": 
            case "saloutbill": {
                DeliveryUtil.updateSaleOrder(deliveryRecord, DeliveryOperation.SEND);
                break;
            }
            case "oemorder": {
                DeliveryUtil.updateSaleOrder4OEM(deliveryRecord, DeliveryOperation.SEND);
            }
        }
        boolean isautosigndeliveryrecord = deliveryRecord.getBoolean("isautosigndeliveryrecord");
        if (isautosigndeliveryrecord) {
            DeliveryUtil.sign(deliveryRecord, isUpdateSignInfo);
        }
    }

    public static void unsend(DynamicObject deliveryRecord) {
        String billType;
        if (deliveryRecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u8d27\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"DeliveryUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        switch (billType = deliveryRecord.getString(SOURCEBILLTYPE)) {
            case "dispatchorder": {
                DeliveryUtil.updateDispatchOrder(deliveryRecord, DeliveryOperation.UNSEND);
                break;
            }
            case "saleorder": 
            case "saloutbill": {
                DeliveryUtil.updateSaleOrder(deliveryRecord, DeliveryOperation.UNSEND);
                break;
            }
            case "oemorder": {
                DeliveryUtil.updateSaleOrder4OEM(deliveryRecord, DeliveryOperation.UNSEND);
            }
        }
    }

    public static void sign(DynamicObject deliveryRecord, boolean isUpdateRecord) {
        String billType;
        if (isUpdateRecord) {
            CurrentInfo current = new CurrentInfo();
            DynamicObject userInfo = UserUtil.getUserInfo();
            deliveryRecord.set("billstatus", (Object)"C");
            deliveryRecord.set("auditor", (Object)userInfo);
            deliveryRecord.set("auditdate", (Object)current.getNow());
            deliveryRecord.set("signstatus", (Object)"1");
            deliveryRecord.set("signer", (Object)userInfo);
            deliveryRecord.set("signtime", (Object)current.getNow());
            DynamicObjectCollection deliverydetails = deliveryRecord.getDynamicObjectCollection(ENTRY_DELIVERYDETAIL);
            for (DynamicObject deliveryDetail : deliverydetails) {
                BigDecimal deliverqty = deliveryDetail.getBigDecimal("deliverqty");
                BigDecimal deliverstandardqty = deliveryDetail.getBigDecimal("deliverstandardqty");
                BigDecimal deliverassitqty = deliveryDetail.getBigDecimal("deliverassitqty");
                BigDecimal deliverbaseqty = deliveryDetail.getBigDecimal("deliverbaseqty");
                deliveryDetail.set("signQty", (Object)deliverqty);
                deliveryDetail.set("signstandardqty", (Object)deliverstandardqty);
                deliveryDetail.set("signbaseqty", (Object)deliverbaseqty);
                deliveryDetail.set("signassitqty", (Object)deliverassitqty);
            }
            SaveServiceHelper.save((IDataEntityType)deliveryRecord.getDataEntityType(), (Object[])new DynamicObject[]{deliveryRecord});
        }
        switch (billType = deliveryRecord.getString(SOURCEBILLTYPE)) {
            case "dispatchorder": {
                DeliveryUtil.updateDispatchOrder(deliveryRecord, DeliveryOperation.SIGN);
                break;
            }
            case "saleorder": 
            case "saloutbill": {
                DeliveryUtil.updateSaleOrder(deliveryRecord, DeliveryOperation.SIGN);
                break;
            }
            case "oemorder": {
                DeliveryUtil.updateSaleOrder4OEM(deliveryRecord, DeliveryOperation.SIGN);
            }
        }
    }

    public static void unSign(DynamicObject deliveryRecord, boolean isUpdateSignInfo) {
        String billType;
        switch (billType = deliveryRecord.getString(SOURCEBILLTYPE)) {
            case "dispatchorder": {
                DeliveryUtil.updateDispatchOrder(deliveryRecord, DeliveryOperation.UNSIGN);
                break;
            }
            case "saleorder": 
            case "saloutbill": {
                DeliveryUtil.updateSaleOrder(deliveryRecord, DeliveryOperation.UNSIGN);
                break;
            }
            case "oemorder": {
                DeliveryUtil.updateSaleOrder4OEM(deliveryRecord, DeliveryOperation.UNSIGN);
            }
        }
        if (isUpdateSignInfo) {
            deliveryRecord.set("billstatus", (Object)"B");
            deliveryRecord.set("auditor", (Object)0L);
            deliveryRecord.set("auditdate", null);
            deliveryRecord.set("signstatus", (Object)"0");
            deliveryRecord.set("signer", null);
            deliveryRecord.set("signtime", null);
            DynamicObjectCollection deliverydetailCollection = deliveryRecord.getDynamicObjectCollection(ENTRY_DELIVERYDETAIL);
            for (DynamicObject deliverydetail : deliverydetailCollection) {
                deliverydetail.set("signQty", (Object)BigDecimal.ZERO);
                deliverydetail.set("signstandardqty", (Object)BigDecimal.ZERO);
                deliverydetail.set("signbaseqty", (Object)BigDecimal.ZERO);
                deliverydetail.set("signassitqty", (Object)BigDecimal.ZERO);
            }
            SaveServiceHelper.save((IDataEntityType)deliveryRecord.getDataEntityType(), (Object[])new DynamicObject[]{deliveryRecord});
        }
    }

    private static void updateSaleOrder(DynamicObject deliveryRecord, DeliveryOperation operation) {
        DeliveryUtil.updateSourceOrder(deliveryRecord, operation);
    }

    private static void updateSaleOrder4OEM(DynamicObject deliveryRecord, DeliveryOperation operation) {
        DeliveryUtil.updateSourceOrder(deliveryRecord, operation);
    }

    private static void updateDispatchOrder(DynamicObject deliveryRecord, DeliveryOperation operation) {
        DeliveryUtil.updateSourceOrder(deliveryRecord, operation);
    }

    private static void updateSourceOrder(DynamicObject deliveryRecord, DeliveryOperation operation) {
        String sourceBillType = deliveryRecord.getString(SOURCEBILLTYPE);
        Map<Object, DynamicObject> ordersMap = DeliveryUtil.getOrdersMap(deliveryRecord, sourceBillType, operation.getOperation());
        DynamicObjectCollection deliverydetailCollection = deliveryRecord.getDynamicObjectCollection(ENTRY_DELIVERYDETAIL);
        DynamicObjectCollection entrys = new DynamicObjectCollection();
        DynamicObject order = new DynamicObject();
        Map<Object, Object> entryMap = new HashMap(deliverydetailCollection.size());
        ArrayList<ItemStoreModel> list = new ArrayList<ItemStoreModel>();
        DynamicObject[] orders = new DynamicObject[deliverydetailCollection.size()];
        int i = 0;
        String orderIdType = DeliveryUtil.getOrderIdType(sourceBillType);
        String orderEntryIdType = DeliveryUtil.getOrderEntryIdType(sourceBillType);
        for (DynamicObject deliverydetail : deliverydetailCollection) {
            order = ordersMap.get(deliverydetail.getLong(orderIdType));
            if (order == null) continue;
            entrys = order.getDynamicObjectCollection("itementry");
            entryMap = CommonUtils.collection2Map("id", (List<DynamicObject>)entrys);
            Long orderentryId = deliverydetail.getLong(orderEntryIdType);
            DynamicObject orderEntry = (DynamicObject)entryMap.get(orderentryId);
            boolean updateDelQty = DeliveryUtil.getUpdateDelQty(sourceBillType, operation);
            boolean updateInv = DeliveryUtil.getUpdateInv(sourceBillType, operation);
            orders[i] = order;
            DeliveryUtil.updateSaleOrderEntry(order, orderEntry, deliverydetail, updateInv, operation, list, updateDelQty);
            if (BILLTYPE_DISPATCH.equals(sourceBillType)) {
                deliverydetail.set(MAINBILLID, orderEntry.get("sourcebillId"));
                deliverydetail.set(MAINBILLENTRYID, orderEntry.get("sourceentryid"));
                DispatchOrderHandler.handleStatusAfterSignOrDelivery(order);
            } else {
                SaleOrderHandler.handleStatusAfterSignOrDelivery(order);
            }
            ++i;
        }
        if (list.size() > 0) {
            ItemStoreUtil.updateItemStore(list);
        }
        SaveServiceHelper.save((DynamicObject[])orders);
        if (BILLTYPE_DISPATCH.equals(sourceBillType)) {
            DeliveryUtil.updateSaleOrderByDispatch(deliveryRecord, operation, deliverydetailCollection, list);
        }
    }

    private static void updateSaleOrderByDispatch(DynamicObject deliveryRecord, DeliveryOperation operation, DynamicObjectCollection deliverydetailCollection, List<ItemStoreModel> list) {
        Map<Object, DynamicObject> ordersMap = DeliveryUtil.getOrdersMap(deliveryRecord, BILLTYPE_SALEORDER, operation.getOperation());
        DynamicObject saleorder = new DynamicObject();
        DynamicObjectCollection entrys = new DynamicObjectCollection();
        Map<Object, Object> entryMap = new HashMap(deliverydetailCollection.size());
        DynamicObject[] saleorders = new DynamicObject[deliverydetailCollection.size()];
        int i = 0;
        for (DynamicObject detail : deliverydetailCollection) {
            saleorder = ordersMap.get(detail.getLong(MAINBILLID));
            if (saleorder == null) continue;
            entrys = saleorder.getDynamicObjectCollection("itementry");
            entryMap = CommonUtils.collection2Map("id", (List<DynamicObject>)entrys);
            Long orderentryId = detail.getLong(MAINBILLENTRYID);
            DynamicObject orderEntry = (DynamicObject)entryMap.get(orderentryId);
            saleorders[i] = saleorder;
            DeliveryUtil.updateSaleOrderEntry(saleorder, orderEntry, detail, false, operation, list);
            SaleOrderHandler.handleStatusAfterSignOrDelivery(saleorder);
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])saleorders);
    }

    private static String getOrderIdType(String sourceBillType) {
        if (BILLTYPE_DISPATCH.equals(sourceBillType)) {
            return SRCBILLID;
        }
        return MAINBILLID;
    }

    private static String getOrderEntryIdType(String sourceBillType) {
        if (BILLTYPE_DISPATCH.equals(sourceBillType)) {
            return SRCBILLENTRYID;
        }
        return MAINBILLENTRYID;
    }

    private static boolean getUpdateInv(String sourceBillType, DeliveryOperation operation) {
        boolean updateInv = true;
        if (sourceBillType.equals(BILLTYPE_SALOUTBILL) && (DeliveryOperation.SEND == operation || DeliveryOperation.UNSEND == operation)) {
            updateInv = false;
        }
        if (sourceBillType.equals(BILLTYPE_OEMORDER)) {
            updateInv = false;
        }
        return updateInv;
    }

    private static boolean getUpdateDelQty(String sourceBillType, DeliveryOperation operation) {
        boolean updateDelQty = true;
        if (sourceBillType.equals(BILLTYPE_SALOUTBILL) && (DeliveryOperation.SEND == operation || DeliveryOperation.UNSEND == operation)) {
            updateDelQty = false;
        }
        return updateDelQty;
    }

    public static Map<Object, DynamicObject> getOrdersMap(DynamicObject deliveryRecord, String billType, String operation) {
        if (deliveryRecord == null || deliveryRecord.getDynamicObjectCollection(ENTRY_DELIVERYDETAIL) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u8d27\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"DeliveryUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection deliverydetailCollection = deliveryRecord.getDynamicObjectCollection(ENTRY_DELIVERYDETAIL);
        HashSet<Long> mainBillIds = new HashSet<Long>(deliverydetailCollection.size());
        HashSet<Long> sourceBillIds = new HashSet<Long>(deliverydetailCollection.size());
        for (DynamicObject deliveryDetail : deliverydetailCollection) {
            if (deliveryDetail.getLong(MAINBILLID) > 0L) {
                mainBillIds.add(deliveryDetail.getLong(MAINBILLID));
            }
            if (deliveryDetail.getLong(SRCBILLID) <= 0L) continue;
            sourceBillIds.add(deliveryDetail.getLong(SRCBILLID));
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bbc_saleorder");
        Object[] ids = mainBillIds.toArray();
        switch (billType) {
            case "dispatchorder": {
                entityType = MetadataServiceHelper.getDataEntityType((String)"mdr_dispatch_order");
                ids = sourceBillIds.toArray();
                break;
            }
            case "saleorder": {
                break;
            }
            case "oemorder": {
                break;
            }
        }
        DynamicObject[] orders = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)entityType);
        if (orders == null || orders.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]), operation));
        }
        Map<Object, DynamicObject> ordersMap = DeliveryUtil.array2Map("id", orders);
        return ordersMap;
    }

    public static void updateSaleOrderEntry(DynamicObject order, DynamicObject orderEntry, DynamicObject deliverydetail, boolean updateInv, DeliveryOperation operation, List<ItemStoreModel> itemStorelist) {
        DeliveryUtil.updateSaleOrderEntry(order, orderEntry, deliverydetail, updateInv, operation, itemStorelist, true);
    }

    public static void updateSaleOrderEntry(DynamicObject order, DynamicObject orderEntry, DynamicObject deliverydetail, boolean updateInv, DeliveryOperation operation, List<ItemStoreModel> itemStorelist, boolean updateDelQty) {
        BigDecimal signedqty;
        BigDecimal deliveredqty;
        if (orderEntry == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]), operation.getOperation()));
        }
        BigDecimal deliverqty = (BigDecimal)deliverydetail.get("deliverqty");
        BigDecimal signQty = deliverydetail.getBigDecimal("signQty");
        if (DeliveryOperation.SEND == operation && updateDelQty) {
            if (deliverqty == null) {
                return;
            }
            deliveredqty = (BigDecimal)orderEntry.get("deliveredqty");
            deliveredqty = deliverqty.add(deliveredqty);
            orderEntry.set("deliveredqty", (Object)deliveredqty);
        } else if (DeliveryOperation.UNSEND == operation && updateDelQty) {
            if (deliverqty == null) {
                return;
            }
            deliveredqty = (BigDecimal)orderEntry.get("deliveredqty");
            deliveredqty = deliveredqty.subtract(deliverqty);
            orderEntry.set("deliveredqty", (Object)deliveredqty);
        } else if (DeliveryOperation.SIGN == operation) {
            if (signQty == null) {
                return;
            }
            signedqty = (BigDecimal)orderEntry.get("signedqty");
            signedqty = signedqty.add(signQty);
            orderEntry.set("signedqty", (Object)signedqty);
        } else if (DeliveryOperation.UNSIGN == operation) {
            if (signQty == null) {
                return;
            }
            signedqty = (BigDecimal)orderEntry.get("signedqty");
            signedqty = signedqty.subtract(signQty);
            orderEntry.set("signedqty", (Object)signedqty);
        }
        Object biztypeId = order.getDynamicObject("biztype").get("id");
        Set<Object> notUpdateInvBizTypes = SysParamsUtil.notUpdateInvBizTypes();
        Set<Long> noUpdateInvBizTypes = ItemStoreUtil.noUpdateInvBizTypes();
        if (!notUpdateInvBizTypes.contains(biztypeId) && updateInv && !noUpdateInvBizTypes.contains(biztypeId)) {
            DeliveryUtil.updateStoreBySaleOrder(order, orderEntry, operation, itemStorelist, deliverqty, signQty);
        }
    }

    private static void updateStoreBySaleOrder(DynamicObject order, DynamicObject orderEntry, DeliveryOperation operation, List<ItemStoreModel> itemStorelist, BigDecimal deliverqty, BigDecimal signQty) {
        DynamicObject owner = (DynamicObject)order.get("owner");
        if (owner == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u4f9b\u8d27\u6e20\u9053\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]), operation.getOperation()));
        }
        DynamicObject customer = (DynamicObject)order.get("customer");
        if (customer == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u8981\u8d27\u6e20\u9053\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_3", (String)"drp-mdr-common", (Object[])new Object[0]), operation.getOperation()));
        }
        DynamicObject item = (DynamicObject)orderEntry.get("item");
        if (item == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]), operation.getOperation()));
        }
        DynamicObject unit = (DynamicObject)orderEntry.get("unit");
        if (unit == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]), operation.getOperation()));
        }
        Object assistattrId = 0L;
        DynamicObject assistattr = (DynamicObject)orderEntry.get("assistattr");
        if (assistattr != null) {
            assistattrId = assistattr.get("id");
        }
        DynamicObject warehouse = (DynamicObject)orderEntry.get("entrywarehouse");
        DynamicObject receivewarehouse = (DynamicObject)orderEntry.get("entryreceivewarehouse");
        Object storeChangeCustomerId = 0L;
        Object storeChangeWarehouseId = 0L;
        BigDecimal storeChangeQty = null;
        BigDecimal storeOrderChangeQty = null;
        if (DeliveryOperation.SEND == operation) {
            if (deliverqty != null && BigDecimal.ZERO.compareTo(deliverqty) != 0) {
                storeOrderChangeQty = storeChangeQty = BigDecimal.ZERO.subtract(deliverqty);
            }
            if (warehouse != null) {
                storeChangeWarehouseId = warehouse.get("id");
            }
            storeChangeCustomerId = owner.get("id");
        } else if (DeliveryOperation.UNSEND == operation) {
            storeOrderChangeQty = storeChangeQty = deliverqty;
            if (warehouse != null) {
                storeChangeWarehouseId = warehouse.get("id");
            }
            storeChangeCustomerId = owner.get("id");
        } else if (DeliveryOperation.SIGN == operation) {
            storeChangeQty = signQty;
            if (receivewarehouse != null) {
                storeChangeWarehouseId = receivewarehouse.get("id");
            }
            storeChangeCustomerId = customer.get("id");
        } else if (DeliveryOperation.UNSIGN == operation) {
            if (signQty != null && BigDecimal.ZERO.compareTo(signQty) != 0) {
                storeChangeQty = BigDecimal.ZERO.subtract(signQty);
            }
            if (receivewarehouse != null) {
                storeChangeWarehouseId = receivewarehouse.get("id");
            }
            storeChangeCustomerId = customer.get("id");
        }
        if (storeChangeQty != null) {
            ItemStoreModel itemStore = new ItemStoreModel(storeChangeCustomerId, item.get("id"), unit.get("id"), assistattrId, storeChangeWarehouseId, storeChangeQty, storeOrderChangeQty);
            itemStorelist.add(itemStore);
        }
    }

    public static Map<Object, DynamicObject> array2Map(String mapKey, DynamicObject[] collection) {
        if (mapKey == null || collection == null || collection.length == 0) {
            return new HashMap<Object, DynamicObject>();
        }
        int len = collection.length;
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(len);
        DynamicObject data = null;
        for (int i = 0; i < len; ++i) {
            data = collection[i];
            map.put(data.get(mapKey), data);
        }
        return map;
    }

    private static enum DeliveryOperation {
        SEND(ResManager.loadKDString((String)"\u53d1\u8d27", (String)"DeliveryUtil_8", (String)"drp-mdr-common", (Object[])new Object[0])),
        UNSEND(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u8d27", (String)"DeliveryUtil_9", (String)"drp-mdr-common", (Object[])new Object[0])),
        SIGN(ResManager.loadKDString((String)"\u7b7e\u6536", (String)"DeliveryUtil_10", (String)"drp-mdr-common", (Object[])new Object[0])),
        UNSIGN(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u6536\u8d27", (String)"DeliveryUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]));

        private String operation;

        private DeliveryOperation(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

