/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.model.ItemStoreModel;
import kd.drp.mdr.common.status.DispatchOrderPayStatus;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.SysParamsUtil;

public class DispatchOrderUtil {
    public static boolean isThisStatus(DynamicObject order, DispatchOrderStatus status) {
        return EnumUtil.toDispatchOrderStatus(order.getString("orderstatus")) == status;
    }

    public static DispatchOrderStatus getOrderStatus(DynamicObject order) {
        return EnumUtil.toDispatchOrderStatus(order.getString("orderstatus"));
    }

    public static DispatchOrderPayStatus getOrderPayStatus(DynamicObject order) {
        return EnumUtil.toDispatchOrderPayStatus(order.getString("paystatus"));
    }

    public static void handleStoreForward(DynamicObject order) {
        if (!SysParamsUtil.isDispatch()) {
            return;
        }
        boolean tempSaveStatus = DispatchOrderUtil.isThisStatus(order, DispatchOrderStatus.TEMP_SAVE);
        Object biztypeid = order.getDynamicObject("biztype").get("id");
        List<ItemStoreModel> stores = null;
        stores = tempSaveStatus ? DispatchOrderUtil.createItemStoreForward(order) : DispatchOrderUtil.createItemStoreContrastOldData(order);
        ItemStoreUtil.updateItemStore4Bill(stores, biztypeid);
    }

    public static void reverseHandleStoreForward(DynamicObject order) {
        if (!SysParamsUtil.isDispatch()) {
            return;
        }
        Object biztypeid = order.getDynamicObject("biztype").get("id");
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        int len = entrys.size();
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>(len);
        ItemStoreModel store = null;
        for (int i = 0; i < len; ++i) {
            store = DispatchOrderUtil.createItemStoreModel(ownerId, (DynamicObject)entrys.get(i));
            DispatchOrderUtil.reverseItemStore(store);
            stores.add(store);
        }
        ItemStoreUtil.updateItemStore4Bill(stores, biztypeid);
    }

    private static List<ItemStoreModel> createItemStoreForward(DynamicObject order) {
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        int len = entrys.size();
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>(len);
        for (int i = 0; i < len; ++i) {
            stores.add(DispatchOrderUtil.createItemStoreModel(ownerId, (DynamicObject)entrys.get(i)));
        }
        return stores;
    }

    private static ItemStoreModel createItemStoreModel(Object ownerId, DynamicObject entry) {
        Object itemId = entry.getDynamicObject("item").get("id");
        Object measureunitId = entry.getDynamicObject("unit").get("id");
        Object assistattrId = 0L;
        DynamicObject assistattr = entry.getDynamicObject("assistattr");
        if (assistattr != null) {
            assistattrId = assistattr.get("id");
        }
        Object warehouseId = 0L;
        DynamicObject entrywarehouse = entry.getDynamicObject("entrywarehouse");
        if (entrywarehouse != null) {
            warehouseId = entrywarehouse.get("id");
        }
        BigDecimal qty = entry.getBigDecimal("qty");
        return new ItemStoreModel(ownerId, itemId, measureunitId, assistattrId, warehouseId, null, qty);
    }

    private static List<ItemStoreModel> createItemStoreContrastOldData(DynamicObject order) {
        int i;
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObjectCollection oldEntrys = DispatchOrderUtil.queryOldEntrys(order);
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        int oldLen = oldEntrys.size();
        int newLen = entrys.size();
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>(oldLen + newLen);
        ItemStoreModel store = null;
        for (i = 0; i < oldLen; ++i) {
            store = DispatchOrderUtil.createItemStoreModelFromOldEntry(ownerId, (DynamicObject)oldEntrys.get(i));
            DispatchOrderUtil.reverseItemStore(store);
            stores.add(store);
        }
        for (i = 0; i < newLen; ++i) {
            stores.add(DispatchOrderUtil.createItemStoreModel(ownerId, (DynamicObject)entrys.get(i)));
        }
        return stores;
    }

    private static DynamicObjectCollection queryOldEntrys(DynamicObject order) {
        QFilter f = new QFilter("id", "=", order.get("id"));
        DynamicObjectCollection oldEntrys = QueryServiceHelper.query((String)"mdr_dispatch_order", (String)"itementry.id,itementry.item,itementry.unit,itementry.entrywarehouse,itementry.assistattr,itementry.qty", (QFilter[])f.toArray());
        return oldEntrys;
    }

    private static ItemStoreModel createItemStoreModelFromOldEntry(Object ownerId, DynamicObject entry) {
        Object itemId = entry.get("itementry.item");
        Object measureunitId = entry.get("itementry.unit");
        Object warehouseId = entry.get("itementry.entrywarehouse");
        Object assistattrId = entry.get("itementry.assistattr");
        if (assistattrId == null) {
            assistattrId = 0L;
        }
        BigDecimal qty = entry.getBigDecimal("itementry.qty");
        return new ItemStoreModel(ownerId, itemId, measureunitId, assistattrId, warehouseId, null, qty);
    }

    private static void reverseItemStore(ItemStoreModel store) {
        store.setOrderqtyup(store.getOrderqtyup().negate());
    }

    public static void handleStoreReverse(DynamicObject order) {
        Object biztypeid = order.getDynamicObject("biztype").get("id");
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObjectCollection entrys = DispatchOrderUtil.queryOldEntrys(order);
        int len = entrys.size();
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>(len);
        ItemStoreModel store = null;
        for (int i = 0; i < len; ++i) {
            store = DispatchOrderUtil.createItemStoreModelFromOldEntry(ownerId, (DynamicObject)entrys.get(i));
            DispatchOrderUtil.reverseItemStore(store);
            stores.add(store);
        }
        ItemStoreUtil.updateItemStore4Bill(stores, biztypeid);
    }
}

