/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.strategy.DynamicObjectCopyStrategy;

public class DynamicObjectUtils {
    public static Object getDynamicObjectID(DynamicObject data, String name) {
        DynamicObject ob = data.getDynamicObject(name);
        if (ob == null) {
            return null;
        }
        Object id = ob.get("id");
        return id;
    }

    public static boolean isNewCreate(DynamicObject data) {
        return !data.getDataEntityState().getFromDatabase();
    }

    public static void copyPropertiesWithOutId(DynamicObject toObj, DynamicObject fromObj) {
        DynamicObjectUtils.copyProperties(toObj, fromObj, null, null, false);
    }

    public static void copyPropertiesWithOutId(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys) {
        DynamicObjectUtils.copyProperties(toObj, fromObj, ignoreKeys, null, false);
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, DynamicObjectCopyStrategy cp) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        Object value = null;
        String key = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            key = ((IDataEntityProperty)toPs.get(i)).getName();
            value = cp.copyWhat(key);
            if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue() || !fromObj.getDataEntityType().getProperties().containsKey((Object)key)) continue;
                toObj.set(key, fromObj.get(key));
                continue;
            }
            toObj.set(key, value);
        }
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            toObj.set(keys[i], fromObj.get(keys[i]));
        }
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys, Map<String, String> convertKeysMap, boolean needCopyId) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (!needCopyId) {
            ignoreKeys.add("id");
        }
        String toKey = null;
        String fromKey = null;
        String toValue = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            if (ignoreKeys.contains(toKey)) continue;
            fromKey = toKey;
            if (convertKeysMap != null && convertKeysMap.get(toKey) != null) {
                toValue = convertKeysMap.get(toKey);
            }
            if (!fromPsSet.contains(fromKey)) continue;
            toObj.set(toKey, fromObj.get(fromKey));
        }
    }

    public static DynamicObject getDynamicObjectByNumber(String easnumber, String entityName) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("number", "=", (Object)easnumber).toArray());
    }

    public static DynamicObject getDynamicObjectById(Object id, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)"id");
    }

    public static void setMultiF7Value(DynamicObject dObject, String multiF7Property, String multiF7EntityName, Object[] multiF7PKIds) {
        DynamicObjectCollection dObjectColletion = null;
        if (multiF7PKIds != null) {
            MulBasedataProp mulBaseDataProp = (MulBasedataProp)dObject.getDynamicObjectType().getProperty(multiF7Property);
            ArrayList<DynamicObject> dObjectList = new ArrayList<DynamicObject>(multiF7PKIds.length);
            for (Object pkId : multiF7PKIds) {
                DynamicObject basedata = new DynamicObject(mulBaseDataProp.getDynamicCollectionItemPropertyType());
                basedata.set("fbasedataid_id", pkId);
                DynamicObjectUtils.setF7Value(basedata, "fbasedataid", multiF7EntityName, pkId, null);
                dObjectList.add(basedata);
            }
            dObjectColletion = new DynamicObjectCollection(mulBaseDataProp.getDynamicCollectionItemPropertyType(), (Object)mulBaseDataProp.getParent(), dObjectList);
            dObject.set(multiF7Property, (Object)dObjectColletion);
        }
    }

    public static void setF7Value(DynamicObject dObject, String f7Property, String f7EntityName, Object pkId, Object defaultPkId) {
        if (pkId != null) {
            long pkid = Long.parseLong(pkId.toString());
            DynamicObject f7 = BusinessDataServiceHelper.newDynamicObject((String)f7EntityName);
            if (pkid > 0L) {
                f7.set("id", pkId);
                dObject.set(f7Property, (Object)f7);
            } else if (defaultPkId != null) {
                f7.set("id", defaultPkId);
                dObject.set(f7Property, (Object)f7);
            }
        }
    }

    public static Object getPkId(DynamicObject data, String name) {
        Object idobject = data.get(name);
        if (idobject == null) {
            return null;
        }
        return idobject.getClass().equals(DynamicObject.class) ? ((DynamicObject)idobject).getPkValue() : idobject;
    }
}

