/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.itemclass.ItemClassUtil;
import kd.drp.mdr.common.util.CustomerUtil;

public class EvaluateUtil {
    public static boolean hasEvaluate(Object orderId) {
        QFilter f = new QFilter("billnumber", "=", orderId);
        f.and("billstatus", "=", (Object)"C");
        return QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])f.toArray());
    }

    public static List<Map<String, Object>> getEvaluateTagsByOwnerId(Object ownerId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Object> customerGroups = CustomerUtil.getCustomerGroups(ownerId);
        customerGroups.add(0L);
        QFilter qf = new QFilter("evaluatetagtype", "=", (Object)"0");
        qf.and("enable", "=", (Object)"1");
        qf.and("customergroup", "in", customerGroups);
        String strFiled = "customergroup,entryentity.evaluatetagnumber.id,entryentity.evaluatetagnumber.name,entryentity.evaluatetagnumber.number";
        DynamicObjectCollection evaluatetagSettings = QueryServiceHelper.query((String)"mdr_evaluatetag_setting", (String)strFiled, (QFilter[])qf.toArray(), (String)"customergroup");
        boolean hasTags = false;
        for (Object customerGroup : customerGroups) {
            for (DynamicObject setting : evaluatetagSettings) {
                Object settingGroup = setting.get("customergroup");
                if (!customerGroup.equals(settingGroup)) continue;
                Object id = setting.get("entryentity.evaluatetagnumber.id");
                Object name = setting.get("entryentity.evaluatetagnumber.name");
                Object number = setting.get("entryentity.evaluatetagnumber.number");
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", id);
                tag.put("name", name);
                tag.put("number", number);
                list.add(tag);
                hasTags = true;
            }
            if (!hasTags) continue;
            break;
        }
        return list;
    }

    public static List<Map<String, Object>> getEvaluateTagsByItemId(Object itemId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Object> classes = ItemClassUtil.queryClassList(itemId);
        classes.add(0L);
        QFilter qf = new QFilter("evaluatetagtype", "=", (Object)"1");
        qf.and("enable", "=", (Object)"1");
        qf.and("itemclass", "in", classes);
        qf.and(QFilter.isNotNull((String)"entryentity.evaluatetagnumber.id"));
        String strFiled = "itemclass,customergroup,entryentity.evaluatetagnumber.id,entryentity.evaluatetagnumber.name,entryentity.evaluatetagnumber.number";
        DynamicObjectCollection evaluatetagSettings = QueryServiceHelper.query((String)"mdr_evaluatetag_setting", (String)strFiled, (QFilter[])qf.toArray(), (String)"itemclass");
        boolean hasTags = false;
        for (Object itemClass : classes) {
            for (DynamicObject setting : evaluatetagSettings) {
                Object settingClass = setting.get("itemclass");
                if (!itemClass.equals(settingClass)) continue;
                Object id = setting.get("entryentity.evaluatetagnumber.id");
                Object name = setting.get("entryentity.evaluatetagnumber.name");
                Object number = setting.get("entryentity.evaluatetagnumber.number");
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", id);
                tag.put("name", name);
                tag.put("number", number);
                tag.put("score", new BigDecimal(5));
                list.add(tag);
                hasTags = true;
            }
            if (!hasTags) continue;
            break;
        }
        return list;
    }

    public static List<Map<String, Object>> getEvaluateLabelsByOwnerId(Object ownerId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Object> customerGroups = CustomerUtil.getCustomerGroups(ownerId);
        customerGroups.add(0L);
        QFilter qf = new QFilter("evaluatelabeltype", "=", (Object)"0");
        qf.and("enable", "=", (Object)"1");
        qf.and("customergroup", "in", customerGroups);
        qf.and(QFilter.isNotNull((String)"entryentity.labelnumber.id"));
        String strFiled = "customergroup,entryentity.labelnumber.id,entryentity.labelnumber.name,entryentity.labelnumber.number";
        DynamicObjectCollection evaluatetagSettings = QueryServiceHelper.query((String)"mdr_evalabel_setting", (String)strFiled, (QFilter[])qf.toArray(), (String)"customergroup");
        boolean hasTags = false;
        for (Object customerGroup : customerGroups) {
            for (DynamicObject setting : evaluatetagSettings) {
                Object settingGroup = setting.get("customergroup");
                if (!customerGroup.equals(settingGroup)) continue;
                Object id = setting.get("entryentity.labelnumber.id");
                Object name = setting.get("entryentity.labelnumber.name");
                Object number = setting.get("entryentity.labelnumber.number");
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", id);
                tag.put("name", name);
                tag.put("number", number);
                list.add(tag);
                hasTags = true;
            }
            if (!hasTags) continue;
            break;
        }
        return list;
    }

    public static List<Map<String, Object>> getEvaluateLabelsByItemId(Object itemId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Object> classes = ItemClassUtil.queryClassList(itemId);
        classes.add(0L);
        QFilter qf = new QFilter("evaluatelabeltype", "=", (Object)"1");
        qf.and("enable", "=", (Object)"1");
        qf.and("itemclass", "in", classes);
        qf.and(QFilter.isNotNull((String)"entryentity.labelnumber.id"));
        String strFiled = "itemclass,entryentity.labelnumber.id,entryentity.labelnumber.name,entryentity.labelnumber.number";
        DynamicObjectCollection evaluatetagSettings = QueryServiceHelper.query((String)"mdr_evalabel_setting", (String)strFiled, (QFilter[])qf.toArray(), (String)"itemclass");
        boolean hasTags = false;
        for (Object itemClass : classes) {
            for (DynamicObject setting : evaluatetagSettings) {
                Object settingClass = setting.get("itemclass");
                if (!itemClass.equals(settingClass)) continue;
                Object id = setting.get("entryentity.labelnumber.id");
                Object name = setting.get("entryentity.labelnumber.name");
                Object number = setting.get("entryentity.labelnumber.number");
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", id);
                tag.put("name", name);
                tag.put("number", number);
                list.add(tag);
                hasTags = true;
            }
            if (!hasTags) continue;
            break;
        }
        return list;
    }

    public static Object getItemEvaluateIDByEntryId(Object entryid) {
        DynamicObject eval = QueryServiceHelper.queryOne((String)"mdr_item_evaluate", (String)"id", (QFilter[])new QFilter("orderentryid", "=", entryid).toArray());
        return eval == null ? null : eval.get("id");
    }
}

