/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.QueryUtil;

public class ItemAttrUtil {
    public static DynamicObject loadAttrInfo(Object attrId) {
        if (attrId == null || attrId.toString().equals("0")) {
            return null;
        }
        DynamicObject attrInfo = BusinessDataServiceHelper.loadSingle((Object)attrId, (String)"mdr_item_attrvalue");
        return attrInfo;
    }

    public static DynamicObjectCollection getAttrInfoByItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("id", "=", itemId);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_item_info", (String)"attrentry.attr,attrentry.attr.name", (QFilter[])fs.toArray(), (String)"attrentry.attr");
        return attrs;
    }

    public static DynamicObjectCollection getAttrValuesByItemId(Object itemId, Object attrId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        if (attrId != null) {
            fs.and("attrentity.attrvalue.group", "=", attrId);
        }
        ORMImpl orm = new ORMImpl();
        WithDistinctable dis = WithDistinctable.get();
        DynamicObjectCollection attrs = null;
        try (DataSet data = orm.queryDataSet(ItemAttrUtil.class.getName(), "mdr_item_attrvalue", "attrentity.attrvalue,attrentity.attrvalue.name", fs.toArray(), "", 1000, (Distinctable)dis);){
            attrs = orm.toPlainDynamicObjectCollection(data);
        }
        return attrs;
    }

    public static DynamicObjectCollection getAttrValuesById(Object itemattrvalueId) {
        if (itemattrvalueId == null) {
            return null;
        }
        QFilter fs = new QFilter("id", "=", itemattrvalueId);
        ORMImpl orm = new ORMImpl();
        WithDistinctable dis = WithDistinctable.get();
        DynamicObjectCollection attrs = null;
        try (DataSet data = orm.queryDataSet(ItemAttrUtil.class.getName(), "mdr_item_attrvalue", "attrentity.attrvalue,attrentity.attrvalue.name,attrentity.attrvalue.group", fs.toArray(), "", 1000, (Distinctable)dis).orderBy(new String[]{"attrentity.attrvalue.group desc"});){
            attrs = orm.toPlainDynamicObjectCollection(data);
        }
        return attrs;
    }

    public static DynamicObjectCollection getAttrIdByAttrValueId(Object attrvalueId) {
        if (attrvalueId == null) {
            return null;
        }
        QFilter fs = new QFilter("id", "=", attrvalueId);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_assist_value", (String)"group", (QFilter[])fs.toArray());
        return attrs;
    }

    public static Set<Object> getAttrIds(Object itemId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        Set<Object> attrIds = QueryUtil.querySingleCol("mdr_item_attrvalue", "id", fs.toArray());
        return attrIds;
    }

    public static DynamicObject[] getAttrInfos(Object itemId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        DynamicObject[] attrIds = BusinessDataServiceHelper.load((String)"mdr_item_attrvalue", (String)"id,name,number,attrseq,attrentity.attrvalue", (QFilter[])fs.toArray());
        return attrIds;
    }

    public static QFilter getAttrFilter(Object itemId) {
        QFilter f = new QFilter("id", "in", ItemAttrUtil.getAttrIds(itemId));
        return f;
    }

    @Deprecated
    public static boolean hasAssistAttr(Object itemId) {
        DynamicObject itemInfo = ItemUtil.getItemBizInfo(itemId);
        boolean hasattr = false;
        if (itemInfo != null) {
            hasattr = itemInfo.getBoolean("hasattr");
        }
        return hasattr;
    }

    public static boolean hasAssistAttr(Object itemId, Object attrId) {
        if (itemId == null || attrId == null) {
            return false;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        fs.and("id", "=", attrId);
        DynamicObject info = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_item_attrvalue", (String)"id", (QFilter[])fs.toArray());
        return info != null;
    }

    public static DynamicObject getDefaultAttr(Object itemId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_item_attrvalue", (String)"id", (QFilter[])fs.toArray(), (String)"attrseq");
        return attrs == null || attrs.size() == 0 ? null : (DynamicObject)attrs.get(0);
    }

    public static DynamicObjectCollection getAttrList(Object itemId) {
        return ItemAttrUtil.getAttrList(itemId, "id,name,number");
    }

    public static DynamicObjectCollection getAttrList(Object itemId, String field) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("item", "=", itemId);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_item_attrvalue", (String)field, (QFilter[])fs.toArray(), (String)"attrseq");
        return attrs;
    }

    public static Object getDefaultAttrId(Object itemId) {
        DynamicObject attr = ItemAttrUtil.getDefaultAttr(itemId);
        return attr == null ? null : attr.get("id");
    }

    public static Map<Object, Object> getDefaultAttrId(Set<Object> itemIds) {
        if (itemIds == null || itemIds.size() == 0) {
            return null;
        }
        QFilter fs = new QFilter("item", "in", itemIds);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_item_attrvalue", (String)"item,id", (QFilter[])fs.toArray(), (String)"item,attrseq");
        HashMap<Object, Object> attrids = new HashMap<Object, Object>(itemIds.size());
        Object olditem = 0L;
        Object pkid = null;
        for (DynamicObject attr : attrs) {
            pkid = attr.get("item");
            if (olditem.equals(pkid)) continue;
            attrids.put(pkid, attr.get("id"));
            olditem = pkid;
        }
        return attrids;
    }
}

