/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.model.ItemStoreModel;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ObjectLockUtil;
import org.apache.log4j.Logger;

public class ItemStoreUtil {
    private static final Logger log = Logger.getLogger(ItemStoreUtil.class);
    private static final DBRoute MDR_DBROUTE = new DBRoute("mdr");
    private static final String DLOCK_KEY = "/drp/mdr/itemstore";
    private static final char STATUS_NORMAL = 'B';
    private static final char STATUS_FROZEN = 'A';
    private static final int SPIN_TIMES = 3;
    private static final int SPIN_TIMEWAIT = 1000;
    private static final int DLOCK_TIME = 5000;
    private static String initStoreSql = "update t_mdr_itemstore set fqty = ? where fid = ?";
    private static String updateStoreSql = "update t_mdr_itemstore set fqty = fqty + ? , forderqty = forderqty + ? where fid = ?";

    public static BigDecimal queryItemStoreQty(Object customerid, Object itemid, Object measureunitid, Object assistattrid, Object warehouseid) {
        DynamicObject o = ItemStoreUtil.queryRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
        if (o == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal qty = o.getBigDecimal("qty");
        BigDecimal orderqty = o.getBigDecimal("orderqty");
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        if (orderqty == null) {
            orderqty = BigDecimal.ZERO;
        }
        return qty.subtract(orderqty);
    }

    public static DynamicObject queryItemStore(Object customerid, Object itemid, Object measureunitid, Object assistattrid, Object warehouseid) {
        DynamicObject o = ItemStoreUtil.queryRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
        if (o == null) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    o = ItemStoreUtil.insertRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
                }
                catch (Exception e) {
                    log.info((Object)"\u5df2\u5b58\u5728\u76f8\u540c\u5e93\u5b58\u8bb0\u5f55\uff0c\u63d2\u5165\u5e93\u5b58\u6570\u636e\u5931\u8d25");
                    h.markRollback();
                }
            }
            o = ItemStoreUtil.queryRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
        }
        return o;
    }

    public static List<DynamicObject> queryItemStoreBatch(Object ownerId, DynamicObjectCollection itemEntryCollection) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        ArrayList<Long> unitIds = new ArrayList<Long>();
        ArrayList<Long> assistAttrIds = new ArrayList<Long>();
        ArrayList<Long> warehouseIds = new ArrayList<Long>();
        for (DynamicObject itemEntry : itemEntryCollection) {
            itemIds.add(itemEntry.getDynamicObject("item") != null ? itemEntry.getDynamicObject("item").getLong("id") : 0L);
            unitIds.add(itemEntry.getDynamicObject("unit") != null ? itemEntry.getDynamicObject("unit").getLong("id") : 0L);
            assistAttrIds.add(itemEntry.getDynamicObject("assistattr") != null ? itemEntry.getDynamicObject("assistattr").getLong("id") : 0L);
            warehouseIds.add(itemEntry.getDynamicObject("entrywarehouse") != null ? itemEntry.getDynamicObject("entrywarehouse").getLong("id") : 0L);
        }
        QFilter filter = new QFilter("customer", "=", ownerId);
        filter.and("item", "in", itemIds);
        filter.and("measureunit", "in", unitIds);
        filter.and("warehouse", "in", warehouseIds);
        filter.and("assistattr", "in", assistAttrIds);
        DynamicObject[] myStoreDynFromDB = BusinessDataServiceHelper.load((String)"mdr_item_store", (String)"id,number,customer,item,assistattr,measureunit,warehouse,qty,orderqty,status", (QFilter[])filter.toArray());
        List<DynamicObject> newMyStoreDyns = ItemStoreUtil.insertIfNotExist(ownerId, itemEntryCollection, myStoreDynFromDB);
        newMyStoreDyns.addAll(Arrays.asList(myStoreDynFromDB));
        return newMyStoreDyns;
    }

    private static List<DynamicObject> insertIfNotExist(Object ownerId, DynamicObjectCollection itemEntryCollection, DynamicObject[] myStoreDynColl) {
        List<DynamicObject> itemEntryNoItemStore = ItemStoreUtil.findNotExist(itemEntryCollection, myStoreDynColl);
        List<DynamicObject> newMyStoreDyns = ItemStoreUtil.buildMyStoreDyns(ownerId, itemEntryNoItemStore);
        if (newMyStoreDyns.size() == 0) {
            return newMyStoreDyns;
        }
        SaveServiceHelper.save((DynamicObject[])newMyStoreDyns.toArray(new DynamicObject[0]));
        return newMyStoreDyns;
    }

    private static List<DynamicObject> findNotExist(DynamicObjectCollection itemEntryCollection, DynamicObject[] myStoreDynColl) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(myStoreDynColl.length);
        if (itemEntryCollection.size() == myStoreDynColl.length) {
            return result;
        }
        List itemIds = Arrays.stream(myStoreDynColl).map(i -> i.getLong("item_id")).collect(Collectors.toList());
        for (DynamicObject itemEntry : itemEntryCollection) {
            long warehouseId;
            long itemId = itemEntry.getDynamicObject("item") != null ? itemEntry.getDynamicObject("item").getLong("id") : 0L;
            long unitId = itemEntry.getDynamicObject("unit") != null ? itemEntry.getDynamicObject("unit").getLong("id") : 0L;
            long assistattrId = itemEntry.getDynamicObject("assistattr") != null ? itemEntry.getDynamicObject("assistattr").getLong("id") : 0L;
            long l = warehouseId = itemEntry.getDynamicObject("entrywarehouse") != null ? itemEntry.getDynamicObject("entrywarehouse").getLong("id") : 0L;
            if (myStoreDynColl.length == 0 || !itemIds.contains(itemId)) {
                result.add(itemEntry);
                continue;
            }
            List tempMyStoreDyns = Arrays.stream(myStoreDynColl).filter(i -> i.getLong("item_id") == itemId).collect(Collectors.toList());
            List assistattrIds = tempMyStoreDyns.stream().map(i -> i.getLong("assistattr_id")).collect(Collectors.toList());
            if (!assistattrIds.contains(assistattrId)) {
                result.add(itemEntry);
                continue;
            }
            List unitIds = (tempMyStoreDyns = tempMyStoreDyns.stream().filter(i -> i.getLong("assistattr_id") == assistattrId).collect(Collectors.toList())).stream().map(i -> i.getLong("measureunit_id")).collect(Collectors.toList());
            if (!unitIds.contains(unitId)) {
                result.add(itemEntry);
                continue;
            }
            List warehouseIds = (tempMyStoreDyns = tempMyStoreDyns.stream().filter(i -> i.getLong("measureunit_id") == unitId).collect(Collectors.toList())).stream().map(i -> i.getLong("warehouse_id")).collect(Collectors.toList());
            if (warehouseIds.contains(warehouseId)) continue;
            result.add(itemEntry);
        }
        return result;
    }

    private static List<DynamicObject> buildMyStoreDyns(Object ownerId, List<DynamicObject> itemEntryNoItemStore) {
        ArrayList<DynamicObject> newMyStoreDyns = new ArrayList<DynamicObject>(itemEntryNoItemStore.size());
        for (DynamicObject itemEntry : itemEntryNoItemStore) {
            long itemId = itemEntry.getDynamicObject("item") != null ? itemEntry.getDynamicObject("item").getLong("id") : 0L;
            long unitId = itemEntry.getDynamicObject("unit") != null ? itemEntry.getDynamicObject("unit").getLong("id") : 0L;
            long assistattrId = itemEntry.getDynamicObject("assistattr") != null ? itemEntry.getDynamicObject("assistattr").getLong("id") : 0L;
            long warehouseId = itemEntry.getDynamicObject("entrywarehouse") != null ? itemEntry.getDynamicObject("entrywarehouse").getLong("id") : 0L;
            DynamicObject unitinfo = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)unitId)});
            DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_store");
            o.set("customer", ownerId);
            o.set("item", (Object)itemId);
            o.set("measureunit", (Object)unitId);
            o.set("assistattr", (Object)assistattrId);
            o.set("warehouse", (Object)warehouseId);
            o.set("status", (Object)Character.valueOf('B'));
            o.set("qty", (Object)BigDecimal.ZERO.setScale(unitinfo.getInt("precision")));
            o.set("orderqty", (Object)BigDecimal.ZERO.setScale(unitinfo.getInt("precision")));
            newMyStoreDyns.add(o);
        }
        return newMyStoreDyns;
    }

    public static DynamicObjectCollection queryAllAttrItemStore(Object customerid, Object itemid, Object measureunitid, boolean isAllowNegativeStore) {
        DynamicObjectCollection itemstores;
        QFilter filter = new QFilter("customer", "=", (Object)Long.parseLong(customerid.toString())).and("item", "=", (Object)Long.parseLong(itemid.toString())).and("measureunit", "=", (Object)Long.parseLong(measureunitid.toString()));
        if (!isAllowNegativeStore) {
            filter.and("qty-orderqty", ">", (Object)0L);
        }
        if ((itemstores = QueryServiceHelper.query((String)"mdr_item_store", (String)"id,assistattr,qty,orderqty", (QFilter[])filter.toArray())) == null || itemstores.isEmpty() || ((DynamicObject)itemstores.get(0)).get("id").equals("0")) {
            return null;
        }
        return itemstores;
    }

    public static DynamicObjectCollection queryItemStoreInfoSum(Object customerid, Object itemid, Object measureunitid, List<Object> assistattrids, Object warehouseid, boolean isAllowNegativeStore) {
        if (customerid == null || itemid == null || measureunitid == null) {
            return null;
        }
        QFilter filter = ItemStoreUtil.queryItemStoreInfoFilter(customerid, itemid, measureunitid, assistattrids, warehouseid, isAllowNegativeStore);
        ORMImpl orm = new ORMImpl();
        try (DataSet data = orm.queryDataSet(ItemStoreUtil.class.getName(), "mdr_item_store", "customer,assistattr,qty,orderqty,qty-orderqty as usableqty", filter.toArray()).groupBy(new String[]{"customer"}).sum("qty").sum("orderqty").sum("usableqty").finish();){
            DynamicObjectCollection attrs;
            DynamicObjectCollection dynamicObjectCollection = attrs = orm.toPlainDynamicObjectCollection(data);
            return dynamicObjectCollection;
        }
    }

    public static DynamicObjectCollection queryItemsStoreInfoSum(Object customerid, Set<Object> itemids, Object warehouseid, boolean isAllowNegativeStore) {
        if (customerid == null || itemids == null) {
            return null;
        }
        QFilter filter = new QFilter("customer", "=", (Object)Long.parseLong(customerid.toString())).and("item", "in", itemids).and("status", "=", (Object)"B");
        if (!isAllowNegativeStore) {
            filter.and("qty-orderqty", ">", (Object)0L);
        }
        if (warehouseid != null) {
            filter.and("warehouse", "=", warehouseid);
        }
        ORMImpl orm = new ORMImpl();
        try (DataSet data = orm.queryDataSet(ItemStoreUtil.class.getName(), "mdr_item_store", "customer,item,measureunit,qty,orderqty,qty-orderqty as usableqty", filter.toArray()).groupBy(new String[]{"customer", "item", "measureunit"}).sum("qty").sum("orderqty").sum("usableqty").finish();){
            DynamicObjectCollection attrs;
            DynamicObjectCollection dynamicObjectCollection = attrs = orm.toPlainDynamicObjectCollection(data);
            return dynamicObjectCollection;
        }
    }

    public static DynamicObjectCollection queryItemStoreInfoDetail(Object customerid, Object itemid, Object measureunitid, List<Object> assistattrids, Object warehouseid, boolean isAllowNegativeStore) {
        if (customerid == null || itemid == null) {
            return null;
        }
        QFilter filter = ItemStoreUtil.queryItemStoreInfoFilter(customerid, itemid, measureunitid, assistattrids, warehouseid, isAllowNegativeStore);
        ORMImpl orm = new ORMImpl();
        WithDistinctable dis = WithDistinctable.get();
        String fields = "assistattr.attrentity.attrvalue,measureunit.id";
        if (measureunitid == null) {
            fields = "measureunit.id";
        }
        try (DataSet data = orm.queryDataSet(ItemAttrUtil.class.getName(), "mdr_item_store", fields, filter.toArray(), "", 10000, (Distinctable)dis);){
            DynamicObjectCollection attrs;
            DynamicObjectCollection dynamicObjectCollection = attrs = orm.toPlainDynamicObjectCollection(data);
            return dynamicObjectCollection;
        }
    }

    private static QFilter queryItemStoreInfoFilter(Object customerid, Object itemid, Object measureunitid, List<Object> assistattrids, Object warehouseid, boolean isAllowNegativeStore) {
        if (customerid == null || itemid == null) {
            return null;
        }
        QFilter filter = new QFilter("customer", "=", (Object)Long.parseLong(customerid.toString())).and("item", "=", (Object)Long.parseLong(itemid.toString())).and("status", "=", (Object)"B");
        if (measureunitid != null) {
            filter.and("measureunit", "=", measureunitid);
        }
        if (!isAllowNegativeStore) {
            filter.and("qty-orderqty", ">", (Object)0L);
        }
        if (assistattrids != null && !assistattrids.isEmpty()) {
            filter.and("assistattr", "in", assistattrids);
        }
        if (warehouseid != null) {
            filter.and("warehouse", "=", warehouseid);
        }
        return filter;
    }

    public static DynamicObject queryItemStoreWithLock(Object customerid, Object itemid, Object measureunitid, Object assistattrid, Object warehouseid) {
        boolean flag;
        DynamicObject o = ItemStoreUtil.queryRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
        if (o == null) {
            o = ItemStoreUtil.insertRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
            o = ItemStoreUtil.queryRecord(customerid, itemid, measureunitid, assistattrid, warehouseid);
        }
        try (TXHandle h = TX.required();){
            try {
                flag = ObjectLockUtil.requestObjectLock(o, "update", ResManager.loadKDString((String)"\u5e93\u5b58\u8c03\u6574\u5355\u5f00\u59cb\u8c03\u6574\u9501\u5e93\u5b58\u8bb0\u5f55", (String)"ItemStoreUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        if (!flag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u8bb0\u5f55\u88ab\u9501\u8bf7\u7a0d\u540e\u64cd\u4f5c", (String)"ItemStoreUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return o;
    }

    public static void updateItemStore4Bill(List<ItemStoreModel> list, Object biztypeid) {
        DynamicObject biztype = QueryServiceHelper.queryOne((String)"mdr_biztype", (String)"id,isupdatestore", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(biztypeid.toString()))});
        if (biztype == null || !biztype.getBoolean("isupdatestore")) {
            return;
        }
        ItemStoreUtil.updateItemStore(list);
    }

    public static Set<Long> noUpdateInvBizTypes() {
        DynamicObjectCollection biztypes = QueryServiceHelper.query((String)"mdr_biztype", (String)"id,isupdatestore", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and("isupdatestore", "=", (Object)false)});
        if (biztypes != null && biztypes.size() > 0) {
            HashSet<Long> types = new HashSet<Long>(biztypes.size());
            for (DynamicObject biztype : biztypes) {
                types.add(biztype.getLong("id"));
            }
            return types;
        }
        return new HashSet<Long>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateItemStore(List<ItemStoreModel> list) {
        HashSet<Object> idset;
        ItemStoreModel m;
        block18: {
            int i = 0;
            while (i < list.size()) {
                m = list.get(i);
                if (!CustomerParamsUtil.isUpdateStore(m.getCustomerid())) {
                    list.remove(i);
                    continue;
                }
                ++i;
            }
            if (list.size() == 0) {
                return;
            }
            idset = new HashSet<Object>(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                m = list.get(i2);
                DynamicObject itemstore = ItemStoreUtil.queryItemStore(m.getCustomerid(), m.getItemid(), m.getMeasureunitid(), m.getAssistattrid(), m.getWarehouseid());
                if (itemstore == null) continue;
                m.setId(itemstore.get("id"));
                idset.add(itemstore.get("id"));
            }
            DLock dlock = DLock.create((String)DLOCK_KEY, (String)ResManager.loadKDString((String)"\u6e20\u9053\u4e91\u5e93\u5b58\u66f4\u65b0\u5206\u5e03\u5f0f\u9501", (String)"ItemStoreUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]));
            if (!dlock.tryLock(5000L)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u6709\u5355\u636e\u5728\u5728\u66f4\u65b0\uff0c\u7b49\u5f85\u9501\u8d85\u65f6(%sms)", (String)"ItemStoreUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]), 5000));
            try {
                boolean exist = true;
                int i3 = 0;
                if (!exist) break block18;
                exist = ItemStoreUtil.isRecordLocked(idset);
                if (exist) {
                    if (i3 >= 3) throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5e93\u5b58\u8bb0\u5f55\u9501\u4e09\u6b21\u91cd\u8bd5\u5931\u8d25", (String)"ItemStoreUtil_3", (String)"drp-mdr-common", (Object[])new Object[0]));
                    try {
                        Thread.sleep(1000L);
                        ++i3;
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"\u5e93\u5b58\u66f4\u65b0\u7ebf\u7a0b\u4f11\u7720\u51fa\u73b0\u5f02\u5e38");
                    }
                }
                ItemStoreUtil.insertRecordLock(idset);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u5165\u5e93\u5b58\u9501\u5931\u8d25\uff0c\u5efa\u8bae\u7a0d\u540e\u518d\u8bd5", (String)"ItemStoreUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            finally {
                dlock.unlock();
            }
        }
        try {
            ArrayList<Object[]> initparams = new ArrayList<Object[]>(list.size());
            ArrayList<Object[]> updparams = new ArrayList<Object[]>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                m = list.get(i);
                if (m.getChangeType() == ItemStoreModel.StoreChangeType.INIT) {
                    initparams.add(new Object[]{m.getQtyup(), m.getId()});
                    continue;
                }
                updparams.add(new Object[]{m.getQtyup(), m.getOrderqtyup(), m.getId()});
            }
            if (initparams.size() > 0) {
                DB.executeBatch((DBRoute)MDR_DBROUTE, (String)initStoreSql, initparams);
            }
            if (updparams.size() <= 0) return;
            DB.executeBatch((DBRoute)MDR_DBROUTE, (String)updateStoreSql, updparams);
            return;
        }
        finally {
            ItemStoreUtil.deleteRecordLock(idset);
        }
    }

    private static void insertRecordLock(Set<Object> idset) {
        String insertsql = "insert into t_mdr_lock(fid,fentitytype) values(?,?)";
        Iterator<Object> i = idset.iterator();
        ArrayList<Object[]> params = new ArrayList<Object[]>(idset.size());
        while (i.hasNext()) {
            params.add(new Object[]{i.next(), "mdr_itemstore"});
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)MDR_DBROUTE, (String)insertsql, params);
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Object)String.format("\u63d2\u5165\u5e93\u5b58\u8bb0\u5f55\u9501\u53d1\u751f%s\u5f02\u5e38\uff1a%s", e.getClass().getName(), e.getMessage()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u5165\u5e93\u5b58\u8bb0\u5f55\u9501\u53d1\u751f%s\u5f02\u5e38\uff1a%s", (String)"ItemStoreUtil_6", (String)"drp-mdr-common", (Object[])new Object[0]), e.getClass().getName(), e.getMessage()));
            }
        }
    }

    private static boolean isRecordLocked(Set<Object> idset) {
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from t_mdr_lock where fid in (");
        int size = idset.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        DataSet set = DB.queryDataSet((String)ItemStoreUtil.class.getName(), (DBRoute)MDR_DBROUTE, (String)sql.toString(), (Object[])idset.toArray());
        return set.hasNext();
    }

    private static void deleteRecordLock(Set<Object> idset) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from t_mdr_lock where fid in (");
        int size = idset.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.update((DBRoute)MDR_DBROUTE, (String)sql.toString(), (Object[])idset.toArray());
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Object)String.format("\u5220\u9664\u5e93\u5b58\u8bb0\u5f55\u9501\u53d1\u751f%s\u5f02\u5e38\uff1a%s", e.getClass().getName(), e.getMessage()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5e93\u5b58\u8bb0\u5f55\u9501\u53d1\u751f%s\u5f02\u5e38\uff1a%s", (String)"ItemStoreUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]), e.getClass().getName(), e.getMessage()));
            }
        }
    }

    private static DynamicObject queryRecord(Object customerid, Object itemid, Object measureunitid, Object assistattrid, Object warehouseid) {
        QFilter q1 = new QFilter("customer", "=", (Object)Long.parseLong(customerid.toString()));
        QFilter q2 = new QFilter("item", "=", (Object)Long.parseLong(itemid.toString()));
        QFilter q3 = new QFilter("measureunit", "=", (Object)Long.parseLong(measureunitid.toString()));
        QFilter q4 = new QFilter("warehouse", "=", (Object)(warehouseid == null ? 0L : Long.parseLong(warehouseid.toString())));
        QFilter q5 = new QFilter("assistattr", "=", (Object)(assistattrid == null ? 0L : Long.parseLong(assistattrid.toString())));
        DynamicObject[] objectCol = BusinessDataServiceHelper.load((String)"mdr_item_store", (String)"id,number,customer,item,measureunit,warehouse,qty,orderqty,status", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return objectCol == null || objectCol.length == 0 ? null : objectCol[0];
    }

    private static DynamicObject insertRecord(Object customerid, Object itemid, Object measureunitid, Object assistattrid, Object warehouseid) {
        DynamicObject unitinfo = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(measureunitid.toString()))});
        DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_store");
        o.set("customer", customerid);
        o.set("item", itemid);
        o.set("measureunit", measureunitid);
        o.set("assistattr", assistattrid);
        o.set("warehouse", warehouseid);
        o.set("status", (Object)Character.valueOf('B'));
        o.set("qty", (Object)BigDecimal.ZERO.setScale(unitinfo.getInt("precision")));
        o.set("orderqty", (Object)BigDecimal.ZERO.setScale(unitinfo.getInt("precision")));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        return o;
    }

    public static void isAllowOverStore(Object itemId, Object ownerId, Object assistattrId, BigDecimal newQty, Object unitId, Object assistUnitId) {
        if (CustomerParamsUtil.isAllowOver(ownerId).equals("1")) {
            BigDecimal storeQty = null;
            if (StringUtils.isNotEmpty(unitId) ? (storeQty = ItemStoreUtil.queryItemStoreQty(ownerId, itemId, unitId, assistattrId, null)).compareTo(newQty) < 0 : (storeQty = ItemStoreUtil.queryItemStoreQty(ownerId, itemId, assistUnitId, assistattrId, null)).compareTo(newQty) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3\uff01\uff01\uff01", (String)"ItemStoreUtil_8", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
        }
    }

    public static String getItemStoreInfo(Object ownerid, Object customerid, Object itemid, Object unitId, Object warehouseId, boolean isAllowOver) {
        String hasStore = ResManager.loadKDString((String)"\u65e0\u8d27", (String)"ItemStoreUtil_9", (String)"drp-mdr-common", (Object[])new Object[0]);
        if (ownerid != null && customerid != null) {
            DynamicObject info = CustomerUtil.getAuthBizInfo(ownerid, customerid);
            String parentinvtype = info.getString("parentinvtype");
            BigDecimal sumUsableQty = BigDecimal.ZERO;
            DynamicObjectCollection attrCollection = ItemAttrUtil.getAttrList(itemid);
            DynamicObjectCollection store = ItemStoreUtil.queryItemStoreInfoSum(ownerid, itemid, unitId, CommonUtils.collection2List("id", (List<DynamicObject>)attrCollection), warehouseId, isAllowOver);
            if (store != null && !store.isEmpty()) {
                DynamicObject itemstore = (DynamicObject)store.get(0);
                sumUsableQty = itemstore.getBigDecimal("qty").subtract(itemstore.getBigDecimal("orderqty")).stripTrailingZeros();
            }
            if (sumUsableQty.compareTo(BigDecimal.ZERO) > 0) {
                hasStore = "1".equals(parentinvtype) ? ResManager.loadKDString((String)"\u6709\u8d27", (String)"ItemStoreUtil_10", (String)"drp-mdr-common", (Object[])new Object[0]) : new StringBuffer(ResManager.loadKDString((String)"\u6709\u8d27\uff08\u5e93\u5b58", (String)"ItemStoreUtil_11", (String)"drp-mdr-common", (Object[])new Object[0])).append(sumUsableQty.stripTrailingZeros().toPlainString()).append("\uff09").toString();
            }
            if ("0".equals(parentinvtype)) {
                hasStore = "";
            }
        }
        return hasStore;
    }

    public static ArrayList<Long> getContianExcuIds(ArrayList<Long> ids) {
        ArrayList<Long> excuIds = new ArrayList<Long>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fid,b.fentryid from t_mem_market_cost_apply a inner join t_mem_market_cost_applye b on a.fid=b.fid ");
        sql.append(" inner join t_mem_marketcostexecute c on b.fentryid=c.fcostapplyentryid where a.fid in ( ");
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        DataSet set = DB.queryDataSet((String)ItemStoreUtil.class.getName(), (DBRoute)MDR_DBROUTE, (String)sql.toString(), (Object[])ids.toArray());
        while (set.hasNext()) {
            Row row = set.next();
            long id = row.getLong("fid");
            excuIds.add(id);
        }
        return excuIds;
    }
}

