/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemUtil {
    private static final String[] cols = new String[]{"itemclass", "thumbnail", "hasattr", "referenceprice", "conversionfor", "itemclassentity.goodsclasssid"};

    @Deprecated
    public static DynamicObject loadInfoById(Object itemId, String fields) {
        if (itemId == null || itemId.toString().equals("0")) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)fields);
    }

    public static DynamicObject getItemBizInfo(Object itemId) {
        if (itemId == null || itemId.toString().equals("0")) {
            return null;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"mdr_item_info", (String)F7Utils.getSelectCols(cols));
        return item;
    }

    public static DynamicObject getInfoByQFilter(QFilter fs, String fields) {
        return QueryServiceHelper.queryOne((String)"mdr_item_info", (String)fields, (QFilter[])fs.toArray());
    }

    @Deprecated
    public static Object getMaterialId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        QFilter fs = new QFilter("id", "=", itemId);
        List<Object> querySingleCol = QueryUtil.querySingleCol("mdr_item_info", "material", fs.toArray(), null, 1);
        if (querySingleCol == null || querySingleCol.size() == 0) {
            return null;
        }
        return querySingleCol.get(0);
    }

    @Deprecated
    public static Object queryBaseUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"material.baseunit", (QFilter[])f.toArray());
        Object id = item.get("material.baseunit");
        return id;
    }

    public static Object querySaleUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"saleunit", (QFilter[])f.toArray());
        Object id = item.get("saleunit");
        return id;
    }

    @Deprecated
    public static Object queryBaseUnitObj(Object itemPK) {
        Object unitlId = ItemUtil.queryBaseUnitId(itemPK);
        if (unitlId != null && !unitlId.equals(0L)) {
            return ItemUtil.loadUnitInfo(unitlId);
        }
        return null;
    }

    @Deprecated
    public static DynamicObject loadUnitInfo(Object unitId) {
        if (unitId == null || unitId.toString().equals("0")) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)unitId, (String)"bd_measureunits");
    }

    public static DynamicObjectCollection loadUnitInfo(Collection<Object> unitIds, String fileds) {
        QFilter f = new QFilter("id", "in", unitIds);
        return QueryServiceHelper.query((String)"bd_measureunits", (String)fileds, (QFilter[])f.toArray());
    }

    @Deprecated
    public static Object queryAssistUnitId(Object itemPK) {
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"assistunit", (QFilter[])f.toArray());
        if (item == null) {
            return null;
        }
        Object assistunitId = item.get("assistunit");
        if (assistunitId == null || assistunitId.equals(0L)) {
            return null;
        }
        return assistunitId;
    }

    @Deprecated
    public static Object queryAssistUnitObj(Object itemPK) {
        Object unitlId = ItemUtil.queryAssistUnitId(itemPK);
        if (unitlId != null && !unitlId.equals(0L)) {
            return ItemUtil.loadUnitInfo(unitlId);
        }
        return null;
    }

    @Deprecated
    public static Set<Object> queryAllUnit(Object itemPK) {
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        return new HashSet<Object>(unitBatchHandler.getUnitIdList(itemPK));
    }

    @Deprecated
    public static Set<Object> queryMaterialAllUnit(Object materialId) {
        if (materialId == null) {
            return null;
        }
        QFilter f = new QFilter("materialid", "=", materialId);
        String colName = "measureunitid";
        Set<Object> units = QueryUtil.querySingleCol("bd_multimeasureunit", colName, f.toArray());
        Set<Object> baseunit = QueryUtil.querySingleCol("bd_material", "baseunit", new QFilter("id", "=", materialId).toArray());
        units.addAll(baseunit);
        return units;
    }

    @Deprecated
    public static BigDecimal queryConversionFactor(Object itemPK, Object unitPK) {
        if (itemPK == null || unitPK == null) {
            return null;
        }
        Object materialId = ItemUtil.getMaterialId(itemPK);
        if (materialId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", materialId).and("baseunit", "=", unitPK);
        if (QueryServiceHelper.exists((String)"bd_material", (QFilter[])qFilter.toArray())) {
            return BigDecimal.ONE;
        }
        BigDecimal result = BigDecimal.ONE;
        QFilter f = new QFilter("materialid", "=", materialId);
        f.and("measureunitid", "=", unitPK);
        String colName = "denominator,numerator";
        DynamicObject multimeasureunit = QueryServiceHelper.queryOne((String)"bd_multimeasureunit", (String)colName, (QFilter[])f.toArray());
        if (multimeasureunit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u65e0\u6b64\u8ba1\u91cf\u5355\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\uff01", (String)"ItemUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        BigDecimal denominator = multimeasureunit.getBigDecimal("denominator");
        BigDecimal numerator = multimeasureunit.getBigDecimal("numerator");
        if (denominator == null || numerator == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u6362\u7b97\u5206\u6bcd\u6216\u8005\u6362\u7b97\u5206\u6bcd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\uff01", (String)"ItemUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        result = numerator.divide(denominator, 50, RoundingMode.HALF_UP);
        return result;
    }

    @Deprecated
    public static BigDecimal queryConversionFactor(Object itemPK, Object unitPK1, Object unitPK2) {
        BigDecimal rate1 = ItemUtil.queryConversionFactor(itemPK, unitPK1);
        BigDecimal rate2 = ItemUtil.queryConversionFactor(itemPK, unitPK2);
        if (rate1 == null || rate2 == null) {
            return null;
        }
        return rate1.divide(rate2, 50, RoundingMode.HALF_UP);
    }

    public static DynamicObjectCollection getShoppingCartList(Object ownerId, Object customerId, Object ispurchasing) {
        QFilter filter = new QFilter("owner.id", "=", ownerId);
        filter.and("customer.id", "=", customerId);
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", ispurchasing);
        DynamicObjectCollection cartItemCollection = QueryServiceHelper.query((String)"mdr_shopping_cart", (String)"id,item.id,unit,unit.id,assistattr,assistattr.id,qty,assistqty,customer.id", (QFilter[])filter.toArray());
        return cartItemCollection;
    }

    public static Set<Object> getCollectionItems(Object userId) {
        QFilter f = new QFilter("user", "=", userId).and("iscombination", "=", (Object)"0");
        HashSet ids = QueryUtil.querySingleCol("dbd_item_collection", "itemId", f.toArray());
        return ids == null ? new HashSet() : ids;
    }

    public static Set<Object> getCollectionItems() {
        return ItemUtil.getCollectionItems(UserUtil.getUserID());
    }

    public static Map<Object, List<Long>> loadMaterialUnitsFromService(Collection<Object> materialIds) {
        HashMap<Object, List<Long>> itemUnitDataMap = new HashMap<Object, List<Long>>(materialIds.size());
        if (materialIds.isEmpty()) {
            return itemUnitDataMap;
        }
        String jsonIds = JSON.toJSONString(materialIds);
        JSONObject itemUnitDatas = (JSONObject)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dbd", (String)"UnitService", (String)"queryUnitInfoByMaterialIds", (Object[])new Object[]{jsonIds});
        JSONObject unitData = null;
        for (Object materialId : materialIds) {
            unitData = itemUnitDatas.getJSONObject(materialId.toString());
            if (unitData == null) {
                unitData = new JSONObject();
            }
            List<Long> unitList = ItemUtil.parseUnitList(unitData);
            itemUnitDataMap.put(materialId, unitList);
        }
        return itemUnitDataMap;
    }

    protected static final List<Long> parseUnitList(JSONObject itemUnitData) {
        JSONArray ids = itemUnitData.getJSONArray("id");
        String newStr = ids.toJSONString();
        return JSON.parseArray((String)newStr, Long.class);
    }

    public static DynamicObjectCollection getItemAllCuOrg(String entityType, IFormView iview) {
        QFilter extendOrgQFilter;
        String orgFuncPro;
        HasPermOrgResult result;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"mdr_item_info");
        String appNumber = iview.getFormShowParameter().getAppId();
        String appid = null;
        if (StringUtils.isNotEmpty(appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"mdr_item_info", (String)"47150e89000000ac")) == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)"mdr_item_info");
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty(useOrgFunc) && StringUtils.isNotEmpty(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)true);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        String view = "";
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)true);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new DynamicObjectCollection();
        }
        DynamicObject[] var17 = viewOrgs;
        int var18 = viewOrgs.length;
        for (int var19 = 0; var19 < var18; ++var19) {
            DynamicObject viewOrg = var17[var19];
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter("id", "in", viewOrgIds);
        filterList.add(idsFilter);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
        filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters, (String)"id");
        return col;
    }
}

