/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.log4j.Logger;

public class ObjectLockUtil {
    private static final Logger log = Logger.getLogger(ObjectLockUtil.class);

    public static boolean requestObjectLock(DynamicObject o, String op, String des) {
        QFilter q = new QFilter("objectid", "=", o.get("id"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mdr_object_lock", (String)"id", (QFilter[])new QFilter[]{q});
        if (col == null || col.isEmpty()) {
            DynamicObject newlock = BusinessDataServiceHelper.newDynamicObject((String)"mdr_object_lock");
            newlock.set("objectid", o.get("id"));
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)o.getDataEntityType().getProperties().get((Object)"number");
            if (iDataEntityProperty != null) {
                newlock.set("objectnumber", o.get("number"));
            }
            newlock.set("user", UserUtil.getUserID());
            newlock.set("locktime", (Object)new Date());
            newlock.set("operation", (Object)op);
            newlock.set("description", (Object)des);
            try (TXHandle h = TX.beginRequired();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newlock});
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                    h.markRollback();
                    boolean bl = false;
                    if (h != null) {
                        if (var8_8 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
            return true;
        }
        return false;
    }

    public static void releaseObjectLock(DynamicObject o) {
        QFilter q = new QFilter("objectid", "=", o.get("id"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mdr_object_lock", (String)"id", (QFilter[])new QFilter[]{q});
        DeleteServiceHelper.delete((IDataEntityType)o.getDataEntityType(), (Object[])col.toArray());
    }

    public static void batchReleaseObjectLock(List<DynamicObject> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        String[] objectids = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            objectids[i2] = list.get(i2).getString("id");
        }
        QFilter q = new QFilter("objectid", "in", Arrays.stream(objectids).map(i -> Long.parseLong(i)).collect(Collectors.toList()));
        Object[] col = BusinessDataServiceHelper.load((String)"mdr_object_lock", (String)"id", (QFilter[])new QFilter[]{q});
        if (col == null || col.length == 0) {
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)col[0].getDataEntityType(), (Object[])col);
    }
}

