/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OperationUtil {
    public static OperationResult invokeOperation(DynamicObject obj, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(new DynamicObject[]{obj}, operation);
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation, OperateOption option) throws KDBizException {
        OperationResult result;
        if (objs == null || objs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"OperationUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (option == null) {
            option = OperateOption.create();
        }
        if (!(result = OperationServiceHelper.executeOperate((String)operation, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)option)).isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                validation.getAllErrorInfo().forEach(info -> sb.append(info.getMessage()).append(','));
            }
            throw new KDBizException(MessageFormat.format("{0} - {1}", result.getMessage(), sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb));
        }
        return result;
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(objs, operation, OperateOption.create());
    }

    public static String invokeOperationToStr(DynamicObject obj, String operation) {
        return OperationUtil.invokeOperationToStr(new DynamicObject[]{obj}, operation);
    }

    public static String invokeOperationToStr(DynamicObject[] objs, String operation) {
        try {
            OperationUtil.invokeOperation(objs, operation);
        }
        catch (KDBizException e) {
            return e.getMessage();
        }
        return null;
    }

    public static DynamicObject addDefaultInfo(DynamicObject obj) {
        if (obj == null) {
            return null;
        }
        obj.set("createtime", (Object)new Date());
        obj.set("creator", (Object)RequestContext.get().getUserId());
        if (obj.get("status") == null) {
            obj.set("status", (Object)"C");
        }
        if (obj.get("enable") == null) {
            obj.set("enable", (Object)"1");
        }
        return obj;
    }

    public static StringBuffer getErroInfo(OperationResult result) {
        StringBuffer sb = new StringBuffer();
        result.getAllErrorInfo().forEach(info -> sb.append(info));
        return sb;
    }
}

