/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.WFXOrderType;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.WebUtil;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.util.CellRangeAddress;

public class OrderExportUtil {
    private static final Logger log = Logger.getLogger(OrderExportUtil.class);
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFSheet tempSheet;
    private IFormView view;
    private static String orderRe = "\\{.+?\\}";
    private static String entryRe = "\\[.+?\\]";
    private static String typeFlag = "|";
    private Pattern p1 = Pattern.compile(orderRe);
    private Pattern p2 = Pattern.compile(entryRe);

    private OrderExportUtil() {
    }

    private OrderExportUtil(IFormView view) {
        this.view = view;
    }

    public static OrderExportUtil create(IFormView view) {
        return new OrderExportUtil(view);
    }

    public void export(Object orderId, WFXOrderType type) {
        if (orderId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        String attachurl = this.getAttachmentUrl(type);
        this.loadFile(attachurl);
        this.replaceExcelDate(orderId, type);
        DynamicObject saleOrder = null;
        saleOrder = WFXOrderType.DISPATCH_ORDER == type ? BusinessDataServiceHelper.loadSingle((String)"mdr_dispatch_order", (String)"billno", (QFilter[])WebUtil.getIdQFilter(orderId).toArray()) : BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)"billno", (QFilter[])WebUtil.getIdQFilter(orderId).toArray());
        String fileName = ResManager.loadKDString((String)"\u8ba2\u5355-", (String)"OrderExportUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]) + saleOrder.getString("billno");
        String url = this.writeFile(this.wb, OrderExportUtil.getTempFilename(fileName));
        String baseuri = RequestContext.get().getClientFullContextPath();
        url = baseuri + url;
        this.view.openUrl(url);
    }

    public void export(Object[] orderIds, WFXOrderType type) {
        if (orderIds == null || orderIds.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        String attachurl = this.getAttachmentUrl(type);
        this.loadFile(attachurl);
        this.replaceExcelDate(orderIds, type);
        String fileName = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355-", (String)"OrderExportUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]);
        String url = this.writeFile(this.wb, OrderExportUtil.getTempFilename(fileName));
        String baseuri = RequestContext.get().getClientFullContextPath();
        url = baseuri + url;
        this.view.openUrl(url);
    }

    public void testExport(Object orderId, WFXOrderType type) {
        if (orderId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        String attachurl = this.getAttachmentUrl(type);
        InputStream inStream = null;
        try {
            inStream = this.getInStream(attachurl);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("down-tempfile", inStream, 10000);
            String baseuri = RequestContext.get().getClientFullContextPath();
            url = baseuri + url;
            this.view.openUrl(url);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getAttachmentUrl(WFXOrderType type) {
        DynamicObjectCollection tempOrders = QueryServiceHelper.query((String)"mdr_order_export_template", (String)"id", (QFilter[])new QFilter("ordertype", "=", (Object)type.getType()).toArray(), (String)"createtime desc");
        if (tempOrders == null || tempOrders.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        DynamicObject tempOrder = (DynamicObject)tempOrders.get(0);
        String attachurl = "";
        List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_order_export_template", (Object)tempOrder.get("id"), (String)"attachmentpanelap");
        attachurl = (String)((Map)attachments.get(0)).get("url");
        if (StringUtils.isEmpty(attachurl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u83b7\u53d6URL\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return attachurl;
    }

    public InputStream getInStream(String fileUrl) {
        if (StringUtils.isEmpty(fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u83b7\u53d6URL\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"OrderExportUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        InputStream inStream = null;
        int index = fileUrl.indexOf("path=");
        int index2 = fileUrl.indexOf("&kdedcba=");
        fileUrl = fileUrl.substring(index + 5, index2);
        inStream = FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl);
        return inStream;
    }

    private void loadFile(String fileUrl) {
        InputStream inStream = null;
        try {
            inStream = this.getInStream(fileUrl);
            this.wb = new HSSFWorkbook(inStream);
            this.sheet = this.wb.getSheetAt(0);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ByteArrayInputStream parse(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    public void replaceExcelDate(Object[] orderIds, WFXOrderType type) {
        Set<Object> salorderIds = new HashSet<Object>(Arrays.asList(orderIds));
        if (WFXOrderType.DISPATCH_ORDER == type) {
            salorderIds = QueryUtil.querySingleCol("mdr_dispatch_order", "itementry.sourcebillid", WebUtil.getIdQFilter(Arrays.asList(orderIds)).toArray());
        }
        if (salorderIds == null || salorderIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderExportUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        this.tempSheet = this.wb.createSheet(ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u636e", (String)"OrderExportUtil_6", (String)"drp-mdr-common", (Object[])new Object[0]));
        HSSFRow row = null;
        HSSFRow newRow = null;
        HashSet<String> keySet = new HashSet<String>();
        HashSet<String> entryKeySet = new HashSet<String>();
        HashSet<Integer> hasEntryRowSet = new HashSet<Integer>();
        int rowNum = this.sheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            this.findReplaceKey(i, keySet, entryKeySet, hasEntryRowSet);
        }
        String keystr = this.getStrFromSet(keySet);
        String entrykeystr = this.getStrFromSet(entryKeySet);
        DynamicObject[] saleOrderEntrys = new DynamicObject[]{};
        DynamicObjectCollection saleOrders = QueryServiceHelper.query((String)"mdr_saleorder", (String)(keystr + ",id"), (QFilter[])WebUtil.getIdQFilter(salorderIds).toArray(), (String)"createtime");
        int tempIndex = 0;
        for (DynamicObject saleOrder : saleOrders) {
            saleOrderEntrys = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)entrykeystr, (QFilter[])new QFilter("order", "=", saleOrder.get("id")).toArray(), (String)"entrywarehouse");
            if (saleOrderEntrys == null || saleOrderEntrys.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5546\u54c1\u5206\u5f55\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"OrderExportUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            int index = 0;
            int rowCount = this.sheet.getLastRowNum();
            while (index <= rowCount) {
                row = this.sheet.getRow(index);
                if (row == null) {
                    ++index;
                    ++tempIndex;
                    continue;
                }
                if (hasEntryRowSet.contains(index)) {
                    for (DynamicObject saleOrderEntry : saleOrderEntrys) {
                        this.copyRows(this.sheet, this.tempSheet, index, index, tempIndex);
                        newRow = this.tempSheet.getRow(tempIndex);
                        this.repleceRowData(row, newRow, saleOrder, saleOrderEntry);
                        ++tempIndex;
                    }
                } else {
                    this.copyRows(this.sheet, this.tempSheet, index, index, tempIndex);
                    newRow = this.tempSheet.getRow(tempIndex);
                    this.repleceRowData(row, newRow, saleOrder, null);
                    ++tempIndex;
                }
                ++index;
            }
        }
        for (int i = 0; i < this.sheet.getRow(0).getPhysicalNumberOfCells(); ++i) {
            this.tempSheet.setColumnWidth(i, this.sheet.getColumnWidth(i));
        }
        this.wb.removeSheetAt(0);
    }

    public void replaceExcelDate(Object orderId, WFXOrderType type) {
        this.tempSheet = this.wb.createSheet("data");
        HSSFRow row = null;
        HSSFRow newRow = null;
        HashSet<String> keySet = new HashSet<String>();
        HashSet<String> entryKeySet = new HashSet<String>();
        HashSet<Integer> hasEntryRowSet = new HashSet<Integer>();
        int rowNum = this.sheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            this.findReplaceKey(i, keySet, entryKeySet, hasEntryRowSet);
        }
        String keystr = this.getStrFromSet(keySet);
        String entrykeystr = this.getStrFromSet(entryKeySet);
        DynamicObject saleOrder = null;
        DynamicObject[] saleOrderEntrys = new DynamicObject[]{};
        if (WFXOrderType.DISPATCH_ORDER == type) {
            saleOrder = BusinessDataServiceHelper.loadSingle((String)"mdr_dispatch_order", (String)keystr, (QFilter[])WebUtil.getIdQFilter(orderId).toArray());
            saleOrderEntrys = BusinessDataServiceHelper.load((String)"mdr_dispatchorder_entry", (String)entrykeystr, (QFilter[])new QFilter("order", "=", orderId).toArray());
        } else {
            saleOrder = BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)keystr, (QFilter[])WebUtil.getIdQFilter(orderId).toArray());
            saleOrderEntrys = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)entrykeystr, (QFilter[])new QFilter("order", "=", orderId).toArray());
        }
        if (saleOrder == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderExportUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (saleOrderEntrys == null || saleOrderEntrys.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5546\u54c1\u5206\u5f55\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"OrderExportUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        int index = 0;
        int tempIndex = 0;
        int rowCount = this.sheet.getLastRowNum();
        while (index <= rowCount) {
            row = this.sheet.getRow(index);
            if (row == null) {
                ++index;
                ++tempIndex;
                continue;
            }
            if (hasEntryRowSet.contains(index)) {
                for (DynamicObject saleOrderEntry : saleOrderEntrys) {
                    this.copyRows(this.sheet, this.tempSheet, index, index, tempIndex);
                    newRow = this.tempSheet.getRow(tempIndex);
                    this.repleceRowData(row, newRow, saleOrder, saleOrderEntry);
                    ++tempIndex;
                }
            } else {
                this.copyRows(this.sheet, this.tempSheet, index, index, tempIndex);
                newRow = this.tempSheet.getRow(tempIndex);
                this.repleceRowData(row, newRow, saleOrder, null);
                ++tempIndex;
            }
            ++index;
        }
        for (int i = 0; i < this.sheet.getRow(0).getPhysicalNumberOfCells(); ++i) {
            this.tempSheet.setColumnWidth(i, this.sheet.getColumnWidth(i));
        }
        this.wb.removeSheetAt(0);
    }

    private void findReplaceKey(int i, Set<String> keySet, Set<String> entryKeySet, Set<Integer> hasEntryRowSet) {
        HSSFRow row = this.sheet.getRow(i);
        if (row == null) {
            return;
        }
        int columnNum = row.getLastCellNum();
        for (int j = 0; j <= columnNum; ++j) {
            String filed2;
            int index;
            int endIndex;
            String filed;
            String cellValue;
            HSSFCell cell = row.getCell(j);
            if (cell == null || !StringUtils.isNotEmpty(cellValue = cell.getStringCellValue())) continue;
            String str = cellValue;
            String str2 = cellValue;
            Matcher orderm = this.p1.matcher(str);
            Matcher entrym = this.p2.matcher(str2);
            while (orderm.find()) {
                filed = orderm.group(0);
                endIndex = filed.length() - 1;
                index = filed.indexOf(124);
                if (index > 0) {
                    endIndex = index;
                }
                filed2 = filed.substring(1, endIndex);
                keySet.add(filed2);
                str = str.replace(filed, "");
                orderm = this.p1.matcher(str);
            }
            while (entrym.find()) {
                hasEntryRowSet.add(i);
                filed = entrym.group(0);
                endIndex = filed.length() - 1;
                index = filed.indexOf(124);
                if (index > 0) {
                    endIndex = index;
                }
                filed2 = filed.substring(1, endIndex);
                entryKeySet.add(filed2);
                str2 = str2.replace(filed, "");
                entrym = this.p2.matcher(str2);
            }
        }
    }

    private String getStrFromSet(Set<String> set) {
        StringBuilder keystr = new StringBuilder();
        Iterator<String> it2 = set.iterator();
        while (it2.hasNext()) {
            String str = it2.next();
            if (it2.hasNext()) {
                keystr.append(str).append(',');
                continue;
            }
            keystr.append(str);
        }
        return keystr.toString();
    }

    private void repleceRowData(HSSFRow row, HSSFRow newRow, DynamicObject order, DynamicObject orderEntry) {
        int columnNum = row.getLastCellNum();
        for (int j = 0; j <= columnNum; ++j) {
            HSSFCell cell = row.getCell(j);
            HSSFCell newCell = newRow.getCell(j);
            if (cell == null || newCell == null) continue;
            String type = "string";
            boolean hasFiled = false;
            String cellValue = cell.getStringCellValue();
            if (!StringUtils.isNotEmpty(cellValue)) continue;
            String str = cellValue;
            Matcher orderm = this.p1.matcher(str);
            while (orderm.find()) {
                String filed = orderm.group(0);
                int index = filed.indexOf(typeFlag);
                if (index > 0) {
                    type = str.substring(index + 1, str.length() - 1);
                    str = str.replace(typeFlag + type, "");
                    filed = str.replace(typeFlag + type, "");
                }
                str = this.replaceStr(str, filed, order);
                orderm = this.p1.matcher(str);
                hasFiled = true;
            }
            Matcher entrym = this.p2.matcher(str);
            while (entrym.find()) {
                String filed = entrym.group(0);
                int index = filed.indexOf(typeFlag);
                if (index > 0) {
                    type = str.substring(index + 1, str.length() - 1);
                    str = str.replace(typeFlag + type, "");
                    filed = str.replace(typeFlag + type, "");
                }
                str = this.replaceStr(str, filed, orderEntry);
                entrym = this.p2.matcher(str);
                hasFiled = true;
            }
            if (!hasFiled) continue;
            if (CellType.NUMERIC.equals((Object)this.getCellType(type))) {
                newCell.setCellValue(Double.parseDouble(str));
                continue;
            }
            newCell.setCellValue(str);
        }
    }

    private CellType getCellType(String str) {
        switch (str) {
            case "numeric": {
                return CellType.NUMERIC;
            }
            case "string": {
                return CellType.STRING;
            }
            case "formula": {
                return CellType.FORMULA;
            }
            case "blank": {
                return CellType.BLANK;
            }
            case "boolean": {
                return CellType.BOOLEAN;
            }
        }
        return CellType.STRING;
    }

    private String replaceStr(String str, String filed, DynamicObject obj) {
        String filed2 = filed.substring(1, filed.length() - 1);
        String filedVauleStr = ResManager.loadKDString((String)"\u65e0", (String)"OrderExportUtil_8", (String)"drp-mdr-common", (Object[])new Object[0]);
        String filedVaule = this.getStringForDynamicObject(obj, filed2);
        if (filedVaule != null) {
            filedVauleStr = filedVaule;
        }
        str = str.replace(filed, filedVauleStr);
        return str;
    }

    private String getStringForDynamicObject(DynamicObject obj, String filed) {
        String str = "";
        Object value = obj.get(filed);
        if (value == null) {
            return null;
        }
        if ("passtype".equals(filed)) {
            if ("A".equals(value)) {
                return ResManager.loadKDString((String)"\u6b3e\u5230\u653e\u884c", (String)"OrderExportUtil_9", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("B".equals(value)) {
                return ResManager.loadKDString((String)"\u5206\u5f00\u6536\u6b3e", (String)"OrderExportUtil_10", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("C".equals(value)) {
                return ResManager.loadKDString((String)"\u6c47\u603b\u6536\u6b3e", (String)"OrderExportUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("D".equals(value)) {
                return ResManager.loadKDString((String)"\u8d26\u671f\u5ba2\u6237", (String)"OrderExportUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
        }
        if ("receipt.taxtype".equals(filed)) {
            if ("1".equals(value)) {
                return ResManager.loadKDString((String)"\u666e\u901a\u53d1\u7968", (String)"OrderExportUtil_13", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("2".equals(value)) {
                return ResManager.loadKDString((String)"\u4e13\u7528\u53d1\u7968", (String)"OrderExportUtil_14", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("3".equals(value)) {
                return ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968", (String)"OrderExportUtil_15", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
        }
        if ("billingtype".equals(filed)) {
            if ("A".equals(value)) {
                return ResManager.loadKDString((String)"\u666e\u7968", (String)"OrderExportUtil_16", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("B".equals(value)) {
                return ResManager.loadKDString((String)"\u4e13\u7968", (String)"OrderExportUtil_17", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
            if ("C".equals(value)) {
                return ResManager.loadKDString((String)"\u4e0d\u5f00\u7968", (String)"OrderExportUtil_18", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
        }
        if (value instanceof DynamicObject) {
            DynamicObject dy = obj.getDynamicObject(filed);
            str = dy.getString("name");
        } else if (value instanceof Boolean) {
            boolean dy = obj.getBoolean(filed);
            str = dy ? ResManager.loadKDString((String)"\u662f", (String)"OrderExportUtil_19", (String)"drp-mdr-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"OrderExportUtil_20", (String)"drp-mdr-common", (Object[])new Object[0]);
        } else if (value instanceof Timestamp) {
            Timestamp dy = (Timestamp)obj.get(filed);
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if ("entryconfirmarrivaldate".equals(filed)) {
                s = new SimpleDateFormat("yyyy-MM-dd");
            }
            str = s.format(dy);
        } else if (value instanceof Date) {
            Date dy = obj.getDate(filed);
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
            str = s.format(dy);
        } else if (value instanceof BigDecimal) {
            BigDecimal dy = obj.getBigDecimal(filed);
            if (filed.indexOf("qty") != -1) {
                dy = dy.stripTrailingZeros();
            } else if (filed.indexOf("price") != -1 || filed.indexOf("amount") != -1) {
                dy = dy.setScale(2);
            }
            str = dy.toPlainString();
        } else {
            Object dy = obj.get(filed);
            str = dy.toString();
        }
        return str;
    }

    private String writeFile(HSSFWorkbook wb, String formName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(formName, (InputStream)inStream, 10000);
            return string;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String currDateTime = dateFormat.format(new Date());
        return formName + "-" + currDateTime + ".xls";
    }

    public void insertCopyRow(HSSFSheet opSheet, int copyRow, int rows) {
        if (copyRow + 1 <= opSheet.getLastRowNum()) {
            opSheet.shiftRows(copyRow + 1, opSheet.getLastRowNum(), rows, true, false);
        }
        int i = 0;
        while (i < rows) {
            ++i;
            ++copyRow;
        }
    }

    public void copyRows(HSSFSheet fromSheet, HSSFSheet toSheet, int startRow, int endRow, int pPosition) {
        int i;
        int pStartRow = startRow;
        int pEndRow = endRow;
        CellRangeAddress region = null;
        if (pStartRow == -1 || pEndRow == -1) {
            return;
        }
        for (i = 0; i < fromSheet.getNumMergedRegions(); ++i) {
            region = fromSheet.getMergedRegion(i);
            if (region.getFirstRow() < pStartRow || region.getLastRow() > pEndRow) continue;
            int targetRowFrom = region.getFirstRow() - pStartRow + pPosition;
            int targetRowTo = region.getLastRow() - pStartRow + pPosition;
            CellRangeAddress newRegion = region.copy();
            newRegion.setFirstRow(targetRowFrom);
            newRegion.setFirstColumn(region.getFirstColumn());
            newRegion.setLastRow(targetRowTo);
            newRegion.setLastColumn(region.getLastColumn());
            toSheet.addMergedRegion(newRegion);
        }
        for (i = pStartRow; i <= pEndRow; ++i) {
            HSSFRow sourceRow = fromSheet.getRow(i);
            if (sourceRow == null) continue;
            int columnCount = sourceRow.getLastCellNum();
            HSSFRow newRow = toSheet.createRow(pPosition - pStartRow + i);
            newRow.setHeight(sourceRow.getHeight());
            for (int j = 0; j < columnCount; ++j) {
                HSSFCell templateCell = sourceRow.getCell(j);
                if (templateCell == null) continue;
                HSSFCell newCell = newRow.createCell(j);
                this.copyCell(templateCell, newCell);
            }
        }
    }

    public void copyCell(HSSFCell templateCell, HSSFCell newCell) {
        newCell.setCellStyle(templateCell.getCellStyle());
        if (templateCell.getCellComment() != null) {
            newCell.setCellComment((Comment)templateCell.getCellComment());
        }
        CellType srcCellType = templateCell.getCellType();
        newCell.setCellType(srcCellType);
        String type = "string";
        String cellValue = templateCell.getStringCellValue();
        boolean hasFiled = false;
        if (StringUtils.isNotEmpty(cellValue)) {
            String str = cellValue;
            Matcher orderm = this.p1.matcher(str);
            while (orderm.find()) {
                String filed = orderm.group(0);
                str = str.replace(filed, "");
                orderm = this.p1.matcher(str);
                hasFiled = true;
            }
            Matcher entrym = this.p2.matcher(str);
            while (entrym.find()) {
                String filed = entrym.group(0);
                str = str.replace(filed, "");
                entrym = this.p2.matcher(str);
                hasFiled = true;
            }
        }
        newCell.setCellType(this.getCellType(type));
        if (!hasFiled) {
            newCell.setCellValue(cellValue);
        }
    }
}

