/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.itemclass.ItemClassUtil;
import kd.drp.mdr.common.util.CustomerGroupUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.RegionUtil;

public class OrderQuantityUtil {
    private static final String PREFIX_KEY = "orderQuantity";

    public static DynamicObject getOrderQuantityRlue(Object ownerId, Object customerId, Object warehouseId, Object itemId, Object unitId, Object assistAttrId) {
        List<Object> itemClassList;
        DynamicObjectCollection itemclassColl;
        Object groupId;
        Object regionId;
        if (ownerId == null || customerId == null || itemId == null) {
            return null;
        }
        DynamicObject info = CustomerUtil.getAuthBizInfo(ownerId, customerId);
        ArrayList<Object> regions = new ArrayList<Object>();
        regions.add(0L);
        DynamicObject region = info.getDynamicObject("region");
        if (region != null && !(regionId = region.getPkValue()).equals(0L)) {
            RegionUtil.queryRegionParentsAndSelf(ownerId, regionId, regions);
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add(0L);
        DynamicObject group = info.getDynamicObject("customergroup");
        if (group != null && !(groupId = group.getPkValue()).equals(0L)) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(ownerId, groupId, groups);
        }
        DynamicObject itemInfo = ItemUtil.getItemBizInfo(itemId);
        QFilter filter = new QFilter("owner", "=", ownerId);
        filter.and(new QFilter("customer", "=", customerId).or("customer", "=", (Object)0L));
        filter.and(new QFilter("customergroup", "in", groups));
        filter.and(new QFilter("region", "in", regions));
        filter.and(new QFilter("warehouse", "=", warehouseId).or("warehouse", "=", (Object)0L));
        QFilter itemFilter = new QFilter("item", "=", itemId);
        if (unitId != null && !unitId.equals(0L)) {
            itemFilter.and(new QFilter("unit", "=", unitId));
        }
        if (assistAttrId != null && !assistAttrId.equals(0L)) {
            itemFilter.and(new QFilter("assistattr", "=", assistAttrId));
        }
        if (itemInfo != null && !CommonUtils.isNull(itemclassColl = itemInfo.getDynamicObjectCollection("itemclassentity")) && !CommonUtils.isNull(itemClassList = itemclassColl.stream().filter(obj -> obj.getLong("goodsclasssid_id") > 0L).map(obj -> obj.getLong("goodsclasssid_id")).collect(Collectors.toList()))) {
            itemClassList.addAll(ItemClassUtil.queryAllParentItemClasses(itemClassList));
            itemFilter.or(new QFilter("itemclass", "in", itemClassList));
        }
        filter.and(itemFilter);
        filter.and("enable", "=", (Object)"1");
        String selectFields = "qty,minqty,warehouse,item,itemclass.level,customer,region.level,customergroup.level";
        String orderBys = "warehouse desc, item desc, itemclass.level desc, customer desc, region.level desc, customergroup.level desc";
        DynamicObjectCollection orderQuantitys = QueryServiceHelper.query((String)"mdr_orderquantity", (String)selectFields, (QFilter[])filter.toArray(), (String)orderBys);
        if (orderQuantitys.isEmpty()) {
            return null;
        }
        return (DynamicObject)orderQuantitys.get(0);
    }

    public static Map<String, BigDecimal> getOrderQuantityRlue(Object ownerId, Object customerId, Object warehouseId, Object itemId, Object unitId, Object assistAttrId, IPageCache pageCache) {
        BigDecimal minqty;
        BigDecimal qty;
        String key = "orderQuantity_" + ownerId + "_" + customerId + "_" + warehouseId + "_" + itemId + "_" + unitId + "_" + assistAttrId;
        String value = pageCache.get(key);
        String splitkey = ",";
        if (StringUtils.isEmpty(value)) {
            DynamicObject orderQuantity = OrderQuantityUtil.getOrderQuantityRlue(ownerId, customerId, warehouseId, itemId, unitId, assistAttrId);
            if (orderQuantity == null) {
                return null;
            }
            qty = orderQuantity.getBigDecimal("qty");
            minqty = orderQuantity.getBigDecimal("minqty");
            value = qty + splitkey + minqty;
            pageCache.put(key, value);
        }
        HashMap<String, BigDecimal> orderQuantityRule = new HashMap<String, BigDecimal>();
        qty = new BigDecimal(value.split(splitkey)[0]);
        minqty = new BigDecimal(value.split(splitkey)[1]);
        orderQuantityRule.put("qty", qty);
        orderQuantityRule.put("minqty", minqty);
        return orderQuantityRule;
    }
}

