/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.item.PricePolicy;
import kd.drp.mdr.common.util.CustomerGroupUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.RegionUtil;
import kd.drp.mdr.common.util.WebUtil;

public class PricePolicyUtil {
    public static BigDecimal getLowestPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        Map<String, BigDecimal> pricePolicyEntry;
        if (date == null) {
            date = new Date();
        }
        if ((pricePolicyEntry = PricePolicyUtil.getItemPricePolicy(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, date)) != null) {
            return pricePolicyEntry.get("lowestprice");
        }
        return null;
    }

    public static BigDecimal getItemPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        Map<String, BigDecimal> pricePolicyEntry;
        if (date == null) {
            date = new Date();
        }
        if ((pricePolicyEntry = PricePolicyUtil.getItemPricePolicy(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, date)) != null) {
            return pricePolicyEntry.get("price");
        }
        return null;
    }

    private static Map<String, BigDecimal> getItemPricePolicy(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        List<Object> groupids;
        Object groupId;
        Object regionId;
        Map<String, BigDecimal> pricePolicy = null;
        QFilter baseFilter = PricePolicyUtil.getBaseFilters(ownerPK, itemPK, unitPK, assistattrPk, qty, date);
        QFilter filter = baseFilter.copy();
        filter.and("customer.id", "=", customerPK);
        pricePolicy = PricePolicyUtil.getItemPricePolicy(filter, null, null);
        if (pricePolicy != null) {
            return pricePolicy;
        }
        DynamicObject info = CustomerUtil.getAuthBizInfo(ownerPK, customerPK);
        ArrayList<Object> regions = new ArrayList<Object>();
        regions.add(0L);
        DynamicObject region = info.getDynamicObject("region");
        if (region != null && !(regionId = region.getPkValue()).equals(0L)) {
            RegionUtil.queryRegionParentsAndSelf(ownerPK, regionId, regions);
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add(0L);
        DynamicObject group = info.getDynamicObject("customergroup");
        if (group != null && !(groupId = group.getPkValue()).equals(0L)) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(ownerPK, groupId, groups);
        }
        if (region != null || group != null) {
            filter = baseFilter.copy();
            filter.and("customer.id", "=", (Object)0L);
            filter.and("customergroup.id", "in", groups);
            filter.and("region.id", "in", regions);
            pricePolicy = PricePolicyUtil.getItemPricePolicy(filter, regions, groups);
            if (pricePolicy != null) {
                return pricePolicy;
            }
        }
        if ((groupids = CustomerUtil.getGroupsByCustomer(customerPK)) != null && groupids.size() > 0 && group != null) {
            Object groupId2 = group.getPkValue();
            groupids.remove(groupId2);
        }
        if (groupids == null || groupids.size() == 0) {
            return pricePolicy;
        }
        groups = new ArrayList();
        groups.addAll(groupids);
        filter = baseFilter.copy();
        filter.and("customer.id", "=", (Object)0L);
        filter.and("customergroup.id", "in", groups);
        pricePolicy = PricePolicyUtil.getItemPricePolicy(filter, null, groups);
        if (pricePolicy != null) {
            return pricePolicy;
        }
        groups = new ArrayList();
        for (Object object : groupids) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(ownerPK, object, groups);
        }
        groups.removeAll(groupids);
        filter = baseFilter.copy();
        filter.and("customer.id", "=", (Object)0L);
        filter.and("customergroup.id", "in", groups);
        pricePolicy = PricePolicyUtil.getItemPricePolicy(filter, null, groups);
        return pricePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, BigDecimal> getItemPricePolicy(QFilter filter, List<Object> regions, List<Object> groups) {
        ORM orm = ORM.create();
        String selectField = PricePolicyUtil.getSelectField();
        try (DataSet priceSet = null;){
            priceSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_price_policy", selectField, filter.toArray());
            DataSet reginSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_region", "level,id", WebUtil.getIdQFilter(regions).toArray());
            DataSet groupSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_customer_group", "level,id", WebUtil.getIdQFilter(groups).toArray());
            if (StringUtils.isNotEmpty(regions) && StringUtils.isNotEmpty(groups)) {
                priceSet = priceSet.join(reginSet, JoinType.LEFT).on("region", "id").select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto"}, new String[]{"level"}).finish().select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "level as grouplevel"});
                priceSet = priceSet.join(groupSet, JoinType.LEFT).on("customergroup", "id").select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "grouplevel"}, new String[]{"level"}).finish().select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "grouplevel", "level as regionlevel"});
                priceSet = priceSet.orderBy(new String[]{"regionlevel desc", "grouplevel desc", "priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            } else if (StringUtils.isEmpty(regions) && StringUtils.isNotEmpty(groups)) {
                priceSet = priceSet.join(groupSet, JoinType.LEFT).on("customergroup", "id").select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto"}, new String[]{"level"}).finish().select(new String[]{"price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "level as grouplevel"});
                priceSet = priceSet.orderBy(new String[]{"priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            } else {
                priceSet = priceSet.orderBy(new String[]{"priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            }
            if (priceSet.hasNext()) {
                Row row = priceSet.next();
                BigDecimal price = row.getBigDecimal("price");
                BigDecimal lowestprice = row.getBigDecimal("lowestprice");
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
                result.put("price", price);
                result.put("lowestprice", lowestprice);
                HashMap<String, BigDecimal> hashMap = result;
                return hashMap;
            }
        }
        return null;
    }

    private static String getSelectField() {
        return "price,region,customergroup,lowestprice,priority,begindate,enddate,qtyfrom,qtyto";
    }

    private static QFilter getBaseFilters(Object ownerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("owner", "=", ownerPK);
        filter.and("item", "=", itemPK);
        filter.and("unit", "=", unitPK);
        filter.and("assistattr", "=", assistattrPk == null ? Integer.valueOf(0) : assistattrPk);
        filter.and("qtyfrom", "<=", (Object)qty);
        filter.and(new QFilter("qtyto", ">=", (Object)qty).or("qtyto", "=", (Object)0));
        filter.and("begindate", "<=", (Object)date);
        filter.and("enddate", ">=", (Object)date);
        return filter;
    }

    public static Set<PricePolicy> getItemPrice(DynamicObjectCollection rows, Object ownerId, Object customerId, BigDecimal qty, Date date) {
        HashSet<PricePolicy> result = new HashSet<PricePolicy>(16);
        PricePolicyUtil.matchComplete(rows, result, ownerId, qty, date, customerId);
        if (result.size() == rows.size()) {
            return result;
        }
        PricePolicyUtil.matchRegionAndCustomerGroup(rows, result, ownerId, qty, date, customerId);
        if (rows.size() == result.size()) {
            return result;
        }
        List<Object> customerGroupIds = PricePolicyUtil.queryCustomerGroupIdsNotInAuthorize(ownerId, customerId);
        if (CommonUtils.isNull(customerGroupIds)) {
            return result;
        }
        PricePolicyUtil.matchCustomerGroup(rows, result, ownerId, qty, date, customerGroupIds);
        if (rows.size() == result.size()) {
            return result;
        }
        List<Object> customerGroupIds2 = PricePolicyUtil.queryGroupParentIdsNoSelf(ownerId, customerGroupIds);
        if (CommonUtils.isNull(customerGroupIds2)) {
            return result;
        }
        PricePolicyUtil.matchCustomerGroup(rows, result, ownerId, qty, date, customerGroupIds2);
        return result;
    }

    private static List<Object> queryGroupParentIdsNoSelf(Object ownerId, List<Object> customerGroupIds) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object groupId : customerGroupIds) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(ownerId, groupId, result);
        }
        result.removeAll(customerGroupIds);
        return result;
    }

    private static void matchCustomerGroup(DynamicObjectCollection rows, Set<PricePolicy> result, Object ownerId, BigDecimal qty, Date date, List<Object> customerGroupIds) {
        QFilter filter = PricePolicyUtil.buildFilter(rows, result, ownerId, qty, date);
        filter.and("customer.id", "=", (Object)0L);
        filter.and("customergroup.id", "in", customerGroupIds);
        result.addAll(PricePolicyUtil.queryPricePolicy(filter, null, customerGroupIds));
    }

    private static List<Object> queryCustomerGroupIdsNotInAuthorize(Object ownerId, Object customerId) {
        DynamicObject customerAuthorizeDyn = CustomerUtil.getAuthBizInfo(ownerId, customerId);
        DynamicObject customerGroupDyn = customerAuthorizeDyn.getDynamicObject("customergroup");
        List<Object> result = CustomerUtil.getGroupsByCustomer(customerId);
        if (!CommonUtils.isNull(result) && !CommonUtils.isNull(customerGroupDyn)) {
            result.remove(customerGroupDyn.getPkValue());
        }
        return result;
    }

    private static void matchRegionAndCustomerGroup(DynamicObjectCollection rows, Set<PricePolicy> result, Object ownerId, BigDecimal qty, Date date, Object customerId) {
        Object customerGroupId;
        Object regionId;
        DynamicObject info = CustomerUtil.getAuthBizInfo(ownerId, customerId);
        ArrayList<Object> regionIds = new ArrayList<Object>();
        regionIds.add(0L);
        DynamicObject regionDyn = info.getDynamicObject("region");
        if (!CommonUtils.isNull(regionDyn) && !(regionId = regionDyn.getPkValue()).equals(0L)) {
            RegionUtil.queryRegionParentsAndSelf(ownerId, regionId, regionIds);
        }
        ArrayList<Object> customerGroupIds = new ArrayList<Object>();
        customerGroupIds.add(0L);
        DynamicObject customerGroupDyn = info.getDynamicObject("customergroup");
        if (!CommonUtils.isNull(customerGroupDyn) && !(customerGroupId = customerGroupDyn.getPkValue()).equals(0L)) {
            CustomerGroupUtil.queryCustomerGroupParentsAndSelf(ownerId, customerGroupId, customerGroupIds);
        }
        if (regionDyn != null || customerGroupDyn != null) {
            QFilter filter = PricePolicyUtil.buildFilter(rows, result, ownerId, qty, date);
            filter.and("customer.id", "=", (Object)0L);
            filter.and("customergroup.id", "in", customerGroupIds);
            filter.and("region.id", "in", regionIds);
            result.addAll(PricePolicyUtil.queryPricePolicy(filter, regionIds, customerGroupIds));
        }
    }

    private static void matchComplete(DynamicObjectCollection rows, Set<PricePolicy> result, Object ownerId, BigDecimal qty, Date date, Object customerId) {
        QFilter filter = PricePolicyUtil.buildFilter(rows, result, ownerId, qty, date);
        filter.and("customer.id", "=", customerId);
        result.addAll(PricePolicyUtil.queryPricePolicy(filter, null, null));
    }

    private static QFilter buildFilter(DynamicObjectCollection rows, Set<PricePolicy> pricePolicySet, Object ownerId, BigDecimal qty, Date date) {
        Object noPricePolicyRows;
        if (pricePolicySet.size() == 0) {
            noPricePolicyRows = rows;
        } else {
            Set hasPriceItemIds = pricePolicySet.stream().map(PricePolicy::getItemId).collect(Collectors.toSet());
            noPricePolicyRows = rows.stream().filter(i -> !hasPriceItemIds.contains(i.getLong("id"))).collect(Collectors.toList());
        }
        Set<Object> itemIds = noPricePolicyRows.stream().map(i -> i.getLong("id")).collect(Collectors.toSet());
        List<Object> unitIds = noPricePolicyRows.stream().map(i -> i.getLong("saleunit_id")).collect(Collectors.toList());
        unitIds.add(0L);
        Map<Object, Object> itemAttrMap = ItemAttrUtil.getDefaultAttrId(itemIds);
        ArrayList<Object> attrIds = new ArrayList<Object>(itemAttrMap.size());
        attrIds.add(0L);
        Set<Map.Entry<Object, Object>> itemAttrEntries = itemAttrMap.entrySet();
        for (Map.Entry<Object, Object> next : itemAttrEntries) {
            attrIds.add(next.getValue());
        }
        return PricePolicyUtil.getBaseFilter(ownerId, itemIds, unitIds, attrIds, qty, date);
    }

    private static QFilter getBaseFilter(Object ownerId, Set<Object> itemIds, List<Object> unitIds, Collection<Object> assistAttrIds, BigDecimal qty, Date date) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("owner", "=", ownerId);
        filter.and("item", "in", itemIds);
        filter.and("unit", "in", unitIds);
        filter.and("assistattr", "in", assistAttrIds);
        filter.and("qtyfrom", "<=", (Object)qty);
        filter.and(new QFilter("qtyto", ">=", (Object)qty).or("qtyto", "=", (Object)0));
        filter.and("begindate", "<=", (Object)date);
        filter.and("enddate", ">=", (Object)date);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<PricePolicy> queryPricePolicy(QFilter filter, List<Object> regions, List<Object> groups) {
        HashSet<PricePolicy> result = new HashSet<PricePolicy>(16);
        ORM orm = ORM.create();
        String selectField = "item,unit,assistattr,price,region,customergroup,lowestprice,priority,begindate,enddate,qtyfrom,qtyto";
        try (DataSet priceSet = null;){
            priceSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_price_policy", selectField, filter.toArray());
            DataSet reginSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_region", "level,id", WebUtil.getIdQFilter(regions).toArray());
            DataSet groupSet = orm.queryDataSet(PricePolicyUtil.class.getName(), "mdr_customer_group", "level,id", WebUtil.getIdQFilter(groups).toArray());
            if (StringUtils.isNotEmpty(regions) && StringUtils.isNotEmpty(groups)) {
                priceSet = priceSet.join(reginSet, JoinType.LEFT).on("region", "id").select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto"}, new String[]{"level"}).finish().select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "level as grouplevel"});
                priceSet = priceSet.join(groupSet, JoinType.LEFT).on("customergroup", "id").select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "grouplevel"}, new String[]{"level"}).finish().select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "grouplevel", "level as regionlevel"});
                priceSet = priceSet.orderBy(new String[]{"regionlevel desc", "grouplevel desc", "priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            } else if (StringUtils.isEmpty(regions) && StringUtils.isNotEmpty(groups)) {
                priceSet = priceSet.join(groupSet, JoinType.LEFT).on("customergroup", "id").select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto"}, new String[]{"level"}).finish().select(new String[]{"item", "unit", "assistattr", "price", "region", "customergroup", "lowestprice", "priority", "begindate", "enddate", "qtyfrom", "qtyto", "level as grouplevel"});
                priceSet = priceSet.orderBy(new String[]{"priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            } else {
                priceSet = priceSet.orderBy(new String[]{"priority asc", "begindate desc", "enddate asc", "qtyfrom desc", "qtyto asc", "price desc"});
            }
            while (priceSet.hasNext()) {
                result.add(new PricePolicy(priceSet.next()));
            }
        }
        return result;
    }
}

