/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.item.PricePolicy;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ObjectUtil;
import kd.drp.mdr.common.util.PricePolicyUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.price.PriceService;
import org.apache.log4j.Logger;

public class PriceUtil {
    private static final Logger log = Logger.getLogger(PriceUtil.class);
    private static PriceService service;

    public static BigDecimal getPriceByDate(Object itemId, Object unitId, Object assistattrPk, Object ownerId, Date date) {
        BigDecimal price = BigDecimal.ZERO;
        QFilter f = new QFilter("entrys.item", "=", itemId);
        f.and("entrys.unit", "=", unitId);
        f.and("owner", "=", ownerId);
        date.setHours(23);
        date.setMinutes(59);
        date.setSeconds(59);
        f.and("approvetime", "<=", (Object)date);
        f.and("status", "=", (Object)"3");
        DynamicObjectCollection itemChange = QueryServiceHelper.query((String)"mdr_item_pricechange", (String)"id,entrys.newprice", (QFilter[])f.toArray(), (String)"approvetime desc", (int)1);
        price = itemChange != null && itemChange.size() > 0 ? ((DynamicObject)itemChange.get(0)).getBigDecimal("entrys.newprice") : PriceUtil.getPrice(itemId, unitId, assistattrPk, ownerId);
        return price;
    }

    public static BigDecimal getLowestPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal policyPrice = PricePolicyUtil.getLowestPrice(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, date);
        price = policyPrice == null ? PriceUtil.getLowestPrice(itemPK, unitPK, assistattrPk, ownerPK) : policyPrice;
        return price;
    }

    public static BigDecimal getCombItemPrice(Object ownerPK, Object customerPK, DynamicObject comb, DynamicObject currency) {
        String pricemode;
        BigDecimal price = BigDecimal.ZERO;
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"PriceUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        switch (pricemode = comb.getString("pricemode")) {
            case "0": {
                DynamicObjectCollection itemdetails = comb.getDynamicObjectCollection("itemdetail");
                for (DynamicObject itemdetail : itemdetails) {
                    Object itemId = itemdetail.getDynamicObject("item").get("id");
                    Object unitId = itemdetail.getDynamicObject("unit").get("id");
                    DynamicObject attr = itemdetail.getDynamicObject("attr");
                    BigDecimal qty = itemdetail.getBigDecimal("qty");
                    BigDecimal itemPrice = PriceUtil.getItemPrice(ownerPK, customerPK, itemId, unitId, attr == null ? Long.valueOf(0L) : attr.get("id"), qty);
                    price = price.add(qty.multiply(itemPrice));
                }
                break;
            }
            case "1": 
            case "2": {
                price = comb.getBigDecimal("totalamount");
            }
        }
        return price.setScale(currency.getInt("priceprecision"), RoundingMode.HALF_UP);
    }

    public static BigDecimal getCombItemPrice(Object ownerPK, Object customerPK, Object combId, DynamicObject currency) {
        DynamicObject comb = BusinessDataServiceHelper.loadSingle((Object)combId, (String)"dpm_item_combination");
        return PriceUtil.getCombItemPrice(ownerPK, customerPK, comb, currency);
    }

    public static BigDecimal getItemPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty) {
        return PriceUtil.getItemPrice(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, new Date());
    }

    public static BigDecimal getItemPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal policyPrice = PricePolicyUtil.getItemPrice(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, date);
        price = policyPrice == null ? PriceUtil.getPrice(itemPK, unitPK, assistattrPk, ownerPK) : policyPrice;
        try {
            Class<?> PriceUtilExt = Class.forName("kd.drp.mdr.common.util.price.PriceUtilExt");
            PriceService priceService = (PriceService)PriceUtilExt.newInstance();
            price = priceService.getItemPrice(ownerPK, customerPK, itemPK, unitPK, assistattrPk, qty, date, price);
        }
        catch (ClassNotFoundException PriceUtilExt) {
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6269\u5c55\u53d6\u4ef7\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\uff01\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s", (String)"PriceUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]), e.getMessage()));
        }
        return price;
    }

    private static BigDecimal getPrice(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        DynamicObject priceObj = PriceUtil.getItemPriceObject(itemPK, unitPK, assistattrPk, ownerPK);
        if (priceObj != null) {
            return priceObj.getBigDecimal("saleprice");
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getLowestPrice(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        DynamicObject priceObj = PriceUtil.getItemPriceObject(itemPK, unitPK, assistattrPk, ownerPK);
        if (priceObj != null) {
            return priceObj.getBigDecimal("lowprice");
        }
        return BigDecimal.ZERO;
    }

    private static DynamicObject getItemPriceObject(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        QFilter filters = PriceUtil.getFilters(itemPK, unitPK, assistattrPk, ownerPK);
        String selectField = PriceUtil.getSelectField();
        DynamicObject price = QueryServiceHelper.queryOne((String)"mdr_item_price", (String)selectField, (QFilter[])filters.toArray());
        return price;
    }

    public static DynamicObject getPriceDynamicObject(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        QFilter filters = PriceUtil.getFilters(itemPK, unitPK, assistattrPk, ownerPK);
        String selectField = "id,name,number,saleprice,lowprice,status";
        DynamicObject price = BusinessDataServiceHelper.loadSingle((String)"mdr_item_price", (String)selectField, (QFilter[])filters.toArray());
        return price;
    }

    private static String getSelectField() {
        return "id,name,number,saleprice,lowprice,itemid,assistattr,unit";
    }

    private static QFilter getFilters(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        QFilter filters = new QFilter("status", "=", (Object)"1");
        if (itemPK != null) {
            filters.and("itemid", "=", itemPK);
        }
        if (unitPK != null) {
            filters.and("unit", "=", unitPK);
        }
        if (assistattrPk != null) {
            filters.and("assistattr", "=", assistattrPk);
        }
        if (ownerPK != null) {
            filters.and("customer", "=", ownerPK);
        } else if (UserUtil.getUserID() != null) {
            filters.and("customer", "=", UserUtil.getDefaultOwnerID());
        }
        return filters;
    }

    public static void setRowsPrice(DynamicObjectCollection rows, Object ownerId, Object customerId, BigDecimal qty) {
        Date nowDate = new Date();
        Set<PricePolicy> itemPriceSet = PricePolicyUtil.getItemPrice(rows, ownerId, customerId, qty, nowDate);
        List<Long> hasPriceItemIds = PriceUtil.setRowsPriceByPricePolicy(rows, itemPriceSet);
        if (rows.size() == itemPriceSet.size()) {
            return;
        }
        List<DynamicObject> noPriceRows = rows.stream().filter(i -> !hasPriceItemIds.contains(i.getLong("id"))).collect(Collectors.toList());
        DynamicObjectCollection itemPriceDynColl = PriceUtil.getItemPriceDynColl(noPriceRows, ownerId);
        PriceUtil.setRowsPriceByItemPriceWithDfv(noPriceRows, itemPriceDynColl);
        PriceUtil.setRowsPriceByExtService(rows, ownerId, customerId, qty, nowDate);
    }

    private static void setRowsPriceByExtService(DynamicObjectCollection rows, Object ownerId, Object customerId, BigDecimal qty, Date nowDate) {
        if (CommonUtils.isNull(service)) {
            return;
        }
        for (DynamicObject row : rows) {
            Object itemId = row.get("id");
            Object unitId = row.getDynamicObject("saleunit").get("id");
            Object attrId = ItemAttrUtil.getDefaultAttrId(itemId);
            BigDecimal price = service.getItemPrice(ownerId, customerId, itemId, unitId, attrId, qty, nowDate, row.getBigDecimal("easnum"));
            row.set("easnum", (Object)price.stripTrailingZeros().toPlainString());
        }
    }

    private static void setRowsPriceByItemPriceWithDfv(List<DynamicObject> noPricePolicyRows, DynamicObjectCollection itemPriceDynColl) {
        for (DynamicObject row : noPricePolicyRows) {
            Object itemId = row.get("id");
            Object unitId = row.getDynamicObject("saleunit").get("id");
            Object attrId = ItemAttrUtil.getDefaultAttrId(itemId);
            Optional<DynamicObject> itemPriceDyn = itemPriceDynColl.stream().filter(i -> PriceUtil.isSameItem(i, itemId, unitId, attrId)).findFirst();
            row.set("easnum", itemPriceDyn.isPresent() ? itemPriceDyn.get().getBigDecimal("saleprice").stripTrailingZeros().toPlainString() : BigDecimal.ZERO);
        }
    }

    private static List<Long> setRowsPriceByPricePolicy(DynamicObjectCollection rows, Set<PricePolicy> itemPriceSet) {
        ArrayList<Long> result = new ArrayList<Long>(itemPriceSet.size());
        for (PricePolicy pricePolicy : itemPriceSet) {
            DynamicObject row = rows.stream().filter(i -> i.getLong("id") == pricePolicy.getItemId().longValue()).findFirst().get();
            row.set("easnum", (Object)pricePolicy.getPrice().stripTrailingZeros().toPlainString());
            result.add(pricePolicy.getItemId());
        }
        return result;
    }

    private static boolean isSameItem(DynamicObject itemPriceDyn, Object itemId, Object unitId, Object attrId) {
        boolean isSameItem;
        boolean bl = isSameItem = itemPriceDyn.getLong("itemid") == ((Long)itemId).longValue();
        if (!ObjectUtil.isEmpty(unitId)) {
            boolean bl2 = isSameItem = isSameItem && itemPriceDyn.getLong("unit") == ((Long)unitId).longValue();
        }
        if (!ObjectUtil.isEmpty(attrId)) {
            isSameItem = isSameItem && itemPriceDyn.getLong("assistattr") == ((Long)attrId).longValue();
        }
        return isSameItem;
    }

    private static DynamicObjectCollection getItemPriceDynColl(List<DynamicObject> noPriceRows, Object ownerPK) {
        QFilter filter = PriceUtil.buildFilter(noPriceRows, ownerPK);
        String selectField = PriceUtil.getSelectField();
        return QueryServiceHelper.query((String)"mdr_item_price", (String)selectField, (QFilter[])filter.toArray());
    }

    private static QFilter buildFilter(List<DynamicObject> noPriceRows, Object ownerPK) {
        Set<Object> itemIds = noPriceRows.stream().map(i -> i.getLong("id")).collect(Collectors.toSet());
        List<Object> unitIds = noPriceRows.stream().map(i -> i.getLong("saleunit_id")).collect(Collectors.toList());
        unitIds.add(0L);
        Map<Object, Object> itemAttrMap = ItemAttrUtil.getDefaultAttrId(itemIds);
        ArrayList<Object> attrIds = new ArrayList<Object>(itemAttrMap.size());
        attrIds.add(0L);
        Set<Map.Entry<Object, Object>> itemAttrEntries = itemAttrMap.entrySet();
        for (Map.Entry<Object, Object> next : itemAttrEntries) {
            attrIds.add(next.getValue());
        }
        return PriceUtil.getFilters(itemIds, unitIds, attrIds, ownerPK);
    }

    private static QFilter getFilters(Set<Object> itemIds, List<Object> unitIds, Collection<Object> itemAttrIds, Object ownerPK) {
        QFilter filters = new QFilter("status", "=", (Object)"1");
        if (!ObjectUtil.isEmpty(itemIds)) {
            filters.and("itemid", "in", itemIds);
        }
        if (!ObjectUtil.isEmpty(unitIds)) {
            filters.and("unit", "in", unitIds);
        }
        if (!ObjectUtil.isEmpty(itemAttrIds)) {
            filters.and("assistattr", "in", itemAttrIds);
        }
        if (!ObjectUtil.isEmpty(ownerPK)) {
            filters.and("customer", "=", ownerPK);
        } else if (UserUtil.getUserID() != null) {
            filters.and("customer", "=", UserUtil.getDefaultOwnerID());
        }
        return filters;
    }

    static {
        try {
            Class<?> PriceUtilExt = Class.forName("kd.drp.mdr.common.util.price.PriceUtilExt");
            service = (PriceService)PriceUtilExt.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6269\u5c55\u53d6\u4ef7\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\uff01\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s", (String)"PriceUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

