/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.f7.F7Utils;
import org.apache.commons.lang3.StringUtils;

public class QueryUtil {
    private static final Log LOG = LogFactory.getLog(QueryUtil.class);

    public static String getSelectCols(String ... colName) {
        return StringUtils.join((Object[])colName, (String)",");
    }

    public static Set<Object> querySingleCol(String entityName, final String colName, QFilter[] filters) {
        final HashSet<Object> set = new HashSet<Object>();
        QueryUtil.queryDataSet((Consumer<? super Row>)new Consumer<Row>(){

            @Override
            public void accept(Row row) {
                set.add(row.get(colName));
            }
        }, null, entityName, colName, filters, null);
        return set;
    }

    public static List<Object> querySingleCol(String entityName, final String colName, QFilter[] filters, String orderByStr) {
        final ArrayList<Object> list = new ArrayList<Object>();
        QueryUtil.queryDataSet((Consumer<? super Row>)new Consumer<Row>(){

            @Override
            public void accept(Row row) {
                list.add(row.get(colName));
            }
        }, null, entityName, colName, filters, orderByStr);
        return list;
    }

    public static List<Object> querySingleCol(String entityName, final String colName, QFilter[] filters, String orderByStr, int top) {
        final ArrayList<Object> list = new ArrayList<Object>();
        QueryUtil.queryDataSetTop((Consumer<? super Row>)new Consumer<Row>(){

            @Override
            public void accept(Row row) {
                list.add(row.get(colName));
            }
        }, null, entityName, colName, filters, orderByStr, top);
        return list;
    }

    public static List<Map<String, Object>> queryColumnsList(String entityName, String[] colNames, QFilter[] filters) {
        return QueryUtil.queryColumnsList(entityName, colNames, filters, null);
    }

    public static List<Map<String, Object>> queryColumnsList(String entityName, String[] colNames, QFilter[] filters, String orderByStr) {
        return QueryUtil.doQueryColumnsList(entityName, colNames, filters, orderByStr, null);
    }

    private static List<Map<String, Object>> doQueryColumnsList(String entityName, final String[] colNames, QFilter[] filters, String orderByStr, final Function<String, String> colsParser) {
        String selectFields = F7Utils.getSelectCols(colNames);
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Consumer<Row> consumer = null;
        consumer = colsParser == null ? new Consumer<Row>(){

            @Override
            public void accept(Row t) {
                HashMap<String, Object> map = new HashMap<String, Object>(colNames.length);
                for (String col : colNames) {
                    map.put(col, t.get(col));
                }
                list.add(map);
            }
        } : new Consumer<Row>(){

            @Override
            public void accept(Row t) {
                HashMap map = new HashMap(colNames.length);
                for (String col : colNames) {
                    map.put(colsParser.apply(col), t.get(col));
                }
                list.add(map);
            }
        };
        QueryUtil.queryDataSet((Consumer<? super Row>)consumer, null, entityName, selectFields, filters, orderByStr);
        return list;
    }

    public static List<Map<String, Object>> queryCamelColsList(String entityName, String[] colNames, QFilter[] filters) {
        return QueryUtil.queryCamelColsList(entityName, colNames, filters, null);
    }

    public static List<Map<String, Object>> queryCamelColsList(String entityName, String[] colNames, QFilter[] filters, String orderByStr) {
        return QueryUtil.doQueryColumnsList(entityName, colNames, filters, orderByStr, CommonUtils::pointToCamel);
    }

    public static Map<String, Object> queryColsList(String entityName, String[] colNames, QFilter[] filters, String orderBys, int page, int pageSize) {
        String selectFields = F7Utils.getSelectCols(colNames);
        DynamicObjectCollection result = ORMUtil.query(entityName, selectFields, filters, orderBys, (page - 1) * pageSize, pageSize);
        int count = QueryUtil.querycount(entityName, filters);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("list", QueryUtil.toList(result, colNames));
        returnData.put("count", count);
        return returnData;
    }

    public static Set<Object> toSet(DynamicObjectCollection result, String keyName) {
        int len = result.size();
        HashSet<Object> values = new HashSet<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(((DynamicObject)result.get(i)).get(keyName));
        }
        return values;
    }

    public static List<Object> toList(DynamicObjectCollection result, String keyName) {
        int len = result.size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(((DynamicObject)result.get(i)).get(keyName));
        }
        return values;
    }

    public static Set<Object> toSet(DynamicObject[] result, String keyName) {
        int len = result.length;
        HashSet<Object> values = new HashSet<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(result[i].get(keyName));
        }
        return values;
    }

    public static List<Object> toList(DynamicObject[] result, String keyName) {
        int len = result.length;
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(result[i].get(keyName));
        }
        return values;
    }

    public static List<Map<String, Object>> toList(DynamicObjectCollection result, String[] keyNames) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject resItem : result) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            int keyLen = keyNames.length;
            for (int j = 0; j < keyLen; ++j) {
                if (resItem.get(keyNames[j]) instanceof BigDecimal) {
                    BigDecimal keyNameBigDecimal = (BigDecimal)resItem.get(keyNames[j]);
                    String setScale = keyNameBigDecimal.setScale(2, 4).toPlainString();
                    item.put(CommonUtils.pointToCamel(keyNames[j]), Double.valueOf(setScale));
                    continue;
                }
                item.put(CommonUtils.pointToCamel(keyNames[j]), resItem.get(keyNames[j]));
            }
            list.add(item);
        }
        return list;
    }

    public static List<Map<String, Object>> toList(List<Map<String, Object>> result, String[] keyNames) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(result.size());
        for (Map<String, Object> resItem : result) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            int keyLen = keyNames.length;
            for (int j = 0; j < keyLen; ++j) {
                if (resItem.get(keyNames[j]) instanceof BigDecimal) {
                    BigDecimal keyNameBigDecimal = (BigDecimal)resItem.get(keyNames[j]);
                    String setScale = keyNameBigDecimal.setScale(2, 4).toPlainString();
                    item.put(CommonUtils.pointToCamel(keyNames[j]), Double.valueOf(setScale));
                    continue;
                }
                item.put(CommonUtils.pointToCamel(keyNames[j]), resItem.get(keyNames[j]));
            }
            list.add(item);
        }
        return list;
    }

    public static void queryDataSet(Consumer<? super Row> action, String exceptionImgPrx, String entityName, String selectFields, QFilter[] filters, String orderBys) {
        QueryUtil.queryDataSetTop(action, exceptionImgPrx, entityName, selectFields, filters, orderBys, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryDataSetTop(Consumer<? super Row> action, String exceptionImgPrx, String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        try (DataSet datas = null;){
            datas = top < 0 ? QueryServiceHelper.queryDataSet((String)QueryUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys) : QueryServiceHelper.queryDataSet((String)QueryUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
            datas.forEach(action);
        }
    }

    public static int querycount(String entityName, QFilter[] filters) {
        int count = ORM.create().count("MDR", entityName, filters);
        return count;
    }

    public static QFilter getIdFilter(Object id) {
        return new QFilter("id", "=", id);
    }

    public static QFilter getIdQFilter(Collection<?> c) {
        return new QFilter("id", "in", c);
    }

    public static QFilter getOwnerIdQFilter(Object ownerId) {
        return new QFilter("owner", "=", ownerId);
    }

    public static Set<Object> queryMaterialAllUnit(Object materialId) {
        if (materialId == null) {
            return null;
        }
        QFilter f = new QFilter("materialid", "=", materialId);
        String colName = "measureunitid";
        Set<Object> units = QueryUtil.querySingleCol("bd_multimeasureunit", colName, f.toArray());
        Set<Object> baseunit = QueryUtil.querySingleCol("bd_material", "baseunit", new QFilter("id", "=", materialId).toArray());
        units.addAll(baseunit);
        return units;
    }

    public static List<Long> getAssistMUListResult(Long materialId, Long srcUnitId, String convertType) {
        if (materialId == null || materialId == 0L || srcUnitId == null || srcUnitId == 0L) {
            return null;
        }
        List assistMUListResult = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)srcUnitId, (String)convertType);
        return assistMUListResult;
    }
}

