/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.handler.BalanceHandler;
import kd.drp.mdr.common.model.ItemStoreModel;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.strategy.DynamicObjectCopyStrategy;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class SaleOrderUtil {
    private static final List<String> FIELDSNEEDEDCOMPARE4HEAD = new ArrayList<String>();
    private static final List<String> FIELDSNEEDEDCOMPARE4ENTRY;

    public static boolean isDataChangeWhenDoOperation(DynamicObject order) {
        DynamicObject oldOrder = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)order.getDynamicObjectType().getName());
        if (SaleOrderUtil.isFields4HeadChange(order, oldOrder)) {
            return true;
        }
        return SaleOrderUtil.isFields4EntryChange(order, oldOrder);
    }

    private static boolean isFields4HeadChange(DynamicObject order, DynamicObject oldOrder) {
        if (FIELDSNEEDEDCOMPARE4HEAD.isEmpty()) {
            return false;
        }
        for (String field : FIELDSNEEDEDCOMPARE4HEAD) {
            Object oldValue;
            Object value = order.get(field);
            if (!SaleOrderUtil.isValueChange(value, oldValue = oldOrder.get(field))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFields4EntryChange(DynamicObject order, DynamicObject oldOrder) {
        if (FIELDSNEEDEDCOMPARE4ENTRY.isEmpty()) {
            return false;
        }
        for (String field : FIELDSNEEDEDCOMPARE4ENTRY) {
            Object oldValue;
            Object value = order.getDynamicObject("itementry").get(field);
            if (!SaleOrderUtil.isValueChange(value, oldValue = oldOrder.getDynamicObject("itementry").get(field))) continue;
            return true;
        }
        return false;
    }

    private static boolean isValueChange(Object value, Object oldValue) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo((BigDecimal)oldValue) != 0;
        }
        return !value.equals(oldValue);
    }

    public static boolean isThisStatus(DynamicObject order, SaleOrderStatus status) {
        return EnumUtil.toSaleOrderStatus(order.getString("orderstatus")) == status;
    }

    public static boolean isThisStatus(DynamicObject order, SaleOrderSyncStatus status) {
        return EnumUtil.toOrderSyncStatus(order.getString("sync")) == status;
    }

    public static boolean isThisStatus(DynamicObject order, SaleOrderPayStatus status) {
        return EnumUtil.toOrderPayStatus(order.getString("paystatus")) == status;
    }

    public static void unWriteDispatchOrderConfirmStatus(DynamicObject saleorder, String status) {
        Object billid = saleorder.get("id");
        QFilter filter = new QFilter("itementry.sourcebillid", "=", (Object)billid.toString());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id,confirmstatus", (QFilter[])filter.toArray());
        if (orders != null && orders.length > 0) {
            for (DynamicObject order : orders) {
                order.set("confirmstatus", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    public static void unWriteDispatchOrderConfirmStatus(Object saleorderid, String status) {
        QFilter filter = new QFilter("itementry.sourcebillid", "=", (Object)saleorderid.toString());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id,confirmstatus", (QFilter[])filter.toArray());
        if (orders != null && orders.length > 0) {
            for (DynamicObject order : orders) {
                order.set("confirmstatus", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    public static SaleOrderStatus getOrderStatus(DynamicObject order) {
        return EnumUtil.toSaleOrderStatus(order.getString("orderstatus"));
    }

    public static SaleOrderPayStatus getOrderPayStatus(DynamicObject order) {
        return EnumUtil.toOrderPayStatus(order.getString("paystatus"));
    }

    public static SaleOrderSyncStatus getOrderSyncStatus(DynamicObject order) {
        return EnumUtil.toOrderSyncStatus(order.getString("sync"));
    }

    public static String[] querySaleOrderAllStatus(Object orderId) {
        DynamicObject info = SaleOrderUtil.queryAllStatus(orderId);
        return new String[]{info.getString("orderstatus"), info.getString("paystatus"), info.getString("sync")};
    }

    public static SaleOrderStatus querySaleOrderStatus(Object orderId) {
        return EnumUtil.toSaleOrderStatus(SaleOrderUtil.querySaleOrderAllStatus(orderId)[0]);
    }

    public static SaleOrderSyncStatus querySaleOrderSyncStatus(Object orderId) {
        return EnumUtil.toOrderSyncStatus(SaleOrderUtil.querySaleOrderAllStatus(orderId)[2]);
    }

    public static SaleOrderPayStatus querySaleOrderPayStatus(Object orderId) {
        return EnumUtil.toOrderPayStatus(SaleOrderUtil.querySaleOrderAllStatus(orderId)[1]);
    }

    private static DynamicObject queryAllStatus(Object orderId) {
        QFilter f = new QFilter("id", "=", orderId);
        DynamicObject info = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"orderstatus,paystatus,sync", (QFilter[])f.toArray());
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"SaleOrderUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return info;
    }

    public static void handleBalance(DynamicObject order) {
        Object ownerPK = DynamicObjectUtils.getDynamicObjectID(order, "owner");
        Object customerPK = DynamicObjectUtils.getDynamicObjectID(order, "customer");
        BigDecimal usedBalance = order.getBigDecimal("usedbalance");
        if (SaleOrderUtil.isNeedAllUpdate(order)) {
            if (!SaleOrderUtil.isNeedUpdateBalance(order)) {
                return;
            }
            BalanceHandler.updateBalance(ownerPK, customerPK, null, usedBalance);
        } else {
            DynamicObject oldSaleOrder = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)order.getDynamicObjectType().getName());
            DynamicObject oldOwner = oldSaleOrder.getDynamicObject("owner");
            Object oldOwnerPK = null;
            if (oldOwner != null) {
                oldOwnerPK = oldOwner.get("id");
            }
            DynamicObject oldCustomer = oldSaleOrder.getDynamicObject("customer");
            Object oldCustomerPK = null;
            if (oldCustomer != null) {
                oldCustomerPK = oldCustomer.get("id");
            }
            BigDecimal oldUsedBalance = oldSaleOrder.getBigDecimal("usedbalance");
            int balanceUseInfo = SaleOrderUtil.info4IsUseBalance(order, oldSaleOrder);
            if (balanceUseInfo == 0) {
                return;
            }
            if (balanceUseInfo == 1) {
                BalanceHandler.updateBalance(oldOwnerPK, oldCustomerPK, null, oldUsedBalance.negate());
            } else if (balanceUseInfo == 2) {
                BalanceHandler.updateBalance(ownerPK, customerPK, null, usedBalance);
            } else if (balanceUseInfo == 3) {
                BalanceHandler.updateBalance(oldOwnerPK, oldCustomerPK, null, oldUsedBalance.negate());
                BalanceHandler.updateBalance(ownerPK, customerPK, null, usedBalance);
            }
        }
    }

    public static void handleBalance4UnSubmit(DynamicObject order) {
        if (!SaleOrderUtil.isNeedUpdateBalance(order)) {
            return;
        }
        DynamicObject owner = order.getDynamicObject("owner");
        Object ownerPK = null;
        if (owner != null) {
            ownerPK = owner.get("id");
        }
        DynamicObject customer = order.getDynamicObject("customer");
        Object customerPK = null;
        if (customer != null) {
            customerPK = customer.get("id");
        }
        BigDecimal usedBalance = order.getBigDecimal("usedbalance");
        BalanceHandler.updateBalance(ownerPK, customerPK, null, usedBalance.negate());
    }

    private static int info4IsUseBalance(DynamicObject order, DynamicObject oldSaleOrder) {
        int oldInfo = 0;
        int newInfo = 0;
        if (oldSaleOrder.getBoolean("isusebalance")) {
            oldInfo = 1;
        }
        if (order.getBoolean("isusebalance")) {
            newInfo = 1;
        }
        return (newInfo << 1) + (oldInfo & 0xFF);
    }

    private static boolean isNeedAllUpdate(DynamicObject order) {
        String orderStatus = order.getString("orderstatus");
        return orderStatus.equals(SaleOrderStatus.TEMP_SAVE.getFlagStr());
    }

    public static boolean isNeedUpdateBalance(DynamicObject order) {
        BigDecimal usedbalance = order.getBigDecimal("usedbalance");
        return usedbalance.compareTo(BigDecimal.ZERO) > 0;
    }

    public static void handleStoreForward(DynamicObject order) {
        if (!SaleOrderUtil.needHandleStore4Order()) {
            return;
        }
        List<ItemStoreModel> stores = SaleOrderUtil.createItemStoreContrastOldData(order);
        Object biztypeid = order.getDynamicObject("biztype").get("id");
        ItemStoreUtil.updateItemStore4Bill(stores, biztypeid);
    }

    private static boolean needHandleStore4Order() {
        return !SysParamsUtil.isDispatch();
    }

    public static void handleStoreReverse(DynamicObject order) {
        if (!SaleOrderUtil.needHandleStore4Order()) {
            return;
        }
        Object biztypeid = order.getDynamicObject("biztype").get("id");
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObjectCollection entrys = SaleOrderUtil.queryOldEntrys(order);
        int len = entrys.size();
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>(len);
        ItemStoreModel store = null;
        for (int i = 0; i < len; ++i) {
            DynamicObject oldEntry = (DynamicObject)entrys.get(i);
            if (oldEntry.getDynamicObjectType().getProperty("itementry.entrytype") != null) {
                Object entrytype = oldEntry.get("itementry.entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            }
            store = SaleOrderUtil.createItemStoreModelFromOldEntry(ownerId, (DynamicObject)entrys.get(i));
            SaleOrderUtil.reverseItemStore(store);
            stores.add(store);
        }
        ItemStoreUtil.updateItemStore4Bill(stores, biztypeid);
    }

    private static List<ItemStoreModel> createItemStoreContrastOldData(DynamicObject order) {
        Object ownerId = order.getDynamicObject("owner").get("id");
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>();
        if (SaleOrderUtil.isThisStatus(order, SaleOrderStatus.CHANGING)) {
            DynamicObjectCollection oldEntrys = SaleOrderUtil.queryOldEntrys(order);
            int oldLen = oldEntrys.size();
            ItemStoreModel store = null;
            for (int i = 0; i < oldLen; ++i) {
                DynamicObject oldEntry = (DynamicObject)oldEntrys.get(i);
                if (oldEntry.getDynamicObjectType().getProperty("itementry.entrytype") != null) {
                    Object entrytype = oldEntry.get("itementry.entrytype");
                    if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
                }
                store = SaleOrderUtil.createItemStoreModelFromOldEntry(ownerId, oldEntry);
                SaleOrderUtil.reverseItemStore(store);
                stores.add(store);
            }
        }
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        int newLen = entrys.size();
        for (int i = 0; i < newLen; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (entry.getDynamicObjectType().getProperty("entrytype") != null) {
                Object entrytype = entry.get("entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            }
            stores.add(SaleOrderUtil.createItemStoreModel(ownerId, entry));
        }
        return stores;
    }

    private static DynamicObjectCollection queryOldEntrys(DynamicObject order) {
        QFilter f = new QFilter("id", "=", order.get("id"));
        StringBuilder selectFileds = new StringBuilder("itementry.id,itementry.item,itementry.unit,itementry.entrywarehouse,itementry.assistattr,itementry.qty");
        if (order.getDynamicObjectCollection("itementry").getDynamicObjectType().getProperty("entrytype") != null) {
            selectFileds = selectFileds.append(",itementry.entrytype");
        }
        DynamicObjectCollection oldEntrys = QueryServiceHelper.query((String)order.getDynamicObjectType().getName(), (String)selectFileds.toString(), (QFilter[])f.toArray());
        return oldEntrys;
    }

    private static ItemStoreModel createItemStoreModelFromOldEntry(Object ownerId, DynamicObject entry) {
        Object itemId = entry.get("itementry.item");
        Object measureunitId = entry.get("itementry.unit");
        Object assistattrId = entry.get("itementry.assistattr");
        if (assistattrId == null) {
            assistattrId = 0L;
        }
        Object warehouseId = entry.get("itementry.entrywarehouse");
        BigDecimal qty = entry.getBigDecimal("itementry.qty");
        return new ItemStoreModel(ownerId, itemId, measureunitId, assistattrId, warehouseId, null, qty);
    }

    private static ItemStoreModel createItemStoreModel(Object ownerId, DynamicObject entry) {
        Object itemId = entry.getDynamicObject("item").get("id");
        Object measureunitId = entry.getDynamicObject("unit").get("id");
        Object assistattrId = 0L;
        DynamicObject assistattr = entry.getDynamicObject("assistattr");
        if (assistattr != null) {
            assistattrId = assistattr.get("id");
        }
        Object warehouseId = 0L;
        DynamicObject entrywarehouse = entry.getDynamicObject("entrywarehouse");
        if (entrywarehouse != null) {
            warehouseId = entrywarehouse.get("id");
        }
        BigDecimal qty = entry.getBigDecimal("qty");
        return new ItemStoreModel(ownerId, itemId, measureunitId, assistattrId, warehouseId, null, qty);
    }

    private static void reverseItemStore(ItemStoreModel store) {
        store.setOrderqtyup(store.getOrderqtyup().negate());
    }

    public static DynamicObject saveVersion(DynamicObject oldData) {
        DynamicObject orderVersion = BusinessDataServiceHelper.newDynamicObject((String)"mdr_saleorder_version");
        SaleOrderUtil.createDatas(orderVersion, oldData);
        SaveServiceHelper.save((IDataEntityType)orderVersion.getDataEntityType(), (Object[])new Object[]{orderVersion});
        return orderVersion;
    }

    public static DynamicObject saveNewVersion(DynamicObject oldData) {
        DynamicObject orderVersion = BusinessDataServiceHelper.newDynamicObject((String)"bbc_saleorder_version");
        SaleOrderUtil.createDatas(orderVersion, oldData);
        SaveServiceHelper.save((IDataEntityType)orderVersion.getDataEntityType(), (Object[])new Object[]{orderVersion});
        return orderVersion;
    }

    private static void createDatas(DynamicObject orderVersion, final DynamicObject oldData) {
        DynamicObjectUtils.copyProperties(orderVersion, oldData, new DynamicObjectCopyStrategy(){

            @Override
            public Object copyWhat(String key) {
                if (oldData.getDynamicObjectType().getName().equalsIgnoreCase("dpa_purorder")) {
                    switch (key) {
                        case "signstatus": {
                            return Boolean.FALSE;
                        }
                    }
                }
                switch (key) {
                    case "id": 
                    case "itementry": 
                    case "recordtime": 
                    case "saleorderid": 
                    case "recorduser": 
                    case "recorduser_id": {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }
        });
        orderVersion.set("recordtime", (Object)new Date());
        orderVersion.set("recorduser", UserUtil.getUserID());
        orderVersion.set("saleorderid", oldData.get("id"));
        SaleOrderUtil.createEntrys(orderVersion, oldData);
    }

    private static void createEntrys(DynamicObject orderVersion, DynamicObject oldData) {
        DynamicObjectCollection itemEntry = orderVersion.getDynamicObjectCollection("itementry");
        DynamicObjectCollection oldEntrys = oldData.getDynamicObjectCollection("itementry");
        DynamicObjectType entryType = itemEntry.getDynamicObjectType();
        DynamicObject entry = null;
        int len = oldEntrys.size();
        for (int i = 0; i < len; ++i) {
            entry = new DynamicObject(entryType);
            DynamicObjectUtils.copyPropertiesWithOutId(entry, (DynamicObject)oldEntrys.get(i));
            itemEntry.add((Object)entry);
        }
    }

    public static boolean isMoneyDebt(DynamicObject order) {
        boolean isDebt = false;
        String ordernumberStr = "";
        if (order == null || order.getPkValue() == null) {
            return isDebt;
        }
        ordernumberStr = order.getPkValue().toString();
        QFilter filter = new QFilter("ordernumber", "=", (Object)ordernumberStr);
        QFilter[] qfilter = new QFilter[]{filter};
        DynamicObject debtInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_money_debt", (String)"id,ordernumber", (QFilter[])qfilter);
        if (debtInfo != null) {
            isDebt = true;
        }
        return isDebt;
    }

    public static QFilter getSaleOrderSalerFilter(Object ownerId) {
        QFilter f = new QFilter("owner", "=", ownerId);
        if (UserUtil.isSaler(ownerId)) {
            Object userId = UserUtil.getUserID();
            if (SysParamsUtil.isOrdershieldbysaler()) {
                f.and("saler", "=", userId);
            } else {
                Set<Object> customers = CustomerSalerUtil.queryCustomerPKBySaler(ownerId, userId);
                if (!customers.isEmpty()) {
                    f.and("customer", "in", customers);
                }
            }
        } else {
            Set<Object> regionIds = UserUtil.queryUserRegionsWithAllSubs(ownerId);
            if (!regionIds.isEmpty()) {
                f.and("region", "in", regionIds);
            }
        }
        return f;
    }

    public static QFilter getSaleOrderSalerFilter(List<Object> ownerIds) {
        Object userid = UserUtil.getUserID();
        Map<Object, DynamicObject> queryuserInfos = UserUtil.queryUserInfo(ownerIds);
        HashMap<Object, Boolean> salerInfo = new HashMap<Object, Boolean>(queryuserInfos.size());
        for (DynamicObject queryuserinfo : queryuserInfos.values()) {
            salerInfo.put(queryuserinfo.get("owner.id"), queryuserinfo.getBoolean("issaler"));
        }
        Map<Object, Set<Object>> queryCustomerInfos = CustomerSalerUtil.queryCustomerPKBySaler(ownerIds, userid);
        return SaleOrderUtil.getRetFilter(ownerIds, userid, salerInfo, queryCustomerInfos);
    }

    public static QFilter getSaleOrderSalerFilter(List<Object> ownerIds, boolean ignoreEnable) {
        Object userid = UserUtil.getUserID();
        Map<Object, DynamicObject> queryuserInfos = UserUtil.queryUserInfo(ownerIds);
        HashMap<Object, Boolean> salerInfo = new HashMap<Object, Boolean>(queryuserInfos.size());
        for (DynamicObject queryuserinfo : queryuserInfos.values()) {
            salerInfo.put(queryuserinfo.get("owner.id"), queryuserinfo.getBoolean("issaler"));
        }
        Map<Object, Set<Object>> queryCustomerInfos = ignoreEnable ? CustomerSalerUtil.queryCustomerPKBySaler(ownerIds, userid, true) : CustomerSalerUtil.queryCustomerPKBySaler(ownerIds, userid);
        return SaleOrderUtil.getRetFilter(ownerIds, userid, salerInfo, queryCustomerInfos);
    }

    private static QFilter getRetFilter(List<Object> ownerIds, Object userid, Map<Object, Boolean> salerInfo, Map<Object, Set<Object>> queryCustomerInfos) {
        QFilter retFilter = null;
        HashSet<Object> set = new HashSet<Object>();
        QFilter tempFilter = null;
        for (Object ownerId : ownerIds) {
            tempFilter = null;
            if (salerInfo.get(ownerId).booleanValue()) {
                if (SysParamsUtil.isOrdershieldbysaler()) {
                    tempFilter = new QFilter("saler", "=", userid);
                } else {
                    Set<Object> orderCustomers = queryCustomerInfos.get(ownerId);
                    if (orderCustomers != null) {
                        tempFilter = new QFilter("customer", "in", orderCustomers);
                    }
                }
            }
            if (tempFilter == null) {
                set.add(ownerId);
            } else {
                tempFilter.and(new QFilter("owner", "=", ownerId));
            }
            if (retFilter == null) {
                retFilter = tempFilter;
                continue;
            }
            retFilter.or(tempFilter);
        }
        if (!set.isEmpty()) {
            if (retFilter == null) {
                retFilter = new QFilter("owner", "in", set);
            } else {
                retFilter.or("owner", "in", set);
            }
        }
        return retFilter;
    }

    public static void handleRebate4EndAudit(DynamicObject[] orders) {
        SaleOrderUtil.handleRebate4Op(orders, "handleAccount4OrderAudit");
    }

    public static void handleRebate4EndUnAudit(DynamicObject[] orders) {
        SaleOrderUtil.handleRebate4Op(orders, "handleAccount4OrderUnAudit");
    }

    public static void handleRebate4EndUnSubmit(DynamicObject[] orders) {
        SaleOrderUtil.handleRebate4Op(orders, "handleAccount4OrderUnSubmit");
    }

    public static void handleRebate4EndSubmit(DynamicObject[] orders) {
        JSONArray jsonOrders = new JSONArray();
        for (DynamicObject order : orders) {
            if (order.getBigDecimal("usedrebate").compareTo(BigDecimal.ZERO) <= 0) continue;
            jsonOrders.add(SaleOrderUtil.createJsonRebateInfo(order));
        }
        if (!jsonOrders.isEmpty()) {
            DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"handleAccount4OrderSubmit", (Object[])new Object[]{jsonOrders.toJSONString()});
        }
    }

    private static Object createJsonRebateInfo(DynamicObject order) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)order.get("id").toString());
        json.put("billno", (Object)order.getString("billno"));
        json.put("owner", order.getDynamicObject("owner").get("id"));
        json.put("customer", order.getDynamicObject("customer").get("id"));
        json.put("currency", order.getDynamicObject("currency").get("id"));
        json.put("rebateaccounttype", order.getDynamicObject("rebateaccounttype").get("id"));
        json.put("usedrebate", (Object)order.getBigDecimal("usedrebate"));
        return json;
    }

    private static void handleRebate4Op(DynamicObject[] orders, String methodName) {
        JSONArray ids = SaleOrderUtil.getUsedRebateOrderIdsStr(orders);
        if (ids.isEmpty()) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)methodName, (Object[])new Object[]{ids.toString()});
    }

    private static JSONArray getUsedRebateOrderIdsStr(DynamicObject[] orders) {
        JSONArray ids = new JSONArray();
        if (orders.length == 0) {
            return ids;
        }
        for (DynamicObject order : orders) {
            if (order.getBigDecimal("usedrebate").compareTo(BigDecimal.ZERO) <= 0) continue;
            ids.add((Object)order.get("id").toString());
        }
        return ids;
    }

    public static void handleAfterUnAudit(DynamicObject[] datas) {
        for (int i = 0; i < datas.length; ++i) {
            SaleOrderUtil.recordItemInfo(datas[i]);
            PromotionServiceHelper.rollbackLimit(datas[i].getPkValue(), false);
        }
    }

    private static void recordItemInfo(DynamicObject order) {
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : itementry) {
            Object entrytype = entry.get("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            BigDecimal baseqty = (BigDecimal)entry.get("baseqty");
            BigDecimal assistqty = (BigDecimal)entry.get("assistqty");
            if (baseqty == null) {
                baseqty = BigDecimal.ZERO;
            }
            if (assistqty == null) {
                assistqty = BigDecimal.ZERO;
            }
            DynamicObject item = (DynamicObject)entry.get("item");
            Object itemId = item.get("id");
            DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"id,isassistorder,assistsaleqty,saleqty,updatetime");
            BigDecimal saleqty = BigDecimal.ZERO;
            if (itemInfo.get("saleqty") != null) {
                saleqty = (BigDecimal)itemInfo.get("saleqty");
            }
            itemInfo.set("saleqty", (Object)saleqty.subtract(baseqty));
            BigDecimal assistsaleqty = BigDecimal.ZERO;
            if (itemInfo.get("assistsaleqty") != null) {
                assistsaleqty = itemInfo.getBigDecimal("assistsaleqty");
            }
            itemInfo.set("assistsaleqty", (Object)assistsaleqty.subtract(assistqty));
            itemInfo.set("updatetime", (Object)new Date());
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemInfo});
                }
                catch (Throwable error) {
                    h.markRollback();
                    throw error;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    static {
        FIELDSNEEDEDCOMPARE4HEAD.add("isusebalance");
        FIELDSNEEDEDCOMPARE4HEAD.add("usedbalance");
        FIELDSNEEDEDCOMPARE4ENTRY = new ArrayList<String>();
    }
}

