/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.common.util.UserUtil;

public class SynDispatchOrderUtil {
    public static SynResult SynSaleOrder(Object orderid) {
        QFilter qFilter;
        QFilter[] filters;
        DynamicObject creatoruserInfo;
        String directcustomereasnumber;
        DynamicObject directcustomer;
        DynamicObject biztype;
        if (orderid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u8ba2\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SynDispatchOrderUtil_10", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>(30);
        DynamicObject saleorderdata = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"mdr_dispatch_order");
        if (saleorderdata == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"SynDispatchOrderUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        data.put("saleorderid", orderid);
        data.put("ordertype", "dispatchorder");
        data.put("number", saleorderdata.getString("billno"));
        if (saleorderdata.getDynamicObject("biztype") != null && (biztype = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("biztype").getPkValue(), (String)"mdr_biztype")) != null) {
            String biztypeNumber = biztype.getString("easnumber");
            data.put("biztype", biztypeNumber);
        }
        if (saleorderdata.get("orderstatus").equals(DispatchOrderStatus.PENDING_DELIVERY.getFlagStr())) {
            data.put("orderstatus", 4);
        }
        data.put("amount", saleorderdata.getBigDecimal("totalitemamount"));
        data.put("remark", saleorderdata.getString("orderremark"));
        if (saleorderdata.getDynamicObject("transporttype") != null && (directcustomer = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("transporttype").getPkValue(), (String)"mdr_distribut_mode")) != null) {
            directcustomereasnumber = directcustomer.getString("easnumber");
            data.put("deliveryType", directcustomereasnumber);
        }
        if (saleorderdata.getDynamicObject("directcustomer") != null && (directcustomer = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("directcustomer").getPkValue(), (String)"mdr_customer")) != null) {
            directcustomereasnumber = directcustomer.getString("easnumber");
            data.put("directdeliverycustomernumber", directcustomereasnumber);
        }
        if (saleorderdata.getDynamicObject("saler") != null) {
            DynamicObject userInfo = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("saler").getPkValue(), (String)"bos_user");
            if (userInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6838\u5b9e\u4fe1\u606f\u3002", (String)"SynDispatchOrderUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            String salePersontelphone = userInfo.getString("phone");
            data.put("salertel", salePersontelphone);
        }
        if (saleorderdata.getDynamicObject("customer") != null) {
            DynamicObject customerdata = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("customer").getPkValue(), (String)"mdr_customer");
            if (customerdata == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5ba2\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6838\u5b9e\u4fe1\u606f\u3002", (String)"SynDispatchOrderUtil_13", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            if (customerdata.getString("easnumber").isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728eas\u5ba2\u6237\u7f16\u7801\uff0ceas\u5ba2\u6237\u7f16\u7801\u8981\u540c\u6b65\u7ebf\u4e0b\u5ba2\u6237\u7684\u7f16\u7801\u3002", (String)"SynDispatchOrderUtil_14", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            String ordercustomernumber = customerdata.getString("easnumber");
            data.put("ordercustomername", saleorderdata.getDynamicObject("customer").get("name"));
            data.put("ordercustomernumber", ordercustomernumber);
            data.put("customernumber", ordercustomernumber);
        }
        if (saleorderdata.getDynamicObject("owner") != null) {
            DynamicObject owner = BusinessDataServiceHelper.loadSingle((Object)saleorderdata.getDynamicObject("owner").getPkValue(), (String)"mdr_customer");
            if (owner == null || owner.getString("easnumber").isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u65f6\u6e20\u9053\u4fe1\u606f\u7684eas\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u540e\u518d\u540c\u6b65\u3002", (String)"SynDispatchOrderUtil_15", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            data.put("companyNumber", owner.getString("easnumber"));
        }
        if (saleorderdata.getDynamicObject("creator") != null && (creatoruserInfo = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"name,phone", (QFilter[])(filters = new QFilter[]{qFilter = new QFilter("id", "=", saleorderdata.getDynamicObject("creator").getPkValue())}))) != null) {
            data.put("contactname", creatoruserInfo.getString("name"));
            data.put("contactphone", creatoruserInfo.getString("phone"));
        }
        data.put("charteredFreight", saleorderdata.getBigDecimal("transportamount"));
        data.put("tonFreight", saleorderdata.getBigDecimal("transportprice"));
        data.put("bizdate", saleorderdata.getString("createtime"));
        data.put("confirmarrivedate", saleorderdata.getString("confirmarrivaldate"));
        data.put("billingtype", saleorderdata.getString("billingtype"));
        data.put("carno", saleorderdata.getString("carno"));
        data.put("drivertel", saleorderdata.getString("drivertel"));
        data.put("passtype", saleorderdata.getString("passtype"));
        String receivablecompanyName = "";
        if (saleorderdata.getDynamicObject("receivablecompany") != null) {
            receivablecompanyName = saleorderdata.getDynamicObject("receivablecompany").getString("name");
        }
        data.put("receivablecompany", receivablecompanyName);
        ArrayList listMaps = new ArrayList();
        DynamicObjectCollection saleorderentrys = saleorderdata.getDynamicObjectCollection("itementry");
        if (saleorderentrys == null || saleorderentrys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u5546\u54c1\u3002", (String)"SynDispatchOrderUtil_16", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        data.put("customerordernum", ((DynamicObject)saleorderentrys.get(0)).getString("sourcebillno"));
        int totalQty = 0;
        for (DynamicObject saleorderentry : saleorderentrys) {
            DynamicObject itemattrvalue;
            DynamicObject itemInfo;
            HashMap<String, Object> entrydata = new HashMap<String, Object>(25);
            entrydata.put("saleorderentryid", saleorderentry.getString("id"));
            entrydata.put("unit", saleorderentry.getDynamicObject("unit").get("name"));
            entrydata.put("orderunit", saleorderentry.getDynamicObject("unit").get("name"));
            entrydata.put("qty", saleorderentry.get("qty"));
            entrydata.put("price", saleorderentry.getBigDecimal("price"));
            entrydata.put("referenceprice", saleorderentry.getBigDecimal("itemprice"));
            entrydata.put("remark", saleorderentry.getString("entryremark"));
            entrydata.put("amount", saleorderentry.getBigDecimal("orderamount"));
            entrydata.put("arrivaldate", saleorderentry.getString("entryarrivaldate"));
            entrydata.put("confirmarrivaldate", saleorderentry.getString("entryconfirmarrivaldate"));
            entrydata.put("consignee", saleorderentry.getString("entryconsignee"));
            entrydata.put("consigneephone", saleorderentry.getString("entryconsigneephone"));
            entrydata.put("productqty", saleorderentry.get("orderneednum"));
            entrydata.put("consigneeaddress", saleorderentry.getString("entryconsignee") + "\uff0c" + saleorderentry.getString("entryconsigneephone") + "," + saleorderentry.getString("entryaddress"));
            totalQty += saleorderentry.getInt("qty");
            if (saleorderentry.getDynamicObject("entrywarehouse") != null) {
                DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)saleorderentry.getDynamicObject("entrywarehouse").getPkValue(), (String)"mdr_warehouse");
                if (warehouse != null) {
                    entrydata.put("warehousenumber", warehouse.get("number"));
                }
            } else {
                entrydata.put("warehousenumber", null);
            }
            if (saleorderentry.getDynamicObject("item") != null && (itemInfo = BusinessDataServiceHelper.loadSingle((Object)saleorderentry.getDynamicObject("item").getPkValue(), (String)"mdr_item_info")) != null) {
                entrydata.put("itemmodel", itemInfo.getString("modelnum"));
                entrydata.put("itemnumber", itemInfo.getString("easnum"));
                entrydata.put("itemremark", itemInfo.getString("remark"));
                entrydata.put("referenceprice", itemInfo.getString("referenceprice"));
            }
            if ((itemattrvalue = saleorderentry.getDynamicObject("assistattr")) != null) {
                itemattrvalue = QueryServiceHelper.queryOne((String)"mdr_item_attrvalue", (String)"easnumber", (QFilter[])new QFilter("id", "=", itemattrvalue.getPkValue()).toArray());
                entrydata.put("propertynumber", itemattrvalue.getString("easnumber"));
            }
            listMaps.add(entrydata);
        }
        data.put("entry", listMaps);
        data.put("totalQty", totalQty);
        return SynDispatchOrderUtil.synMessageSendOut(data, orderid);
    }

    public static SynResult CancelSynOrder(Object orderid) {
        if (orderid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u8ba2\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SynDispatchOrderUtil_10", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        DynamicObject saleorderdata = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"mdr_dispatch_order");
        if (saleorderdata == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"SynDispatchOrderUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        data.put("saleorderid", orderid);
        return SynDispatchOrderUtil.cancelMessageSendOut(data, orderid);
    }

    public static SynResult synMessageSendOut(Map<String, Object> data, Object orderid) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete(MsgTypeEnum.WDH_SALEORDER_CREATE, data, null, RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4\u3002", (String)"SynDispatchOrderUtil_17", (String)"drp-mdr-common", (Object[])new Object[0]);
                }
                SynDispatchOrderUtil.synSalerOrderRecord(orderid, errorMessage);
                issyn = false;
                synresult.setMsg(errorMessage);
            } else {
                SynDispatchOrderUtil.setSynStatus(orderid, DispatchOrderSyncStatus.ALREADY_SYNC);
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static SynResult cancelMessageSendOut(Map<String, Object> data, Object orderid) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete(MsgTypeEnum.WDH_SALEORDER_DELETE, data, null, RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4\u3002", (String)"SynDispatchOrderUtil_17", (String)"drp-mdr-common", (Object[])new Object[0]);
                }
                SynDispatchOrderUtil.synSalerOrderRecord(orderid, String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"SynDispatchOrderUtil_18", (String)"drp-mdr-common", (Object[])new Object[0]), errorMessage));
                issyn = false;
                synresult.setMsg(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"SynDispatchOrderUtil_18", (String)"drp-mdr-common", (Object[])new Object[0]), errorMessage));
            } else {
                SynDispatchOrderUtil.setSynStatus(orderid, DispatchOrderSyncStatus.NOT_SYNC);
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static void synSalerOrderRecord(Object orderid, String errorMessage) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"mdr_synsaleorder_record");
        DynamicObject record = new DynamicObject((DynamicObjectType)entityType);
        QFilter qFilter = new QFilter("saleorder", "=", orderid);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject synsaleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_synsaleorder_record", (String)"id,saleorder,synctime,createdate,exceptioninfo", (QFilter[])filters);
        if (synsaleorderInfo != null) {
            Integer synctime = synsaleorderInfo.getInt("synctime") + 1;
            synsaleorderInfo.set("synctime", (Object)synctime);
            synsaleorderInfo.set("createdate", (Object)new Date());
            synsaleorderInfo.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)synsaleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{synsaleorderInfo});
        } else {
            record.set("saleorder", orderid);
            record.set("synctime", (Object)1);
            record.set("createdate", (Object)new Date());
            record.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)record.getDataEntityType(), (Object[])new DynamicObject[]{record});
        }
    }

    public static void setSynStatus(Object orderid, DispatchOrderSyncStatus status) {
        DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"mdr_dispatch_order");
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)UserUtil.getUserID(), (String)"bos_user");
        if (saleorderInfo != null) {
            saleorderInfo.set("sync", (Object)status.getFlagStr());
            if (DispatchOrderSyncStatus.ALREADY_SYNC == status) {
                saleorderInfo.set("syncuser", (Object)user);
                saleorderInfo.set("synctime", (Object)new Date());
            } else if (DispatchOrderSyncStatus.NOT_SYNC == status) {
                saleorderInfo.set("syncuser", (Object)0L);
                saleorderInfo.set("synctime", null);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u8ba2\u5355\u540c\u6b65\u72b6\u6001\u5931\u8d25\u3002", (String)"SynDispatchOrderUtil_19", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((IDataEntityType)saleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{saleorderInfo});
    }
}

