/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.SaleorderExtFieldParams;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIInvokeService;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.status.JDOrderStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.ISalerorderSyncExtend;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SynSaleOrderUtil {
    public static SynResult SynSaleOrderToJD(DynamicObject saleorderdata) {
        SynResult synresult = new SynResult();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bbc_saleorder");
        if (SysParamsUtil.isUseJDStore() && entityType.getAllFields().containsKey("isneedsynctojd") && saleorderdata.getBoolean("isneedsynctojd") && (StringUtils.isEmpty(saleorderdata.getString("outsidelogisticsno")) || "0".equals(saleorderdata.getString("outsidelogisticsno")))) {
            Dto resultFromJD = JDStoreAPIInvokeService.sendOrderToJDStore(saleorderdata);
            if (!resultFromJD.getSuccess().booleanValue()) {
                synresult.setSuccess(false);
                synresult.setMsg(resultFromJD.getErrorMessage());
                return synresult;
            }
            saleorderdata.set("outsidelogisticsno", (Object)resultFromJD.getAsString("eclpSoNo"));
            saleorderdata.set("jdorderstatus", (Object)JDOrderStatus.PUSHED.getFlagStr());
            SaveServiceHelper.save((IDataEntityType)saleorderdata.getDataEntityType(), (Object[])new DynamicObject[]{saleorderdata});
            synresult.setSuccess(true);
            return synresult;
        }
        return null;
    }

    public static SynResult SynSaleOrder(Object orderid) {
        if (orderid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u8ba2\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SynSaleOrderUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        DynamicObject saleorderdata = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"bbc_saleorder");
        if (SysParamsUtil.isUseJDStore() && StringUtils.isEmpty(saleorderdata.getString("outsidelogisticsno"))) {
            Dto resultFromJD = JDStoreAPIInvokeService.sendOrderToJDStore(saleorderdata);
            if (!resultFromJD.getSuccess().booleanValue()) {
                SynResult res = new SynResult();
                res.setSuccess(false);
                res.setMsg(resultFromJD.getErrorMessage());
                return res;
            }
            saleorderdata.set("outsidelogisticsno", (Object)resultFromJD.getAsString("eclpSoNo"));
            saleorderdata.set("jdorderstatus", (Object)JDOrderStatus.PUSHED.getFlagStr());
            SaveServiceHelper.save((IDataEntityType)saleorderdata.getDataEntityType(), (Object[])new DynamicObject[]{saleorderdata});
        }
        return SynSaleOrderUtil.SynSaleOrder(saleorderdata);
    }

    public static SynResult SynSaleOrder(DynamicObject saleorderdata) {
        DynamicObject saler;
        DynamicObject directcustomer;
        IDataEntityProperty cterms1DataEntityProperty;
        IDataEntityProperty settlementtype1DataEntityProperty;
        IDataEntityProperty department1DataEntityProperty;
        IDataEntityProperty transportprice1DataEntityProperty;
        IDataEntityProperty carryfee1DataEntityProperty;
        IDataEntityProperty deliveryaddress1DataEntityProperty;
        IDataEntityProperty jhfsDataEntityProperty;
        IDataEntityProperty yfcdfDataEntityProperty;
        IDataEntityProperty pzfsDataEntityProperty;
        DynamicObject dpt;
        DynamicObject biztype;
        if (saleorderdata == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"SynSaleOrderUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>(50);
        data.put("sendAddress", saleorderdata.getString("address"));
        data.put("customerPhone", saleorderdata.getString("consigneephone"));
        data.put("saleorderid", saleorderdata.get("id"));
        data.put("ordertype", "saleorder");
        data.put("number", saleorderdata.getString("billno"));
        data.put("customerordernum", saleorderdata.getString("billno"));
        data.put("bizdate", saleorderdata.getString("createtime"));
        if (saleorderdata.get("orderstatus").equals(SaleOrderStatus.PENDING_DELIVERY.getFlagStr())) {
            data.put("orderstatus", 4);
        }
        if (SysParamsUtil.isUseJDStore() && !StringUtils.isEmpty(saleorderdata.getString("outsidelogisticsno"))) {
            data.put("outsidelogisticsno", saleorderdata.getString("outsidelogisticsno"));
        }
        if ((biztype = saleorderdata.getDynamicObject("biztype")) != null) {
            String biztypeNumber = biztype.getString("number");
            data.put("biztype", biztypeNumber);
        }
        data.put("department", (dpt = saleorderdata.getDynamicObject("department")) == null ? "" : dpt.getLocaleString("name").getLocaleValue());
        DynamicObject consigneeaddress = saleorderdata.getDynamicObject("consigneeaddress");
        if (consigneeaddress != null) {
            data.put("address2", consigneeaddress.get("address2"));
        }
        data.put("consignee", saleorderdata.get("consignee"));
        data.put("consigneephone", saleorderdata.getString("consigneephone"));
        data.put("consigneepddress", saleorderdata.getString("address"));
        data.put("sendAddress", saleorderdata.get("consignee") + "\uff0c" + saleorderdata.getString("consigneephone") + "\uff0c" + saleorderdata.getString("address"));
        data.put("amount", saleorderdata.getBigDecimal("totalorderamount").toString());
        data.put("askarrivedate", saleorderdata.getString("arrivaldate"));
        data.put("confirmarrivedate", saleorderdata.getString("confirmarrivaldate"));
        data.put("remark", saleorderdata.getString("orderremark"));
        DynamicObject transporttype = saleorderdata.getDynamicObject("transporttype");
        if (transporttype != null) {
            String transporttypeNumber = transporttype.getString("easnumber");
            data.put("deliveryType", transporttypeNumber);
        }
        if ((pzfsDataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"pzfs")) != null) {
            String pzfs = saleorderdata.getString("pzfs");
            data.put("pzfs", pzfs);
        }
        if ((yfcdfDataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"yfcdf")) != null) {
            String yfcdf = saleorderdata.getString("yfcdf");
            data.put("yfcdf", yfcdf);
        }
        if ((jhfsDataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"jhfs")) != null) {
            String jhfs = saleorderdata.getString("jhfs");
            data.put("jhfs", jhfs);
        }
        if ((deliveryaddress1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"deliveryaddress1")) != null) {
            String deliveryaddress1 = saleorderdata.getString("deliveryaddress1");
            data.put("deliveryaddress1", deliveryaddress1);
        }
        if ((carryfee1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"carryfee1")) != null) {
            BigDecimal carryfee1 = saleorderdata.getBigDecimal("carryfee1");
            data.put("carryfee1", carryfee1.toString());
        }
        if ((transportprice1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"transportprice1")) != null) {
            BigDecimal transportprice1 = saleorderdata.getBigDecimal("transportprice1");
            data.put("transportprice1", transportprice1.toString());
        }
        if ((department1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"department1")) != null) {
            DynamicObject department = saleorderdata.getDynamicObject("department1");
            data.put("adminorg", department == null ? "" : department.getString("number"));
        }
        if ((settlementtype1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"settlementtype1")) != null) {
            DynamicObject settlementtype = saleorderdata.getDynamicObject("settlementtype1");
            data.put("settlementtype", settlementtype == null ? "" : settlementtype.getString("number"));
        }
        if ((cterms1DataEntityProperty = (IDataEntityProperty)saleorderdata.getDataEntityType().getProperties().get((Object)"cterms1")) != null) {
            String cterms1 = saleorderdata.getString("cterms1");
            data.put("paycondition", cterms1);
        }
        if ((directcustomer = saleorderdata.getDynamicObject("directcustomer")) != null) {
            String directcustomereasnumber = directcustomer.getString("easnumber");
            data.put("directdeliverycustomernumber", directcustomereasnumber);
        }
        if ((saler = saleorderdata.getDynamicObject("saler")) != null) {
            String salePersontelphone = saler.getString("phone");
            data.put("salertel", salePersontelphone);
        }
        DynamicObject customer = saleorderdata.getDynamicObject("customer");
        if ((customer = BusinessDataServiceHelper.loadSingle((Object)customer.getPkValue(), (String)"mdr_customer")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5ba2\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6838\u5b9e\u4fe1\u606f\u3002", (String)"SynSaleOrderUtil_13", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (customer.getString("easnumber").isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728eas\u5ba2\u6237\u7f16\u7801\uff0ceas\u5ba2\u6237\u7f16\u7801\u8981\u540c\u6b65\u7ebf\u4e0b\u5ba2\u6237\u7684\u7f16\u7801\u3002", (String)"SynSaleOrderUtil_14", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        String ordercustomernumber = customer.getString("easnumber");
        data.put("ordercustomername", customer.getLocaleString("name").getLocaleValue());
        data.put("ordercustomernumber", ordercustomernumber);
        data.put("customernumber", ordercustomernumber);
        DynamicObject owner = saleorderdata.getDynamicObject("owner");
        owner = BusinessDataServiceHelper.loadSingle((Object)owner.getPkValue(), (String)"mdr_customer");
        if (owner == null || owner.getString("easnumber").isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u65f6\u6e20\u9053\u4fe1\u606f\u7684eas\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u540e\u518d\u540c\u6b65\u3002", (String)"SynSaleOrderUtil_15", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        data.put("companyNumber", owner.getString("easnumber"));
        DynamicObject creator = saleorderdata.getDynamicObject("creator");
        if (creator != null) {
            data.put("contactname", creator.getLocaleString("name").getLocaleValue());
            data.put("contactphone", creator.getString("phone"));
        }
        data.put("charteredFreight", saleorderdata.getBigDecimal("transportamount").toString());
        data.put("tonFreight", saleorderdata.getBigDecimal("transportprice").toString());
        ArrayList listMaps = new ArrayList();
        DynamicObjectCollection saleorderentrys = saleorderdata.getDynamicObjectCollection("itementry");
        if (saleorderentrys == null || saleorderentrys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u5546\u54c1\u3002", (String)"SynSaleOrderUtil_16", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        int totalQty = 0;
        for (DynamicObject saleorderentry : saleorderentrys) {
            DynamicObject itemattrvalue;
            String entrytype = saleorderentry.getString("entrytype");
            if (saleorderentry.getString("entryclosestatus").compareTo("0") == 0 || SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            HashMap<String, Object> entrydata = new HashMap<String, Object>(30);
            entrydata.put("saleorderentryid", saleorderentry.getString("id"));
            entrydata.put("unit", saleorderentry.getDynamicObject("unit").getLocaleString("name").getLocaleValue());
            entrydata.put("orderunit", saleorderentry.getDynamicObject("unit").getLocaleString("name").getLocaleValue());
            entrydata.put("qty", saleorderentry.getBigDecimal("qty").toString());
            entrydata.put("price", saleorderentry.getBigDecimal("price").toString());
            entrydata.put("remark", saleorderentry.getString("entryremark"));
            entrydata.put("amount", saleorderentry.getBigDecimal("taxamount").toString());
            entrydata.put("taxrate", saleorderentry.getBigDecimal("taxrate").toString());
            entrydata.put("discounttype", saleorderentry.getString("discounttype"));
            entrydata.put("discount", saleorderentry.getBigDecimal("discount").toString());
            entrydata.put("consignee", saleorderentry.getString("entryconsignee"));
            entrydata.put("consigneephone", saleorderentry.getString("entryconsigneephone"));
            entrydata.put("arrivaldate", saleorderentry.getString("entryarrivaldate"));
            entrydata.put("confirmarrivaldate", saleorderentry.getString("entryconfirmarrivaldate"));
            entrydata.put("productqty", saleorderentry.get("orderneednum"));
            entrydata.put("combbaseqty", saleorderentry.get("combbaseqty"));
            entrydata.put("parententryid", saleorderentry.get("parententryid"));
            entrydata.put("consigneeaddress", saleorderentry.getString("entryconsignee") + "\uff0c" + saleorderentry.getString("entryconsigneephone") + "," + saleorderentry.getString("entryaddress"));
            totalQty += saleorderentry.getInt("qty");
            DynamicObject entrywarehouse = saleorderentry.getDynamicObject("entrywarehouse");
            if (entrywarehouse != null) {
                entrydata.put("warehousenumber", entrywarehouse.get("number"));
            } else {
                entrydata.put("warehousenumber", null);
            }
            DynamicObject itemInfo = saleorderentry.getDynamicObject("item");
            if (itemInfo != null) {
                entrydata.put("itemmodel", itemInfo.getString("modelnum"));
                entrydata.put("itemnumber", itemInfo.getString("easnum"));
                entrydata.put("itemremark", itemInfo.getString("remark"));
                entrydata.put("referenceprice", itemInfo.getString("referenceprice"));
            }
            if ((itemattrvalue = saleorderentry.getDynamicObject("assistattr")) != null) {
                itemattrvalue = QueryServiceHelper.queryOne((String)"mdr_item_attrvalue", (String)"easnumber", (QFilter[])new QFilter("id", "=", itemattrvalue.getPkValue()).toArray());
                entrydata.put("propertynumber", itemattrvalue.getString("easnumber"));
            }
            entrydata.put("sourcebillentryid", saleorderentry.getString("sourcebillentryid"));
            entrydata.put("sourcebillid", saleorderentry.getString("sourcebillid"));
            IDataEntityProperty presenttypeEntityProperty = (IDataEntityProperty)saleorderentry.getDataEntityType().getProperties().get((Object)"presenttype");
            if (presenttypeEntityProperty != null) {
                DynamicObject presenttype = saleorderentry.getDynamicObject("presenttype");
                entrydata.put("presenttype", presenttype == null ? "" : presenttype.getString("number"));
            }
            entrydata.put("ispresent", saleorderentry.getBoolean("ispresent"));
            listMaps.add(entrydata);
        }
        data.put("entry", listMaps);
        data.put("totalQty", totalQty);
        SynSaleOrderUtil.fieldsExtend(data, saleorderdata);
        return SynSaleOrderUtil.synMessageSendOut(data, saleorderdata.get("id"));
    }

    public static SynResult CancelSynOrder(Object orderid) {
        if (orderid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u8ba2\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SynSaleOrderUtil_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean exists = QueryServiceHelper.exists((String)"bbc_saleorder", (Object)orderid);
        if (!exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"SynSaleOrderUtil_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        data.put("saleorderid", orderid);
        List<Character> easBillStatus = SysParamsUtil.getEasBillStatus();
        data.put("easbillstatus", easBillStatus);
        return SynSaleOrderUtil.cancelMessageSendOut(data, orderid);
    }

    public static SynResult synMessageSendOut(Map<String, Object> data, Object orderid) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete(MsgTypeEnum.WDH_SALEORDER_CREATE, data, null, RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4\u3002", (String)"SynSaleOrderUtil_17", (String)"drp-mdr-common", (Object[])new Object[0]);
                }
                SynSaleOrderUtil.synSalerOrderRecord(orderid, errorMessage);
                issyn = false;
                synresult.setMsg(errorMessage);
            } else {
                SynSaleOrderUtil.setSynStatus(orderid, SaleOrderSyncStatus.ALREADY_SYNC, result == null ? " " : result.getData());
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static SynResult cancelMessageSendOut(Map<String, Object> data, Object orderid) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete(MsgTypeEnum.WDH_SALEORDER_DELETE, data, null, RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4\u3002", (String)"SynSaleOrderUtil_17", (String)"drp-mdr-common", (Object[])new Object[0]);
                }
                SynSaleOrderUtil.synSalerOrderRecord(orderid, String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"SynSaleOrderUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]), errorMessage));
                issyn = false;
                synresult.setMsg(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"SynSaleOrderUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]), errorMessage));
            } else {
                SynSaleOrderUtil.setSynStatus(orderid, SaleOrderSyncStatus.NOT_SYNC, " ");
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static void synSalerOrderRecord(Object orderid, String errorMessage) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"mdr_synsaleorder_record");
        DynamicObject record = new DynamicObject((DynamicObjectType)entityType);
        QFilter qFilter = new QFilter("saleorder", "=", orderid);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject synsaleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_synsaleorder_record", (String)"id,saleorder,synctime,createdate,exceptioninfo", (QFilter[])filters);
        if (synsaleorderInfo != null) {
            Integer synctime = synsaleorderInfo.getInt("synctime") + 1;
            synsaleorderInfo.set("synctime", (Object)synctime);
            synsaleorderInfo.set("createdate", (Object)new Date());
            synsaleorderInfo.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)synsaleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{synsaleorderInfo});
        } else {
            record.set("saleorder", orderid);
            record.set("synctime", (Object)1);
            record.set("createdate", (Object)new Date());
            record.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)record.getDataEntityType(), (Object[])new DynamicObject[]{record});
        }
    }

    public static void setSynStatus(Object orderid, SaleOrderSyncStatus status, String ... params) {
        DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"bbc_saleorder");
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)UserUtil.getUserID(), (String)"bos_user", (String)"id");
        if (saleorderInfo != null) {
            saleorderInfo.set("sync", (Object)status.getFlagStr());
            if (params != null && params.length > 0) {
                saleorderInfo.set("eassaleorderno", (Object)params[0]);
            }
            if (SaleOrderSyncStatus.ALREADY_SYNC == status) {
                saleorderInfo.set("syncuser", (Object)user);
                saleorderInfo.set("synctime", (Object)new Date());
            } else if (SaleOrderSyncStatus.NOT_SYNC == status) {
                saleorderInfo.set("syncuser", (Object)0L);
                saleorderInfo.set("synctime", null);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u8ba2\u5355\u540c\u6b65\u72b6\u6001\u5931\u8d25\u3002", (String)"SynSaleOrderUtil_18", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((IDataEntityType)saleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{saleorderInfo});
    }

    private static void fieldsExtend(Map<String, Object> data, DynamicObject saleorderdata) {
        try {
            String paramType;
            String tenantCode = RequestContext.get().getTenantCode();
            String tenantId = RequestContext.get().getTenantId();
            ISalerorderSyncExtend syncExt = null;
            syncExt = "yonggao".equalsIgnoreCase(tenantCode) || "yonggao".equalsIgnoreCase(tenantId) ? (ISalerorderSyncExtend)Class.forName("kd.drp.dpa.opplugin.newsaleorder.SaleorderSyncExtendImpl").newInstance() : (ISalerorderSyncExtend)Class.forName("kd.drp.dpa.opplugin.newsaleorder.SaleorderSyncExtendImpl" + tenantId.toUpperCase()).newInstance();
            Map<String, SaleorderExtFieldParams> fields = syncExt.fieldsExtend();
            List todataEntrys = (List)data.get("entry");
            DynamicObjectCollection entrys = saleorderdata.getDynamicObjectCollection("itementry");
            HashMap<String, SaleorderExtFieldParams> bodyMap = new HashMap<String, SaleorderExtFieldParams>();
            HashMap<String, SaleorderExtFieldParams> entryMap = new HashMap<String, SaleorderExtFieldParams>();
            for (Map.Entry<String, SaleorderExtFieldParams> entry : fields.entrySet()) {
                boolean fromBody = entry.getValue().getIsFromBody();
                if (fromBody) {
                    bodyMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                entryMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, SaleorderExtFieldParams> entry : bodyMap.entrySet()) {
                String key = entry.getKey();
                paramType = entry.getValue().getFieldType();
                SynSaleOrderUtil.fieldAddTools(data, saleorderdata, key, paramType);
            }
            for (Map.Entry<String, SaleorderExtFieldParams> entry : entryMap.entrySet()) {
                String key = entry.getKey();
                paramType = entry.getValue().getFieldType();
                for (int i = 0; i < todataEntrys.size(); ++i) {
                    SynSaleOrderUtil.fieldAddTools((Map)todataEntrys.get(i), (DynamicObject)entrys.get(i), key, paramType);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fieldAddTools(Map<String, Object> toData, DynamicObject fromData, String key, String paramType) {
        if (null == fromData.get(key)) {
            return;
        }
        switch (paramType) {
            case "BASEDATA": {
                toData.put(key, fromData.getDynamicObject(key).getString("number"));
                break;
            }
            case "BigDecimal": {
                toData.put(key, fromData.getBigDecimal(key));
                break;
            }
            case "DATE": {
                toData.put(key, fromData.getDate(key));
                break;
            }
            case "String": {
                toData.put(key, fromData.getString(key));
                break;
            }
        }
    }
}

