/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.RegionUtil;
import kd.drp.mdr.common.util.UserRole;

public class UserUtil {
    private static final String PARTNER = "bos_bizpartneruser";

    public static Object getUserID() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static long getOrgId() {
        return RequestContext.get().getOrgId();
    }

    public static DynamicObject getUserInfo() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)UserUtil.getUserID(), (String)"bos_user");
    }

    public static List<Object> getAuthorizedCustomerIds() {
        return UserUtil.getAuthorizedCustomerIds(UserUtil.getUserID());
    }

    private static List<Object> getAuthorizedCustomerIds(Object userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT FORGID  ");
        sql.append("FROM T_PERM_USERROLE ");
        sql.append("WHERE (FDIMTYPE = 'mdr_customer' OR FDIMTYPE = 'DIM_CUSTOMER') AND FUSERID = ? ");
        sql.append("UNION ALL ");
        sql.append("SELECT DISTINCT FORGID ");
        sql.append("FROM T_PERM_USERPERM ");
        sql.append("WHERE (FDIMTYPE = 'mdr_customer' OR FDIMTYPE = 'DIM_CUSTOMER') AND FUSERID = ? ");
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql.toString(), (Object[])new Object[]{userId, userId}, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                HashSet<Long> results = new HashSet<Long>(rs.getFetchSize());
                while (rs.next()) {
                    results.add(rs.getLong("FORGID"));
                }
                return new ArrayList<Object>(results);
            }
        });
    }

    public static Set<Object> getAuthorizedOwnerIDs() {
        return UserUtil.getAuthorizedOwnerIDs(UserUtil.getUserID());
    }

    public static Set<Object> getAuthorizedOwnerIDs(Object userId) {
        List<Object> ownerIds = UserUtil.getOwnerIDs(userId);
        List<Object> authorizedIds = UserUtil.getAuthorizedCustomerIds(userId);
        HashSet<Object> ids = new HashSet<Object>();
        ids.addAll(ownerIds);
        ids.addAll(authorizedIds);
        return ids;
    }

    @Deprecated
    public static List<Object> getOwnerIDs() {
        return UserUtil.getOwnerIDs(UserUtil.getUserID());
    }

    @Deprecated
    public static List<Object> getOwnerIDs(Object userId) {
        QFilter fs = new QFilter("sysuser", "=", userId);
        fs.and("enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])fs.toArray());
        ArrayList<Object> owners = new ArrayList<Object>(userInfos.size());
        if (userInfos.isEmpty()) {
            return owners;
        }
        Object defaultId = null;
        Object id = null;
        DynamicObject owner = null;
        for (DynamicObject userInfo : userInfos.values()) {
            owner = userInfo.getDynamicObject("owner");
            if (owner == null) continue;
            id = owner.getPkValue();
            if (defaultId == null && userInfo.getBoolean("isdefault")) {
                defaultId = id;
                continue;
            }
            owners.add(id);
        }
        if (defaultId != null) {
            if (owners.isEmpty()) {
                owners.add(defaultId);
            } else {
                owners.add(0, defaultId);
            }
        }
        return owners;
    }

    public static List<DynamicObject> getOwners(Object userId) {
        QFilter fs = new QFilter("sysuser", "=", userId);
        fs.and("enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])fs.toArray());
        ArrayList<DynamicObject> owners = new ArrayList<DynamicObject>(userInfos.size());
        if (userInfos.isEmpty()) {
            return owners;
        }
        DynamicObject defaultowner = null;
        DynamicObject owner = null;
        for (DynamicObject userInfo : userInfos.values()) {
            owner = userInfo.getDynamicObject("owner");
            if (owner == null) continue;
            if (defaultowner == null && userInfo.getBoolean("isdefault")) {
                defaultowner = owner;
                continue;
            }
            owners.add(owner);
        }
        if (defaultowner != null) {
            if (owners.isEmpty()) {
                owners.add(defaultowner);
            } else {
                owners.add(0, defaultowner);
            }
        }
        return owners;
    }

    public static QFilter getAuthorizedCommonUserOwnersFilter() {
        return new QFilter("id", "in", UserUtil.getAuthorizedOwnerIDs());
    }

    @Deprecated
    public static QFilter getCommonUserOwnersFilter() {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("id", "in", UserUtil.getOwnerIDs());
        return fs;
    }

    public static Object getDefaultOwnerID() {
        List<Object> ownerIDs = UserUtil.getOwnerIDs();
        if (ownerIDs.size() == 0) {
            return 0L;
        }
        return ownerIDs.get(0);
    }

    public static QFilter getOwnerIdsQFilter() {
        return UserUtil.getOwnerIdsQFilter("owner");
    }

    public static QFilter getOwnerIdsQFilter(String filed) {
        return new QFilter(filed, "in", UserUtil.getOwnerIDs());
    }

    public static boolean isBuyer(Object myOwnerId) {
        DynamicObject bizInfo = UserUtil.queryUserInfo(myOwnerId);
        return bizInfo.getBoolean("isbuyer");
    }

    public static boolean isDispatcher(Object myOwnerId) {
        DynamicObject bizInfo = UserUtil.queryUserInfo(myOwnerId);
        return bizInfo.getBoolean("isdispatcher");
    }

    public static boolean isSaler(Object myOwnerId) {
        DynamicObject bizInfo = UserUtil.queryUserInfo(myOwnerId);
        return bizInfo.getBoolean("issaler");
    }

    public static boolean isDptAdmin(Object myOwnerId) {
        DynamicObject bizInfo = UserUtil.queryUserInfo(myOwnerId);
        return bizInfo.getBoolean("isdptadmin");
    }

    public static boolean isCusOrderProcessor(Object myOwnerId) {
        DynamicObject bizInfo = UserUtil.queryUserInfo(myOwnerId);
        return bizInfo.getBoolean("iscusorderprocessor");
    }

    public static DynamicObject queryUserInfo(Object myOwnerId) {
        QFilter f = new QFilter("sysuser", "=", UserUtil.getUserID());
        if (myOwnerId == null) {
            myOwnerId = 0L;
        }
        f.and("owner", "=", myOwnerId);
        DynamicObject info = BusinessDataServiceHelper.loadSingleFromCache((String)"dbd_drp_user", (QFilter[])f.toArray());
        return info;
    }

    public static Map<Object, DynamicObject> queryUserInfo(List<Object> ownerIds) {
        QFilter f = new QFilter("sysuser", "=", UserUtil.getUserID());
        if (ownerIds != null) {
            f.and("owner", "in", ownerIds);
        }
        Map queryuserInfo = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])f.toArray());
        return queryuserInfo;
    }

    public static Set<Object> queryUserRegions(Object myOwnerId) {
        return RegionUtil.queryRegionByUser(UserUtil.getUserID(), myOwnerId);
    }

    public static Set<Object> queryUserRegionsWithAllSubs(Object myOwnerId) {
        Set<Object> ids = RegionUtil.queryRegionByUser(UserUtil.getUserID(), myOwnerId);
        if (!ids.isEmpty()) {
            ids.addAll(RegionUtil.queryAllSubNodeIds(ids));
        }
        return ids;
    }

    public static Set<Object> queryUserRegions() {
        return RegionUtil.queryRegionByUser(UserUtil.getUserID());
    }

    public static Set<Object> queryUserRegionsWithAllSubs() {
        Set<Object> ids = RegionUtil.queryRegionByUser(UserUtil.getUserID());
        if (!ids.isEmpty()) {
            ids.addAll(RegionUtil.queryAllSubNodeIds(ids));
        }
        return ids;
    }

    public static Set<Object> getBuyerIds(Object ownerId) {
        return UserUtil.getUserIdsByRole(ownerId, "isbuyer");
    }

    public static Set<Object> getSalerIds(Object ownerId) {
        return UserUtil.getUserIdsByRole(ownerId, "issaler");
    }

    public static Set<Object> getDispathcerIds(Object ownerId) {
        return UserUtil.getUserIdsByRole(ownerId, "isdispatcher");
    }

    private static Set<Object> getUserIdsByRole(Object ownerId, String roleName) {
        QFilter fs = new QFilter("enable", "=", (Object)"1");
        fs.and("owner", "=", ownerId);
        fs.and(roleName, "=", (Object)"1");
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"dbd_drp_user", (String)"sysuser", (QFilter[])fs.toArray());
        if (infos == null || infos.length == 0) {
            return new HashSet<Object>();
        }
        HashSet<Object> ids = new HashSet<Object>(infos.length);
        for (DynamicObject info : infos) {
            if (info.getDynamicObject("sysuser") == null) continue;
            ids.add(info.getDynamicObject("sysuser").getPkValue());
        }
        return ids;
    }

    public static String getAcctId() {
        return CacheKeyUtil.getAcctId();
    }

    public static boolean isPartnerUser() {
        Long id = Long.valueOf(UserUtil.getUserID().toString());
        return QueryServiceHelper.exists((String)PARTNER, (Object)id);
    }

    public static Set<Object> getPartners() {
        Long id = Long.valueOf(UserUtil.getUserID().toString());
        QFilter fs = new QFilter("user", "=", (Object)id);
        return QueryUtil.querySingleCol(PARTNER, "bizpartner", fs.toArray());
    }

    public static Set<Object> getAdminOrgIDs() {
        return UserUtil.getAdminOrgIDs(UserUtil.getUserID());
    }

    public static Set<Object> getAdminOrgIDs(Object userid) {
        QFilter filter = new QFilter("id", "=", userid);
        return QueryUtil.querySingleCol("bos_user", "entryentity.dpt.id", filter.toArray());
    }

    public static Set<Object> getAdminOrgIDs4Res() {
        return UserUtil.getAdminOrgIDs4Res(UserUtil.getUserID());
    }

    public static Set<Object> getAdminOrgIDs4Res(Object userid) {
        QFilter filter = new QFilter("id", "=", userid);
        filter.and(new QFilter("entryentity.isincharge", "=", (Object)"1"));
        return QueryUtil.querySingleCol("bos_user", "entryentity.dpt.id", filter.toArray());
    }

    public static Object getDefaultAdminOrgID() {
        return UserUtil.getDefaultAdminOrgID(UserUtil.getUserID());
    }

    public static Object getDefaultAdminOrgID(Object userid) {
        QFilter filter = new QFilter("id", "=", userid);
        DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"entryentity.dpt.id", (QFilter[])filter.toArray());
        return user.get("entryentity.dpt.id");
    }

    public static Set<Object> getDispatcherIds(Object departmentid) {
        QFilter filter = new QFilter("department.id", "=", departmentid);
        return QueryUtil.querySingleCol("dbd_department_user", "dispatcher.id", filter.toArray());
    }

    public static Object getDefaultDispatcherId(Object departmentid) {
        QFilter filter = new QFilter("department.id", "=", departmentid);
        filter.and(new QFilter("isdefault", "=", (Object)"1"));
        DynamicObject relation = QueryServiceHelper.queryOne((String)"dbd_department_user", (String)"dispatcher.id", (QFilter[])filter.toArray());
        return relation == null ? null : relation.get("dispatcher.id");
    }

    public static Set<UserRole> getUserRoleInfo(Object ownerid) {
        DynamicObject bizinfo = UserUtil.queryUserInfo(ownerid);
        EnumSet<UserRole> set = EnumSet.noneOf(UserRole.class);
        UserRole[] roles = UserRole.values();
        if (bizinfo != null) {
            for (UserRole role : roles) {
                if (!bizinfo.getBoolean(role.getKey())) continue;
                set.add(role);
            }
        }
        return set;
    }
}

