/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.PhoneType;

public class ValidateUtils {
    public static boolean checkEmail(String value) {
        boolean flag = false;
        Pattern p1 = null;
        Matcher m = null;
        p1 = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
        m = p1.matcher(value);
        flag = m.matches();
        return flag;
    }

    public static CheckResult validMobPhone(String phoneNum) {
        return ValidateUtils.validPhoneNum(PhoneType.MOBILE, phoneNum);
    }

    public static CheckResult validPhoneNum(PhoneType type, String phoneNum) {
        boolean flag = false;
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        String pattern = "^1[\\d]{10}";
        p1 = Pattern.compile(pattern);
        p2 = Pattern.compile("^(0[0-9]{2,3}\\-)?([1-9][0-9]{6,7})$");
        String msg = null;
        switch (type) {
            case MOBILE: {
                msg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff1a\u8bf7\u8f93\u516511\u4f4d\u6570\u624b\u673a\u53f7\u7801", (String)"ValidateUtils_0", (String)"drp-mdr-common", (Object[])new Object[0]);
                if (phoneNum.length() != 11) break;
                m = p1.matcher(phoneNum);
                flag = m.matches();
                break;
            }
            case TEL: {
                msg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff1a\u8bf7\u8f93\u51650000-0000000\u683c\u5f0f\u7684\u56fa\u5b9a\u7535\u8bdd", (String)"ValidateUtils_1", (String)"drp-mdr-common", (Object[])new Object[0]);
                if (phoneNum.length() < 11 || phoneNum.length() >= 16) break;
                m = p2.matcher(phoneNum);
                flag = m.matches();
                break;
            }
            case ALL: {
                msg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff1a\u8bf7\u8f93\u516511\u4f4d\u6570\u624b\u673a\u53f7\u7801\u6216\u8f93\u51650000-0000000\u683c\u5f0f\u7684\u56fa\u5b9a\u7535\u8bdd", (String)"ValidateUtils_2", (String)"drp-mdr-common", (Object[])new Object[0]);
                if (!(phoneNum.length() == 11 && p1.matcher(phoneNum).matches() || phoneNum.length() < 16 && p2.matcher(phoneNum).matches())) break;
                flag = true;
                break;
            }
            default: {
                msg = ResManager.loadKDString((String)"\u7535\u8bdd\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u53cd\u9988", (String)"ValidateUtils_3", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
        }
        return new CheckResult(flag, msg);
    }

    public static CheckResult validPhoneNumWithOutLength(PhoneType type, String phoneNum) {
        boolean flag = true;
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        String pattern = "^1[\\d]{10}";
        p1 = Pattern.compile(pattern);
        p2 = Pattern.compile("^(0[0-9]{2,3}\\-)?([1-9][0-9]{6,7})$");
        String msg = null;
        switch (type) {
            case MOBILE: {
                msg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff1a\u8bf7\u8f93\u5165\u6570\u5b57", (String)"ValidateUtils_4", (String)"drp-mdr-common", (Object[])new Object[0]);
                m = p1.matcher(phoneNum);
                flag = m.matches();
                break;
            }
            default: {
                msg = ResManager.loadKDString((String)"\u7535\u8bdd\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u53cd\u9988", (String)"ValidateUtils_3", (String)"drp-mdr-common", (Object[])new Object[0]);
            }
        }
        return new CheckResult(flag, msg);
    }
}

