/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.DeliveryRuleModel;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.WebUtil;

public class WarehouseRuleUtil {
    public static List<Object> queryWarehouse(Object customerId) {
        QFilter filter = new QFilter("customer", "=", customerId);
        ArrayList<Object> ids = new ArrayList<Object>();
        DynamicObjectCollection warehouseList = WarehouseRuleUtil.queryWarehouseRelation(filter);
        for (DynamicObject warehouse : warehouseList) {
            ids.add(warehouse.get("warehouse.id"));
        }
        return ids;
    }

    public static Object getWarehouse(Object ownerId, Object customerId) {
        if (WebUtil.isEmptyId(customerId)) {
            return null;
        }
        DynamicObjectCollection warehouses = WarehouseRuleUtil.getWarehouseCollection(ownerId, customerId);
        if (warehouses != null && warehouses.size() > 0) {
            return ((DynamicObject)warehouses.get(0)).get("warehouse.id");
        }
        List<Object> warehouseList = WarehouseRuleUtil.queryWarehouse(ownerId);
        if (warehouseList != null && warehouseList.size() > 0) {
            return warehouseList.get(0);
        }
        return null;
    }

    public static List<Object> getWarehouseList(Object ownerId, Object customerId) {
        if (WebUtil.isEmptyId(customerId)) {
            return null;
        }
        ArrayList<Object> warehouseList = new ArrayList<Object>();
        DynamicObjectCollection warehouses = WarehouseRuleUtil.getWarehouseCollection(ownerId, customerId);
        if (warehouses != null) {
            for (DynamicObject warehouse : warehouses) {
                if (warehouse.get("warehouse.id") == null || warehouseList.contains(warehouse.get("warehouse.id"))) continue;
                warehouseList.add(warehouse.get("warehouse.id"));
            }
        }
        return warehouseList;
    }

    public static Object getWarehouse(Object ownerId, Object customerId, Object itemId) {
        if (WebUtil.isEmptyId(customerId)) {
            return null;
        }
        if (WebUtil.isEmptyId(itemId)) {
            return WarehouseRuleUtil.getWarehouse(ownerId, customerId);
        }
        ArrayList<DeliveryRuleModel> drms = WarehouseRuleUtil.getWarehouseCollection(ownerId, customerId, itemId);
        if (drms.size() > 0 && drms.get(0) != null) {
            return drms.get(0).getWarehouseid();
        }
        return null;
    }

    public static List<Object> getWarehouseList(Object ownerId, Object customerId, Object itemId) {
        if (WebUtil.isEmptyId(customerId)) {
            return null;
        }
        if (WebUtil.isEmptyId(itemId)) {
            return WarehouseRuleUtil.getWarehouseList(ownerId, customerId);
        }
        ArrayList<Object> warehouseList = new ArrayList<Object>();
        ArrayList<DeliveryRuleModel> drms = WarehouseRuleUtil.getWarehouseCollection(ownerId, customerId, itemId);
        if (drms.size() > 0 && drms.get(0) != null) {
            for (DeliveryRuleModel drm : drms) {
                if (warehouseList.contains(drm.getWarehouseid())) continue;
                warehouseList.add(drm.getWarehouseid());
            }
        }
        return warehouseList;
    }

    private static DynamicObjectCollection getWarehouseCollection(Object owner, Object customerId) {
        DynamicObjectCollection rules = null;
        QFilter filter = WarehouseRuleUtil.creatRuleFilter(owner, customerId, 0L, 0L, 0L);
        rules = WarehouseRuleUtil.queryWarehouseRule(filter);
        if (rules != null && rules.size() > 0) {
            return rules;
        }
        rules = WarehouseRuleUtil.loopCustomergroup(owner, 0L, WarehouseRuleUtil.queryCustomerGroup(owner, customerId), 0L, 0L);
        if (rules != null && rules.size() > 0) {
            return rules;
        }
        return rules;
    }

    private static ArrayList<DeliveryRuleModel> getWarehouseCollection(Object owner, Object customerId, Object itemId) {
        ArrayList<DeliveryRuleModel> drms = new ArrayList<DeliveryRuleModel>();
        if (WebUtil.isEmptyId(owner)) {
            return drms;
        }
        List<Object> customerClassids = WarehouseRuleUtil.getCustomerClassids(customerId);
        List<Object> itemClassids = WarehouseRuleUtil.getItemClassids(itemId);
        QFilter filter = null;
        DynamicObjectCollection rules = null;
        Boolean useWareHouseRule = SysParamsUtil.isUseWareHouseRule();
        if (useWareHouseRule.booleanValue() && WebUtil.isNotEmptyId(customerId) && WebUtil.isNotEmptyId(itemId)) {
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and("owner", "=", owner);
            filter.and("customer", "=", customerId);
            filter.and("item", "=", itemId);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            WarehouseRuleUtil.addToDrms(drms, rules, 2);
            if (itemClassids != null && itemClassids.size() > 0) {
                filter = new QFilter("enable", "=", (Object)"1");
                filter.and("owner", "=", owner);
                filter.and("customer", "=", customerId);
                filter.and("itemclass", "in", itemClassids);
                rules = WarehouseRuleUtil.queryWarehouseRule(filter);
                WarehouseRuleUtil.addToDrms(drms, rules, 4);
            }
            if (customerClassids != null && customerClassids.size() > 0) {
                filter = new QFilter("enable", "=", (Object)"1");
                filter.and("owner", "=", owner);
                filter.and("customergroup", "in", customerClassids);
                filter.and("item", "=", itemId);
                rules = WarehouseRuleUtil.queryWarehouseRule(filter);
                WarehouseRuleUtil.addToDrms(drms, rules, 6);
            }
            if (customerClassids != null && customerClassids.size() > 0 && itemClassids != null && itemClassids.size() > 0) {
                filter = new QFilter("enable", "=", (Object)"1");
                filter.and("owner", "=", owner);
                filter.and("customergroup", "in", customerClassids);
                filter.and("itemclass", "in", itemClassids);
                rules = WarehouseRuleUtil.queryWarehouseRule(filter);
                WarehouseRuleUtil.addToDrms(drms, rules, 8);
            }
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and("owner", "=", owner);
            filter.and("customergroup", "=", (Object)0L);
            filter.and("customer", "=", customerId);
            filter.and("item", "=", (Object)0L);
            filter.and("itemclass", "=", (Object)0L);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            WarehouseRuleUtil.addToDrms(drms, rules, 10);
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and("owner", "=", owner);
            filter.and("customergroup", "in", customerClassids);
            filter.and("customer", "=", (Object)0L);
            filter.and("item", "=", (Object)0L);
            filter.and("itemclass", "=", (Object)0L);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            WarehouseRuleUtil.addToDrms(drms, rules, 12);
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and("owner", "=", owner);
            filter.and("customergroup", "=", (Object)0L);
            filter.and("customer", "=", (Object)0L);
            filter.and("item", "=", itemId);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            WarehouseRuleUtil.addToDrms(drms, rules, 14);
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and("owner", "=", owner);
            filter.and("customergroup", "=", (Object)0L);
            filter.and("customer", "=", (Object)0L);
            filter.and("itemclass", "in", itemClassids);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            WarehouseRuleUtil.addToDrms(drms, rules, 16);
        }
        filter = new QFilter("customer", "=", owner);
        rules = WarehouseRuleUtil.queryWarehouseRelation(filter);
        WarehouseRuleUtil.addToDrms(drms, rules, 18);
        return drms;
    }

    private static List<Object> getItemClassids(Object itemId) {
        String selectFieldStr = "id,number,name,itemclassentity.classstandardid,itemclassentity.goodsclasssid ";
        DynamicObject iteminfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)selectFieldStr);
        DynamicObjectCollection groupEntrys = iteminfo.getDynamicObjectCollection("itemclassentity");
        ArrayList<String> groupNumbers = new ArrayList<String>();
        for (DynamicObject groupEntry : groupEntrys) {
            String[] numbers;
            DynamicObject tempGroup = groupEntry.getDynamicObject("goodsclasssid");
            if (tempGroup == null || tempGroup.getLong("id") == 0L) continue;
            String longNumber = tempGroup.getString("longnumber");
            for (String number : numbers = longNumber.split("\\.")) {
                groupNumbers.add(number);
            }
            if (longNumber.length() <= 0 || numbers.length != 0) continue;
            groupNumbers.add(longNumber);
        }
        QFilter qf = new QFilter("number", "in", groupNumbers);
        List customergroupids = QueryServiceHelper.queryPrimaryKeys((String)"mdr_item_class", (QFilter[])new QFilter[]{qf}, (String)"", (int)500);
        return customergroupids;
    }

    private static List<Object> getCustomerClassids(Object customerId) {
        String selectFieldStr = "id,number,name,area,custclassentity.classstandardid,custclassentity.customergroupid ";
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"mdr_customer", (String)selectFieldStr);
        DynamicObjectCollection groupEntrys = customer.getDynamicObjectCollection("custclassentity");
        ArrayList<String> groupNumbers = new ArrayList<String>();
        for (DynamicObject groupEntry : groupEntrys) {
            String[] numbers;
            DynamicObject tempGroup = groupEntry.getDynamicObject("customergroupid");
            if (tempGroup == null || tempGroup.getLong("id") == 0L) continue;
            String longNumber = tempGroup.getString("longnumber");
            for (String number : numbers = longNumber.split("\\.")) {
                groupNumbers.add(number);
            }
            if (longNumber.length() <= 0 || numbers.length != 0) continue;
            groupNumbers.add(longNumber);
        }
        QFilter qf = new QFilter("number", "in", groupNumbers);
        List customergroupids = QueryServiceHelper.queryPrimaryKeys((String)"mdr_customer_group", (QFilter[])new QFilter[]{qf}, (String)"", (int)500);
        return customergroupids;
    }

    private static void addToDrms(ArrayList<DeliveryRuleModel> drms, DynamicObjectCollection rules, int priority) {
        if (rules == null || rules.size() == 0) {
            return;
        }
        for (DynamicObject obj : rules) {
            DeliveryRuleModel drm = new DeliveryRuleModel();
            drm.setIsdefault(obj.getBoolean("isdefault"));
            drm.setPriority(priority);
            drm.setWarehouseid(obj.getLong("warehouse.id"));
            drm.setWarehousename(obj.getString("warehouse.name"));
            drms.add(drm);
        }
    }

    private static DynamicObjectCollection loopItemClass(Object owner, Object customerId, Object customergroupId, Object itemId, Object itemClassId) {
        DynamicObjectCollection rules = null;
        while (!WebUtil.isEmptyId(itemClassId)) {
            QFilter filter = WarehouseRuleUtil.creatRuleFilter(owner, customerId, customergroupId, itemId, itemClassId);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            if (rules.size() > 0) {
                return rules;
            }
            itemClassId = WarehouseRuleUtil.queryUpItemClass(itemClassId);
        }
        return rules;
    }

    private static DynamicObjectCollection loopCustomergroup(Object owner, Object customerId, Object customergroupId, Object itemId, Object itemClassId) {
        DynamicObjectCollection rules = null;
        while (!WebUtil.isEmptyId(customergroupId)) {
            QFilter filter = WarehouseRuleUtil.creatRuleFilter(owner, customerId, customergroupId, itemId, itemClassId);
            rules = WarehouseRuleUtil.queryWarehouseRule(filter);
            if (rules.size() > 0) {
                return rules;
            }
            customergroupId = WarehouseRuleUtil.queryUpCustomerGroup(customergroupId);
        }
        return rules;
    }

    private static DynamicObjectCollection queryWarehouseRule(QFilter filter) {
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"mdr_warehouse_rule", (String)"warehouse.name,warehouse.id,isdefault", (QFilter[])filter.toArray(), (String)"isdefault desc");
        return rules;
    }

    private static DynamicObjectCollection queryWarehouseRelation(QFilter filter) {
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.name,warehouse.id,isdefault", (QFilter[])filter.toArray(), (String)"isdefault desc");
        return rules;
    }

    private static Object queryUpCustomerGroup(Object customergroupId) {
        QFilter filter = new QFilter("id", "=", customergroupId);
        DynamicObject customerGroup = QueryServiceHelper.queryOne((String)"mdr_customer_group", (String)"parent.name,parent.id", (QFilter[])filter.toArray());
        if (customerGroup != null) {
            return customerGroup.get("parent.id");
        }
        return null;
    }

    private static Object queryCustomerGroup(Object ownerId, Object customerId) {
        QFilter filter = new QFilter("customer.id", "=", customerId);
        filter.and("authowner", "=", ownerId);
        DynamicObject authInfo = QueryServiceHelper.queryOne((String)"mdr_customer_authorize", (String)"customergroup.name,customergroup.id", (QFilter[])filter.toArray());
        if (authInfo != null) {
            return authInfo.get("customergroup.id");
        }
        return null;
    }

    private static Object queryItemClass(Object itemId) {
        DynamicObject item = ItemUtil.getItemBizInfo(itemId);
        if (item != null && item.getDynamicObject("itemclass") != null) {
            return item.getDynamicObject("itemclass").getPkValue();
        }
        return null;
    }

    private static Object queryUpItemClass(Object itemClassId) {
        QFilter filter = new QFilter("id", "=", itemClassId);
        DynamicObject authInfo = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)"parent.name,parent.id", (QFilter[])filter.toArray());
        if (authInfo != null) {
            return authInfo.get("parent.id");
        }
        return null;
    }

    private static QFilter creatRuleFilter(Object ownerId, Object customerId, Object customergroupId, Object itemId, Object itemClassId) {
        QFilter filter = new QFilter("owner", "=", ownerId);
        filter.and("enable", "=", (Object)"1");
        filter.and("customer", "=", customerId);
        filter.and("customergroup", "=", customergroupId);
        filter.and("item", "=", itemId);
        filter.and("itemclass", "=", itemClassId);
        return filter;
    }

    public static boolean hasRule(DynamicObject rule) {
        DynamicObject[] rules;
        DynamicObject owner = (DynamicObject)rule.get("owner");
        if (owner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u5f52\u5c5e\u6e20\u9053\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"WarehouseRuleUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("owner", "=", owner.get("id"));
        DynamicObject customer = (DynamicObject)rule.get("customer");
        if (customer != null) {
            filter.and("customer", "=", (Object)Long.parseLong(customer.get("id").toString()));
        } else {
            filter.and("customer", "=", (Object)0);
        }
        DynamicObject customergroup = (DynamicObject)rule.get("customergroup");
        if (customergroup != null) {
            filter.and("customergroup", "=", (Object)Long.parseLong(customergroup.get("id").toString()));
        } else {
            filter.and("customergroup", "=", (Object)0);
        }
        DynamicObject item = (DynamicObject)rule.get("item");
        if (item != null) {
            filter.and("item", "=", (Object)Long.parseLong(item.get("id").toString()));
        } else {
            filter.and("item", "=", (Object)0);
        }
        DynamicObject itemclass = (DynamicObject)rule.get("itemclass");
        if (itemclass != null) {
            filter.and("itemclass", "=", (Object)Long.parseLong(itemclass.get("id").toString()));
        } else {
            filter.and("itemclass", "=", (Object)0);
        }
        DynamicObject warehouse = (DynamicObject)rule.get("warehouse");
        if (warehouse != null) {
            filter.and("warehouse", "=", (Object)Long.parseLong(warehouse.get("id").toString()));
        } else {
            filter.and("warehouse", "=", (Object)0);
        }
        Object ruleId = rule.get("id");
        if (ruleId != null) {
            filter.and("id", "!=", (Object)Long.parseLong(ruleId.toString()));
        }
        return (rules = BusinessDataServiceHelper.load((String)"mdr_warehouse_rule", (String)"id,isdefault", (QFilter[])filter.toArray())).length > 0;
    }
}

