/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.formhandler.UserOwnerHandler;

public class MdrListPlugin
extends AbstractListPlugin {
    private String filterOwnerName = "owner.id";
    private String modelName;
    private UserOwnerHandler userOwnerHandler = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        ((AbstractOperate)evt.getSource()).getOption().setVariableValue("DRP_OP_FROM_LIST", "DRP_OP_FROM_LIST");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "billnumber.owner.id": 
            case "myowner.id": 
            case "contactscustomer.id": 
            case "customer.id": 
            case "order.owner.id": 
            case "authowner.id": 
            case "owner.id": {
                ArrayList<QFilter> filters = e.getCustomQFilters();
                if (filters == null) {
                    filters = new ArrayList<QFilter>();
                    e.setCustomQFilters(filters);
                }
                filters.add(new QFilter("id", "in", this.getOwnerIDs()));
            }
        }
        super.filterContainerBeforeF7Select(e);
    }

    public String getModelName() {
        if (this.modelName == null) {
            this.modelName = this.getListModel().getDataEntityType().getName();
        }
        return this.modelName;
    }

    public void setFilter(SetFilterEvent e) {
        if (!this.isNeedCahceOwner()) {
            return;
        }
        List fs = e.getQFilters();
        Map<String, QFilter> fsMap = this.filter2Map(fs);
        if (fsMap.containsKey(this.getFilterOwnerName())) {
            QFilter f = fsMap.get(this.getFilterOwnerName());
            Object value = f.getValue();
            if (value instanceof Long) {
                this.getPageCache().put("ownerid4cache", value.toString());
            }
        } else {
            this.getPageCache().put("ownerid4cache", null);
        }
    }

    protected String getFilterOwnerName() {
        return this.filterOwnerName;
    }

    protected void setFilterOwnerName(String filterOwnerName) {
        this.filterOwnerName = filterOwnerName;
    }

    protected boolean isNeedCahceOwner() {
        return false;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.getPageCache().get("ownerid4cache") != null) {
            e.getParameter().setCustomParam("ownerid4cache", (Object)this.getPageCache().get("ownerid4cache"));
        }
    }

    protected IListView getListView() {
        IFormView formview = this.getView();
        IListView listview = (IListView)formview;
        return listview;
    }

    protected IListModel getListModel() {
        return this.getListView().getListModel();
    }

    public boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    protected boolean getOperationResult(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        return result == null || result.isSuccess();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("default".equals(e.getOperateKey()) || "undefault".equals(e.getOperateKey())) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    protected List<ComboItem> getAuthoriedOwnerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getAuthoriedOwnerIDs();
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    @Deprecated
    protected List<ComboItem> getOwnerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getWareHouseComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFilter f = new QFilter("user", "=", UserUtil.getUserID());
        f.and("enable", "=", (Object)"1");
        DynamicObjectCollection wareHouses = QueryServiceHelper.query((String)"mdr_wareshouse_user_r", (String)"warehouse.id,warehouse.name", (QFilter[])f.toArray());
        if (wareHouses == null || wareHouses.size() == 0) {
            List<Object> ownerIDs = this.getOwnerIDs();
            f = new QFilter("customer", "in", ownerIDs);
            wareHouses = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.id,warehouse.name", (QFilter[])f.toArray());
        }
        ComboItem item = null;
        for (DynamicObject wareHouse : wareHouses) {
            item = new ComboItem();
            item.setId(String.valueOf(wareHouse.get("warehouse.id")));
            item.setValue(String.valueOf(wareHouse.get("warehouse.id")));
            item.setCaption(new LocaleString(wareHouse.getString("warehouse.name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getWareHouseComboItem4Order() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("customer", "in", ownerIDs);
        DynamicObjectCollection wareHouses = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.id,warehouse.name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject wareHouse : wareHouses) {
            item = new ComboItem();
            item.setId(String.valueOf(wareHouse.get("warehouse.id")));
            item.setValue(String.valueOf(wareHouse.get("warehouse.id")));
            item.setCaption(new LocaleString(wareHouse.getString("warehouse.name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getCustomerGroupComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("owner", "in", ownerIDs);
        DynamicObjectCollection customerGroups = QueryServiceHelper.query((String)"mdr_customer_group", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject customerGroup : customerGroups) {
            item = new ComboItem();
            item.setId(String.valueOf(customerGroup.get("id")));
            item.setValue(String.valueOf(customerGroup.get("id")));
            item.setCaption(new LocaleString(customerGroup.getString("name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getItemClassComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFilter f = new QFilter("1", "=", (Object)"1");
        DynamicObjectCollection itemClasses = QueryServiceHelper.query((String)"mdr_item_class", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject itemClass : itemClasses) {
            item = new ComboItem();
            item.setId(String.valueOf(itemClass.get("id")));
            item.setValue(String.valueOf(itemClass.get("id")));
            item.setCaption(new LocaleString(itemClass.getString("name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected void initAuthoriedOwnerFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey) {
        this.initAuthoriedOwnerFilterComboItem(e, ownerFilterkey, true);
    }

    protected void initAuthoriedOwnerFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey, boolean isSetDefault) {
        if (this.isLookup()) {
            return;
        }
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getAuthoriedOwnerComboItem();
            if (isSetDefault && comboItems.size() > 0) {
                List<Object> ownerIDs;
                Object id = this.getDefaultOwner();
                if (!this.isDefaultOwnerList() && !(ownerIDs = this.getAuthoriedOwnerIDs()).contains(id)) {
                    id = ownerIDs.get(0);
                }
                col.setDefaultValue(id.toString());
            }
            col.setComboItems(comboItems);
        }
    }

    @Deprecated
    protected void initOwnerFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey) {
        if (this.isLookup()) {
            return;
        }
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getOwnerComboItem();
            if (comboItems.size() > 0) {
                List<Object> ownerIDs;
                Object id = this.getDefaultOwner();
                if (!this.isDefaultOwnerList() && !(ownerIDs = this.getOwnerIDs()).contains(id)) {
                    id = ownerIDs.get(0);
                }
                col.setDefaultValue(id.toString());
            }
            col.setComboItems(comboItems);
        }
    }

    protected boolean isDefaultOwnerList() {
        return true;
    }

    protected void setWareHouseFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey) {
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getWareHouseComboItem4Order();
            col.setComboItems(comboItems);
        }
    }

    protected Map<String, QFilter> filter2Map(List<QFilter> fs) {
        HashMap<String, Object> fsMap = new HashMap<String, QFilter>(1);
        if (fs != null) {
            fsMap = new HashMap(fs.size());
            for (QFilter f : fs) {
                fsMap.put(f.getProperty(), f);
            }
        }
        return fsMap;
    }

    protected Object[] getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        return ids;
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    protected Object[] getSelectedIds(boolean isSingle) {
        Object[] ids = this.getSelectIds();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MdrListPlugin_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (isSingle && size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MdrListPlugin_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return ids;
    }

    public List<Object> getAuthoriedOwnerIDs() {
        return this.getUserOwnerHandler().getAuthoriedOwners();
    }

    @Deprecated
    public List<Object> getOwnerIDs() {
        return this.getUserOwnerHandler().getOwners();
    }

    public Object getDefaultOwner() {
        return this.getUserOwnerHandler().getDefaultOwner();
    }

    private UserOwnerHandler getUserOwnerHandler() {
        if (this.userOwnerHandler == null) {
            this.userOwnerHandler = new UserOwnerHandler();
        }
        return this.userOwnerHandler;
    }
}

