/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.billconvert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.ShortMessageUtil;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.formplugin.MdrBillConvertPlugin;

public class SaleOrderConvertPlugin
extends MdrBillConvertPlugin {
    private static final String BILL_DATE = "billdate";
    private static final String ITEM_ENTRY = "itementry";
    private static final String ORDERAMOUNT = "orderamount";
    private static final String ENTRYQTY = "qty";
    protected static final String TOTAL_ITEM_AMOUT = "totalitemamount";
    protected static final String TOTAL_ORDER_AMOUNT = "totalorderamount";
    protected static final String TOTAL_QTY = "totalqty";
    protected static final String AMOUNT_TO_BE_PAID = "amounttobepaid";
    protected static final String RECEIVED_AMOUNT = "receivedamount";
    protected static final String SOURCEBILL_TYPE = "sourcebilltype";
    protected static final String SOURCEBILLID = "sourcebillid";

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        if (this.targetEntityNumber.equals("mdr_dispatch_order")) {
            this.initDispatchOrder(e);
        }
    }

    private void initDispatchOrder(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber)) {
            Date billDate = DateUtil.getNowDate();
            billDataEntity.setValue(BILL_DATE, (Object)billDate);
            this.calcuAmount(billDataEntity);
        }
    }

    private void calcuAmount(ExtendedDataEntity billDataEntity) {
        DynamicObjectCollection entryRows = (DynamicObjectCollection)billDataEntity.getValue(ITEM_ENTRY);
        BigDecimal totalamount = new BigDecimal(0);
        BigDecimal entryamount = new BigDecimal(0);
        BigDecimal totalqty = new BigDecimal(0);
        BigDecimal entryqty = new BigDecimal(0);
        Iterator it = entryRows.iterator();
        while (it.hasNext()) {
            DynamicObject entryRow = (DynamicObject)it.next();
            if (entryRow.getBigDecimal(ENTRYQTY).compareTo(BigDecimal.ZERO) == 0 || entryRow.getDynamicObject("item") == null) {
                it.remove();
                continue;
            }
            entryamount = entryRow.getBigDecimal(ORDERAMOUNT);
            totalamount = totalamount.add(entryamount);
            entryqty = entryRow.getBigDecimal(ENTRYQTY);
            totalqty = totalqty.add(entryqty);
        }
        billDataEntity.setValue(TOTAL_ITEM_AMOUT, (Object)totalamount);
        billDataEntity.setValue(TOTAL_ORDER_AMOUNT, (Object)totalamount);
        billDataEntity.setValue(RECEIVED_AMOUNT, (Object)ZERO);
        billDataEntity.setValue(AMOUNT_TO_BE_PAID, (Object)totalamount);
        billDataEntity.setValue(TOTAL_QTY, (Object)totalqty);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        HashSet<Object> ids = new HashSet<Object>();
        if (SysParamsUtil.isNeedConfirmAfterAllot() && this.targetEntityNumber.equals("mdr_dispatch_order")) {
            DynamicObject[] saleorders;
            ExtendedDataEntity[] billDataEntitys;
            for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber)) {
                DynamicObjectCollection entryRows = (DynamicObjectCollection)billDataEntity.getValue(ITEM_ENTRY);
                for (DynamicObject entryRow : entryRows) {
                    Object saleorderId = entryRow.get(SOURCEBILLID);
                    ids.add(saleorderId);
                }
            }
            for (DynamicObject saleorder : saleorders = BusinessDataServiceHelper.load((String)"bbc_saleorder", (String)"id,confirmstatus", (QFilter[])QueryUtil.getIdQFilter(ids).toArray())) {
                saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr());
                ShortMessageUtil.sendDispatchOrderMsg(saleorder.get("id"));
            }
            SaveServiceHelper.save((DynamicObject[])saleorders);
        }
    }
}

