/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.formhandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import org.apache.commons.lang3.StringUtils;

public class UnitFormHandler
extends UnitBatchHandler {
    private final IPageCache cache;

    public UnitFormHandler(IPageCache cache) {
        this.cache = cache;
    }

    @Override
    public void batchLoad(Collection<Object> itemIds) {
        itemIds = this.getLocalNotExsistId(itemIds);
        if (!(itemIds = this.parse2LoaclMap(itemIds)).isEmpty()) {
            Map<Object, JSONObject> itemUnitDatas = this.batchLoad4LoaclMap(itemIds);
            this.addAll2PageCache(itemUnitDatas);
        }
    }

    private void addAll2PageCache(Map<Object, JSONObject> itemUnitDatas) {
        for (Map.Entry<Object, JSONObject> itemUnitData : itemUnitDatas.entrySet()) {
            this.add2PageCache(itemUnitData.getKey(), itemUnitData.getValue());
        }
    }

    private void add2PageCache(Object itemId, JSONObject itemUnitData) {
        String key = this.getCacheKey(itemId);
        this.cache.put(key, itemUnitData.toJSONString());
    }

    private List<Object> parse2LoaclMap(Collection<Object> itemIds) {
        ArrayList<Object> notExsistItemIds = new ArrayList<Object>();
        JSONObject itemUnitData = null;
        for (Object itemId : itemIds) {
            itemUnitData = this.parseFromCache(itemId);
            if (itemUnitData == null) {
                notExsistItemIds.add(itemId);
                continue;
            }
            this.loaclMap.put(itemId, itemUnitData);
        }
        return notExsistItemIds;
    }

    @Override
    protected JSONObject getItemUnitData(Object itemId) {
        JSONObject itemUnitData = (JSONObject)this.loaclMap.get(itemId);
        if (itemUnitData == null) {
            itemUnitData = this.parseFromCache(itemId);
            if (itemUnitData == null) {
                itemUnitData = this.load4LoaclMap(itemId);
                this.add2PageCache(itemId, itemUnitData);
            } else {
                this.loaclMap.put(itemId, itemUnitData);
            }
        }
        this.checkUnit(itemId, itemUnitData);
        return itemUnitData;
    }

    private JSONObject parseFromCache(Object itemId) {
        String key = this.getCacheKey(itemId);
        String itemUnitsJsonStr = this.cache.get(key);
        JSONObject itemUnitData = null;
        if (!StringUtils.isEmpty((CharSequence)itemUnitsJsonStr)) {
            itemUnitData = JSON.parseObject((String)itemUnitsJsonStr);
            this.parseUnitIdToLong(itemUnitData);
        }
        return itemUnitData;
    }

    private String getCacheKey(Object itemId) {
        return "DRP_ITEM_UNIT" + itemId;
    }
}

