/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.homecard;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.homecard.DependencyExpression;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public abstract class AbstractHomePageNavigationFormPlugin
extends MdrBasePlugin {
    private Map<String, String> hyperLinkMap = new HashMap<String, String>();
    private Map<String, String> titleContentMap = new HashMap<String, String>();
    private Map<String, String> titleHiddenIconMap = new HashMap<String, String>();
    private Map<String, String> titleShowIconMap = new HashMap<String, String>();
    private Map<String, DependencyExpression> controlDependencyMap = new HashMap<String, DependencyExpression>();

    protected abstract void initRegisterContent();

    public AbstractHomePageNavigationFormPlugin() {
        this.initRegisterContent();
    }

    protected void registerTitle(String title, String content) {
        this.titleContentMap.put(title, content);
    }

    protected void registerTilte(String title, String content, String hiddenIcon, String showIcon) {
        this.registerTitle(title, content);
        this.titleHiddenIconMap.put(title, hiddenIcon);
        this.titleShowIconMap.put(title, showIcon);
    }

    protected void registerHyperLink(String control, String hyperLink) {
        this.hyperLinkMap.put(control, hyperLink);
    }

    protected void registerControlDependency(String control, DependencyExpression depnedOnExp) {
        if (!this.hyperLinkMap.containsKey(control)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63a7\u4ef6%s\u672a\u6ce8\u518c\u8d85\u94fe\u63a5\uff0c\u4e0d\u80fd\u6ce8\u518c\u4f9d\u8d56\u5185\u5bb9\u8868\u8fbe\u5f0f", (String)"AbstractHomePageNavigationFormPlugin_0", (String)"drp-mdr-common", (Object[])new Object[0]), control));
        }
        this.controlDependencyMap.put(control, depnedOnExp);
    }

    protected void removeControlDependecy(String control) {
        if (this.hyperLinkMap.containsKey(control)) {
            this.hyperLinkMap.remove(control);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String content = this.titleContentMap.get(key);
        if (content == null) {
            this.showList(key);
        } else {
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            String visibleStatus = cache.get(this.getView().getPageId() + content);
            if (visibleStatus == null || "show".equals(visibleStatus)) {
                this.hiddenContent(this.titleShowIconMap.get(key));
            } else if ("hidden".equals(visibleStatus)) {
                this.showContent(this.titleHiddenIconMap.get(key));
            }
        }
        if (this.titleHiddenIconMap.values().contains(key)) {
            this.showContent(key);
        } else if (this.titleShowIconMap.values().contains(key)) {
            this.hiddenContent(key);
        } else if (this.hyperLinkMap.containsKey(key)) {
            this.showList(key);
        }
    }

    private void showList(String key) {
        String hyperLink = this.hyperLinkMap.get(key);
        if (hyperLink != null) {
            ListShowParameter para = new ListShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setBillFormId(hyperLink);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)hyperLink);
            para.setFormId(formConfig.getListFormId());
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private void hiddenContent(String key) {
        String content = null;
        for (Map.Entry<String, String> entry : this.titleShowIconMap.entrySet()) {
            if (!key.equals(entry.getValue())) continue;
            content = entry.getKey();
            break;
        }
        this.setDisVisible(this.titleShowIconMap.get(content));
        this.setVisible(this.titleHiddenIconMap.get(content));
        this.setDisVisible(this.titleContentMap.get(content));
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.put(this.getView().getPageId() + this.titleContentMap.get(content), "hidden");
    }

    private void showContent(String key) {
        String content = null;
        for (Map.Entry<String, String> entry : this.titleHiddenIconMap.entrySet()) {
            if (!key.equals(entry.getValue())) continue;
            content = entry.getKey();
            break;
        }
        this.setVisible(this.titleShowIconMap.get(content));
        this.setDisVisible(this.titleHiddenIconMap.get(content));
        this.setVisible(this.titleContentMap.get(content));
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.put(this.getView().getPageId() + this.titleContentMap.get(content), "show");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        for (Map.Entry<String, DependencyExpression> entry : this.controlDependencyMap.entrySet()) {
            DependencyExpression exp = entry.getValue();
            if (!exp.getAllUnit().contains(key) && !exp.getAllUnit().contains(this.hyperLinkMap.get(key))) continue;
            boolean result = (Boolean)FormulaEngine.execExcelFormula((String)this.parseDependecyExpSource(exp));
            if (result) {
                this.setEnable(entry.getKey());
                continue;
            }
            this.setUnEnable(entry.getKey());
        }
    }

    public void afterBindData(EventObject e) {
        this.hiddenControl();
        this.parseDependence();
    }

    private void hiddenControl() {
        HashSet<String> needHiddenIcon = new HashSet<String>();
        for (Map.Entry<String, String> tileContent : this.titleContentMap.entrySet()) {
            if (tileContent.getValue() != null && tileContent.getValue().trim() != "") continue;
            needHiddenIcon.add(this.titleShowIconMap.get(tileContent.getKey()));
        }
        needHiddenIcon.addAll(this.titleHiddenIconMap.values());
        this.setDisVisible(needHiddenIcon.toArray(new String[needHiddenIcon.size()]));
    }

    protected final void parseDependence() {
        for (Map.Entry<String, DependencyExpression> entry : this.controlDependencyMap.entrySet()) {
            DependencyExpression exp = entry.getValue();
            boolean result = (Boolean)FormulaEngine.execExcelFormula((String)this.parseDependecyExpSource(exp));
            String key = entry.getKey();
            if (result) {
                this.setEnable(key);
                continue;
            }
            this.setUnEnable(key);
        }
    }

    protected String parseDependecyExpSource(DependencyExpression expression) {
        StringBuilder exp = new StringBuilder();
        List<Object> objects = expression.getExpSource();
        for (Object fact : objects) {
            if (fact instanceof String) {
                exp.append(this.isMatchRule((String)fact));
                continue;
            }
            if (fact instanceof DependencyExpression) {
                exp.append('(');
                exp.append(this.parseDependecyExpSource((DependencyExpression)fact));
                exp.append(')');
                continue;
            }
            if (!(fact instanceof Integer)) continue;
            if (fact.equals(DependencyExpression.AND)) {
                exp.append(" AND ");
                continue;
            }
            if (!fact.equals(DependencyExpression.OR)) continue;
            exp.append(" OR ");
        }
        return exp.toString();
    }

    private boolean isMatchRule(String control) {
        String entityName = this.hyperLinkMap.get(control);
        QFilter filter = this.beforeExcuteDependecyExp(control);
        if (filter == null) {
            filter = new QFilter("1", "=", (Object)"1");
        }
        if (entityName == null || entityName.trim() == "") {
            entityName = control;
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])filter.toArray());
    }

    protected QFilter beforeExcuteDependecyExp(String control) {
        return new QFilter("1", "=", (Object)"1");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        HashSet<String> needRegisterControl = new HashSet<String>();
        needRegisterControl.addAll(this.hyperLinkMap.keySet());
        needRegisterControl.addAll(this.titleContentMap.keySet());
        needRegisterControl.addAll(this.titleShowIconMap.values());
        needRegisterControl.addAll(this.titleHiddenIconMap.values());
        this.addClickListeners(needRegisterControl.toArray(new String[needRegisterControl.size()]));
    }
}

