/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.plugintemplate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;

public class MdrListPlugin
extends AbstractListPlugin {
    private String modelName;

    protected String getModelName() {
        if (this.modelName == null) {
            this.modelName = this.getListModel().getDataEntityType().getName();
        }
        return this.modelName;
    }

    protected IListView getListView() {
        IFormView formview = this.getView();
        IListView listview = (IListView)formview;
        return listview;
    }

    protected IListModel getListModel() {
        return this.getListView().getListModel();
    }

    public final void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String key = e.getFieldName();
        this.registerFilterQFilter(key, e.getCustomQFilters());
    }

    protected void registerFilterQFilter(String key, List<QFilter> filter) {
    }

    protected boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    protected boolean isOperationResult(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        return result == null || result.isSuccess();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String[] refreshops = this.registerOPNeedRefreshList();
        if (refreshops == null || refreshops.length == 0) {
            return;
        }
        HashSet<String> opset = new HashSet<String>(Arrays.asList(refreshops));
        if (opset.contains(e.getOperateKey())) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    protected String[] registerOPNeedRefreshList() {
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        String[] onlyoneops = this.registerOP4OnlyOneRow();
        if (onlyoneops == null || onlyoneops.length == 0) {
            return;
        }
        HashSet<String> opset = new HashSet<String>(Arrays.asList(onlyoneops));
        if (opset.contains(key) && this.getSelectIds().length != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u53ea\u5141\u8bb8\u9009\u62e9\u5355\u884c", (String)"MdrListPlugin_2", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
    }

    protected String[] registerOP4OnlyOneRow() {
        return null;
    }

    protected Object[] getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        return ids;
    }

    protected void showForm(FormShowParameter param) {
        Objects.requireNonNull(param);
        this.getView().showForm(param);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (this.isShowBillWithModel()) {
            BillShowParameter parameter = e.getParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    protected boolean isShowBillWithModel() {
        return false;
    }
}

