/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.plugintemplate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.formplugin.plugintemplate.MdrOwnerFormPlugin;

public class MdrOwnerCusFormPlugin
extends MdrOwnerFormPlugin {
    protected static final String CUSTOMER = "customer";
    protected static final String PRE_CUSTOMERID = "customerids";

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = this.getKey((EventObject)e);
        if (key.equals(CUSTOMER)) {
            this.beforeCustomerF7Select(e);
        }
    }

    protected void beforeCustomerF7Select(BeforeF7SelectEvent e) {
        CheckResult re = this.checkCustomerBeforeSelect();
        if (!re.isSuccess()) {
            this.getView().showTipNotification(re.getMsg());
            return;
        }
        F7Utils.addF7Filter(e, this.getCustomerFilter());
    }

    protected QFilter getCustomerFilter() {
        QFilter filter = new QFilter("id", "in", this.getCustomerIDS(this.getOwnerF7Value()));
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        return filter;
    }

    protected List<Object> getCustomerIDS(Object ownerid) {
        StringBuilder cachekey = new StringBuilder();
        cachekey.append(PRE_CUSTOMERID).append('-').append(ownerid);
        return this.getIDSFromCache(cachekey.toString(), () -> new ArrayList<Object>(CustomerUtil.getAuthSubsIds(ownerid)));
    }

    protected CheckResult checkCustomerBeforeSelect() {
        if (this.getF7Value("owner") == null) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"MdrOwnerCusFormPlugin_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    protected void setCustomerF7Value(Object pk) {
        this.getModel().setValue(CUSTOMER, pk);
    }

    protected Object getCustomerF7PKValue() {
        return this.getF7PKValue(CUSTOMER);
    }

    protected DynamicObject getCustomerF7Value() {
        return this.getF7Value(CUSTOMER);
    }
}

