/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.plugintemplate;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.plugintemplate.MdrBaseDataFormPlugin;

public class MdrOwnerFormPlugin
extends MdrBaseDataFormPlugin
implements BeforeF7SelectListener {
    protected static final String OWNER = "owner";
    protected static final String DEFAULTOWNER = "defaultowner";
    protected static final String OWNERIDS = "ownerids";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object ownerid = this.getOwnerIDFromList();
        if (ownerid == null) {
            ownerid = this.getDefaultOwnerID4User();
        }
        this.setOwnerF7Value(ownerid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, OWNER);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = this.getKey((EventObject)e);
        if (OWNER.equals(key)) {
            F7Utils.addF7Filter(e, this.getOwnerFilter());
        }
    }

    protected QFilter getOwnerFilter() {
        QFilter filter = new QFilter("id", "in", this.getOwnerIDS4User());
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        return filter;
    }

    protected Object getDefaultOwnerID4User() {
        Object ownerid = this.getPageCache().get(DEFAULTOWNER);
        if (ownerid == null) {
            ownerid = UserUtil.getDefaultOwnerID();
            this.getPageCache().put(DEFAULTOWNER, ownerid.toString());
        }
        return ownerid;
    }

    protected List<Object> getOwnerIDS4User() {
        return this.getIDSFromCache(OWNERIDS, () -> UserUtil.getOwnerIDs());
    }

    protected Object getOwnerIDFromList() {
        return this.getValueFromShowParam(OWNER);
    }

    protected void setOwnerF7Value(Object pk) {
        this.getModel().setValue(OWNER, pk);
    }

    protected Object getOwnerF7PKValue() {
        return this.getF7PKValue(OWNER);
    }

    protected DynamicObject getOwnerF7Value() {
        return this.getF7Value(OWNER);
    }
}

