/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.formplugin.plugintemplate;

import java.util.List;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.formplugin.plugintemplate.MdrListPlugin;

public class MdrOwnerListPlugin
extends MdrListPlugin {
    protected static final String OWNERFILTERKEY = "owner.id";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("owner", (Object)this.getOwnerIDFromList());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.putListOwnerIntoCache(e);
    }

    protected Object getListOwnerFilterValue(SetFilterEvent e) {
        List filters = e.getQFilters();
        for (QFilter filter : filters) {
            if (!filter.getProperty().equals(OWNERFILTERKEY)) continue;
            return filter.getValue();
        }
        return null;
    }

    protected void putListOwnerIntoCache(SetFilterEvent e) {
        Object ownerid = this.getListOwnerFilterValue(e);
        this.getPageCache().put("owner", ownerid == null ? null : ownerid.toString());
    }

    protected String getOwnerIDFromList() {
        return this.getPageCache().get("owner");
    }
}

