/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.iAlgorithm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.BigDecimalConstants;
import kd.drp.mdr.common.constants.DiscountModeEnum;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.item.ConversionDirection;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;
import kd.drp.mdr.formplugin.formhandler.UnitFormHandler;
import kd.drp.mdr.iAlgorithm.IAlgorithm;

public class OrderAlgorithm
extends MdrBillPlugin
implements IAlgorithm {
    protected DynamicObject order;
    protected DynamicObjectCollection entry;
    protected int amountPrecision = 2;
    protected int localAmountPrecision = 2;
    protected int pricePrecision = 2;
    protected int localPricePrecision = 2;
    protected IPageCache pageCache;
    private UnitFormHandler unitFromHandler = null;

    public OrderAlgorithm(DynamicObject order, IPageCache cache) {
        this.order = order;
        this.pageCache = cache;
        this.entry = order.getDynamicObjectCollection(this.getEntryKey());
        this.initPrecision();
    }

    protected void initPrecision() throws KDBizException {
        DynamicObject localCurrency;
        DynamicObject currency = this.order.getDynamicObject("currency");
        if (currency != null) {
            this.pricePrecision = currency.getInt("priceprecision");
            this.amountPrecision = currency.getInt("amtprecision");
        }
        if ((localCurrency = this.order.getDynamicObject("localcurrency")) != null) {
            this.localAmountPrecision = localCurrency.getInt("priceprecision");
            this.localPricePrecision = localCurrency.getInt("amtprecision");
        }
    }

    @Override
    public void revalue() throws KDBizException {
        this.reCalFields();
    }

    @Override
    public void calByUnit(int i, boolean needCalTotal) {
        this.calQtysByBaseQty(i);
        this.calOtherAfterCalQty(i, needCalTotal);
    }

    @Override
    public void calByAssistAttr(int i, boolean needCalTotal) {
        this.calOtherAfterCalQty(i, needCalTotal);
    }

    @Override
    public void calByExecutePromotion() {
    }

    public boolean calQtysByBaseQty(int i) {
        DynamicObject assisUnit;
        boolean qtyHasChange = false;
        DynamicObject orderEntry = this.getEntry(i);
        BigDecimal baseQty = orderEntry.getBigDecimal("baseqty");
        BigDecimal alterBaseQty = orderEntry.getBigDecimal("alterbaseqty");
        BigDecimal oldQty = orderEntry.getBigDecimal("qty");
        DynamicObject item = orderEntry.getDynamicObject("item");
        Object itemId = item.get("id");
        DynamicObject unit = orderEntry.getDynamicObject("unit");
        BigDecimal qty = this.getUnitFormHandler().getUnitQty(itemId, unit.get("id"), baseQty);
        if (oldQty.compareTo(qty) != 0) {
            qtyHasChange = true;
        }
        BigDecimal alterQty = this.getUnitFormHandler().getUnitQty(itemId, unit.get("id"), alterBaseQty);
        this.setValue("alterqty", (Object)alterQty, i);
        this.setValue("qty", (Object)qty, i);
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            BigDecimal assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
            BigDecimal alterAssistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), alterBaseQty);
            this.setValue("alterassistqty", (Object)alterAssistQty, i);
            this.setValue("assistqty", (Object)assistQty, i);
        }
        return qtyHasChange;
    }

    @Override
    public void calByQtys(int i, String key, boolean needCalTotal) {
        this.calQtysByQtys(i, key);
        this.calOtherAfterCalQty(i, needCalTotal);
    }

    public void calQtysByQtys(int i, String key) {
        switch (key) {
            case "alterqty": {
                this.calQtysByAlterQty(i);
                break;
            }
            case "qty": {
                this.calQtysByQty(i);
                break;
            }
            case "alterassistqty": {
                this.calQtysByAlterAssistQty(i);
                break;
            }
            case "assistqty": {
                this.calQtysByAssistQty(i);
                break;
            }
        }
    }

    @Override
    public void calByAlterQty(int i, boolean needCalTotal) {
        this.calByQtys(i, "alterqty", needCalTotal);
    }

    @Override
    public void calByQty(int i, boolean needCalTotal) {
        this.calByQtys(i, "qty", needCalTotal);
    }

    @Override
    public void calByAlterAssistQty(int i, boolean needCalTotal) {
        this.calByQtys(i, "alterassistqty", needCalTotal);
    }

    @Override
    public void calByAssistQty(int i, boolean needCalTotal) {
        this.calByQtys(i, "assistqty", needCalTotal);
    }

    public void calTaxPriceAndPrice(int i) {
        if (this.hasTax()) {
            this.calTaxPrice(i);
            this.calPrice(i);
        } else {
            this.calPrice(i);
            this.calTaxPrice(i);
        }
    }

    public void calDealPriceAmount() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calTaxAmount(i);
            this.calActualTaxPrice(i);
            this.calHightPriceRatio(i);
            this.calTax(i);
            this.calAmount(i);
            this.calLocalTaxAmount(i);
            this.calLocalTax(i);
            this.calLocalAmount(i);
        }
    }

    @Override
    public void calByResetPrimPrice(int i, boolean needCalTotal) {
        this.resetPrimPrice(i);
        this.calPrimAmount(i);
        this.calTaxPriceAndPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    public void resetPrimPrice(int i) {
        if (SaleOrderUtil.isThisStatus(this.order, SaleOrderStatus.CHANGING) && SysParamsUtil.isAlterPriceResetPrice() || SaleOrderUtil.isThisStatus(this.order, SaleOrderStatus.TEMP_SAVE)) {
            this.setValue("primprice", (Object)this.getSysPrice(i), i);
        }
    }

    public BigDecimal getSysPrice(int i) {
        DynamicObject entry = this.getEntry(i);
        DynamicObject item = entry.getDynamicObject("item");
        Object itemPK = DynamicObjectUtils.getDynamicObjectID(entry, "item");
        if (itemPK == null) {
            return entry.getBigDecimal("price");
        }
        Object ownerPk = DynamicObjectUtils.getDynamicObjectID(this.order, "owner");
        Object customerPk = DynamicObjectUtils.getDynamicObjectID(this.order, "customer");
        Object unitPK = DynamicObjectUtils.getDynamicObjectID(entry, "unit");
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        Date date = new Date();
        if (SysParamsUtil.isPriceByConfirmarrivedate()) {
            date = entry.getDate("entryconfirmarrivaldate");
        }
        DynamicObject assistAttr = entry.getDynamicObject("assistattr");
        BigDecimal itemPrice = BigDecimal.ZERO;
        if (!item.getBoolean("hasattr") || assistAttr != null) {
            Object assistAttrId = 0L;
            if (assistAttr != null) {
                assistAttrId = assistAttr.get("id");
            }
            itemPrice = OrderAlgorithm.loadPrice(ownerPk, customerPk, itemPK, unitPK, assistAttrId, qty, date);
        }
        return itemPrice;
    }

    public BigDecimal getSysPrice(DynamicObject entry, DetailItemInfo iteminfo, BigDecimal qty) {
        if (entry == null) {
            return BigDecimal.ZERO;
        }
        Object ownerPk = DynamicObjectUtils.getDynamicObjectID(this.order, "owner");
        Object customerPk = DynamicObjectUtils.getDynamicObjectID(this.order, "customer");
        Date date = new Date();
        if (SysParamsUtil.isPriceByConfirmarrivedate()) {
            date = entry.getDate("entryconfirmarrivaldate");
        }
        BigDecimal itemPrice = OrderAlgorithm.loadPrice(ownerPk, customerPk, iteminfo.getItemid(), iteminfo.getUnitid(), iteminfo.getAttrid(), qty, date);
        return itemPrice;
    }

    public static BigDecimal loadPrice(Object ownerPk, Object customerPk, Object itemPK, Object unitPK, Object assistAttrId, BigDecimal qty, Date date) {
        return PriceUtil.getItemPrice(ownerPk, customerPk, itemPK, unitPK, assistAttrId, qty, date);
    }

    @Override
    public void calByPrice(int i, boolean needCalTotal) {
        this.calTaxPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    @Override
    public void calByTaxRate(int i, boolean needCalTotal) {
        if (this.hasTax()) {
            this.calPrice(i);
            this.calTax(i);
            this.calAmount(i);
            this.calLocalTax(i);
            this.calLocalAmount(i);
            if (needCalTotal) {
                this.calTotalFields();
            }
        } else {
            this.calByPrice(i, needCalTotal);
        }
    }

    @Override
    public void calByTaxPrice(int i, boolean needCalTotal) {
        this.calPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    @Override
    public void calByDiscountType(int i, boolean needCalTotal) {
        this.calDiscountByDiscountType(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calCombDiscount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    @Override
    public void calByDiscount(int i, boolean needCalTotal) {
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calCombDiscount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    @Override
    public void calByDiscountAmount(int i, boolean needCalTotal) {
        this.calDiscountByDiscountAmount(i);
        this.calItemAmount(i);
        this.calCombDiscount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    @Override
    public void calByItemAmount(int i, boolean needCalTotal) {
        this.calPirceByItemAmount(i);
        this.calDiscountAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    public void calPirceByItemAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        String discountType = entry.getString("discounttype");
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal itemAmount = BigDecimalUtil.getNullToZero(entry, "itemamount");
        if (StringUtils.isEmpty(discountType)) {
            if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                taxPrice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
            }
        } else {
            DiscountModeEnum discountMode = EnumUtil.toDiscountMode(discountType);
            BigDecimal discount = BigDecimalUtil.getNullToZero(entry, "discount");
            switch (discountMode) {
                case PERCENT: {
                    if (itemAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (discount.compareTo(BigDecimal.ZERO) != 0) {
                        discount = discount.divide(BigDecimalConstants.ONEHUNDRED, discount.scale() + 2, RoundingMode.HALF_UP);
                    }
                    if (discount.compareTo(BigDecimalConstants.ONEHUNDRED) == 0) break;
                    taxPrice = itemAmount.divide(qty.multiply(BigDecimal.ONE.subtract(discount)), this.pricePrecision, RoundingMode.HALF_UP);
                    break;
                }
                case PERUNIT: {
                    if (itemAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    taxPrice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP).add(discount);
                    break;
                }
            }
        }
        this.setValue("taxprice", (Object)taxPrice, i);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero(entry, "taxrate");
        if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, RoundingMode.HALF_UP);
        }
        BigDecimal price = taxPrice.divide(BigDecimal.ONE.add(taxRate), this.pricePrecision, RoundingMode.HALF_UP);
        this.setValue("price", (Object)price, i);
    }

    @Override
    public void calByExchangeRate() {
        this.calAllLocalAmount();
        this.calTotalFields();
    }

    public void calAllLocalAmount() {
        int entrySize = this.getEntrySize();
        for (int i = 0; i < entrySize; ++i) {
            this.calLocalTaxAmount(i);
            this.calLocalTax(i);
            this.calLocalAmount(i);
        }
    }

    public boolean calQtysByAlterAssistQty(int i) {
        DynamicObject assisUnit;
        DynamicObject unit;
        boolean needCal = false;
        DynamicObject orderEntry = this.getEntry(i);
        BigDecimal alterAssistQty = orderEntry.getBigDecimal("alterassistqty");
        DynamicObject item = orderEntry.getDynamicObject("item");
        Object itemId = item.get("id");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) && (unit = orderEntry.getDynamicObject("unit")) != null && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            needCal = true;
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            qty = this.getUnitFormHandler().getQtyFromAssistUnit(itemId, assisUnit.get("id"), alterAssistQty, unit.get("id"));
            BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit.get("id"));
            this.setValue("alterqty", (Object)qty, i);
            this.setValue("qty", (Object)qty, i);
            this.setValue("baseqty", (Object)baseQty, i);
        }
        this.setValue("assistqty", (Object)alterAssistQty, i);
        return needCal;
    }

    public boolean calQtysByAssistQty(int i) {
        DynamicObject unit;
        boolean needCal = false;
        DynamicObject orderEntry = this.getEntry(i);
        DynamicObject item = orderEntry.getDynamicObject("item");
        Object itemId = item.get("id");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) && (unit = orderEntry.getDynamicObject("unit")) != null) {
            BigDecimal assistQty = orderEntry.getBigDecimal("assistqty");
            DynamicObject assisUnit = orderEntry.getDynamicObject("assistunit");
            needCal = true;
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            qty = this.getUnitFormHandler().getQtyFromAssistUnit(itemId, assisUnit.get("id"), assistQty, unit.get("id"));
            BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit.get("id"));
            this.setValue("qty", (Object)qty, i);
            this.setValue("baseqty", (Object)baseQty, i);
        }
        return needCal;
    }

    public void calQtysByAlterQty(int i) {
        DynamicObject assisUnit;
        DynamicObject orderEntry = this.getEntry(i);
        DynamicObject item = orderEntry.getDynamicObject("item");
        if (item == null) {
            return;
        }
        Object itemId = item.get("id");
        BigDecimal alterQty = orderEntry.getBigDecimal("alterqty");
        DynamicObject unit = orderEntry.getDynamicObject("unit");
        BigDecimal alterBaseQty = this.getUnitFormHandler().getBaseQty(itemId, alterQty, unit.get("id"));
        BigDecimal alterAssistQty = orderEntry.getBigDecimal("alterassistqty");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            alterAssistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), alterBaseQty);
        }
        this.setValue("alterbaseqty", (Object)alterBaseQty, i);
        this.setValue("baseqty", (Object)alterBaseQty, i);
        this.setValue("alterassistqty", (Object)alterAssistQty, i);
        this.setValue("assistqty", (Object)alterAssistQty, i);
        this.setValue("qty", (Object)alterQty, i);
    }

    public void calQtysByQtyAndAlterQty(int i) {
        DynamicObject assisUnit;
        DynamicObject orderEntry = this.getEntry(i);
        DynamicObject item = orderEntry.getDynamicObject("item");
        if (item == null) {
            return;
        }
        Object itemId = item.get("id");
        BigDecimal alterQty = orderEntry.getBigDecimal("alterqty");
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        DynamicObject unit = orderEntry.getDynamicObject("unit");
        BigDecimal alterBaseQty = this.getUnitFormHandler().getBaseQty(itemId, alterQty, unit.get("id"));
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit.get("id"));
        BigDecimal alterAssistQty = orderEntry.getBigDecimal("alterassistqty");
        BigDecimal assistqty = orderEntry.getBigDecimal("assistqty");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            alterAssistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), alterBaseQty);
            assistqty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
        }
        this.setValue("alterbaseqty", (Object)alterBaseQty, i);
        this.setValue("baseqty", (Object)baseQty, i);
        this.setValue("alterassistqty", (Object)alterAssistQty, i);
        this.setValue("assistqty", (Object)assistqty, i);
    }

    public void calQtysByQty(int i) {
        DynamicObject assisUnit;
        DynamicObject orderEntry = this.getEntry(i);
        DynamicObject item = orderEntry.getDynamicObject("item");
        Object itemId = item.get("id");
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        DynamicObject unit = orderEntry.getDynamicObject("unit");
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit.get("id"));
        BigDecimal assistQty = orderEntry.getBigDecimal("assistqty");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
        }
        this.setValue("baseqty", (Object)baseQty, i);
        this.setValue("assistqty", (Object)assistQty, i);
    }

    public void calOtherAfterCalQty(int i, boolean needCalTotal) {
        this.resetPrimPrice(i);
        this.calPrimAmount(i);
        this.calTaxPriceAndPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    public void calByRebateAmount() {
    }

    @Override
    public void reCalFields() {
        this.reCalQtyFields();
        this.reCalPirceAmonutFields();
        this.calTotalFields();
    }

    public void reCalWholeOrderByItemAmount() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calQtysByQty(i);
            this.calPrimAmount(i);
            this.calPirceByItemAmount(i);
            this.calDiscountAmount(i);
        }
        this.calDealPriceAmount();
        this.calTotalFields();
        this.calBotpDiscount();
    }

    public void reCalFields(int i, boolean needCalTotal) {
        if (SaleOrderEntryType.COMBINATION != this.getEntryType(i)) {
            this.calQtysByInitQty(i);
        }
        this.calOtherAfterCalQty(i, needCalTotal);
        if (needCalTotal) {
            this.calTotalFields();
        }
    }

    public void calQtysByInitQty(int i) {
        DynamicObject assisUnit;
        DynamicObject orderEntry = this.getEntry(i);
        DynamicObject item = orderEntry.getDynamicObject("item");
        Object itemId = item.get("id");
        BigDecimal alterQty = orderEntry.getBigDecimal("alterqty");
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        DynamicObject unit = orderEntry.getDynamicObject("unit");
        BigDecimal alterBaseQty = this.getUnitFormHandler().getBaseQty(itemId, alterQty, unit.get("id"));
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit.get("id"));
        BigDecimal alterAssistQty = orderEntry.getBigDecimal("alterassistqty");
        BigDecimal assistQty = orderEntry.getBigDecimal("assistqty");
        String conversionfor = item.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject("assistunit")) != null) {
            alterAssistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), alterBaseQty);
            assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
        }
        this.setValue("alterbaseqty", (Object)alterBaseQty, i);
        this.setValue("baseqty", (Object)baseQty, i);
        this.setValue("alterassistqty", (Object)alterAssistQty, i);
        this.setValue("assistqty", (Object)assistQty, i);
    }

    public void reCalQtyFields() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            SaleOrderEntryType entryType;
            if (!this.isEntryAavailable(i) || (entryType = this.getEntryType(i)) == SaleOrderEntryType.COMBINATION) continue;
            this.calQtysByInitQty(i);
        }
    }

    public void reCalPirceAmonutFields() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (!this.isEntryAavailable(i)) continue;
            this.calTaxPriceAndPrice(i);
            SaleOrderEntryType entryType = this.getEntryType(i);
            if (entryType != SaleOrderEntryType.COMBINATION_SON) {
                this.calDiscountAmount(i);
                if (entryType == SaleOrderEntryType.COMBINATION) {
                    this.calCombDiscount(i);
                }
            }
            this.calItemAmount(i);
        }
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        this.calBotpDiscount();
    }

    @Override
    public void calPrimAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal primprice = BigDecimalUtil.getNullToZero(entry, "primprice");
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        this.setValue("primamount", (Object)primprice.multiply(qty).setScale(this.amountPrecision, 4), i);
    }

    @Override
    public void calTaxPrice(int i) {
        DynamicObject entry = this.getEntry(i);
        if (this.hasTax()) {
            if (!this.hasCustChangePrice(i)) {
                BigDecimal primPrice = BigDecimalUtil.getNullToZero(entry, "primprice");
                this.setValue("taxprice", (Object)primPrice, i);
            }
        } else {
            BigDecimal price = BigDecimalUtil.getNullToZero(entry, "price");
            BigDecimal taxRate = BigDecimalUtil.getNullToZero(entry, "taxrate");
            BigDecimal taxPrice = null;
            if (price != null) {
                taxRate = taxRate == null ? BigDecimalConstants.ZERO : taxRate;
                BigDecimal one = BigDecimalConstants.ONE;
                BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
                taxRate = taxRate.divide(oneHundred, taxRate.scale() + 2, RoundingMode.HALF_UP);
                taxPrice = price.multiply(one.add(taxRate));
                taxPrice = taxPrice.setScale(this.pricePrecision, RoundingMode.HALF_UP);
            }
            this.setValue("taxprice", taxPrice, i);
        }
    }

    @Override
    public void calPrice(int i) {
        DynamicObject entry = this.getEntry(i);
        if (this.hasTax()) {
            this.calPriceByTaxPrice(i);
        } else if (!this.hasCustChangePrice(i)) {
            BigDecimal primPrice = BigDecimalUtil.getNullToZero(entry, "primprice");
            this.setValue("price", (Object)primPrice, i);
        }
    }

    public void calPriceByTaxPrice(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero(entry, "taxprice");
        BigDecimal taxRate = BigDecimalUtil.getNullToZero(entry, "taxrate");
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, RoundingMode.HALF_UP);
            price = taxPrice.divide(one.add(taxRate), this.pricePrecision, RoundingMode.HALF_UP);
        }
        this.setValue("price", (Object)price, i);
    }

    @Override
    public void calDiscountByDiscountAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        int discountRatePrecision = 2;
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero(entry, "taxprice");
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        BigDecimal discountAmount = BigDecimalUtil.getNullToZero(entry, "discountamount");
        String discountType = entry.getString("discounttype");
        DiscountModeEnum discountMode = EnumUtil.toDiscountMode(discountType);
        BigDecimal discountRate = BigDecimal.ZERO;
        if (discountAmount != null && discountAmount.compareTo(BigDecimal.ZERO) != 0) {
            switch (discountMode) {
                case PERCENT: {
                    discountRate = discountAmount.multiply(BigDecimalConstants.ONEHUNDRED).divide(qty.multiply(taxPrice), discountRatePrecision, 4);
                    break;
                }
                case PERUNIT: {
                    discountRate = discountAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
                    break;
                }
            }
        }
        this.setValue("discount", (Object)discountRate, i);
    }

    @Override
    public void calDiscountByDiscountType(int i) {
        block7: {
            block6: {
                DynamicObject entry = this.getEntry(i);
                String discountType = entry.getString("discounttype");
                if (!StringUtils.isNotEmpty(discountType)) break block6;
                DiscountModeEnum discountMode = EnumUtil.toDiscountMode(discountType);
                BigDecimal discount = BigDecimalUtil.getNullToZero(entry, "discount");
                switch (discountMode) {
                    case PERCENT: {
                        if (BigDecimalConstants.ONEHUNDRED.compareTo(discount) < 0) {
                            this.setValue("discount", (Object)BigDecimalConstants.ZERO, i);
                            break;
                        }
                        break block7;
                    }
                    case PERUNIT: {
                        BigDecimal taxprice = BigDecimalUtil.getNullToZero(entry, "taxprice");
                        if (discount == null || discount.compareTo(taxprice) > 0) {
                            this.setValue("discount", (Object)BigDecimalConstants.ZERO, i);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        this.setValue("discount", (Object)BigDecimalConstants.ZERO, i);
                        break;
                    }
                }
                break block7;
            }
            this.setValue("discount", (Object)BigDecimalConstants.ZERO, i);
        }
    }

    @Override
    public void calDiscountAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero(entry, "taxprice");
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        BigDecimal discountRate = BigDecimalUtil.getNullToZero(entry, "discount");
        String discountType = entry.getString("discounttype");
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty(discountType)) {
            DiscountModeEnum discountMode = EnumUtil.toDiscountMode(discountType);
            switch (discountMode) {
                case PERCENT: {
                    discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4));
                    break;
                }
                case PERUNIT: {
                    discountAmount = qty.multiply(discountRate);
                    break;
                }
            }
        }
        this.setValue("discountamount", (Object)discountAmount, i);
    }

    @Override
    public void calItemAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero(entry, "taxprice");
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        BigDecimal discountAmount = BigDecimalUtil.getNullToZero(entry, "discountamount");
        BigDecimal itemAmount = taxPrice.multiply(qty).subtract(discountAmount).setScale(this.amountPrecision, RoundingMode.HALF_UP);
        this.setValue("itemamount", (Object)itemAmount, i);
    }

    @Override
    public void calPromotionAmount() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            DynamicObject entry = this.getEntry(i);
            BigDecimal itemAmount = BigDecimalUtil.getNullToZero(entry, "itemamount");
            this.setValue("promotionamount", (Object)itemAmount, i);
        }
    }

    @Override
    public void calRebateAmount() {
        BigDecimal promotionAmount = null;
        BigDecimal entryUsedRebate = null;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            DynamicObject entry = this.getEntry(i);
            promotionAmount = BigDecimalUtil.getNullToZero(entry, "promotionamount");
            entryUsedRebate = BigDecimalUtil.getNullToZero(entry, "entryusedrebate");
            this.setValue("rebateamount", (Object)promotionAmount.subtract(entryUsedRebate), i);
        }
    }

    @Override
    public void calTaxAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        this.setValue("taxamount", entry.get("rebateamount"), i);
    }

    @Override
    public void calActualTaxPrice(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxAmount = BigDecimalUtil.getNullToZero(entry, "taxamount");
        BigDecimal rebateAmount = BigDecimalUtil.getNullToZero(entry, "rebateamount");
        BigDecimal promotionAmount = BigDecimalUtil.getNullToZero(entry, "promotionamount");
        BigDecimal primAmount = BigDecimalUtil.getNullToZero(entry, "primamount");
        if (taxAmount.compareTo(primAmount) == 0 && taxAmount.compareTo(rebateAmount) == 0 && taxAmount.compareTo(promotionAmount) == 0) {
            this.setValue("actualtaxprice", entry.get("taxprice"), i);
        } else {
            BigDecimal actualtaxprice = BigDecimal.ZERO;
            BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) != 0) {
                actualtaxprice = taxAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
            }
            this.setValue("actualtaxprice", (Object)actualtaxprice, i);
        }
    }

    @Override
    public void calHightPriceRatio(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal actualTaxPrice = BigDecimalUtil.getNullToZero(entry, "actualtaxprice");
        BigDecimal primPrice = BigDecimalUtil.getNullToZero(entry, "primprice");
        BigDecimal ratio = BigDecimal.ZERO;
        if (primPrice.compareTo(BigDecimal.ZERO) != 0 && actualTaxPrice.subtract(primPrice).compareTo(BigDecimal.ZERO) != 0) {
            ratio = actualTaxPrice.subtract(primPrice).divide(primPrice, 2, RoundingMode.HALF_UP);
        }
        this.setValue("hightpriceratio", (Object)ratio, i);
    }

    @Override
    public void calTax(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxAmount = BigDecimalUtil.getNullToZero(entry, "taxamount");
        BigDecimal taxRate = BigDecimalUtil.getNullToZero(entry, "taxrate");
        BigDecimal tax = BigDecimalConstants.ZERO;
        if (taxAmount != null && taxRate != null) {
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
            tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
        }
        this.setValue("tax", (Object)tax, i);
    }

    @Override
    public void calAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxAmount = BigDecimalUtil.getNullToZero(entry, "taxamount");
        BigDecimal tax = BigDecimalUtil.getNullToZero(entry, "tax");
        BigDecimal amount = taxAmount.subtract(tax);
        this.setValue("amount", (Object)amount, i);
    }

    @Override
    public void calLocalTaxAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal taxAmount = BigDecimalUtil.getNullToZero(entry, "taxamount");
        BigDecimal exchangerate = BigDecimalUtil.getNullToZero(this.order, "exchangerate");
        if (BigDecimalConstants.ZERO.compareTo(exchangerate) != 0) {
            BigDecimal localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.localAmountPrecision, 4);
            this.setValue("localtaxamount", (Object)localTaxAmount, i);
        } else {
            this.setValue("localtaxamount", (Object)taxAmount, i);
        }
    }

    @Override
    public void calLocalTax(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal tax = BigDecimalUtil.getNullToZero(entry, "tax");
        BigDecimal exchangerate = BigDecimalUtil.getNullToZero(this.order, "exchangerate");
        if (BigDecimalConstants.ZERO.compareTo(exchangerate) != 0) {
            BigDecimal localTax = tax.multiply(exchangerate).setScale(this.localAmountPrecision, 4);
            this.setValue("localtax", (Object)localTax, i);
        } else {
            this.setValue("localtax", (Object)tax, i);
        }
    }

    @Override
    public void calLocalAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal LocalTaxAmount = BigDecimalUtil.getNullToZero(entry, "localtaxamount");
        BigDecimal LocalTax = BigDecimalUtil.getNullToZero(entry, "localtax");
        this.setValue("localamount", (Object)LocalTaxAmount.subtract(LocalTax), i);
    }

    @Override
    public void calTotalAlterQty() {
        this.setValue("totalalterqty", this.sumEntryFiled("alterqty"));
    }

    @Override
    public void calTotalQty() {
        this.setValue("totalqty", this.sumEntryFiled("qty"));
    }

    @Override
    public void calTotalAlterBaseQty() {
        this.setValue("totalalterbaseqty", this.sumEntryFiled("alterbaseqty"));
    }

    @Override
    public void calTotalBaseQty() {
        this.setValue("totalbaseqty", this.sumEntryFiled("baseqty"));
    }

    @Override
    public void calTotalAlterAssistQty() {
        this.setValue("totalalterassistqty", this.sumEntryFiled("alterassistqty"));
    }

    @Override
    public void calTotalAssistQty() {
        this.setValue("totalassistqty", this.sumEntryFiled("assistqty"));
    }

    @Override
    public void calTotalOrderAmount() {
        this.setValue("totalorderamount", this.sumEntryFiled("taxamount"));
    }

    @Override
    public void calTotalDiscountAmount() {
        this.setValue("totaldiscountamount", this.sumEntryFiled("discountamount"));
    }

    @Override
    public void calTotalPromotionAmount() {
        BigDecimal totalItemAmount = BigDecimalUtil.getNullToZero(this.order, "totalitemamount");
        BigDecimal totalpromotionAmount = this.sumEntryFiled("promotionamount");
        this.setValue("totalpromotionamount", totalItemAmount.subtract(totalpromotionAmount));
    }

    @Override
    public void calTotalRebateAmount() {
        BigDecimal totalpromotionAmount = this.sumEntryFiled("promotionamount");
        BigDecimal totalRebateAmount = this.sumEntryFiled("rebateamount");
        this.setValue("totalrebateamount", totalpromotionAmount.subtract(totalRebateAmount));
    }

    public void calTotalPrimAmount() {
        this.setValue("totalprimamount", this.sumEntryFiled("primamount"));
    }

    public void calTotalItemAmount() {
        this.setValue("totalitemamount", this.sumEntryFiled("itemamount"));
    }

    public void calAmountTobePaid() {
        BigDecimal totalOrderAmount = BigDecimalUtil.getNullToZero(this.order, "totalorderamount");
        BigDecimal receivedamount = BigDecimalUtil.getNullToZero(this.order, "receivedamount");
        this.setValue("amounttobepaid", totalOrderAmount.subtract(receivedamount));
    }

    public void calTotalHightPriceRatio() {
        BigDecimal totalItemAmount = BigDecimalUtil.getNullToZero(this.order, "totalitemamount");
        BigDecimal totalpromotionAmount = this.sumEntryFiled("promotionamount");
        this.setValue("totalhightpriceratio", totalItemAmount.subtract(totalpromotionAmount));
    }

    @Override
    public void calTotalFields() {
        this.calTotalAlterQty();
        this.calTotalQty();
        this.calTotalAlterBaseQty();
        this.calTotalBaseQty();
        this.calTotalAlterAssistQty();
        this.calTotalAssistQty();
        this.calTotalPrimAmount();
        this.calTotalItemAmount();
        this.calTotalOrderAmount();
        this.calAmountTobePaid();
        this.calTotalHightPriceRatio();
        this.calTotalDiscountAmount();
        this.calTotalPromotionAmount();
        this.calTotalRebateAmount();
    }

    protected void setAmountPrecision(int precision) {
        this.amountPrecision = precision;
    }

    protected void setLocalAmountPrecision(int precision) {
        this.localAmountPrecision = precision;
    }

    public boolean hasTax() {
        return this.order.getBoolean("hastax");
    }

    public BigDecimal sumEntryFiled(String key) {
        return this.sumEntryFiled(key, false);
    }

    public BigDecimal sumEntryFiled(String key, boolean includeComb) {
        DynamicObjectCollection entrys = this.getEntry();
        BigDecimal totleValue = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            SaleOrderEntryType entryType = this.getEntryType(entry);
            if (entryType == SaleOrderEntryType.COMBINATION || !this.isEntryAavailable(entry)) continue;
            BigDecimal value = BigDecimalUtil.getNullToZero(entry, key);
            totleValue = totleValue.add(value);
        }
        return totleValue;
    }

    public boolean hasCustChangePrice(int i) {
        DynamicObject entry = this.getEntry(i);
        return entry.getBoolean("custchangeprice");
    }

    @Override
    public DynamicObjectCollection getEntry() {
        return this.entry;
    }

    @Override
    public DynamicObject getEntry(int i) {
        return (DynamicObject)this.getEntry().get(i);
    }

    public int getEntrySize() {
        DynamicObjectCollection entrys = this.getEntry();
        if (entrys == null) {
            return 0;
        }
        return entrys.size();
    }

    @Override
    public String getEntryKey() {
        return "itementry";
    }

    @Override
    public int addEntry() {
        this.getEntry().addNew();
        return this.getEntrySize() - 1;
    }

    @Override
    public int[] batchAddEntry(int i) {
        int[] indexs = new int[i];
        for (int j = 0; j < i; ++j) {
            int index;
            indexs[j] = index = this.addEntry();
        }
        return indexs;
    }

    @Override
    public void insertEntry(int i) {
        this.getEntry().add(i, this.getNewEntry());
    }

    @Override
    public void insertEntry(int i, DynamicObject entry) {
        this.getEntry().add(i, entry);
    }

    @Override
    public DynamicObject getNewEntry() {
        DynamicObjectType dt = this.getEntry().getDynamicObjectType();
        return new DynamicObject(dt);
    }

    @Override
    public Object getValue(String key) {
        if (this.order == null) {
            return null;
        }
        return this.order.get(key);
    }

    @Override
    public Object getValue(String key, int i) {
        DynamicObject entry = this.getEntry(i);
        if (entry == null) {
            return null;
        }
        return entry.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        if (this.order == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u8ba1\u7b97\u5931\u8d25\uff1a\u8ba2\u5355\u672a\u7a7a\uff0c\u8bbe\u7f6e\u503c%s\u5931\u8d25\uff01", (String)"OrderAlgorithm_0", (String)"drp-mdr-common", (Object[])new Object[0]), key));
        }
        this.order.set(key, value);
    }

    @Override
    public void setValue(String key, Object value, int i) {
        DynamicObject entry = this.getEntry(i);
        if (entry == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u8ba1\u7b97\u5931\u8d25\uff1a\u8ba2\u5355\u5206\u5f55\u672a\u7a7a\uff0c\u8bbe\u7f6e\u503c%s\u5931\u8d25\uff01", (String)"OrderAlgorithm_1", (String)"drp-mdr-common", (Object[])new Object[0]), key));
        }
        entry.set(key, value);
    }

    public Object getEntryId(int i) {
        DynamicObject entry = this.getEntry(i);
        if (entry == null) {
            return null;
        }
        return entry.getPkValue();
    }

    protected SaleOrderEntryType getEntryType(int i) {
        return this.getEntryType(this.getEntry(i));
    }

    protected SaleOrderEntryType getEntryType(DynamicObject entry) {
        String entrytype = entry.getString("entrytype");
        if (StringUtils.isEmpty(entrytype)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5206\u5f55\u7c7b\u578b\u4e3a\u7a7a", (String)"OrderAlgorithm_2", (String)"drp-mdr-common", (Object[])new Object[0]), entry.get("seq")));
        }
        return EnumUtil.toSaleOrderEntryType(entrytype);
    }

    protected boolean isEntryAavailable(int i) {
        DynamicObject entry = this.getEntry(i);
        return this.isEntryAavailable(entry);
    }

    protected boolean isEntryAavailable(DynamicObject entry) {
        if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype"))) {
            return entry.get("combitem") != null;
        }
        if (entry.get("item") == null || entry.get("unit") == null) {
            return false;
        }
        boolean hasAssistAttr = this.hasAssistAttr(entry.getDynamicObject("item"));
        return !hasAssistAttr || entry.get("assistattr") != null;
    }

    @Override
    public UnitFormHandler getUnitFormHandler() {
        if (this.unitFromHandler == null) {
            this.unitFromHandler = new UnitFormHandler(this.pageCache);
        }
        return this.unitFromHandler;
    }

    protected boolean hasAssistAttr(DynamicObject item) {
        boolean hasattr = false;
        if (item != null) {
            hasattr = item.getBoolean("hasattr");
        }
        return hasattr;
    }

    public void calBotpDiscount() {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calBotpDiscount(i);
        }
    }

    public void calBotpDiscount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
        BigDecimal itemAmount = BigDecimalUtil.getNullToZero(entry, "itemamount");
        String discountType = entry.getString("discounttype");
        BigDecimal discountAmount = BigDecimalUtil.getNullToZero(entry, "discountamount");
        BigDecimal discountRate = BigDecimalUtil.getNullToZero(entry, "discount");
        BigDecimal promotionAmount = BigDecimalUtil.getNullToZero(entry, "promotionamount");
        BigDecimal rebateamount = BigDecimalUtil.getNullToZero(entry, "rebateamount");
        BigDecimal entryUsedRebateAmount = promotionAmount.subtract(rebateamount);
        BigDecimal entryUsedPromotionAmount = itemAmount.subtract(promotionAmount);
        if (BigDecimal.ZERO.compareTo(entryUsedRebateAmount) == 0 && BigDecimal.ZERO.compareTo(entryUsedPromotionAmount) == 0 && BigDecimal.ZERO.compareTo(itemAmount) != 0 && BigDecimal.ZERO.compareTo(discountAmount) != 0) {
            this.setValue("botpdiscounttype", (Object)discountType, i);
            this.setValue("botpdiscountamount", (Object)discountAmount, i);
            this.setValue("botpdiscount", (Object)discountRate, i);
        } else if (BigDecimal.ZERO.compareTo(itemAmount) != 0 && BigDecimal.ZERO.compareTo(qty) != 0 && (BigDecimal.ZERO.compareTo(entryUsedRebateAmount) != 0 || BigDecimal.ZERO.compareTo(entryUsedPromotionAmount) != 0)) {
            this.setValue("botpdiscounttype", (Object)DiscountModeEnum.PERUNIT.getFlagStr(), i);
            BigDecimal botpDiscountAmount = itemAmount.subtract(rebateamount).add(discountAmount);
            this.setValue("botpdiscountamount", (Object)botpDiscountAmount, i);
            BigDecimal botpDiscountRate = BigDecimal.ZERO;
            if (botpDiscountAmount.compareTo(BigDecimal.ZERO) != 0) {
                botpDiscountRate = botpDiscountAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
            }
            this.setValue("botpdiscount", (Object)botpDiscountRate, i);
        } else {
            this.setValue("botpdiscounttype", (Object)DiscountModeEnum.NULL.toString(), i);
            this.setValue("botpdiscountamount", (Object)BigDecimal.ZERO, i);
            this.setValue("botpdiscount", (Object)BigDecimal.ZERO, i);
        }
    }

    public Set<Integer> getCombItemSonEntrys(int i) {
        HashSet<Integer> rows = new HashSet<Integer>();
        SaleOrderEntryType entryType = this.getEntryType(i);
        Object entryId = this.getEntryId(i);
        if (entryType != SaleOrderEntryType.COMBINATION) {
            return rows;
        }
        for (int j = 0; j < this.getEntrySize(); ++j) {
            if (i == j || SaleOrderEntryType.COMBINATION_SON != (entryType = this.getEntryType(j))) continue;
            String parententryid = (String)this.getValue("parententryid", j);
            if (!entryId.toString().equals(parententryid)) continue;
            rows.add(j);
        }
        return rows;
    }

    public Integer getMaxAmountId(Set<Integer> rows) {
        BigDecimal maxAmount = BigDecimal.ZERO;
        Integer maxId = 0;
        BigDecimal amount = BigDecimal.ZERO;
        for (Integer integer : rows) {
            amount = BigDecimalUtil.getNullToZero(this.getEntry(integer), "itemamount");
            if (amount.compareTo(maxAmount) <= 0) continue;
            maxAmount = amount;
            maxId = integer;
        }
        return maxId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calCombDiscount(int i) {
        SaleOrderEntryType entryType = this.getEntryType(i);
        if (entryType != SaleOrderEntryType.COMBINATION) return;
        Set<Integer> rows = this.getCombItemSonEntrys(i);
        DynamicObject entry = this.getEntry(i);
        String discountType = entry.getString("discounttype");
        if (StringUtils.isNotEmpty(discountType)) {
            DiscountModeEnum discountMode = EnumUtil.toDiscountMode(discountType);
            switch (discountMode) {
                case PERCENT: {
                    BigDecimal discount = BigDecimalUtil.getNullToZero(entry, "discount");
                    for (Integer integer : rows) {
                        this.setValue("discount", discount, integer, false);
                        this.calDiscountAmount(integer);
                        this.calItemAmount(integer);
                    }
                    return;
                }
                case PERUNIT: {
                    BigDecimal taxPrice = BigDecimalUtil.getNullToZero(entry, "taxprice");
                    BigDecimal qty = BigDecimalUtil.getNullToZero(entry, "qty");
                    BigDecimal combitemAmount = taxPrice.multiply(qty).setScale(this.amountPrecision, RoundingMode.HALF_UP);
                    BigDecimal discountAmount = BigDecimalUtil.getNullToZero(entry, "discountamount");
                    if (combitemAmount.compareTo(BigDecimal.ZERO) == 0 || discountAmount.compareTo(BigDecimal.ZERO) == 0) {
                        for (Integer sonindex : rows) {
                            this.setValue("discountamount", BigDecimal.ZERO, sonindex, false);
                            this.setValue("discount", BigDecimal.ZERO, sonindex, false);
                            this.calItemAmount(sonindex);
                        }
                        return;
                    }
                    Integer maxId = this.getMaxAmountId(rows);
                    BigDecimal alreadydiff = BigDecimal.ZERO;
                    BigDecimal sondiscountamount = BigDecimal.ZERO;
                    BigDecimal sondiscount = BigDecimal.ZERO;
                    for (Integer sonindex : rows) {
                        if (sonindex.compareTo(maxId) == 0) continue;
                        DynamicObject rowinfo = this.getEntry(sonindex);
                        taxPrice = BigDecimalUtil.getNullToZero(rowinfo, "taxprice");
                        qty = BigDecimalUtil.getNullToZero(rowinfo, "qty");
                        BigDecimal sonitemAmount = taxPrice.multiply(qty).setScale(this.amountPrecision, RoundingMode.HALF_UP);
                        sondiscountamount = discountAmount.multiply(sonitemAmount).divide(combitemAmount, this.amountPrecision, RoundingMode.HALF_UP);
                        alreadydiff = alreadydiff.add(sondiscountamount);
                        sondiscount = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sondiscountamount.divide(qty, this.amountPrecision, RoundingMode.HALF_UP);
                        this.setValue("discountamount", sondiscountamount, sonindex, false);
                        this.setValue("discount", sondiscount, sonindex, false);
                        this.calItemAmount(sonindex);
                    }
                    qty = BigDecimalUtil.getNullToZero(this.getEntry(maxId), "qty");
                    sondiscountamount = discountAmount.subtract(alreadydiff);
                    sondiscount = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sondiscountamount.divide(qty, this.amountPrecision, RoundingMode.HALF_UP);
                    this.setValue("discountamount", sondiscountamount, maxId, false);
                    this.setValue("discount", sondiscount, maxId, false);
                    this.calItemAmount(maxId);
                    return;
                }
            }
            return;
        }
        for (Integer sonindex : rows) {
            this.calItemAmount(sonindex);
        }
    }
}

