/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.mobile.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;
import kd.drp.mdr.mobile.model.FormModel;

public abstract class MdrFormIndexMobTemplate
extends MdrFormMobPlugin {
    private Map<String, MenuBarButton> menuBarButtons = new HashMap<String, MenuBarButton>();

    public MdrFormIndexMobTemplate() {
        this.initMenuBar();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Set<String> menuBarButtonsKeys = this.menuBarButtons.keySet();
        this.addClickListeners(menuBarButtonsKeys.toArray(new String[menuBarButtonsKeys.size()]));
    }

    protected abstract void initMenuBar();

    protected final void registerMenuBarButton(String button, String unenableButton, String showFlex) {
        this.menuBarButtons.put(button, new MenuBarButton(unenableButton, showFlex));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.menuBarButtons.containsKey(key)) {
            this.clickMenuBarButtons(key);
        }
    }

    protected void clickMenuBarButtons(String key) {
        IFormView formView = this.getChildView(key);
        if (formView == null) {
            this.openButtonLinkPage(key);
        } else {
            this.refreshButtonLinkPage(formView, key);
        }
        this.showPage(key);
    }

    protected void openButtonLinkPage(String button) {
        MenuBarButton menuBarButton = this.menuBarButtons.get(button);
        if (menuBarButton == null) {
            return;
        }
        FormModel formModel = this.getLinkFormModel(button);
        if (formModel == null) {
            return;
        }
        formModel.setTargetKey(menuBarButton.getShowFlex());
        formModel.setShowType(ShowType.InContainer);
        formModel.showPage((AbstractFormPlugin)this);
        IFormView view = this.getView().getView(formModel.getPageId());
        if (view instanceof MobileListView) {
            QFilter filter = this.getListChildPageQFilter(button);
            MobileControlUtils.BillListRefresh((BillList)view.getControl("billlistap"), filter);
            this.getView().sendFormAction(view);
        }
        this.getPageCache().put(button + this.getView().getPageId(), formModel.getPageId());
    }

    protected FormModel getLinkFormModel(String button) {
        return null;
    }

    private void refreshButtonLinkPage(IFormView view, String key) {
        if (view == null) {
            return;
        }
        FormShowParameter showParameter = view.getFormShowParameter();
        if (showParameter instanceof MobileFormShowParameter) {
            this.refreshChildPage((MobileFormView)view, key);
        } else if (view instanceof MobileListView) {
            this.refreshListChildPage((MobileListView)view, key);
        }
    }

    protected void refreshChildPage(MobileFormView view, String key) {
        IDataModel childmodel = view.getModel();
        this.setKeyChildModelValue(childmodel, key);
        this.refreshChildView((IFormView)view);
    }

    protected void setKeyChildModelValue(IDataModel childmodel, String key) {
        childmodel.setValue("customer", this.getF7PKValue("customer"));
        childmodel.setValue("owner", this.getF7PKValue("owner"));
    }

    protected void refreshListChildPage(MobileListView view, String key) {
        QFilter filter = this.getListChildPageQFilter(key);
        MobileControlUtils.BillListRefresh((BillList)view.getControl("billlistap"), filter);
        this.getView().sendFormAction((IFormView)view);
    }

    protected QFilter getListChildPageQFilter(String key) {
        return null;
    }

    protected void showPage(String key) {
        int size = this.menuBarButtons.size() * 2;
        HashSet<String> unenableKeys = new HashSet<String>(size);
        for (MenuBarButton menuBarButton : this.menuBarButtons.values()) {
            unenableKeys.add(menuBarButton.getUnenableButton());
            unenableKeys.add(menuBarButton.getShowFlex());
        }
        this.setDisVisible(unenableKeys.toArray(new String[size]));
        Set<String> menuBarButtonsKeys = this.menuBarButtons.keySet();
        this.setVisible(menuBarButtonsKeys.toArray(new String[menuBarButtonsKeys.size()]));
        MenuBarButton currentClickMenuBarButton = this.menuBarButtons.get(key);
        this.setDisVisible(key);
        this.setVisible(currentClickMenuBarButton.getUnenableButton(), currentClickMenuBarButton.getShowFlex());
    }

    protected final IFormView getChildView(String button) {
        String pageid = this.getPageCache().get(button + this.getView().getPageId());
        return this.getView().getView(pageid);
    }

    protected final void setChildViewValue(String button, String key, Object value) {
        IFormView view = this.getChildView(button);
        if (view == null) {
            return;
        }
        IDataModel model = view.getModel();
        model.setValue(key, value);
    }

    protected final void setChildViewValues(String button, Map<String, Object> values) {
        IDataModel model = this.getChildView(button).getModel();
        if (model == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
    }

    protected final void refreshChildView(String button) {
        IFormView view = this.getChildView(button);
        if (view == null) {
            return;
        }
        this.refreshChildView(view);
    }

    protected final void refreshChildView(IFormView subChildView) {
        this.getView().sendFormAction(subChildView);
    }

    private static class MenuBarButton {
        private String unenableButton;
        private String showFlex;

        public String getUnenableButton() {
            return this.unenableButton;
        }

        public String getShowFlex() {
            return this.showFlex;
        }

        public MenuBarButton(String unenableButton, String showFlex) {
            this.unenableButton = unenableButton;
            this.showFlex = showFlex;
        }
    }
}

