/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.mobile.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.OrderQuantityUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.formplugin.formhandler.UnitFormHandler;
import kd.drp.mdr.mobile.MobileControlUtils;
import kd.drp.mdr.mobile.model.FormModel;

public abstract class MdrShoppingCartMobTemplate
extends MdrFormMobPlugin
implements BeforeF7SelectListener {
    public static final String SHOPPING_CART_LIST = "shoppingcartlist";
    public static final String ITEM_LIST = "itemlist";
    public static final String BUT_DOWN_ORDER = "butdownorder";
    public static final String ORDER_AMOUNT = "orderamount";
    public static final String TOTAL_QTY = "totalqty";
    public static final String SHOPPINGCARTID = "shoppingcartid";
    public static final String CLEARSHOPPINGCART = "clearshoppingcart";
    public static final String ADDITEM = "additem";
    public static final String ASSISTATTR = "assistattr";
    public static final String ITEM = "item";
    public static final String ITEMPIC = "itempic";
    public static final String UNIT = "unit";
    public static final String ASSIST_UNIT = "assistunit";
    public static final String ASSISTINFO = "assistinfo";
    public static final String ASSISTUNITNAME = "assistunitname";
    public static final String PRICE = "price";
    public static final String QTY = "qty";
    public static final String ASSIST_QTY = "assistqty";
    public static final String DELETE = "delete";
    public static final String ADD = "add";
    public static final String REDUCE = "reduce";
    public static final String ASSIST_ADD = "assistadd";
    public static final String ASSIST_REDUCE = "assistreduce";
    public static final String MODIFY = "modify";
    public static final String ALLCHECK = "allcheck";
    public static final String SPLITKEY = "&";
    private UnitFormHandler unitFormHandler = null;
    protected boolean isAfterCreateNewData = false;

    @Override
    public UnitFormHandler getUnitFormHandler() {
        if (this.unitFormHandler == null) {
            this.unitFormHandler = new UnitFormHandler(this.getPageCache());
        }
        return this.unitFormHandler;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, ASSISTATTR);
        this.addClickListeners(new String[]{BUT_DOWN_ORDER, QTY, DELETE, MODIFY, ADD, REDUCE, ASSIST_REDUCE, ASSIST_ADD, CLEARSHOPPINGCART, ADDITEM});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "assistattr": {
                int index = this.getModel().getEntryCurrentRowIndex(ITEM_LIST);
                this.showItemAttr(index);
                e.setCancel(true);
            }
        }
    }

    protected void showItemAttr(int index) {
        Object shoppingcartId = this.getModel().getValue(SHOPPINGCARTID, index);
        Object item = this.getModel().getValue(ITEM, index);
        Object assistattr = this.getModel().getValue(ASSISTATTR, index);
        BigDecimal qty = (BigDecimal)this.getModel().getValue(QTY, index);
        Object price = this.getModel().getValue(PRICE, index);
        Object unit = this.getModel().getValue(UNIT, index);
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        if (ownerId == null || customerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u53ca\u4f9b\u8d27\u6e20\u9053", (String)"MdrShoppingCartMobTemplate_0", (String)"drp-mdr-common", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SHOPPINGCARTID, shoppingcartId);
        params.put("ownerid", ownerId);
        params.put("customerid", customerId);
        params.put("itemid", ((DynamicObject)item).getPkValue());
        if (assistattr != null) {
            params.put("assistattrid", ((DynamicObject)assistattr).getPkValue());
        }
        params.put("unitid", ((DynamicObject)unit).getPkValue());
        params.put(QTY, qty);
        params.put(PRICE, price);
        params.put("operate", "edit");
        FormModel chooseItemAttrPage = new FormModel("mdr_mobchooseitemattr", ResManager.loadKDString((String)"\u9009\u62e9\u5546\u54c1\u5c5e\u6027", (String)"MdrShoppingCartMobTemplate_1", (String)"drp-mdr-common", (Object[])new Object[0]), "15", true);
        chooseItemAttrPage.setCustomParam(params);
        chooseItemAttrPage.showPage((AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        switch (key = e.getActionId()) {
            case "mdr_mobchooseitemattr": {
                this.mdrMobChooseitemattrCloseCallBack(e);
                break;
            }
            case "mdr_item_addmobile": {
                this.mdrMobItemAddCloseCallBack(e);
                break;
            }
            case "dpa_purorder_mob": 
            case "bbc_saleorder_mob": {
                this.initShoppingCart();
                break;
            }
        }
    }

    protected void mdrMobChooseitemattrCloseCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        this.updateSelectItemList((Map)returnData);
        this.initShoppingCart();
    }

    protected void mdrMobItemAddCloseCallBack(ClosedCallBackEvent e) {
        this.initShoppingCart();
    }

    protected void updateSelectItemList(Map<String, Object> returnData) {
        BigDecimal qty = (BigDecimal)returnData.get(QTY);
        BigDecimal assistqty = (BigDecimal)returnData.get(ASSIST_QTY);
        BigDecimal price = (BigDecimal)returnData.get(PRICE);
        Object unitid = returnData.get("unitid");
        Object assistattrid = returnData.get("assistattrid");
        Object cartId = returnData.get(SHOPPINGCARTID);
        String strFields = String.format("id,%s,%s,%s,%s,%s", UNIT, PRICE, QTY, ASSIST_QTY, ASSISTATTR);
        DynamicObject cartItem = BusinessDataServiceHelper.loadSingle((String)"mdr_shopping_cart", (String)strFields, (QFilter[])new QFilter("id", "=", cartId).toArray());
        if (cartItem != null) {
            if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
                cartItem.set(UNIT, unitid);
                cartItem.set(ASSIST_QTY, (Object)assistqty);
                cartItem.set(ASSISTATTR, assistattrid);
                cartItem.set(QTY, (Object)qty);
                cartItem.set(PRICE, (Object)price);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
            }
        } else {
            if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            Object customer = this.getCustomerF7PKValue();
            Object owner = this.getOwnerF7PKValue();
            Object item = returnData.get(ITEM);
            Object assistUnit = returnData.get("assistUnit");
            cartItem = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
            cartItem.set(PRICE, (Object)price);
            cartItem.set("owner", customer);
            cartItem.set(ITEM, item);
            cartItem.set(QTY, (Object)qty);
            cartItem.set(ASSIST_QTY, (Object)assistqty);
            cartItem.set(ASSISTATTR, assistattrid);
            cartItem.set(UNIT, unitid);
            cartItem.set(ASSIST_UNIT, assistUnit);
            cartItem.set("createdate", (Object)new Date());
            cartItem.set("ispurchasing", (Object)this.getIsPurchasing());
            cartItem.set("customer", owner);
            cartItem.set("user", UserUtil.getUserID());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBaseInfo();
        Object ownerid = this.getOwnerF7PKValue();
        Object customerid = this.getCustomerF7PKValue();
        this.titleName(ownerid);
        if (ownerid == null || customerid == null) {
            return;
        }
        this.initShoppingCart();
        this.isAfterCreateNewData = true;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.isAfterCreateNewData) {
            this.initShoppingCart();
        }
    }

    protected void initBaseInfo() {
        this.setOwnerF7Value(this.getParameter("ownerid"));
        this.setCustomerF7Value(this.getParameter("customerid"));
    }

    protected void titleName(Object ownerid) {
        String ownername = "";
        String customername = "";
        Object customerid = this.getCustomerF7PKValue();
        if (ownerid != null && customerid != null) {
            DynamicObject ownerInfo = BusinessDataServiceHelper.loadSingle((Object)ownerid, (String)"mdr_customer");
            DynamicObject customerInfo = BusinessDataServiceHelper.loadSingle((Object)customerid, (String)"mdr_customer");
            if (ownerInfo != null && customerInfo != null) {
                ownername = ownerInfo.getString("name");
                if (ownername.length() > 15) {
                    ownername = ownername.substring(0, 15) + "...";
                }
                if ((customername = customerInfo.getString("name")).length() > 15) {
                    customername = customername.substring(0, 15) + "...";
                }
            }
        }
        ((Label)this.getControl("titlename")).setText(ownername + "-" + customername);
    }

    protected void initShoppingCart() {
        Object ownerid = this.getOwnerF7PKValue();
        this.initShoppingCart(ownerid);
    }

    protected void initShoppingCart(Object ownerid) {
        this.initItemList(ownerid);
        this.orderAmountAndTotalCount(ownerid);
    }

    protected void initItemList(Object ownerid) {
        QFilter qfilter;
        QFilter[] filters;
        DynamicObject[] shoppingCartItems;
        Object customerId = this.getCustomerF7PKValue();
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
        this.getModel().beginInit();
        if (itemList != null && itemList.size() > 0) {
            this.getModel().deleteEntryData(ITEM_LIST);
        }
        if ((shoppingCartItems = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"id,item,item.thumbnail,unit,qty,customer.id,price,item.enable,assistattr,assistunit.id,assistunit.name,assistunit.precision,assistqty", (QFilter[])(filters = new QFilter[]{qfilter = this.getShoppingCartFilter(ownerid, customerId)}))) != null && shoppingCartItems.length > 0) {
            int index = 0;
            this.getModel().batchCreateNewEntryRow(ITEM_LIST, shoppingCartItems.length);
            for (DynamicObject cartItem : shoppingCartItems) {
                DynamicObject newInsertObj = this.getModel().getEntryRowEntity(ITEM_LIST, index);
                newInsertObj.set(ITEM, (Object)cartItem.getDynamicObject(ITEM));
                newInsertObj.set(ITEMPIC, cartItem.get("item.thumbnail"));
                newInsertObj.set(UNIT, (Object)cartItem.getDynamicObject(UNIT));
                newInsertObj.set(ASSIST_UNIT, (Object)cartItem.getDynamicObject(ASSIST_UNIT));
                newInsertObj.set(ASSISTUNITNAME, cartItem.get("assistunit.name"));
                newInsertObj.set(PRICE, (Object)cartItem.getBigDecimal(PRICE));
                newInsertObj.set(ASSISTATTR, (Object)cartItem.getDynamicObject(ASSISTATTR));
                newInsertObj.set(SHOPPINGCARTID, cartItem.get("id"));
                newInsertObj.set(QTY, cartItem.get(QTY));
                newInsertObj.set(ASSISTINFO, (Object)cartItem.getBigDecimal(ASSIST_QTY).setScale(cartItem.getInt("assistunit.precision"), 0).stripTrailingZeros().toPlainString());
                this.triggerChangeEvent = true;
                if (cartItem.getBoolean("item.enable")) {
                    this.setEnable(index, QTY);
                    newInsertObj.set("enable", (Object)"");
                } else {
                    this.setUnEnable(index, QTY);
                    newInsertObj.set("enable", (Object)"\u5df2\u5931\u6548");
                }
                ++index;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ITEM_LIST);
    }

    protected Object orderAmountAndTotalCount(Object ownerid) {
        DynamicObjectCollection cartItemCollection = this.getModel().getEntryEntity(ITEM_LIST);
        BigDecimal totalamount = ZERO;
        BigDecimal totalqty = ZERO;
        DynamicObject cartItem = null;
        for (int i = 0; i < cartItemCollection.size(); ++i) {
            cartItem = (DynamicObject)cartItemCollection.get(i);
            BigDecimal price = (BigDecimal)cartItem.get(PRICE);
            BigDecimal qty = (BigDecimal)cartItem.get(QTY);
            BigDecimal itemamount = qty.multiply(price);
            this.setValue("entryamount", (Object)itemamount, i);
            totalamount = totalamount.add(itemamount);
            totalqty = totalqty.add(qty);
        }
        MobileControlUtils.LabelSetValue((Label)this.getControl(ORDER_AMOUNT), totalamount.stripTrailingZeros().toPlainString());
        MobileControlUtils.LabelSetValue((Label)this.getControl(TOTAL_QTY), totalqty);
        return totalamount;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(ITEM_LIST);
        switch (key) {
            case "add": {
                if (!this.getItemEnable(index)) {
                    this.getView().showTipNotification("\u8be5\u5546\u54c1\u5df2\u5931\u6548\u3002");
                    return;
                }
                this.add(index, QTY);
                break;
            }
            case "reduce": {
                if (!this.getItemEnable(index)) {
                    this.getView().showTipNotification("\u8be5\u5546\u54c1\u5df2\u5931\u6548\u3002");
                    return;
                }
                this.reduce(index, QTY);
                break;
            }
            case "assistadd": {
                this.add(index, ASSIST_QTY);
                break;
            }
            case "assistreduce": {
                this.reduce(index, ASSIST_QTY);
                break;
            }
            case "delete": {
                this.clickDelete(evt);
                break;
            }
            case "clearshoppingcart": {
                this.clickClearShoppingCart(evt);
                break;
            }
            case "additem": {
                this.toItemAddPage();
                break;
            }
            case "modify": {
                if (!this.getItemEnable(index)) {
                    this.getView().showTipNotification("\u8be5\u5546\u54c1\u5df2\u5931\u6548\u3002");
                    return;
                }
                this.showItemAttr(index);
                break;
            }
            case "butdownorder": {
                this.goToOrder();
            }
        }
    }

    private boolean getItemEnable(int index) {
        boolean isenable = false;
        Object item = this.getModel().getValue(ITEM, index);
        if (item != null) {
            isenable = ((DynamicObject)item).getBoolean("enable");
        }
        return isenable;
    }

    protected abstract void goToOrder();

    protected void toItemAddPage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerid", this.getCustomerF7PKValue());
        map.put("ownerid", this.getOwnerF7PKValue());
        map.put("ispurchasing", this.getIsPurchasing() + "");
        FormModel itemAddPage = new FormModel("mdr_item_addmobile", ResManager.loadKDString((String)"\u6dfb\u52a0\u5546\u54c1", (String)"MdrShoppingCartMobTemplate_2", (String)"drp-mdr-common", (Object[])new Object[0]), "5", true);
        itemAddPage.setCustomParam(map);
        itemAddPage.showPage((AbstractFormPlugin)this);
    }

    protected void add(int index, String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname, index);
        this.getModel().setValue(qtyname, (Object)qty.add(ONE), index);
    }

    protected void reduce(int index, String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname, index);
        this.getModel().setValue(qtyname, (Object)qty.subtract(ONE), index);
    }

    protected void clickDelete(EventObject evt) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteShoppingCartCallBack", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u8be5\u5546\u54c1\u5417\uff1f", (String)"MdrShoppingCartMobTemplate_3", (String)"drp-mdr-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
    }

    protected void clickClearShoppingCart(EventObject evt) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("clearShoppingCartCallBack", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u7a7a\u8d2d\u7269\u8f66\u5417\uff1f", (String)"MdrShoppingCartMobTemplate_4", (String)"drp-mdr-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean isYes = messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes);
        if (!isYes) {
            return;
        }
        switch (callBackId) {
            case "deleteShoppingCartCallBack": {
                this.delete();
                break;
            }
            case "clearShoppingCartCallBack": {
                this.clearShoppingCart();
                break;
            }
        }
    }

    protected void delete() {
        int index = this.getModel().getEntryCurrentRowIndex(ITEM_LIST);
        QFilter filter = new QFilter("id", "=", this.getModel().getValue(SHOPPINGCARTID, index));
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])filter.toArray());
        Object ownerid = this.getOwnerF7PKValue();
        this.initItemList(ownerid);
        this.orderAmountAndTotalCount(ownerid);
    }

    protected void clearShoppingCart() {
        Object ownerid = this.getOwnerF7PKValue();
        Object customerid = this.getCustomerF7PKValue();
        QFilter filter = this.getShoppingCartFilter(ownerid, customerid);
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])filter.toArray());
        this.initItemList(ownerid);
        this.orderAmountAndTotalCount(ownerid);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("customer") || propertyName.equals("owner")) {
            this.triggerChangeEvent = true;
        }
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (propertyName) {
            case "customer": {
                this.customerPropertyChange(e);
                break;
            }
            case "owner": {
                this.ownerPropertyChange(e);
                break;
            }
            case "allcheck": {
                this.allCheckPropertyChange(e);
                break;
            }
            case "assistqty": {
                this.assistQtyPropertyChange(e);
                break;
            }
            case "qty": {
                this.qtyPropertyChange(e);
                break;
            }
        }
    }

    protected void customerPropertyChange(PropertyChangedArgs e) {
        this.ownerPropertyChange(e);
    }

    protected void ownerPropertyChange(PropertyChangedArgs e) {
        Object ownerid = this.getOwnerF7PKValue();
        this.titleName(ownerid);
        this.initShoppingCart(ownerid);
    }

    protected void qtyPropertyChange(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        Object oldValue = data.getOldValue();
        int index = this.getRowIndex(e);
        BigDecimal qty = (BigDecimal)this.getModel().getValue(QTY, index);
        if (qty.compareTo(ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"MdrShoppingCartMobTemplate_5", (String)"drp-mdr-common", (Object[])new Object[0]));
            this.getModel().setValue(QTY, oldValue, index);
        }
        this.qtyChange(index, QTY);
    }

    protected void assistQtyPropertyChange(PropertyChangedArgs e) {
        this.triggerChangeEvent = false;
        ChangeData data = e.getChangeSet()[0];
        Object oldValue = data.getOldValue();
        int index = this.getRowIndex(e);
        BigDecimal assistqty = (BigDecimal)this.getModel().getValue(ASSIST_QTY, index);
        if (assistqty.compareTo(ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u52a9\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"MdrShoppingCartMobTemplate_6", (String)"drp-mdr-common", (Object[])new Object[0]));
            this.getModel().setValue(ASSIST_QTY, oldValue, index);
        }
        this.qtyChange(index, ASSIST_QTY);
    }

    /*
     * WARNING - void declaration
     */
    protected void qtyChange(int index, String qtyname) {
        void var7_10;
        this.triggerChangeEvent = false;
        Object ownerid = this.getOwnerF7PKValue();
        DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, index);
        Map<Object, Object> qtys = null;
        if (rowInfo.get(ITEM) == null) {
            qtys = new HashMap();
        }
        String string = qtyname;
        int n = -1;
        switch (string.hashCode()) {
            case 112310: {
                if (!string.equals(QTY)) break;
                boolean bl = false;
                break;
            }
            case 1429843885: {
                if (!string.equals(ASSIST_QTY)) break;
                boolean bl = true;
            }
        }
        switch (var7_10) {
            case 0: {
                qtys = this.handleQTYChange(rowInfo);
                break;
            }
            case 1: {
                qtys = this.handleAssistQtyChange(rowInfo);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf\u6216\u5355\u4f4d\u5b57\u6bb5\u540d\u6709\u8bef\uff01", (String)"MdrShoppingCartMobTemplate_7", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
        }
        for (Map.Entry entry : qtys.entrySet()) {
            if (ASSIST_QTY.equals(entry.getKey())) {
                this.getModel().setValue(ASSISTINFO, (Object)((BigDecimal)entry.getValue()).stripTrailingZeros().toPlainString(), index);
            }
            this.getModel().setValue((String)entry.getKey(), entry.getValue(), index);
        }
        this.updateSelectItemList(index);
        this.setPrice(index);
        this.orderAmountAndTotalCount(ownerid);
        this.checkOrderQuantity(index);
    }

    protected void updateSelectItemList(int row) {
        Object customer = this.getCustomerF7PKValue();
        Object owner = this.getOwnerF7PKValue();
        IDataModel model = this.getModel();
        DynamicObject item = (DynamicObject)model.getValue(ITEM, row);
        BigDecimal qty = (BigDecimal)model.getValue(QTY, row);
        DynamicObject unit = (DynamicObject)model.getValue(UNIT, row);
        BigDecimal assistQty = (BigDecimal)model.getValue(ASSIST_QTY, row);
        DynamicObject assistUnit = (DynamicObject)model.getValue(ASSIST_UNIT, row);
        DynamicObject assistAttr = (DynamicObject)model.getValue(ASSISTATTR, row);
        BigDecimal price = (BigDecimal)model.getValue(PRICE, row);
        Object cartId = model.getValue(SHOPPINGCARTID, row);
        String strFields = String.format("id,%s,%s,%s,%s", UNIT, PRICE, QTY, ASSIST_QTY);
        DynamicObject cartItem = BusinessDataServiceHelper.loadSingle((String)"mdr_shopping_cart", (String)strFields, (QFilter[])new QFilter("id", "=", cartId).toArray());
        if (cartItem != null) {
            if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
                cartItem.set(UNIT, (Object)unit);
                cartItem.set(PRICE, (Object)price);
                cartItem.set(QTY, (Object)qty);
                cartItem.set(ASSIST_QTY, (Object)assistQty);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
            } else {
                DeleteServiceHelper.delete((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem.getPkValue()});
            }
        } else {
            if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            cartItem = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
            Object attrid = null;
            if (assistAttr != null) {
                attrid = assistAttr.getPkValue();
            }
            cartItem.set(PRICE, (Object)PriceUtil.getItemPrice(owner, customer, item.getPkValue(), unit.getPkValue(), attrid, ONE));
            cartItem.set("owner", customer);
            cartItem.set(ITEM, (Object)item);
            cartItem.set(QTY, (Object)qty);
            cartItem.set(ASSIST_QTY, (Object)assistQty);
            cartItem.set(ASSISTATTR, attrid);
            cartItem.set(UNIT, (Object)unit);
            cartItem.set(ASSIST_UNIT, (Object)assistUnit);
            cartItem.set("createdate", (Object)new Date());
            cartItem.set("ispurchasing", (Object)this.getIsPurchasing());
            cartItem.set("customer", owner);
            cartItem.set("user", UserUtil.getUserID());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
            model.setValue(SHOPPINGCARTID, cartItem.get("id"), row);
        }
    }

    private Map<String, BigDecimal> handleQTYChange(DynamicObject orderEntry) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(2);
        Object itemId = orderEntry.getDynamicObject(ITEM).get("id");
        BigDecimal qty = orderEntry.getBigDecimal(QTY);
        Object unit = orderEntry.getDynamicObject(UNIT).get("id");
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, qty, unit);
        BigDecimal assistQty = BigDecimal.ZERO;
        DynamicObject assisUnit = orderEntry.getDynamicObject(ASSIST_UNIT);
        if (assisUnit != null) {
            assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
        }
        map.put(ASSIST_QTY, assistQty);
        map.put(QTY, qty);
        return map;
    }

    private Map<String, BigDecimal> handleAssistQtyChange(DynamicObject orderEntry) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(2);
        Object itemId = orderEntry.getDynamicObject(ITEM).get("id");
        BigDecimal assistQty = orderEntry.getBigDecimal(ASSIST_QTY);
        DynamicObject assisUnit = orderEntry.getDynamicObject(ASSIST_UNIT);
        if (assisUnit == null) {
            return map;
        }
        DynamicObject unit = orderEntry.getDynamicObject(UNIT);
        if (unit == null) {
            return map;
        }
        BigDecimal qty = this.getUnitFormHandler().getQtyFromAssistUnit(itemId, assisUnit.get("id"), assistQty, unit.get("id"));
        map.put(ASSIST_QTY, assistQty);
        map.put(QTY, qty);
        return map;
    }

    protected void setPrice(int index) {
        Object itemPK = this.getEntryF7PKValue(ITEM_LIST, ITEM, index);
        Object unitPK = this.getEntryF7PKValue(ITEM_LIST, UNIT, index);
        DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, index);
        BigDecimal qty = rowInfo.getBigDecimal(QTY);
        Object assistattrId = 0L;
        Object assistattr = rowInfo.get(ASSISTATTR);
        if (assistattr != null) {
            assistattrId = ((DynamicObject)assistattr).get("id");
        }
        BigDecimal itemPrice = PriceUtil.getItemPrice(this.getOwnerF7PKValue(), this.getCustomerF7PKValue(), itemPK, unitPK, assistattrId, qty);
        this.setRowValue(PRICE, itemPrice, index);
    }

    protected void checkOrderQuantity(int index) {
        String errorMsg = this.getOrderQuantityMsg(index);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            BigDecimal entryqty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
            errorMsg = errorMsg.split(SPLITKEY)[0];
            this.getModel().setValue(QTY, (Object)entryqty, index);
            this.qtyChange(index, QTY);
            this.getView().showTipNotification(errorMsg);
        }
    }

    protected String getOrderQuantityMsg(int index) {
        int rowindex = index + 1;
        String errorHead = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5546\u54c1\u5df2\u542f\u7528\u8ba2\u8d27\u6279\u91cf\uff0c\u8ba2\u8d27\u6570\u91cf\u9700", (String)"MdrShoppingCartMobTemplate_8", (String)"drp-mdr-common", (Object[])new Object[0]), rowindex);
        Object owner = this.getOwnerF7PKValue();
        Object customer = this.getCustomerF7PKValue();
        Object warehouse = null;
        Object item = this.getEntryF7PKValue(ITEM_LIST, ITEM, index);
        Object unit = this.getEntryF7PKValue(ITEM_LIST, UNIT, index);
        Object assistattr = this.getEntryF7PKValue(ITEM_LIST, ASSISTATTR, index);
        DynamicObject unitDy = this.getEntryF7Value(ITEM_LIST, UNIT, index);
        String unitTips = "(" + unitDy.getString("name") + ")";
        IPageCache pageCache = this.getPageCache();
        Map<String, BigDecimal> orderQuantity = OrderQuantityUtil.getOrderQuantityRlue(owner, customer, warehouse, item, unit, assistattr, pageCache);
        if (orderQuantity == null) {
            return "";
        }
        boolean isLessThanMinQty = false;
        boolean isAccordOrderQuantity = true;
        DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, index);
        BigDecimal entryqty = rowInfo.getBigDecimal(QTY);
        BigDecimal qty = orderQuantity.get(QTY).stripTrailingZeros();
        BigDecimal minqty = orderQuantity.get("minqty").stripTrailingZeros();
        StringBuffer errorMessage = new StringBuffer();
        StringBuilder builder = new StringBuilder();
        if (entryqty.compareTo(minqty) < 0) {
            isLessThanMinQty = true;
            entryqty = minqty;
            builder.append(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"MdrShoppingCartMobTemplate_9", (String)"drp-mdr-common", (Object[])new Object[0]));
            builder.append(minqty.toPlainString());
            builder.append(unitTips);
            builder.append('!');
            errorMessage.append((CharSequence)builder);
        }
        BigDecimal[] result = entryqty.divideAndRemainder(qty);
        BigDecimal intpart = result[0];
        BigDecimal remainder = result[1];
        if (remainder.compareTo(BigDecimal.ZERO) > 0) {
            isAccordOrderQuantity = false;
            if (isLessThanMinQty) {
                errorMessage.append(ResManager.loadKDString((String)"\u4e14", (String)"MdrShoppingCartMobTemplate_10", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            errorMessage.append(String.format(ResManager.loadKDString((String)"\u4e3a%s %s\u7684\u500d\u6570\uff01", (String)"MdrShoppingCartMobTemplate_11", (String)"drp-mdr-common", (Object[])new Object[0]), qty.toPlainString(), unitTips));
        }
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            if (!isAccordOrderQuantity) {
                entryqty = intpart.add(BigDecimal.ONE).multiply(qty).stripTrailingZeros();
                errorMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d2d\u4e70\u6570\u91cf\u5efa\u8bae\u4e3a%s", (String)"MdrShoppingCartMobTemplate_12", (String)"drp-mdr-common", (Object[])new Object[0]), entryqty.toPlainString()));
            }
            builder = new StringBuilder();
            builder.append(errorHead).append(errorMessage).append(SPLITKEY).append(entryqty);
            return builder.toString();
        }
        return "";
    }

    protected void allCheckPropertyChange(PropertyChangedArgs e) {
        boolean isAllCheck = (Boolean)this.getModel().getValue(ALLCHECK);
        CardEntry itemList = (CardEntry)this.getControl(ITEM_LIST);
        int rowCount = this.getModel().getEntryRowCount(ITEM_LIST);
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        if (isAllCheck) {
            itemList.selectRows(rows, rowCount + 1);
        }
    }

    protected QFilter getShoppingCartFilter(Object ownerid, Object customerid) {
        QFilter filter = new QFilter("customer.id", "=", ownerid);
        filter.and("owner.id", "=", customerid);
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", (Object)(this.getIsPurchasing() == 1 ? 1 : 0));
        return filter;
    }

    protected abstract int getIsPurchasing();
}

