/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.cache.LRUCache;
import kd.drp.mdr.common.util.CustomerParamsUtil;

public class ImportCache {
    private LRUCache<String, Object> itemIdMap;
    private LRUCache<String, Object> unitIdMap;
    private LRUCache<String, Object> customerIdMap;
    private LRUCache<String, Object> warehouseIdMap;
    private LRUCache<String, Object> itemClassIdMap;
    private LRUCache<String, Object> assistAttrIdMap;
    private LRUCache<String, Object> customerGroupIdMap;
    private LRUCache<String, Object> sysuserIdMap;
    private LRUCache<Object, String> customerStrategyMap;
    private LRUCache<String, Object> regionIdMap;
    private LRUCache<String, Object> transportTypeIdMap;

    public Object getTransportTypeIdFromCache(String number) {
        if (this.transportTypeIdMap == null) {
            this.transportTypeIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_distribut_mode", this.transportTypeIdMap);
    }

    public Object getSysuserIdByPhoneFromCache(String phone) {
        if (this.sysuserIdMap == null) {
            this.sysuserIdMap = new LRUCache(64);
        }
        return this.getIdFromCache(new QFilter("phone", "=", (Object)phone), phone, "bos_user", this.sysuserIdMap);
    }

    public Object getItemIdFromCache(String number) {
        if (this.itemIdMap == null) {
            this.itemIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_item_info", this.itemIdMap);
    }

    public Object getUnitIdFromCache(String number) {
        if (this.unitIdMap == null) {
            this.unitIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "bd_measureunits", this.unitIdMap);
    }

    public String getStrategyFromCache(Object customerId) {
        if (this.customerStrategyMap == null) {
            this.customerStrategyMap = new LRUCache();
        }
        return this.getStrategyFromCache(customerId, this.customerStrategyMap);
    }

    private String getStrategyFromCache(Object customerId, LRUCache<Object, String> cache) {
        String strategy = cache.get(customerId);
        if (StringUtils.isEmpty(strategy)) {
            strategy = CustomerParamsUtil.getSaleControlType(customerId);
            cache.put(customerId, strategy);
        }
        return strategy;
    }

    public Object getcustomerGroupIdFromCache(String number, Object ownerId) {
        this.initCustomerGroupIdMap();
        return this.getIdFromCache(number, ownerId, "mdr_customer_group", this.customerGroupIdMap);
    }

    private void initCustomerGroupIdMap() {
        if (this.customerGroupIdMap == null) {
            this.customerGroupIdMap = new LRUCache();
        }
    }

    public Object getcustomerGroupIdFromCache(String number) {
        this.initCustomerGroupIdMap();
        return this.getIdFromCache(number, "mdr_customer_group", this.customerGroupIdMap);
    }

    public Object getRegionIdFromCache(String number, Object ownerId) {
        this.initRegionIdFromCache();
        return this.getIdFromCache(number, ownerId, "mdr_region", this.regionIdMap);
    }

    private void initRegionIdFromCache() {
        if (this.regionIdMap == null) {
            this.regionIdMap = new LRUCache();
        }
    }

    public Object getRegionIdFromCache(String number) {
        this.initRegionIdFromCache();
        return this.getIdFromCache(number, "mdr_region", this.regionIdMap);
    }

    public Object getCustomerIdFromCache(String number) {
        if (this.customerIdMap == null) {
            this.customerIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_customer", this.customerIdMap);
    }

    public Object getWareHouseIdFromCache(String number) {
        if (this.warehouseIdMap == null) {
            this.warehouseIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_warehouse", this.warehouseIdMap);
    }

    public Object getItemClassIdFromCache(String number) {
        if (this.itemClassIdMap == null) {
            this.itemClassIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_item_class", this.itemClassIdMap);
    }

    public Object getAssistAttrIdFromCache(String number) {
        if (this.assistAttrIdMap == null) {
            this.assistAttrIdMap = new LRUCache();
        }
        return this.getIdFromCache(number, "mdr_item_attrvalue", this.assistAttrIdMap);
    }

    private Object getIdFromCache(String number, Object ownerId, String pageModeName, LRUCache<String, Object> cache) {
        if (cache.containsKey(number)) {
            return cache.get(number);
        }
        QFilter fs = new QFilter("number", "=", (Object)number);
        DynamicObject one = QueryServiceHelper.queryOne((String)pageModeName, (String)"id", (QFilter[])fs.toArray());
        Object id = null;
        if (one != null) {
            id = one.get("id");
        }
        String key = String.format("%s%s", number, ownerId);
        cache.put(key, id);
        return id;
    }

    private Object getIdFromCache(QFilter fs, String key, String pageModeName, LRUCache<String, Object> cache) {
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        DynamicObject one = QueryServiceHelper.queryOne((String)pageModeName, (String)"id", (QFilter[])fs.toArray());
        Object id = null;
        if (one != null) {
            id = one.get("id");
        }
        cache.put(key, id);
        return id;
    }

    private Object getIdFromCache(String number, String pageModeName, LRUCache<String, Object> cache) {
        return this.getIdFromCache(new QFilter("number", "=", (Object)number), number, pageModeName, cache);
    }
}

