/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class OperateConfirmOpPlugin
extends MdrBaseOperationServicePlugIn {
    public static final String MESSAGE = "message";
    public static final String REMARK = "remark";
    public static final String ISMUSTINPUT = "ismustinput";
    private static final String Interaction_Sponore = "kd.drp.mdr.opplugin.OperateConfirmOpPlugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("operateremark");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (e.getSelectedRows().size() >= 100) {
            for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
                dataEntity.setValue("operateremark", (Object)"\u7cfb\u7edf\u6279\u91cf\u64cd\u4f5c");
            }
        } else {
            e.cancel = !this.showInteractionForm(e);
        }
    }

    private boolean showInteractionForm(BeforeOperationArgs e) {
        String isFromWF = this.getOption().getVariableValue("wf", "");
        if (isFromWF.equals("TRUE")) {
            return true;
        }
        List datas = e.getValidExtDataEntities();
        String ismob = this.getOption().getVariableValue("ismob", "");
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(Interaction_Sponore)) {
            String result = (String)confirmResult.getResults().get(Interaction_Sponore);
            if (StringUtils.isBlank((CharSequence)result)) {
                return false;
            }
            JSONObject map = JSONObject.parseObject((String)result);
            String remark = (String)map.get((Object)REMARK);
            for (ExtendedDataEntity dataEntity : datas) {
                dataEntity.setValue("operateremark", (Object)remark);
            }
            return true;
        }
        InteractionContext interactionContext = new InteractionContext();
        String opMessage = OrderOperateLogHandler.getOpMessage(e.getOperationKey());
        String formId = "mdr_operate_confirm";
        if ("true".equals(ismob)) {
            formId = "mdr_operate_confirmmob";
        }
        interactionContext.setCustShowFormId(formId);
        interactionContext.getCustShowParameter().put(MESSAGE, opMessage);
        interactionContext.getCustShowParameter().put(REMARK, String.format(ResManager.loadKDString((String)"%s\u539f\u56e0", (String)"OperateConfirmOpPlugin_0", (String)"drp-mdr-common", (Object[])new Object[0]), OrderOperateLogHandler.getOpName(e.getOperationKey())));
        interactionContext.getCustShowParameter().put("isFromOP", "true");
        throw new KDInteractionException(Interaction_Sponore, interactionContext);
    }
}

