/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.opplugin.handle;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.util.UserUtil;

public class ImportHandle {
    private Map<String, Object> myOwnerIdMap;
    private Map<Object, List<AuthCust>> relationMap;

    public String getNumber(Map<String, Object> data, String key) {
        return this.getF7ColVal(data, key, "number");
    }

    public boolean isAuthRelation(Object ownerId, Object customerId) {
        if (this.relationMap == null) {
            this.initRelationMap();
        }
        return this.isAuthRelation(ownerId, customerId, this.relationMap);
    }

    private boolean isAuthRelation(Object ownerId, Object customerId, Map<Object, List<AuthCust>> relationMap) {
        List<AuthCust> parentIds = relationMap.get(customerId);
        if (parentIds != null) {
            for (AuthCust authCust : parentIds) {
                if (!authCust.isValid() || !authCust.getAuthOwnerId().equals(ownerId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInSubAuthIds(Object ownerId, Object customerId) {
        if (this.relationMap == null) {
            this.initRelationMap();
        }
        return this.isInSubAuthIds(ownerId, customerId, this.relationMap);
    }

    private void initRelationMap() {
        this.relationMap = CustomerTreeCache.getCache().getCustomerMap();
    }

    private boolean isInSubAuthIds(Object ownerId, Object customerId, Map<Object, List<AuthCust>> relationMap) {
        List<AuthCust> parentIds = relationMap.get(customerId);
        if (parentIds != null) {
            for (AuthCust authCust : parentIds) {
                if (!authCust.isValid()) continue;
                if (authCust.getAuthOwnerId().equals(ownerId)) {
                    return true;
                }
                if (!this.isInSubAuthIds(ownerId, authCust.getAuthOwnerId(), relationMap)) continue;
                return true;
            }
        }
        return false;
    }

    public String getF7ColVal(Map<String, Object> data, String key, String colKey) {
        JSONObject obj = (JSONObject)data.get(key);
        if (obj == null) {
            return null;
        }
        return obj.getString(colKey);
    }

    public Object queryMyOwnerId(String number) {
        if (this.myOwnerIdMap == null) {
            this.initMyOwnerIdMap();
        }
        return this.myOwnerIdMap.get(number);
    }

    private void initMyOwnerIdMap() {
        List<Object> ownerIDs = UserUtil.getOwnerIDs();
        Map customers = BusinessDataServiceHelper.loadFromCache((Object[])ownerIDs.toArray(), (String)"mdr_customer");
        this.myOwnerIdMap = new HashMap<String, Object>(customers.size());
        for (DynamicObject owner : customers.values()) {
            this.myOwnerIdMap.put(owner.getString("number"), owner.getPkValue());
        }
    }
}

