/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.report.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ReportUtils {
    private static final String OWNER_FILTER = "ownerfilter";
    private static final String BILLNO_FILTER = "billnofilter";
    private static final String SALEORDER = "saleorder";
    private static final String DISPATCHORDER = "dispatchorder";

    public static void setBillNoFilter(ReportQueryParam queryParam) {
        ReportUtils.setBillNoFilter(queryParam, OWNER_FILTER, BILLNO_FILTER, SALEORDER);
    }

    public static void setDispatchBillNoFilter(ReportQueryParam queryParam) {
        ReportUtils.setBillNoFilter(queryParam, OWNER_FILTER, BILLNO_FILTER, DISPATCHORDER);
    }

    public static void setBillNoFilter(ReportQueryParam queryParam, String ownerfilter, String billnofilter, String ordertype) {
        if (ownerfilter == null || billnofilter == null) {
            return;
        }
        List<Object> selectedOwnerIds = null;
        DynamicObjectCollection ownerCollection = null;
        FilterItemInfo owner = queryParam.getFilter().getFilterItem(ownerfilter);
        if (owner == null) {
            return;
        }
        try {
            ownerCollection = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(ownerfilter).getValue();
            selectedOwnerIds = ownerCollection == null ? UserUtil.getOwnerIDs() : ReportUtils.getSelectedOwnerIds(ownerCollection);
        }
        catch (Exception e) {
            selectedOwnerIds = (List<Object>)queryParam.getFilter().getFilterItem(ownerfilter).getValue();
        }
        queryParam.getFilter().getFilterItem(ownerfilter).setValue(selectedOwnerIds);
        List<Object> billnos = ReportUtils.getBillnos(selectedOwnerIds, ordertype);
        queryParam.getFilter().addFilterItem(billnofilter, (Object)ownerCollection, "17");
        queryParam.getFilter().getFilterItem(billnofilter).setValue(billnos);
    }

    /*
     * WARNING - void declaration
     */
    private static List<Object> getBillnos(List<Object> selectedOwnerIds, String ordertype) {
        void var6_9;
        QFilter f = null;
        ArrayList<Object> ids = new ArrayList<Object>();
        String route = "";
        String string = ordertype;
        int n = -1;
        switch (string.hashCode()) {
            case -86254745: {
                if (!string.equals(SALEORDER)) break;
                boolean bl = false;
                break;
            }
            case -2102264044: {
                if (!string.equals(DISPATCHORDER)) break;
                boolean bl = true;
            }
        }
        switch (var6_9) {
            case 0: {
                route = "bbc_saleorder";
                break;
            }
            case 1: {
                route = "mdr_dispatch_order";
            }
        }
        for (Object e : selectedOwnerIds) {
            f = ReportUtils.getOrderFilter(e, ordertype);
            if (f == null) continue;
            Set<Object> billnos = QueryUtil.querySingleCol(route, "billno", f.toArray());
            ids.addAll(billnos);
        }
        return ids;
    }

    private static QFilter getOrderFilter(Object ownerid, String ordertype) {
        if (SALEORDER.equals(ordertype)) {
            return SaleOrderUtil.getSaleOrderSalerFilter(ownerid);
        }
        if (DISPATCHORDER.equals(ordertype)) {
            return ReportUtils.getDispatchOrderFilter(ownerid);
        }
        return null;
    }

    private static QFilter getDispatchOrderFilter(Object ownerid) {
        QFilter fs = SaleOrderUtil.getSaleOrderSalerFilter(ownerid);
        QFilter warehouseFilter = new QFilter("-1", "=", (Object)"1");
        QFilter f = new QFilter("user", "=", UserUtil.getUserID());
        f.and("owner", "=", ownerid);
        f.and("enable", "=", (Object)"1");
        DynamicObjectCollection wareHouses = QueryServiceHelper.query((String)"mdr_wareshouse_user_r", (String)"warehouse.id", (QFilter[])f.toArray());
        QFilter ftemp = new QFilter("owner", "=", ownerid);
        if (wareHouses != null && wareHouses.size() > 0) {
            ArrayList<Object> ownerWarehouseIds = new ArrayList<Object>();
            for (DynamicObject wareHouse : wareHouses) {
                ownerWarehouseIds.add(wareHouse.get("warehouse.id"));
            }
            ftemp.and("warehouse", "in", ownerWarehouseIds);
        }
        warehouseFilter.or(ftemp);
        return fs.and(warehouseFilter);
    }

    private static List<Object> getSelectedOwnerIds(DynamicObjectCollection ownerCollection) {
        ArrayList<Object> ownerids = new ArrayList<Object>();
        for (DynamicObject owner : ownerCollection) {
            ownerids.add(owner.get("id"));
        }
        return ownerids;
    }
}

