/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.Api;
import kd.drp.mdr.api.ApiLogLevel;
import kd.drp.mdr.api.ApiManage;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MdrApi
implements IBillWebApiPlugin {
    protected static Log logger = LogFactory.getLog(MdrApi.class);

    public ApiResult doCustomService(Map<String, Object> map) {
        ApiResult apiResult = null;
        DynamicObject log = null;
        Api api = null;
        Map<String, Object> data = this.getData(map);
        try {
            String apiNumber = this.getMethod(map);
            api = this.getApi(apiNumber);
            String methodName = api.getMethod();
            Class<?> apiClass = this.getApiClass(api.getPlugin());
            Method method = apiClass.getMethod(methodName, Map.class);
            if (method == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u79fb\u52a8\u5206\u9500\u63a5\u53e3\u5931\u8d25\uff1a%s\u65b9\u6cd5\u4e0d\u5b58\u5728\uff01", (String)"MdrApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]), methodName));
            }
            Propagation propagation = null;
            if (method.isAnnotationPresent(ApiTransaction.class)) {
                ApiTransaction myAnnotation = method.getAnnotation(ApiTransaction.class);
                propagation = myAnnotation.propagation();
            }
            try (TXHandle h = null;){
                if (propagation != null) {
                    switch (propagation) {
                        case REQUIRED: {
                            h = TX.required();
                            break;
                        }
                        case REQUIRES_NEW: {
                            h = TX.requiresNew();
                            break;
                        }
                        case NOT_SUPPORTED: {
                            h = TX.notSupported();
                            break;
                        }
                    }
                }
                log = this.logBeforInvoke(api, data);
                apiResult = (ApiResult)method.invoke(apiClass.newInstance(), data);
                this.logAfterInvoke(api, log, apiResult, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = null;
            if (e instanceof InvocationTargetException) {
                Throwable targetEx = ((InvocationTargetException)e).getTargetException();
                if (targetEx != null) {
                    msg = targetEx instanceof KDBizException ? ((KDBizException)targetEx).getMessage() : ExceptionUtils.getStackTrace((Throwable)targetEx);
                    logger.info("MdrApi_doCustomService\n" + ExceptionUtils.getStackTrace((Throwable)targetEx));
                    this.logExceptionAfterInvoke(api, log, targetEx, data);
                }
            } else {
                logger.info("MdrApi_doCustomService2\n" + ExceptionUtils.getStackTrace((Throwable)e));
                this.logExceptionAfterInvoke(api, log, e, data);
                msg = e.getMessage();
            }
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u79fb\u52a8\u5206\u9500\u63a5\u53e3\u5931\u8d25\uff1a%s", (String)"MdrApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]), msg));
        }
        return apiResult;
    }

    protected Map<String, Object> getData(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        return data == null ? new HashMap() : data;
    }

    private String getMethod(Map<String, Object> map) {
        String method = (String)map.get("method");
        if (StringUtils.isEmpty((String)method)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u65b9\u6cd5method\u4e3a\u7a7a\uff01", (String)"MdrApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        int index = method.indexOf("/invoke");
        if (index > 0) {
            method = method.substring(0, index);
        }
        return method;
    }

    private Api getApi(String apiNumber) {
        Api api = this.getApiFromCache(apiNumber);
        if (api == null) {
            ApiManage.reloadApiList();
            api = this.getApiFromCache(apiNumber);
            if (api == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3[%s]\u5728\u79fb\u52a8\u5206\u9500\u4e2d\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"MdrApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]), apiNumber));
            }
        }
        return api;
    }

    protected Api getApiFromCache(String apiNumber) {
        Api api = null;
        Object apiObj = ApiManage.getApiMap().get(apiNumber);
        if (apiObj instanceof Map) {
            api = Api.formMap((Map)((Map)apiObj));
        } else if (apiObj instanceof Api) {
            api = (Api)apiObj;
        }
        return api;
    }

    private Class<?> getApiClass(String apiClass) throws ClassNotFoundException {
        if (StringUtils.isEmpty((String)apiClass)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6cd5\u672a\u627e\u5230\u5b9e\u73b0\u63a5\u53e3\u7c7b\uff01\u8bf7\u5148\u6dfb\u52a0\u914d\u7f6e", (String)"MdrApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]), apiClass));
        }
        Class<?> forName = Class.forName(apiClass);
        return forName;
    }

    private DynamicObject logBeforInvoke(Api api, Map<String, Object> data) {
        DynamicObject log = null;
        if (SysParamsUtil.getApiLogLevel() != ApiLogLevel.ALL) {
            return null;
        }
        if (api == null || !api.isIslog()) {
            return null;
        }
        try (TXHandle h = TX.requiresNew();){
            log = this.creatApiLog(api, data);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception ee) {
            logger.error("mdrapi_logBeforInvoke:" + ee.getMessage() + "\n" + ee.getStackTrace());
        }
        return log;
    }

    private DynamicObject creatApiLog(Api api, Map<String, Object> fromData) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"mdr_receivemessage");
        log.set("method", (Object)api.getNumber());
        log.set("formdata_tag", (Object)SerializationUtils.toJsonString(fromData));
        log.set("iserror", (Object)Boolean.TRUE);
        log.set("creater", UserUtil.getUserID());
        log.set("createtime", (Object)new Date());
        return log;
    }

    private void logAfterInvoke(Api api, DynamicObject log, ApiResult apiResult, Map<String, Object> fromData) {
        ApiLogLevel apiLogLevel = SysParamsUtil.getApiLogLevel();
        if (apiLogLevel == ApiLogLevel.NONE) {
            return;
        }
        if (apiResult.getSuccess() && apiLogLevel == ApiLogLevel.ERROR) {
            return;
        }
        if (api == null || !api.isIslog()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            String msg;
            if (log == null) {
                log = this.creatApiLog(api, fromData);
            }
            if (apiResult.getSuccess()) {
                log.set("iserror", (Object)Boolean.FALSE);
            }
            if ((msg = apiResult.getMessage()) != null && msg.length() > 200) {
                msg = msg.substring(0, 200);
            }
            log.set("msg", (Object)msg);
            log.set("backtime", (Object)new Date());
            Object toData = apiResult.getData();
            String dataStr = "null";
            if (toData != null) {
                dataStr = toData instanceof Map ? SerializationUtils.toJsonString((Object)toData) : (toData instanceof List ? SerializationUtils.toJsonString((Object)toData) : toData.toString());
            }
            log.set("todata_tag", (Object)dataStr);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception ee) {
            logger.error("mdrapi_logAfterInvoke:" + ee.getMessage() + "\n" + ee.getStackTrace());
        }
    }

    private void logExceptionAfterInvoke(Api api, DynamicObject log, Throwable e, Map<String, Object> data) {
        if (SysParamsUtil.getApiLogLevel() == ApiLogLevel.NONE) {
            return;
        }
        if (api == null || !api.isIslog()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            String msg;
            if (log == null) {
                log = this.creatApiLog(api, data);
            }
            if ((msg = e.getMessage()) != null && msg.length() > 500) {
                msg = msg.substring(0, 500);
            }
            log.set("iserror", (Object)Boolean.TRUE);
            log.set("msg", (Object)msg);
            log.set("backtime", (Object)new Date());
            log.set("todata_tag", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception ee) {
            logger.error("mdrapi_logExceptionAfterInvoke:" + ee.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)ee));
        }
    }

    protected ApiResult fail(String msg, HashMap<String, Object> data) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("success", Boolean.FALSE);
        ret.put("message", msg);
        ret.put("data", data);
        return ApiResult.fromMap(ret);
    }

    protected ApiResult fail(String errorCode, String msg) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("errorCode", errorCode);
        data.put("errorMessage", msg);
        ret.put("success", Boolean.FALSE);
        ret.put("message", msg);
        ret.put("data", data);
        return ApiResult.fromMap(ret);
    }

    public void checkRecordField(Map<String, Object> data, String ... fields) {
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570!!", (String)"MdrApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        for (String field : fields) {
            if (!data.containsKey(field)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u53c2\u6570%s", (String)"MdrApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]), field));
            }
            if (!StringUtils.isEmpty((Object)data.get(field))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"MdrApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]), field));
        }
    }

    protected Object getIdByNumber(Object number, String entityName) {
        DynamicObject o = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter("number", "=", number).toArray());
        return o == null ? null : o.get("id");
    }

    protected DynamicObject getDynamicObjectByNumber(String number, String entityName, String fields) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)fields, (QFilter[])new QFilter("number", "=", (Object)number).toArray());
    }

    protected DynamicObject getDynamicObjectByNumber(String number, String entityName) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
    }

    protected DynamicObject getDynamicObjectByEASNumber(String easnumber, String entityName, String fields) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)fields, (QFilter[])new QFilter("easnumber", "=", (Object)easnumber).toArray());
    }
}

