/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class NoticeApi
extends MdrApi {
    public ApiResult getListData(Map<String, Object> data) {
        QFilter filter = new QFilter("1", "=", (Object)"1");
        filter.and("ownerentity.ownerid", "in", (Object)UserUtil.getOwnerIDs());
        String fileds = "id,title,owner.id,owner.name,department,releasedate,endDate,releasemode";
        if (data != null) {
            String ownerId = (String)data.get("ownerId");
            String enddate = (String)data.get("endDate");
            String releasedate = (String)data.get("releaseDate");
            String releasemode = (String)data.get("releasemode");
            int page = (Integer)data.get("page");
            int pageSize = (Integer)data.get("pageSize");
            String orderBys = (String)data.get("orderBys");
            String orderType = (String)data.get("orderType");
            String belongOwner = (String)data.get("belongOwner");
            if (StringUtils.isNotEmpty((CharSequence)ownerId)) {
                filter.and("owner.id", "=", (Object)ownerId);
            }
            if (StringUtils.isNotEmpty((CharSequence)releasemode)) {
                filter.and("releasemode", "=", (Object)releasemode);
            }
            if (StringUtils.isNotEmpty((CharSequence)releasedate)) {
                filter.and("releasedate", "match", (Object)releasedate);
            }
            if (StringUtils.isNotEmpty((CharSequence)enddate)) {
                filter.and("enddate", "match", (Object)enddate);
            }
            if (StringUtils.isNotEmpty((CharSequence)orderBys)) {
                orderBys = StringUtils.isNotEmpty((CharSequence)orderType) ? orderBys + " " + orderType : orderBys + " asc";
            }
            if (StringUtils.isNotEmpty((CharSequence)belongOwner)) {
                filter.and("ownerentity.ownerid", "in", (Object)belongOwner);
            } else {
                filter.and("ownerentity.ownerid", "in", UserUtil.getDefaultOwnerID());
            }
            int from = (page - 1) * pageSize;
            int length = pageSize;
            DynamicObjectCollection list = ORMUtil.query((String)"mdr_notice_sendview", (String)fileds, (QFilter[])filter.toArray(), (String)orderBys, (int)from, (int)length);
            ArrayList returnData = new ArrayList();
            for (DynamicObject returnDatas : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                returnDatas = BusinessDataServiceHelper.loadSingle((Object)returnDatas.getString("id"), (String)"mdr_notice_sendview");
                map.put("id", returnDatas.getString("id"));
                map.put("title", returnDatas.getString("title"));
                map.put("content", returnDatas.getString("content_tag"));
                map.put("ownerId", returnDatas.getString("owner.id"));
                map.put("ownerName", returnDatas.getString("owner.name"));
                map.put("department", returnDatas.getString("department"));
                map.put("endDate", returnDatas.getString("endDate"));
                map.put("releaseDate", returnDatas.getString("releasedate"));
                map.put("releaseMode", returnDatas.getInt("releasemode"));
                returnData.add(map);
            }
            int count = QueryUtil.querycount((String)"mdr_notification", (QFilter[])filter.toArray());
            HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
            returnMap.put("returnData", returnData);
            returnMap.put("count", Integer.valueOf(count));
            return ApiResult.success(returnMap);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u901a\u77e5\u516c\u544a\u83b7\u53d6\u5217\u8868\u6570\u636e\u63a5\u53e3\u5f02\u5e38:\u4f20\u9012\u7684\u53c2\u6570\u4e3a\u7a7a", (String)"NoticeApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }

    public ApiResult getDetailDataById(Map<String, Object> data) {
        if (data != null) {
            String id = (String)data.get("id");
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((CharSequence)id) && QueryServiceHelper.exists((String)"mdr_notification", (Object)id)) {
                DynamicObject noticeDetail = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_notification");
                List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_notification", (Object)noticeDetail.get("id"), (String)"attachment");
                map.put("id", noticeDetail.getString("id"));
                map.put("title", noticeDetail.getString("title"));
                map.put("ownerId", noticeDetail.getString("owner.id"));
                map.put("ownerName", noticeDetail.getString("owner.name"));
                map.put("department", noticeDetail.getString("department"));
                map.put("endDate", noticeDetail.getString("enddate"));
                map.put("releaseDate", noticeDetail.getString("releasedate"));
                map.put("releaseMode", noticeDetail.getString("releasemode"));
                map.put("sendObject", noticeDetail.getString("sendobject"));
                DynamicObjectCollection notificationEntrys = noticeDetail.getDynamicObjectCollection("ownerentity");
                ArrayList<String> list = new ArrayList<String>();
                for (DynamicObject notificationEntry : notificationEntrys) {
                    list.add(notificationEntry.get("ownerid") + "");
                }
                map.put("notificationEntry", list);
                map.put("contentTag", noticeDetail.get("content_tag"));
                map.put("attachments", attachments);
                return ApiResult.success(map);
            }
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u4e3b\u952eid\u4e3a\u7a7a\u6216\u8005\u4e0d\u6b63\u786e", (String)"NoticeApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u901a\u77e5\u516c\u544a\u83b7\u53d6\u5217\u8868\u6570\u636e\u63a5\u53e3\u5f02\u5e38:\u4f20\u9012\u7684\u53c2\u6570\u4e3a\u7a7a", (String)"NoticeApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }
}

